/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.archive;

import com.sas.codepolicy.SASScope;
import com.sas.io.ChainedIOException;
import com.sas.io.ReaderAdapter;
import com.sas.io.RemoteInputStream;
import com.sas.io.RemoteInputStreamInterface;
import com.sas.io.RemoteReader;
import com.sas.io.RemoteReaderInterface;
import com.sas.services.publish.ViewerEntryInterface;
import com.sas.services.publish.archive.ArchiveEntry;
import com.sas.services.publish.archive.RB;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;

@SASScope
class ArchiveViewerEntry
extends ArchiveEntry
implements ViewerEntryInterface {
    private String _mimeType = null;
    private int _viewerType;
    private String _encoding = null;
    private String _textEncoding = null;
    private int _maximumLineLength;
    private static final CharArrayReader DUMMY_READER = new CharArrayReader(new char[1]);
    private static final ByteArrayInputStream DUMMY_INPUTSTREAM = new ByteArrayInputStream(new byte[1]);

    private ArchiveViewerEntry() throws RemoteException {
        super(ArchiveViewerEntry.class);
    }

    ArchiveViewerEntry(String textEncoding) throws RemoteException {
        this();
        this._textEncoding = textEncoding;
        this._viewerType = 1;
    }

    protected void setMaximumLineLength(int maxLineLength) {
        this._maximumLineLength = maxLineLength;
    }

    @Override
    public String getMIMEType() throws RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        return this._mimeType;
    }

    @Override
    public void setMIMEType(String mimeType) throws IllegalStateException, RemoteException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.entryReadOnly.ex.txt"));
        }
        this._mimeType = mimeType;
    }

    @Override
    public String getEncoding() throws RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        return this._viewerType == 2 ? this._textEncoding : this._encoding;
    }

    @Override
    public void setEncoding(String encoding) throws IllegalStateException, RemoteException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.entryReadOnly.ex.txt"));
        }
        if (this._viewerType != 1) {
            throw new IllegalStateException(RB.getStringResource("ArchiveViewerEntry.typeIllegalStateException.ex.txt"));
        }
        this._encoding = encoding;
    }

    @Override
    public int getViewerType() throws RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        return this._viewerType;
    }

    protected void setViewerType(int viewerType) throws RemoteException {
        this._viewerType = viewerType;
    }

    @Override
    public RemoteInputStreamInterface getRemoteInputStream(Object streamId) throws ChainedIOException, RemoteException, IllegalStateException {
        InputStream stream = null;
        this.throwExceptionIfClosed();
        if (this.getVersion() > 30) {
            throw new ChainedIOException(RB.getStringResource("ArchiveCommon.compat.ex.txt"));
        }
        try {
            stream = this.getZipTable().getInputStream(this.getName());
        }
        catch (IOException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("ArchiveCommon.remoteStreamIOError.ex.txt"));
        }
        return new RemoteInputStream(stream);
    }

    @Override
    public Reader getReader() throws IOException, RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.getVersion() > 30) {
            throw new ChainedIOException(RB.getStringResource("ArchiveCommon.compat.ex.txt"));
        }
        InputStream stream = null;
        try {
            stream = this.getZipTable().getInputStream(this.getName());
        }
        catch (IOException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("ArchiveCommon.readerIOError.ex.txt"));
        }
        InputStreamReader reader = null;
        String encoding = this.getEncoding();
        if (encoding == null) {
            reader = new InputStreamReader(stream);
        } else {
            try {
                reader = new InputStreamReader(stream, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ChainedIOException((Throwable)e, RB.getStringResource("ArchiveCommon.readerIOError.ex.txt"));
            }
        }
        return new ReaderAdapter((Reader)reader);
    }

    @Override
    public Reader getReader(Object streamId) throws ChainedIOException, RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.getVersion() > 30) {
            throw new ChainedIOException(RB.getStringResource("ArchiveCommon.compat.ex.txt"));
        }
        InputStream stream = null;
        try {
            stream = this.getZipTable().getInputStream(this.getName());
        }
        catch (IOException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("ArchiveCommon.readerIOError.ex.txt"));
        }
        InputStreamReader reader = null;
        String encoding = this.getEncoding();
        if (encoding == null) {
            reader = new InputStreamReader(stream);
        } else {
            try {
                reader = new InputStreamReader(stream, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ChainedIOException((Throwable)e, RB.getStringResource("ArchiveCommon.readerIOError.ex.txt"));
            }
        }
        return reader;
    }

    @Override
    public RemoteReaderInterface getRemoteReader(Object streamId) throws ChainedIOException, RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.getVersion() > 30) {
            throw new ChainedIOException(RB.getStringResource("ArchiveCommon.compat.ex.txt"));
        }
        InputStream stream = null;
        try {
            stream = this.getZipTable().getInputStream(this.getName());
        }
        catch (IOException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("ArchiveCommon.remoteReaderIOError.ex.txt"));
        }
        InputStreamReader reader = null;
        String encoding = this.getEncoding();
        if (encoding == null) {
            reader = new InputStreamReader(stream);
        } else {
            try {
                reader = new InputStreamReader(stream, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ChainedIOException((Throwable)e, RB.getStringResource("ArchiveCommon.remoteReaderIOError.ex.txt"));
            }
        }
        return new RemoteReader((Reader)reader);
    }

    @Override
    public Object hasInputStream() throws UnmarshalException, RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        return DUMMY_INPUTSTREAM;
    }

    @Override
    public Object hasReader() throws UnmarshalException, RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        return DUMMY_READER;
    }
}

