/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.archive;

import com.sas.codepolicy.SASScope;
import com.sas.io.ChainedIOException;
import com.sas.io.ReaderAdapter;
import com.sas.io.RemoteReader;
import com.sas.io.RemoteReaderInterface;
import com.sas.services.publish.TextFileEntryInterface;
import com.sas.services.publish.archive.ArchiveEntry;
import com.sas.services.publish.archive.RB;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;

@SASScope
class ArchiveTextFileEntry
extends ArchiveEntry
implements TextFileEntryInterface {
    private String _mimeType = null;
    private String _encoding = null;
    private int _maximumLineLength;
    private static final CharArrayReader DUMMYREADER = new CharArrayReader(new char[1]);

    private ArchiveTextFileEntry() throws RemoteException {
        super(ArchiveTextFileEntry.class);
    }

    ArchiveTextFileEntry(String encoding) throws RemoteException {
        this();
        this._encoding = encoding;
    }

    protected void setMaximumLineLength(int maxLineLength) {
        this._maximumLineLength = maxLineLength;
    }

    @Override
    public String getMIMEType() throws RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        return this._mimeType;
    }

    @Override
    public void setMIMEType(String mimeType) throws IllegalStateException, RemoteException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.entryReadOnly.ex.txt"));
        }
        this._mimeType = mimeType;
    }

    @Override
    public void setEncoding(String encoding) throws RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.entryReadOnly.ex.txt"));
        }
        this._encoding = encoding;
    }

    @Override
    public Reader getReader() throws IOException, RemoteException, IllegalStateException {
        InputStream stream = null;
        this.throwExceptionIfClosed();
        if (this.getVersion() > 15) {
            throw new ChainedIOException(RB.getStringResource("ArchiveCommon.compat.ex.txt"));
        }
        try {
            stream = this.getZipTable().getInputStream(this.getName());
        }
        catch (IOException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("ArchiveCommon.readerIOError.ex.txt"));
        }
        InputStreamReader reader = null;
        if (this._encoding == null) {
            reader = new InputStreamReader(stream);
        } else {
            try {
                reader = new InputStreamReader(stream, this._encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ChainedIOException((Throwable)e, RB.getStringResource("ArchiveCommon.readerIOError.ex.txt"));
            }
        }
        return new ReaderAdapter((Reader)reader);
    }

    @Override
    public Reader getReader(int maxLineLength) throws IOException, RemoteException, IllegalStateException {
        return this.getReader();
    }

    @Override
    public Reader getReader(Object streamId) throws ChainedIOException, RemoteException, IllegalStateException {
        InputStream stream = null;
        this.throwExceptionIfClosed();
        if (this.getVersion() > 15) {
            throw new ChainedIOException(RB.getStringResource("ArchiveCommon.compat.ex.txt"));
        }
        try {
            stream = this.getZipTable().getInputStream(this.getName());
        }
        catch (IOException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("ArchiveCommon.readerIOError.ex.txt"));
        }
        InputStreamReader reader = null;
        if (this._encoding == null) {
            reader = new InputStreamReader(stream);
        } else {
            try {
                reader = new InputStreamReader(stream, this._encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ChainedIOException((Throwable)e, RB.getStringResource("ArchiveCommon.readerIOError.ex.txt"));
            }
        }
        return reader;
    }

    @Override
    public RemoteReaderInterface getRemoteReader(Object streamId) throws ChainedIOException, RemoteException, IllegalStateException {
        InputStream stream = null;
        this.throwExceptionIfClosed();
        if (this.getVersion() > 15) {
            throw new ChainedIOException(RB.getStringResource("ArchiveCommon.compat.ex.txt"));
        }
        try {
            stream = this.getZipTable().getInputStream(this.getName());
        }
        catch (IOException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("ArchiveCommon.remoteReaderIOError.ex.txt"));
        }
        InputStreamReader reader = null;
        if (this._encoding == null) {
            reader = new InputStreamReader(stream);
        } else {
            try {
                reader = new InputStreamReader(stream, this._encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ChainedIOException((Throwable)e, RB.getStringResource("ArchiveCommon.remoteReaderIOError.ex.txt"));
            }
        }
        return new RemoteReader((Reader)reader);
    }

    @Override
    public Object hasReader() throws UnmarshalException, RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        return DUMMYREADER;
    }
}

