/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.archive;

import com.sas.codepolicy.SASScope;
import com.sas.io.ChainedIOException;
import com.sas.io.RemoteInputStreamInterface;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.IWorkspaceHelper;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryConfiguration;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryManager;
import com.sas.services.information.metadata.DirectoryInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.ServerInterface;
import com.sas.services.publish.EntryInterface;
import com.sas.services.publish.EventDataInterface;
import com.sas.services.publish.ResultPackageEventBuilder;
import com.sas.services.publish.ResultPackageInterface;
import com.sas.services.publish.TransportInterface;
import com.sas.services.publish.archive.ArchiveEntry;
import com.sas.services.publish.archive.ArchiveTransport;
import com.sas.services.publish.archive.ArchiveZipTable;
import com.sas.services.publish.archive.RB;
import com.sas.services.publish.metadata.PackageInterface;
import com.sas.services.publish.metadata.PackageUtil;
import com.sas.services.session.RemoteSessionContextStateChangedListener;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionContextStateChangedEvent;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.services.util.URIUtil;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.ResourceInterface;
import com.sas.text.Message;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;
import java.rmi.dgc.VMID;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;

@SASScope
class ArchiveResultPackage
extends ArchiveEntry
implements ResultPackageInterface,
RemoteSessionContextStateChangedListener {
    private String _abstract;
    private long _creationDateTime;
    private long _expirationDateTime;
    private String _extractionDirectory;
    private ArrayList _entries;
    private boolean _nested;
    private Map _allMyEntries = new HashMap();
    private String _textEncoding;
    private String _uniqueId = new VMID().toString();
    private SessionContextInterface _sessionContext = null;
    private PackageInterface _packageSmartObject = null;
    private boolean _isReplicated = false;
    private ResourceInterface _davResource = null;
    private TransportInterface _transport = null;
    static ByteArrayInputStream dummyInputStream = new ByteArrayInputStream(new byte[1]);
    private Logger logger = LogManager.getLogger(ArchiveResultPackage.class);

    private ArchiveResultPackage() throws RemoteException {
        super(ArchiveResultPackage.class);
    }

    ArchiveResultPackage(ArchiveTransport transport, String filename) throws RemoteException, TransportException {
        this(transport, filename, (String)null);
    }

    ArchiveResultPackage(ArchiveTransport transport, String filename, String extractionDirectory, PackageInterface packageSmartObject, boolean isReplicated) throws RemoteException, TransportException {
        this(transport, filename, extractionDirectory);
        this._packageSmartObject = packageSmartObject;
        this._isReplicated = isReplicated;
    }

    ArchiveResultPackage(ArchiveTransport transport, String filename, String extractionDirectory) throws RemoteException, TransportException {
        this(transport, filename, extractionDirectory, false);
    }

    ArchiveResultPackage(ArchiveTransport transport, String filename, String extractionDirectory, boolean nested) throws RemoteException, TransportException {
        this();
        this.setName(filename);
        this._extractionDirectory = extractionDirectory;
        this._nested = nested;
        this._entries = new ArrayList();
        if (transport != null) {
            if (nested) {
                this._transport = transport;
            }
            this._sessionContext = transport.getSessionContext();
        }
    }

    ArchiveResultPackage(ArchiveTransport transport, String filename, String extractionDirectory, ResourceInterface davResource) throws RemoteException, TransportException {
        this(transport, filename, extractionDirectory);
        this._davResource = davResource;
        this._isReplicated = true;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream is = null;
        this.throwExceptionIfClosed();
        if (this.isNested()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveResultPackage.nestedStream.ex.txt"));
        }
        ArchiveZipTable zt = this.getZipTable();
        if (zt != null) {
            is = zt.getPackageInputStream();
        }
        return is;
    }

    protected InputStream getNestedInputStream() throws IOException {
        return super.getInputStream();
    }

    protected void setReplicated(boolean replicated) {
        this._isReplicated = replicated;
    }

    @Override
    public java.lang.Object hasInputStream() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return dummyInputStream;
    }

    @Override
    public InputStream getInputStream(java.lang.Object streamID) throws ChainedIOException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.isNested()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveResultPackage.nestedStream.ex.txt"));
        }
        return null;
    }

    @Override
    public RemoteInputStreamInterface getRemoteInputStream(java.lang.Object streamID) throws IOException, RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.isNested()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveResultPackage.nestedStream.ex.txt"));
        }
        return null;
    }

    @Override
    public String getURL() throws IllegalStateException, TransportException, RemoteException {
        String url = null;
        this.throwExceptionIfClosed();
        if (this._davResource != null) {
            try {
                url = this._davResource.getURL();
            }
            catch (DAVException e) {
                throw new TransportException((Throwable)e, e.getMessage());
            }
        }
        return url;
    }

    @Override
    public boolean isNested() throws IllegalStateException {
        this.throwExceptionIfClosed();
        if (!this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveResultPackage.nestedIllegalStateException.ex.txt"));
        }
        return this._nested;
    }

    String getExtractionDirectory() {
        return this._extractionDirectory;
    }

    protected String getTextEncoding() {
        return this._textEncoding;
    }

    protected void setTextEncoding(String textEncoding) {
        this._textEncoding = textEncoding;
    }

    protected String getUniqueId() {
        return this._uniqueId;
    }

    protected void setUniqueId(String uniqueId) {
        this._uniqueId = uniqueId;
    }

    @Override
    public void close() throws TransportException, IllegalStateException, RemoteException {
        block6: {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveResultPackage.closeIt.fmt.txt", (java.lang.Object)this.getEntityKey()));
            }
            this.throwExceptionIfClosed();
            if (this.isNested()) {
                throw new IllegalStateException(RB.getStringResource("ArchiveResultPackage.closeNestedIllegalStateException.ex.txt"));
            }
            this.closeEverything();
            if (this._isReplicated) {
                this.deleteLocal();
            }
            if (this._davResource != null) {
                try {
                    this._davResource.close();
                }
                catch (Throwable t) {
                    if (this.logger == null) break block6;
                    this.logger.warn(RB.getStringResource("ArchiveResultPackage.closeErr.txt"), t);
                }
            }
        }
    }

    @Override
    public void delete() throws IllegalStateException, TransportException, RemoteException {
        this.throwExceptionIfClosed();
        if (this.isNested()) {
            throw new TransportException(RB.getStringResource("ArchiveResultPackage.deleteNestedTransportException.ex.txt"));
        }
        this.closeEverything();
        try {
            this.deleteLocal();
        }
        catch (TransportException e) {
            if (this._isReplicated) {
                if (this.logger != null) {
                    this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveResultPackage.replicaErr.fmt.txt", (java.lang.Object)this.getName()));
                }
            }
            throw e;
        }
        if (this._packageSmartObject != null) {
            try {
                if (this._isReplicated) {
                    this.deleteRemote();
                }
            }
            catch (ServiceException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveResultPackage.remoteErr.txt"));
            }
        }
        if (this._davResource != null) {
            try {
                this._davResource.delete();
                this._davResource.close();
            }
            catch (DAVException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveResultPackage.davDelErr.ex.txt"));
            }
        }
    }

    private void closeEverything() {
        block9: {
            for (ArchiveEntry e : this._entries) {
                e.closeEntry();
            }
            this.closeEntry();
            if (this._sessionContext != null) {
                try {
                    this._sessionContext.removeAttribute("com.sas.services.publish." + this._uniqueId);
                }
                catch (IllegalStateException e) {
                    if (this.logger != null && this.logger.isDebugEnabled()) {
                        this.logger.debug(RB.getStringResource("ArchiveResultPackage.errorRemovingFromSession.txt"), (Throwable)e);
                    }
                }
                catch (RemoteException e) {
                    if (this.logger == null || !this.logger.isDebugEnabled()) break block9;
                    this.logger.debug(RB.getStringResource("ArchiveResultPackage.errorRemovingFromSession.txt"), (Throwable)e);
                }
            }
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            try {
                this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveResultPackage.closeDone.fmt.txt", (java.lang.Object)this.getEntityKey()));
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    protected void deleteLocal() throws TransportException {
        this.setClosed(false);
        try {
            File f = new File(this.getName());
            boolean b = f.delete();
            if (!b) {
                this.setClosed(true);
                throw new TransportException(RB.getStringResource("ArchiveResultPackage.deleteFailedTransportException.ex.txt"));
            }
        }
        catch (TransportException e) {
            this.setClosed(true);
            throw e;
        }
        catch (SecurityException e) {
            this.setClosed(true);
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveResultPackage.deleteFailedTransportException.ex.txt"));
        }
        this.setClosed(true);
    }

    @Override
    public long getCreationDateTime() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this._creationDateTime;
    }

    protected void setCreationDateTime(long creationDateTime) throws IllegalStateException {
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveResultPackage.readOnlyIllegalStateException.ex.txt"));
        }
        this._creationDateTime = creationDateTime;
    }

    @Override
    public void addEntry(EntryInterface entry) throws IllegalStateException, RemoteException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveResultPackage.readOnlyIllegalStateException.ex.txt"));
        }
        boolean inserted = false;
        int thisPosition = ((ArchiveEntry)entry).getPosition();
        if (this._entries.size() > 0 && thisPosition != -1) {
            for (int i = 0; i < this._entries.size(); ++i) {
                ArchiveEntry ae = (ArchiveEntry)this._entries.get(i);
                if (thisPosition >= ae.getPosition()) continue;
                this._entries.add(i, entry);
                inserted = true;
                break;
            }
        }
        if (!inserted) {
            this._entries.add(entry);
        }
        this._allMyEntries.put(entry.getEntityKey(), entry);
    }

    @Override
    public EntryInterface getEntry(int index) throws IllegalStateException, TransportException, RemoteException {
        this.throwExceptionIfClosed();
        this.initCheck();
        return (EntryInterface)this._entries.get(index);
    }

    @Override
    public EntryInterface getEntry(String uniqueId) throws IllegalStateException, RemoteException, TransportException {
        this.throwExceptionIfClosed();
        this.initCheck();
        return this.findEntry(uniqueId);
    }

    EntryInterface findEntry(String uniqueId) throws TransportException, RemoteException {
        EntryInterface[] entryList = null;
        EntryInterface foundEntry = null;
        foundEntry = (EntryInterface)this._allMyEntries.get(uniqueId);
        if (foundEntry == null) {
            entryList = this.getEntries();
            for (int i = 0; i < entryList.length && foundEntry == null; ++i) {
                EntryInterface entry = entryList[i];
                if (!(entry instanceof ResultPackageInterface)) continue;
                ArchiveResultPackage archivePkg = (ArchiveResultPackage)entry;
                foundEntry = archivePkg.findEntry(uniqueId);
            }
        }
        return foundEntry;
    }

    @Override
    public EntryInterface[] getEntries() throws IllegalStateException, TransportException, RemoteException {
        this.throwExceptionIfClosed();
        this.initCheck();
        EntryInterface[] entries = new EntryInterface[this._entries.size()];
        Iterator itor = this._entries.iterator();
        int i = 0;
        while (itor.hasNext()) {
            entries[i++] = (EntryInterface)itor.next();
        }
        return entries;
    }

    @Override
    public long getExpirationDateTime() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this._expirationDateTime;
    }

    @Override
    public void setExpirationDateTime(long expirationDateTime) throws IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveResultPackage.readOnlyIllegalStateException.ex.txt"));
        }
        this._expirationDateTime = expirationDateTime;
    }

    @Override
    public String getAbstract() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this._abstract;
    }

    @Override
    public void setAbstract(String pkgAbstract) throws IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveResultPackage.readOnlyIllegalStateException.ex.txt"));
        }
        this._abstract = pkgAbstract;
    }

    @Override
    public EventDataInterface getEventData() throws TransportException, RemoteException {
        EventDataInterface eventData = null;
        ResultPackageEventBuilder builder = new ResultPackageEventBuilder();
        eventData = builder.buildEvent(this, this.getName(), null, "archive", null);
        return eventData;
    }

    public void contextStateChanged(SessionContextStateChangedEvent event) throws RemoteException {
        block8: {
            int state = event.getStateChange();
            if (state == 2) {
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(RB.getStringResource("ArchiveResultPackage.sessionDestroyed.txt"));
                }
                try {
                    this._sessionContext = null;
                    this.close();
                }
                catch (IllegalStateException e) {
                    if (this.logger != null) {
                        this.logger.warn(RB.getStringResource("ArchiveResultPackage.unexpectedDestroyError.txt"), (Throwable)e);
                    }
                    break block8;
                }
                catch (TransportException e) {
                    if (this.logger != null) {
                        this.logger.warn(RB.getStringResource("ArchiveResultPackage.unexpectedDestroyError.txt"), (Throwable)e);
                    }
                    break block8;
                }
            }
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(RB.getStringResource("ArchiveResultPackage.removedFromSession.txt"));
            }
        }
    }

    public void deleteRemote() throws TransportException {
        String filename = null;
        UserContextInterface userContext = null;
        try {
            userContext = this._packageSmartObject.getRepository().getUserContext();
        }
        catch (RemoteException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveCommon.metadata.ex.txt"));
        }
        try {
            Map m = PackageUtil.getDirectoryURL(this._packageSmartObject);
            String p = (String)m.get("PROTOCOL");
            if (p.equals("FILE")) {
                filename = (String)m.get("URL");
                if (this.logger != null && this.logger.isInfoEnabled()) {
                    this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveCommon.archiveInfo.fmt.txt", (java.lang.Object)filename));
                }
                this.deleteWithIOM(filename, userContext);
            } else if (p.equals("HTTP")) {
                this.deleteWithHttp((URL)m.get("URL"), (String)m.get("DOMAIN"), userContext);
            } else {
                this.deleteWithFtp((URL)m.get("URL"), (String)m.get("DOMAIN"), userContext);
            }
        }
        catch (ServiceException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveResultPackage.deleteErr.ex.txt"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteWithIOM(String filename, UserContextInterface userContext) throws TransportException {
        DirectoryInterface dir = null;
        LogicalServerInterface server = null;
        IFileService fileService = null;
        try (ConnectionInterface connection = null;){
            try {
                dir = this._packageSmartObject.getContentDestination().getDirectory();
            }
            catch (ServiceException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveCommon.metadata.ex.txt"));
            }
            catch (RemoteException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveCommon.metadata.ex.txt"));
            }
            if (this.logger != null && this.logger.isInfoEnabled()) {
                this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveResultPackage.deleteRem.fmt.txt", (java.lang.Object)filename));
            }
            try {
                List servers = dir.getServers();
                Iterator serverIt = servers.iterator();
                boolean foundIOM = false;
                while (serverIt.hasNext()) {
                    server = (LogicalServerInterface)serverIt.next();
                    for (String type : server.getServiceTypes()) {
                        if (!type.equals("Logical IOM Server")) continue;
                        foundIOM = true;
                        break;
                    }
                    if (!foundIOM) {
                        server = null;
                        continue;
                    }
                    break;
                }
            }
            catch (ServiceException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveCommon.metadata.ex.txt"));
            }
            catch (RemoteException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveCommon.metadata.ex.txt"));
            }
            if (server == null) {
                throw new TransportException(RB.getStringResource("ArchiveResultPackage.noDelServer.ex.txt"));
            }
            try {
                String longLivedUser = null;
                if (this._sessionContext != null && (longLivedUser = (String)this._sessionContext.getAttribute("com.sas.services.connection.platform.privilegedUserNameKey")) != null && this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(RB.getStringResource("ArchiveCommon.privUser.txt"));
                }
                PlatformConnectionFactoryConfiguration config = new PlatformConnectionFactoryConfiguration(server, longLivedUser);
                PlatformConnectionFactoryInterface cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)config);
                connection = cxf.getConnection(userContext);
                Object obj = connection.getObject();
                IWorkspace iWorkspace = IWorkspaceHelper.narrow((Object)obj);
                fileService = iWorkspace.FileService();
            }
            catch (ConnectionFactoryException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveResultPackage.connectDelErr.ex.txt"));
            }
            catch (RemoteException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveResultPackage.connectDelErr.ex.txt"));
            }
            try {
                StringHolder stringHolder = new StringHolder();
                IFileref fileref = null;
                String requestedName = "";
                String accessMethod = "DISK";
                String externalFile = filename;
                String hostOptions = "";
                fileref = fileService.AssignFileref(requestedName, accessMethod, externalFile, hostOptions, stringHolder);
                fileref.DeleteFile();
            }
            catch (GenericError e) {
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveResultPackage.deleteErr.ex.txt"));
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void deleteWithHttp(URL u, String domain, UserContextInterface userContext) throws TransportException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteWithFtp(URL u, String domain, UserContextInterface userContext) throws TransportException {
        DirectoryInterface dir = null;
        LogicalServerInterface logicalServer = null;
        ConnectionInterface connection = null;
        IFileService fileService = null;
        UserIdentityInterface ident = null;
        Iterator logItor = null;
        String ftpUser = null;
        String ftpPw = null;
        String urlStr = null;
        try {
            String filename;
            block38: {
                try {
                    String uPath = u.getPath();
                    filename = uPath != null && uPath.length() > 0 ? URIUtil.addSegment((String)u.getPath(), (String)(this._packageSmartObject.getName() + ".spk")) : this._packageSmartObject.getName() + ".spk";
                    dir = this._packageSmartObject.getContentDestination().getDirectory();
                }
                catch (ServiceException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveCommon.metadata.ex.txt"));
                }
                catch (RemoteException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveCommon.metadata.ex.txt"));
                }
                if (this.logger != null && this.logger.isInfoEnabled()) {
                    this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveResultPackage.deleteRem.fmt.txt", (java.lang.Object)filename));
                }
                try {
                    List servers = dir.getServers();
                    Iterator serverIt = servers.iterator();
                    boolean foundIOM = false;
                    while (serverIt.hasNext()) {
                        ServerInterface server = (ServerInterface)serverIt.next();
                        for (String type : server.getServiceTypes()) {
                            if (!type.equals("Logical IOM Server")) continue;
                            logicalServer = (LogicalServerInterface)server;
                            foundIOM = true;
                            break;
                        }
                        if (!foundIOM) continue;
                        break;
                    }
                }
                catch (ServiceException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveCommon.metadata.ex.txt"));
                }
                catch (RemoteException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveCommon.metadata.ex.txt"));
                }
                if (logicalServer == null) {
                    throw new TransportException(RB.getStringResource("ArchiveResultPackage.noDelServer.ex.txt"));
                }
                try {
                    String longLivedUser = null;
                    if (this._sessionContext != null && (longLivedUser = (String)this._sessionContext.getAttribute("com.sas.services.connection.platform.privilegedUserNameKey")) != null && this.logger != null && this.logger.isDebugEnabled()) {
                        this.logger.debug(RB.getStringResource("ArchiveCommon.privUser.txt"));
                    }
                    PlatformConnectionFactoryConfiguration config = new PlatformConnectionFactoryConfiguration(logicalServer, longLivedUser);
                    PlatformConnectionFactoryInterface cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)config);
                    connection = cxf.getConnection(userContext);
                    Object obj = connection.getObject();
                    IWorkspace iWorkspace = IWorkspaceHelper.narrow((Object)obj);
                    fileService = iWorkspace.FileService();
                    if (domain == null || userContext == null) break block38;
                    final String dom = domain;
                    final UserContextInterface uc = userContext;
                    PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                        public java.lang.Object run() throws Exception {
                            return uc.getIdentitiesByDomain(dom, true, "");
                        }
                    };
                    List ilist = null;
                    try {
                        ilist = (List)AccessController.doPrivileged(action);
                    }
                    catch (PrivilegedActionException pae) {
                        throw new TransportException(pae.getCause(), RB.getStringResource("ArchiveResultPackage.connectDelErr.ex.txt"));
                    }
                    logItor = ilist.iterator();
                    if (logItor.hasNext()) {
                        ident = (UserIdentityInterface)logItor.next();
                        ftpUser = (String)ident.getPrincipal();
                        try {
                            ftpPw = SasPasswordString.decode((String)((String)ident.getCredential()));
                        }
                        catch (SasPasswordEncodingException e) {
                            ftpPw = (String)ident.getCredential();
                        }
                    }
                }
                catch (ConnectionFactoryException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveResultPackage.connectDelErr.ex.txt"));
                }
                catch (RemoteException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveResultPackage.connectDelErr.ex.txt"));
                }
            }
            try {
                boolean done = false;
                while (!done) {
                    StringHolder stringHolder;
                    block39: {
                        stringHolder = new StringHolder();
                        IFileref fileref = null;
                        String requestedName = "";
                        String accessMethod = "FTP";
                        String externalFile = filename;
                        String hostOptions = "";
                        StringBuffer buf = new StringBuffer(200);
                        buf.append("host='");
                        buf.append(u.getHost());
                        buf.append("' ");
                        if (ftpUser != null) {
                            buf.append("user='");
                            buf.append(ftpUser);
                            buf.append("' pass='");
                            buf.append(ftpPw);
                            buf.append("'");
                        }
                        buf.append(" rcmd='dele ");
                        buf.append(filename);
                        buf.append("'");
                        hostOptions = buf.toString();
                        fileref = fileService.AssignFileref(requestedName, accessMethod, externalFile, hostOptions, stringHolder);
                        StreamOpenMode readmode = StreamOpenMode.StreamOpenModeForReading;
                        try {
                            fileref.OpenBinaryStream(readmode);
                            done = true;
                        }
                        catch (GenericError e) {
                            try {
                                int pos;
                                String p = URIUtil.addSegment((String)u.toExternalForm(), (String)(this._packageSmartObject.getName() + ".spk"));
                                URL u2 = new URL(p);
                                urlStr = u2.toString();
                                if (ftpUser != null && (pos = urlStr.indexOf("://")) > 0) {
                                    buf = new StringBuffer(urlStr.length() + ftpUser.length() + ftpPw.length() + 3);
                                    buf.append(urlStr.substring(0, pos + 3));
                                    buf.append(ftpUser);
                                    buf.append(":");
                                    buf.append(ftpPw);
                                    buf.append("@");
                                    buf.append(urlStr.substring(pos + 3));
                                    u2 = new URL(buf.toString());
                                }
                                URLConnection urlConn = u2.openConnection();
                                urlConn.connect();
                                urlConn.getInputStream();
                                done = true;
                            }
                            catch (IOException e2) {
                                if (!(e2 instanceof FileNotFoundException)) {
                                    if (logItor != null && logItor.hasNext()) {
                                        if (this.logger != null && this.logger.isInfoEnabled()) {
                                            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveResultPackage.ftpRetry.fmt.txt", (java.lang.Object)urlStr, (java.lang.Object)e2.getMessage()));
                                        }
                                        ident = (UserIdentityInterface)logItor.next();
                                        ftpUser = (String)ident.getPrincipal();
                                        try {
                                            ftpPw = SasPasswordString.decode((String)((String)ident.getCredential()));
                                        }
                                        catch (SasPasswordEncodingException spee) {
                                            ftpPw = (String)ident.getCredential();
                                        }
                                        break block39;
                                    }
                                    done = true;
                                    throw e;
                                }
                                done = true;
                            }
                        }
                    }
                    fileService.DeassignFileref(stringHolder.value);
                }
            }
            catch (GenericError e) {
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveResultPackage.deleteErr.ex.txt"));
            }
        }
        finally {
            if (connection != null) {
                connection.close();
                connection = null;
            }
        }
    }

    @Override
    protected void closeEntry() {
        if (this.isNested()) {
            if (this._transport == null) {
                EntryInterface[] _entries = null;
                try {
                    _entries = this.getEntries();
                    for (int i = 0; i < _entries.length; ++i) {
                        ArchiveEntry e = (ArchiveEntry)_entries[i];
                        e.closeEntry();
                    }
                }
                catch (RemoteException e) {
                    this.printCloseErrorMsg(e);
                }
                catch (TransportException e) {
                    this.printCloseErrorMsg((Exception)((java.lang.Object)e));
                }
                boolean deleted = this.getZipTable().delete();
                if (deleted) {
                    if (this.logger != null && this.logger.isDebugEnabled()) {
                        this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveEntry.nestedDeleteError.fmt.txt", (java.lang.Object)this.getName()));
                    }
                } else {
                    String errMsg = Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveEntry.deleteNested.fmt.txt", (java.lang.Object)this.getName());
                    if (this.logger != null) {
                        this.logger.warn(errMsg);
                    } else {
                        System.err.println(errMsg);
                    }
                }
            } else {
                this._transport = null;
            }
        } else {
            this.getZipTable().close();
            super.closeEntry();
        }
    }

    private void initCheck() throws RemoteException, TransportException {
        if (this._transport != null) {
            this.setIsReadOnly(false);
            ((ArchiveTransport)this._transport).initializeResultPackage(this, true);
            this.setIsReadOnly(true);
            this._transport = null;
        }
    }

    protected void finalize() throws Throwable {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveResultPackage.finalize.fmt.txt", (java.lang.Object)this.getEntityKey()));
        }
        if (!this.isClosed() && !this.isNested()) {
            this.close();
        }
        super.finalize();
    }
}

