/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.archive;

import com.sas.codepolicy.SASScope;
import com.sas.services.TransportException;
import com.sas.services.publish.ReferenceEntryInterface;
import com.sas.services.publish.archive.ArchiveEntry;
import com.sas.services.publish.archive.ArchiveResultPackage;
import com.sas.services.publish.archive.ArchiveZipTable;
import com.sas.services.publish.archive.RB;
import com.sas.text.Message;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
class ArchiveReferenceEntry
extends ArchiveEntry
implements ReferenceEntryInterface {
    private String _reference;
    private String _referenceType;

    ArchiveReferenceEntry() throws RemoteException {
        super(ArchiveReferenceEntry.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getReference() throws IllegalStateException, TransportException {
        this.throwExceptionIfClosed();
        Logger logger = LogManager.getLogger(ArchiveReferenceEntry.class);
        if (this.getVersion() > 15) {
            throw new TransportException(RB.getStringResource("ArchiveCommon.compat.ex.txt"));
        }
        String returnRef = null;
        ArchiveZipTable zip = this.getZipTable();
        String encoding = null;
        InputStream stream = null;
        BufferedReader reader = null;
        try {
            stream = zip.getInputStream(this.getName());
            encoding = ((ArchiveResultPackage)this.getPackage()).getTextEncoding();
            reader = new BufferedReader(new InputStreamReader(stream, encoding));
            returnRef = reader.readLine();
        }
        catch (IOException e) {
            if (stream != null) {
                DataInputStream dis = new DataInputStream(stream);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                try {
                    int len;
                    while ((len = dis.read(buffer)) != -1) {
                        baos.write(buffer, 0, len);
                    }
                    returnRef = baos.toString();
                }
                catch (IOException e2) {
                    if (logger != null) {
                        logger.warn(RB.getStringResource("ArchiveReferenceEntry.ioErr.txt"));
                    }
                }
                finally {
                    try {
                        baos.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        dis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (logger != null) {
                logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveReferenceEntry.encErr.fmt.txt", (Object)encoding));
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                    stream = null;
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                    reader = null;
                }
                catch (IOException iOException) {}
            }
        }
        return returnRef;
    }

    @Override
    public void setReferenceType(String referenceType) throws IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.entryReadOnly.ex.txt"));
        }
        this._referenceType = referenceType;
    }

    @Override
    public void setReference(String reference) throws IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.entryReadOnly.ex.txt"));
        }
        this._reference = reference;
    }

    @Override
    public String getReferenceType() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this._referenceType;
    }
}

