/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.archive;

import com.sas.codepolicy.SASScope;
import com.sas.io.InputStreamAdapter;
import com.sas.services.publish.archive.ArchiveZipTable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.rmi.RemoteException;

@SASScope
public class ArchiveInputStreamWrapper
extends InputStreamAdapter
implements Serializable {
    private static final long serialVersionUID = 3256441391516299828L;
    private ArchiveZipTable _zipTable;
    private boolean _closed = false;
    private static final byte[] CLOSE_LOCK = new byte[0];

    public ArchiveInputStreamWrapper(InputStream inputstream) throws RemoteException {
        this(inputstream, null);
    }

    public ArchiveInputStreamWrapper(InputStream inputstream, ArchiveZipTable zipTable) throws RemoteException {
        super(inputstream);
        this._zipTable = zipTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        super.close();
        byte[] byArray = CLOSE_LOCK;
        synchronized (CLOSE_LOCK) {
            if (!this._closed) {
                this._closed = true;
                this._zipTable.decrement();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

