/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.archive;

import com.sas.codepolicy.SASScope;
import com.sas.entities.EntityKeyInterface;
import com.sas.io.ChainedIOException;
import com.sas.io.InputStreamAdapter;
import com.sas.io.RemoteInputStream;
import com.sas.io.RemoteInputStreamInterface;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.DefaultEntityKeyImpl;
import com.sas.services.publish.HTMLFileInterface;
import com.sas.services.publish.archive.ArchiveZipTable;
import com.sas.services.publish.archive.RB;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.server.UnicastRemoteObject;

@SASScope
class ArchiveHTMLFile
extends UnicastRemoteObject
implements HTMLFileInterface {
    private String _encoding = null;
    private boolean _isReadOnly = false;
    private String _mimeType;
    private int _role;
    private ArchiveZipTable _zipTable;
    private String _name;
    private String _url;
    private boolean _closed = false;
    private EntityKeyInterface _entityKeyIf = new DefaultEntityKeyImpl();
    private int _position = -1;
    private static final ByteArrayInputStream DUMMY_INPUTSTREAM = new ByteArrayInputStream(new byte[1]);

    ArchiveHTMLFile() throws RemoteException {
        super(SSLRMISocketFactories.getInstance().getPortForClass(0, ArchiveHTMLFile.class), SSLRMISocketFactories.getInstance().getRMIClientSocketFactoryForClass(ArchiveHTMLFile.class), SSLRMISocketFactories.getInstance().getRMIServerSocketFactoryForClass(ArchiveHTMLFile.class));
    }

    protected boolean isClosed() {
        return this._closed;
    }

    protected void closeEntry() {
        this._closed = true;
        this._zipTable = null;
    }

    protected int getPosition() {
        return this._position;
    }

    protected void setPosition(int position) {
        this._position = position;
    }

    @Override
    public String getURL() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.alreadyClosed.ex.txt"));
        }
        return this._url;
    }

    @Override
    public void setURL(String url) throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.alreadyClosed.ex.txt"));
        }
        if (this._isReadOnly) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.entryReadOnly.ex.txt"));
        }
        this._url = url;
    }

    @Override
    public String getEncoding() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.alreadyClosed.ex.txt"));
        }
        return this._encoding;
    }

    @Override
    public void setEncoding(String encoding) throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.alreadyClosed.ex.txt"));
        }
        if (this._isReadOnly) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.entryReadOnly.ex.txt"));
        }
        this._encoding = encoding;
    }

    public boolean isReadOnly() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.alreadyClosed.ex.txt"));
        }
        return this._isReadOnly;
    }

    protected final void setIsReadOnly(boolean isReadOnly) {
        this._isReadOnly = isReadOnly;
    }

    protected void setRole(int role) {
        this._role = role;
    }

    protected void setName(String name) {
        this._name = name;
    }

    protected void setZipTable(ArchiveZipTable table) {
        this._zipTable = table;
    }

    protected ArchiveZipTable getZipTable() {
        return this._zipTable;
    }

    @Override
    public String getName() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.alreadyClosed.ex.txt"));
        }
        return this._name;
    }

    @Override
    public String getMIMEType() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.alreadyClosed.ex.txt"));
        }
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.alreadyClosed.ex.txt"));
        }
        return this._mimeType;
    }

    @Override
    public void setMIMEType(String mimeType) throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.alreadyClosed.ex.txt"));
        }
        if (this._isReadOnly) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.entryReadOnly.ex.txt"));
        }
        this._mimeType = mimeType;
    }

    @Override
    public int getRole() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.alreadyClosed.ex.txt"));
        }
        return this._role;
    }

    @Override
    public InputStream getInputStream() throws IOException, IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.alreadyClosed.ex.txt"));
        }
        try {
            return new InputStreamAdapter(this._zipTable.getInputStream(this._name));
        }
        catch (IOException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("ArchiveCommon.streamIOError.ex.txt"));
        }
    }

    @Override
    public InputStream getInputStream(Object streamId) throws ChainedIOException, IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.alreadyClosed.ex.txt"));
        }
        try {
            return this._zipTable.getInputStream(this._name);
        }
        catch (IOException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("ArchiveCommon.streamIOError.ex.txt"));
        }
    }

    @Override
    public RemoteInputStreamInterface getRemoteInputStream(Object streamId) throws ChainedIOException, IllegalStateException, RemoteException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.alreadyClosed.ex.txt"));
        }
        InputStream stream = null;
        try {
            stream = this.getZipTable().getInputStream(this.getName());
        }
        catch (IOException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("ArchiveCommon.remoteStreamIOError.ex.txt"));
        }
        return new RemoteInputStream(stream);
    }

    @Override
    public Object hasInputStream() throws UnmarshalException, IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.alreadyClosed.ex.txt"));
        }
        return DUMMY_INPUTSTREAM;
    }

    public String getEntityKey() throws IllegalStateException, RemoteException {
        return this._entityKeyIf.getEntityKey();
    }

    public boolean sameEntity(EntityKeyInterface entity) throws RemoteException {
        return this._entityKeyIf.sameEntity(entity);
    }

    public void setEntityKey(String entityKey) throws RemoteException, IllegalStateException {
        this._entityKeyIf.setEntityKey(entityKey);
    }
}

