/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.alerts;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.publish.alerts.AlertUtil;
import com.sas.services.publish.alerts.RB;
import com.sas.services.publish.alerts.Template;
import com.sas.text.Message;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;

@SASScope
public class URLTemplate
extends Template {
    private URL _url;

    public URLTemplate(String url) throws ServiceException {
        super(url);
        try {
            this._url = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new ServiceException(RB.getStringResource("URLTemplate.invalidURL.ex.txt"));
        }
    }

    public URLTemplate(URL url) {
        super(url.toString());
        this._url = url;
    }

    @Override
    public String getPath() {
        return super.getPath();
    }

    @Override
    public String getResult() throws ServiceException {
        String templateStr = null;
        try {
            InputStream is = this._url.openStream();
            templateStr = AlertUtil.resolveTemplate(is, this);
        }
        catch (IOException ioe) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Common.IOExceptionReadingTemplate.ex.fmt.txt", (Object)this.getPath(), (Object)ioe.getMessage()));
        }
        return templateStr;
    }
}

