/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.alerts;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.publish.alerts.AbstractTemplate;
import com.sas.services.publish.alerts.AlertUtil;
import com.sas.services.publish.alerts.RB;
import com.sas.text.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;

@SASScope
public class Template
extends AbstractTemplate {
    private String _path;

    public Template(String pathname) {
        this._path = pathname;
    }

    @Override
    public String getPath() {
        return this._path;
    }

    @Override
    public String getResult() throws ServiceException {
        String path = this.getPath();
        String templateStr = null;
        InputStream is = null;
        try {
            File file = new File(path);
            is = new FileInputStream(file);
            templateStr = AlertUtil.resolveTemplate(is, this);
        }
        catch (IOException ioe) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Common.IOExceptionReadingTemplate.ex.fmt.txt", (Object)path, (Object)ioe.getMessage()));
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return templateStr;
    }
}

