/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.alerts;

import com.sas.codepolicy.SASScope;
import com.sas.framework.commons.util.MimeTypeMapper;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.publish.DAVMailDataSource;
import com.sas.services.publish.FileMailDataSource;
import com.sas.services.publish.MailAttachment;
import com.sas.services.publish.StreamMailDataSource;
import com.sas.services.publish.URLMailDataSource;
import com.sas.services.publish.alerts.MailAlertTransportInterface;
import com.sas.services.publish.alerts.RB;
import com.sas.services.publish.alerts.SMTPServerInfo;
import com.sas.services.publish.alerts.TemplateInterface;
import com.sas.svcs.mail.client.InlineData;
import com.sas.svcs.mail.client.Mail;
import com.sas.svcs.mail.client.MailAddress;
import com.sas.svcs.mail.client.MailServiceInterface;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class MailAlertTransport
implements MailAlertTransportInterface {
    private Logger _saslogger = null;
    private String _emailAddress;
    private String _bcc;
    private String _smtpHost;
    private int _smtpPort = -1;
    private String _smtpSubject;
    private String _smtpSubjectCharset = null;
    private String _smtpFrom;
    private String _smtpFromPersonalNameCharset = null;
    private String _smtpFromPersonalName;
    private String _smtpUser;
    private String _smtpPassword;
    private String _smtpReplyTo;
    private String _smtpReplyToPersonalNameCharset = null;
    private String _smtpReplyToPersonalName;
    private String _contentType;
    private List _attachments = new ArrayList();
    private TemplateInterface _template = null;
    private Transport _transport = null;
    private MailServiceInterface _mailService = null;
    private Logger logger = LogManager.getLogger(MailAlertTransport.class);
    private boolean sanitizeSubject;

    MailAlertTransport() {
        this((SMTPServerInfo)null);
    }

    MailAlertTransport(SMTPServerInfo info) {
        if (info != null) {
            this._smtpHost = info.getHost();
            this._smtpPort = info.getPort();
            this._smtpUser = info.getUser();
            this._smtpPassword = info.getPassword();
        }
    }

    MailAlertTransport(MailServiceInterface mailService) {
        if (mailService == null) {
            throw new IllegalArgumentException("Mail Service is required.");
        }
        this._mailService = mailService;
    }

    @Override
    public void addAttachment(String path, String contentId, String name, String contentType) {
        MailAttachment at = new MailAttachment(path, contentId, name, contentType);
        this._attachments.add(at);
    }

    @Override
    public void addAttachment(String url, String user, String password, String contentId, String name, String contentType) {
        MailAttachment at = new MailAttachment(url, user, password, contentId, name, contentType);
        this._attachments.add(at);
    }

    @Override
    public void addAttachment(URL url, String contentId, String name, String contentType) {
        MailAttachment at = new MailAttachment(url, contentId, name, contentType);
        this._attachments.add(at);
    }

    @Override
    public void addAttachment(InputStream inputStream, String contentId, String name, String contentType) {
        MailAttachment at = new MailAttachment(inputStream, contentId, name, contentType);
        this._attachments.add(at);
    }

    void setUser(String user) {
        this._smtpUser = user;
    }

    void setPassword(String password) {
        this._smtpPassword = password;
    }

    @Override
    public String getReplyTo() {
        return this._smtpReplyTo;
    }

    @Override
    public void setReplyTo(String replyTo) {
        this._smtpReplyTo = replyTo;
    }

    @Override
    public String getReplyToName() {
        return this._smtpReplyToPersonalName;
    }

    public String getReplyToNameCharset() {
        return this._smtpReplyToPersonalNameCharset;
    }

    @Override
    public void setReplyToName(String personalName) {
        this.setReplyToName(personalName, null);
    }

    @Override
    public void setReplyToName(String personalName, String charset) {
        this._smtpReplyToPersonalName = personalName;
        this._smtpReplyToPersonalNameCharset = charset;
    }

    @Override
    public String getEmailAddress() {
        return this._emailAddress;
    }

    @Override
    public void setEmailAddress(String address) {
        this._emailAddress = address;
    }

    void setHost(String host) {
        this._smtpHost = host;
    }

    void setPort(int port) {
        this._smtpPort = port;
    }

    @Override
    public String getSubject() {
        return this._smtpSubject;
    }

    public String getSubjectCharset() {
        return this._smtpSubjectCharset;
    }

    @Override
    public void setSubject(String subject) {
        this.setSubject(subject, null);
    }

    @Override
    public void setSubject(String subject, String charset) {
        this._smtpSubject = subject;
        this._smtpSubjectCharset = charset;
    }

    @Override
    public String getFrom() {
        return this._smtpFrom;
    }

    @Override
    public void setFrom(String from) {
        this._smtpFrom = from;
    }

    @Override
    public String getFromName() {
        return this._smtpFromPersonalName;
    }

    public String getFromNameCharset() {
        return this._smtpFromPersonalNameCharset;
    }

    @Override
    public void setFromName(String personalName) {
        this.setFromName(personalName, null);
    }

    @Override
    public void setFromName(String personalName, String charset) {
        this._smtpFromPersonalName = personalName;
        this._smtpFromPersonalNameCharset = charset;
    }

    @Override
    public void setContentType(String contentType) {
        this._contentType = contentType;
    }

    @Override
    public String getContentType() {
        return this._contentType;
    }

    @Override
    public String getBccAddress() {
        return this._bcc;
    }

    @Override
    public void setBccAddress(String address) {
        this._bcc = address;
    }

    @Override
    public void send(TemplateInterface template) throws TransportException, IllegalArgumentException {
        if (template == null) {
            throw new IllegalArgumentException(RB.getStringResource("Common.nullMsg.ex.txt"));
        }
        if (this._mailService != null) {
            this.sendWithMailService(template);
        } else {
            this.sendDirectly(template);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDirectly(TemplateInterface template) throws TransportException, IllegalArgumentException {
        String contentType = null;
        Session session = null;
        try {
            String addr;
            Properties props;
            this._template = template;
            contentType = this.getContentType();
            try {
                props = System.getProperties();
            }
            catch (SecurityException se) {
                props = new Properties();
            }
            session = Session.getDefaultInstance((Properties)props, null);
            try {
                this._transport = session.getTransport("smtp");
                this._transport.connect(this._smtpHost, this._smtpPort, this._smtpUser, this._smtpPassword);
            }
            catch (NoSuchProviderException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("MailAlertTransport.initErr.ex.txt"));
            }
            catch (MessagingException me) {
                throw new TransportException((Throwable)me, RB.getStringResource("MailAlertTransport.initErr.ex.txt"));
            }
            MimeMessage mm = new MimeMessage(session);
            if (this.getFrom() != null && !this.getFrom().equals("")) {
                try {
                    InternetAddress ia = new InternetAddress(this.getFrom(), this.getFromName(), this.getFromNameCharset());
                    mm.setFrom((Address)ia);
                }
                catch (AddressException ae) {
                    throw new TransportException((Throwable)ae, com.sas.text.Message.format((ResourceBundle)RB.getResources(), (String)"MailAlertTransport.fromAddrErr.ex.fmt.txt", (Object)this.getFrom()));
                }
                catch (MessagingException me) {
                    throw new TransportException((Throwable)me, com.sas.text.Message.format((ResourceBundle)RB.getResources(), (String)"MailAlertTransport.fromAddrErr.ex.fmt.txt", (Object)this.getFrom()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new TransportException((Throwable)e, com.sas.text.Message.format((ResourceBundle)RB.getResources(), (String)"MailAlertTransport.fromAddrErr.ex.fmt.txt", (Object)this.getFrom()));
                }
            }
            if (this.getReplyTo() != null && !this.getReplyTo().equals("")) {
                try {
                    InternetAddress[] replies = new InternetAddress[]{new InternetAddress(this.getReplyTo(), this.getReplyToName(), this.getReplyToNameCharset())};
                    mm.setReplyTo((Address[])replies);
                }
                catch (AddressException ae) {
                    throw new TransportException((Throwable)ae, com.sas.text.Message.format((ResourceBundle)RB.getResources(), (String)"MailAlertTransport.replyAddrErr.ex.fmt.txt", (Object)this.getReplyTo()));
                }
                catch (MessagingException me) {
                    throw new TransportException((Throwable)me, com.sas.text.Message.format((ResourceBundle)RB.getResources(), (String)"MailAlertTransport.replyAddrErr.ex.fmt.txt", (Object)this.getReplyTo()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new TransportException((Throwable)e, com.sas.text.Message.format((ResourceBundle)RB.getResources(), (String)"MailAlertTransport.fromAddrErr.ex.fmt.txt", (Object)this.getFrom()));
                }
            }
            if ((addr = this.getEmailAddress()) == null) {
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(RB.getStringResource("MailAlertTransport.noRecipients.txt"));
                }
                return;
            }
            if (addr.indexOf(44) == -1) {
                try {
                    mm.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(addr));
                }
                catch (AddressException ae) {
                    throw new TransportException((Throwable)ae, com.sas.text.Message.format((ResourceBundle)RB.getResources(), (String)"MailAlertTransport.recipAddrErr.ex.fmt.txt", (Object)addr));
                }
                catch (MessagingException me) {
                    throw new TransportException((Throwable)me, com.sas.text.Message.format((ResourceBundle)RB.getResources(), (String)"MailAlertTransport.recipAddrErr.ex.fmt.txt", (Object)addr));
                }
            } else {
                List l = this.parseEmail(addr);
                for (String current : l) {
                    try {
                        mm.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(current));
                    }
                    catch (AddressException ae) {
                        throw new TransportException((Throwable)ae, com.sas.text.Message.format((ResourceBundle)RB.getResources(), (String)"MailAlertTransport.recipAddrErr.ex.fmt.txt", (Object)current));
                    }
                    catch (MessagingException me) {
                        throw new TransportException((Throwable)me, com.sas.text.Message.format((ResourceBundle)RB.getResources(), (String)"MailAlertTransport.recipAddrErr.ex.fmt.txt", (Object)current));
                    }
                }
            }
            String bcc = this.getBccAddress();
            if (bcc != null) {
                try {
                    mm.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(bcc));
                }
                catch (AddressException ae) {
                    throw new TransportException((Throwable)ae, com.sas.text.Message.format((ResourceBundle)RB.getResources(), (String)"MailAlertTransport.recipBccErr.ex.fmt.txt", (Object)bcc));
                }
                catch (MessagingException me) {
                    throw new TransportException((Throwable)me, com.sas.text.Message.format((ResourceBundle)RB.getResources(), (String)"MailAlertTransport.recipBccErr.ex.fmt.txt", (Object)bcc));
                }
            }
            if (this.getSubject() != null) {
                try {
                    String subject = this.isSanitizeSubject() ? StringEscapeUtils.escapeHtml4((String)this.getSubject()) : this.getSubject();
                    mm.setSubject(subject, this.getSubjectCharset());
                }
                catch (MessagingException e) {
                    throw new TransportException((Throwable)e, com.sas.text.Message.format((ResourceBundle)RB.getResources(), (String)"MailAlertTransport.subjectErr.ex.fmt.txt", (Object)this.getSubject()));
                }
            }
            if (this._attachments.size() == 0) {
                try {
                    if (contentType != null && !contentType.equals("")) {
                        mm.setContent((Object)this._template.getResult(), contentType);
                    }
                    mm.setContent((Object)this._template.getResult(), "text/plain");
                }
                catch (MessagingException me) {
                    throw new TransportException((Throwable)me, RB.getStringResource("MailAlertTransport.contentErr.ex.txt"));
                }
                catch (ServiceException me) {
                    throw new TransportException((Throwable)me, RB.getStringResource("MailAlertTransport.contentErr.ex.txt"));
                }
            } else {
                try {
                    MailAttachment att2 = null;
                    boolean embeddedImages = false;
                    boolean attachmentsIncluded = false;
                    for (MailAttachment att2 : this._attachments) {
                        if (att2.getContentId() != null && !att2.getContentId().equals("")) {
                            embeddedImages = true;
                            continue;
                        }
                        attachmentsIncluded = true;
                    }
                    MimeMultipart multiPart = null;
                    MimeMultipart relatedMultiPart = null;
                    if (attachmentsIncluded) {
                        multiPart = new MimeMultipart("mixed");
                    }
                    if (embeddedImages) {
                        relatedMultiPart = new MimeMultipart("related");
                    }
                    MimeBodyPart bp = new MimeBodyPart();
                    if (contentType != null) {
                        bp.setContent((Object)this._template.getResult(), contentType);
                    } else {
                        bp.setContent((Object)this._template.getResult(), "text/plain");
                    }
                    if (!embeddedImages) {
                        multiPart.addBodyPart((BodyPart)bp);
                    } else {
                        relatedMultiPart.addBodyPart((BodyPart)bp);
                    }
                    Iterator itor = this._attachments.iterator();
                    while (itor.hasNext()) {
                        String mimeType;
                        boolean related = false;
                        att2 = (MailAttachment)itor.next();
                        DataSource ds = null;
                        URL url = null;
                        bp = new MimeBodyPart();
                        int attPathType = att2.getType();
                        if (attPathType == 1) {
                            if (null == att2.getContentType() || att2.getContentType().equals("")) {
                                mimeType = MimeTypeMapper.getMimeType((String)att2.getPath());
                                ds = new FileMailDataSource(att2.getPath(), mimeType);
                            } else {
                                ds = new FileMailDataSource(att2.getPath(), att2.getContentType());
                            }
                        } else if (attPathType == 2) {
                            url = new URL(att2.getPath());
                            if (null == att2.getContentType() || att2.getContentType().equals("")) {
                                mimeType = MimeTypeMapper.getMimeType((String)att2.getPath());
                                ds = new URLMailDataSource(url, mimeType);
                            } else {
                                ds = new URLMailDataSource(url, att2.getContentType());
                            }
                        } else if (attPathType == 3) {
                            if (null == att2.getContentType() || att2.getContentType().equals("")) {
                                mimeType = MimeTypeMapper.getMimeType((String)att2.getPath());
                                ds = new DAVMailDataSource(att2.getPath(), att2.getUser(), att2.getPassword(), mimeType, att2.getName());
                            } else {
                                ds = new DAVMailDataSource(att2.getPath(), att2.getUser(), att2.getPassword(), att2.getContentType(), att2.getName());
                            }
                        } else if (attPathType == 0) {
                            ds = new StreamMailDataSource(att2.getInputStream(), att2.getContentType(), att2.getName());
                        }
                        bp.setDataHandler(new DataHandler(ds));
                        if (att2.getContentId() != null && !att2.getContentId().equals("")) {
                            bp.setHeader("Content-ID", att2.getContentId());
                            related = true;
                        }
                        if (!related) {
                            if (att2.getName() != null && !att2.getName().equals("")) {
                                bp.setFileName(att2.getName());
                            } else if (att2.getType() == 1) {
                                bp.setFileName(ds.getName());
                            } else {
                                try {
                                    File f = new File(url.getFile());
                                    bp.setFileName(f.getName());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        if (related) {
                            relatedMultiPart.addBodyPart((BodyPart)bp);
                            continue;
                        }
                        multiPart.addBodyPart((BodyPart)bp);
                    }
                    if (embeddedImages && attachmentsIncluded) {
                        bp = new MimeBodyPart();
                        bp.setContent((Multipart)relatedMultiPart);
                        multiPart.addBodyPart((BodyPart)bp);
                        mm.setContent((Multipart)multiPart);
                    } else if (embeddedImages) {
                        mm.setContent((Multipart)relatedMultiPart);
                    } else {
                        mm.setContent((Multipart)multiPart);
                    }
                }
                catch (MessagingException me) {
                    throw new TransportException((Throwable)me, RB.getStringResource("MailAlertTransport.attachErr.ex.txt"));
                }
                catch (MalformedURLException me) {
                    throw new TransportException((Throwable)me, RB.getStringResource("MailAlertTransport.attachErr.ex.txt"));
                }
                catch (ServiceException me) {
                    throw new TransportException((Throwable)me, RB.getStringResource("MailAlertTransport.attachErr.ex.txt"));
                }
            }
            try {
                this._transport.sendMessage((Message)mm, mm.getAllRecipients());
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(com.sas.text.Message.format((ResourceBundle)RB.getResources(), (String)"MailAlertTransport.successfulPublish.fmt.txt", (Object)addr));
                }
            }
            catch (MessagingException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("MailAlertTransport.sendErr.ex.txt"));
            }
        }
        finally {
            if (this._transport != null) {
                try {
                    this._transport.close();
                }
                catch (MessagingException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("MailAlertTransport.closeErr.ex.txt"));
                }
                this._transport = null;
            }
        }
    }

    private void sendWithMailService(TemplateInterface template) throws TransportException, IllegalArgumentException {
        String subject;
        MailAddress[] toAddresses;
        String addr;
        if (template == null) {
            throw new IllegalArgumentException(RB.getStringResource("Common.nullMsg.ex.txt"));
        }
        Mail mail = new Mail();
        if (this.getFrom() != null && !this.getFrom().equals("")) {
            MailAddress fromAddress = new MailAddress(this.getFrom(), this.getFromName());
            mail.setFromAddress(fromAddress);
        }
        if (this.getReplyTo() != null && !this.getReplyTo().equals("")) {
            MailAddress replyAddress = new MailAddress(this.getReplyTo(), this.getReplyToName());
            mail.setReplyToAddress(replyAddress);
        }
        if ((addr = this.getEmailAddress()) == null) {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(RB.getStringResource("MailAlertTransport.noRecipients.txt"));
            }
            return;
        }
        if (addr.indexOf(44) == -1) {
            toAddresses = new MailAddress[1];
            MailAddress address = new MailAddress();
            address.setAddress(addr);
            toAddresses[0] = address;
            mail.setToAddresses(toAddresses);
        } else {
            List l = this.parseEmail(addr);
            toAddresses = new MailAddress[l.size()];
            mail.setToAddresses(toAddresses);
            for (int i = 0; i < l.size(); ++i) {
                String current = (String)l.get(i);
                MailAddress address = new MailAddress();
                address.setAddress(current);
                toAddresses[i] = address;
            }
        }
        String bcc = this.getBccAddress();
        if (bcc != null) {
            MailAddress bccAddress = new MailAddress();
            bccAddress.setAddress(bcc);
        }
        if (null != (subject = this.getSubject())) {
            if (!this.isSanitizeSubject()) {
                mail.setSubject(subject);
            } else {
                mail.setSubjectSanitize(subject);
            }
        }
        try {
            if (this._contentType != null && !this._contentType.equals("") && this._contentType.contains("text/plain")) {
                mail.setTextMessage(template.getResult());
            } else {
                mail.setHtmlMessage(template.getResult());
            }
        }
        catch (ServiceException me) {
            throw new TransportException((Throwable)me, RB.getStringResource("MailAlertTransport.contentErr.ex.txt"));
        }
        for (MailAttachment att : this._attachments) {
            File f = new File(att.getPath());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                FileInputStream fis = new FileInputStream(f);
                byte[] bytes = new byte[2048];
                int read = 0;
                while ((read = fis.read(bytes)) != -1) {
                    baos.write(bytes, 0, read);
                }
            }
            catch (FileNotFoundException ex) {
                throw new TransportException((Throwable)ex, RB.getStringResource("MailAlertTransport.attachErr.ex.txt"));
            }
            catch (IOException ex) {
                throw new TransportException((Throwable)ex, RB.getStringResource("MailAlertTransport.attachErr.ex.txt"));
            }
            if (att.getContentId() != null && !att.getContentId().equals("")) {
                String contentType = att.getContentType();
                if (contentType == null) {
                    contentType = MimeTypeMapper.getMimeType((String)att.getPath());
                }
                String cid = att.getContentId();
                if ((cid = cid.trim()).startsWith("<")) {
                    cid = cid.substring(1, cid.length());
                }
                if (cid.endsWith(">")) {
                    cid = cid.substring(0, cid.length() - 1);
                }
                InlineData inline = new InlineData(cid, contentType, baos.toByteArray());
                mail.addInline(inline);
                continue;
            }
            if (att.getName() != null && !att.getName().equals("")) {
                mail.addAttachment(att.getName(), baos.toByteArray());
                continue;
            }
            mail.addAttachment(f.getName(), baos.toByteArray());
        }
        this._mailService.send(mail);
    }

    private List parseEmail(String addr) {
        ArrayList<String> list = new ArrayList<String>();
        String buf = addr.trim();
        int buflen = buf.length();
        int startIdx = 0;
        String current = null;
        while (startIdx < buflen) {
            int idx = buf.indexOf(",", startIdx);
            if (idx > 0) {
                current = buf.substring(startIdx, idx).trim();
                if (current.length() > 0) {
                    list.add(current);
                }
                startIdx = idx + 1;
                continue;
            }
            if (idx < 0) {
                current = buf.substring(startIdx).trim();
                if (current.length() > 0) {
                    list.add(current);
                }
                startIdx = buflen;
                continue;
            }
            startIdx = idx + 1;
        }
        return list;
    }

    public boolean isSanitizeSubject() {
        return this.sanitizeSubject;
    }

    public void setSanitizeSubject(boolean sanitizeSubject) {
        this.sanitizeSubject = sanitizeSubject;
    }

    @Override
    public Logger getLogger() {
        return this._saslogger;
    }

    @Override
    public void setLogger(Logger logger) {
        this._saslogger = logger;
    }

    public void close() throws TransportException {
        if (this._transport != null) {
            try {
                this._transport.close();
            }
            catch (MessagingException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("MailAlertTransport.closeErr.ex.txt"));
            }
            this._transport = null;
        }
    }
}

