/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.alerts;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.publish.alerts.AlertUtil;
import com.sas.services.publish.alerts.RB;
import com.sas.services.publish.alerts.URLTemplate;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.ResourceFactory;
import com.sas.services.webdav.ResourceInterface;
import com.sas.text.Message;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ResourceBundle;

@SASScope
class DAVTemplate
extends URLTemplate {
    private String _user;
    private String _password;

    DAVTemplate(String url, String user, String password) throws ServiceException {
        super(url);
        this._user = user;
        this._password = password;
    }

    public DAVTemplate(URL url, String user, String password) {
        super(url);
        this._user = user;
        this._password = password;
    }

    @Override
    public String getResult() throws ServiceException {
        String templateStr;
        block15: {
            templateStr = null;
            ResourceInterface ri = null;
            try {
                ri = this._user != null && this._password != null && this._user.length() > 0 && this._password.length() > 0 ? ResourceFactory.bindResource((String)this.getPath(), (String)this._user, (String)this._password) : ResourceFactory.bindResource((String)this.getPath());
                if (ri != null) {
                    InputStream is = ri.getContents();
                    templateStr = AlertUtil.resolveTemplate(is, this);
                    break block15;
                }
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTemplate.noTemplate.ex.fmt.txt", (Object)this.getPath()));
            }
            catch (DAVException de) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Common.IOExceptionReadingTemplate.ex.fmt.txt", (Object)this.getPath(), (Object)((Object)de)));
            }
            catch (RemoteException re) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Common.IOExceptionReadingTemplate.ex.fmt.txt", (Object)this.getPath(), (Object)re));
            }
            catch (IOException ioe) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Common.IOExceptionReadingTemplate.ex.fmt.txt", (Object)this.getPath(), (Object)ioe));
            }
            finally {
                if (ri != null) {
                    try {
                        ri.close();
                    }
                    catch (DAVException dAVException) {
                    }
                    catch (RemoteException remoteException) {}
                }
            }
        }
        return templateStr;
    }
}

