/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.io.ChainedIOException;
import com.sas.io.InputStreamAdapter;
import com.sas.io.ReaderAdapter;
import com.sas.io.RemoteInputStream;
import com.sas.io.RemoteInputStreamInterface;
import com.sas.io.RemoteReader;
import com.sas.io.RemoteReaderInterface;
import com.sas.services.TransportException;
import com.sas.services.publish.AbstractEntry;
import com.sas.services.publish.RB;
import com.sas.services.publish.ViewerEntryInterface;
import com.sas.text.Message;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.ResourceBundle;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class ViewerEntry
extends AbstractEntry
implements ViewerEntryInterface {
    private static final int ARRAY_SIZE_2048 = 2048;
    private File _file;
    private String _mimeType;
    private String _encoding;
    private int _viewerType;
    private InputStream _inputStream = null;
    private String _name = null;
    private File _tempFile;
    private static final CharArrayReader DUMMY_READER = new CharArrayReader(new char[1]);
    private static final ByteArrayInputStream DUMMY_INPUTSTREAM = new ByteArrayInputStream(new byte[1]);

    public ViewerEntry() throws RemoteException {
        this(ViewerEntry.class);
    }

    protected ViewerEntry(Class theClass) throws RemoteException {
        super(theClass);
    }

    public ViewerEntry(File file, int viewerType) throws IllegalArgumentException, RemoteException {
        this(ViewerEntry.class);
        if (viewerType != 1 && viewerType != 2) {
            throw new IllegalArgumentException(RB.getStringResource("ViewerEntry.invalidTypeIllegalArgumentException.ex.txt"));
        }
        if (file == null) {
            throw new IllegalArgumentException(RB.getStringResource("PublishCommon.nullFile.ex.txt"));
        }
        this._file = file;
        this._viewerType = viewerType;
    }

    public ViewerEntry(InputStream inputStream, String name, int viewerType) throws IllegalArgumentException, RemoteException {
        this(ViewerEntry.class);
        if (viewerType != 1 && viewerType != 2) {
            throw new IllegalArgumentException(RB.getStringResource("ViewerEntry.invalidTypeIllegalArgumentException.ex.txt"));
        }
        if (inputStream == null) {
            throw new IllegalArgumentException(RB.getStringResource("PublishCommon.nullStream.ex.txt"));
        }
        if (name == null) {
            throw new IllegalArgumentException(RB.getStringResource("PublishCommon.nullName.ex.txt"));
        }
        this._name = name;
        this._inputStream = inputStream;
        this._viewerType = viewerType;
    }

    @Override
    public String getName() throws RemoteException, TransportException, IllegalStateException {
        this.throwExceptionIfClosed();
        return this._file != null ? this._file.getName() : this._name;
    }

    @Override
    public String getMIMEType() throws RemoteException, TransportException, IllegalStateException {
        this.throwExceptionIfClosed();
        return this._mimeType;
    }

    @Override
    public void setMIMEType(String mimeType) throws IllegalStateException, RemoteException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("PublishCommon.entryReadOnly.ex.txt"));
        }
        this._mimeType = mimeType;
    }

    @Override
    public int getViewerType() throws RemoteException, TransportException, IllegalStateException {
        this.throwExceptionIfClosed();
        return this._viewerType;
    }

    @Override
    public String getEncoding() throws RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        return this._encoding;
    }

    @Override
    public void setEncoding(String encoding) throws IllegalStateException, RemoteException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("PublishCommon.entryReadOnly.ex.txt"));
        }
        this._encoding = encoding;
    }

    @Override
    public InputStream getInputStream() throws RemoteException, IOException, IllegalStateException {
        FileInputStream stream = null;
        this.throwExceptionIfClosed();
        if (this._viewerType != 1) {
            throw new IllegalStateException(RB.getStringResource("ViewerEntry.textStreamIllegalStateException.ex.txt"));
        }
        if (this._file != null) {
            try {
                stream = new FileInputStream(this._file);
            }
            catch (FileNotFoundException e) {
                throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.streamIOError.ex.txt"));
            }
        } else {
            this.consumeStream();
            stream = new FileInputStream(this._tempFile);
        }
        return new InputStreamAdapter((InputStream)stream);
    }

    @Override
    public Reader getReader() throws IllegalStateException, RemoteException, IOException {
        FileInputStream stream = null;
        this.throwExceptionIfClosed();
        if (this._viewerType != 2) {
            throw new IllegalStateException(RB.getStringResource("ViewerEntry.htmlReaderIllegalStateException.ex.txt"));
        }
        if (this._file == null) {
            this.consumeStream();
            stream = new FileInputStream(this._tempFile);
        } else {
            try {
                stream = new FileInputStream(this._file);
            }
            catch (IOException e) {
                throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.readerIOError.ex.txt"));
            }
        }
        InputStreamReader reader = null;
        if (this._encoding == null) {
            reader = new InputStreamReader(stream);
        } else {
            try {
                reader = new InputStreamReader((InputStream)stream, this._encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.readerIOError.ex.txt"));
            }
        }
        return new ReaderAdapter((Reader)reader);
    }

    @Override
    public InputStream getInputStream(Object streamID) throws RemoteException, IOException, IllegalStateException, UnmarshalException {
        FileInputStream stream = null;
        this.throwExceptionIfClosed();
        if (this._viewerType != 1) {
            throw new IllegalStateException(RB.getStringResource("ViewerEntry.textStreamIllegalStateException.ex.txt"));
        }
        if (this._file != null) {
            try {
                stream = new FileInputStream(this._file);
            }
            catch (FileNotFoundException e) {
                throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.streamIOError.ex.txt"));
            }
        } else {
            this.consumeStream();
            stream = new FileInputStream(this._tempFile);
        }
        return stream;
    }

    @Override
    public RemoteInputStreamInterface getRemoteInputStream(Object streamID) throws IllegalStateException, ChainedIOException, RemoteException {
        FileInputStream stream = null;
        RemoteInputStream remoteInputStream = null;
        this.throwExceptionIfClosed();
        if (this._viewerType != 1) {
            throw new IllegalStateException(RB.getStringResource("ViewerEntry.textStreamIllegalStateException.ex.txt"));
        }
        if (this._file != null) {
            try {
                stream = new FileInputStream(this._file);
            }
            catch (FileNotFoundException e) {
                throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.remoteStreamIOError.ex.txt"));
            }
        }
        try {
            this.consumeStream();
            stream = new FileInputStream(this._tempFile);
        }
        catch (IOException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.streamIOError.ex.txt"));
        }
        remoteInputStream = new RemoteInputStream((InputStream)stream);
        return remoteInputStream;
    }

    @Override
    public Reader getReader(Object readerID) throws IllegalStateException, RemoteException, IOException {
        FileInputStream stream = null;
        this.throwExceptionIfClosed();
        if (this._viewerType != 2) {
            throw new IllegalStateException(RB.getStringResource("ViewerEntry.htmlReaderIllegalStateException.ex.txt"));
        }
        if (this._file == null) {
            this.consumeStream();
            stream = new FileInputStream(this._tempFile);
        } else {
            try {
                stream = new FileInputStream(this._file);
            }
            catch (IOException e) {
                throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.readerIOError.ex.txt"));
            }
        }
        InputStreamReader reader = null;
        if (this._encoding == null) {
            reader = new InputStreamReader(stream);
        } else {
            try {
                reader = new InputStreamReader((InputStream)stream, this._encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.readerIOError.ex.txt"));
            }
        }
        return reader;
    }

    @Override
    public RemoteReaderInterface getRemoteReader(Object readerID) throws IllegalStateException, ChainedIOException, RemoteException {
        FileInputStream stream = null;
        this.throwExceptionIfClosed();
        if (this._viewerType != 2) {
            throw new IllegalStateException(RB.getStringResource("ViewerEntry.htmlReaderIllegalStateException.ex.txt"));
        }
        if (this._file == null) {
            try {
                this.consumeStream();
                stream = new FileInputStream(this._tempFile);
            }
            catch (IOException e) {
                throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.readerIOError.ex.txt"));
            }
        }
        try {
            stream = new FileInputStream(this._file);
        }
        catch (IOException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.remoteReaderIOError.ex.txt"));
        }
        InputStreamReader reader = null;
        if (this._encoding == null) {
            reader = new InputStreamReader(stream);
        } else {
            try {
                reader = new InputStreamReader((InputStream)stream, this._encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.remoteReaderIOError.ex.txt"));
            }
        }
        return new RemoteReader((Reader)reader);
    }

    @Override
    public Object hasInputStream() throws UnmarshalException, RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        return DUMMY_INPUTSTREAM;
    }

    @Override
    public Object hasReader() throws UnmarshalException, RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        return DUMMY_READER;
    }

    public void consumeStream() throws IOException, RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this._file != null) {
            return;
        }
        FileOutputStream fos = null;
        try {
            if (this._tempFile == null) {
                int len;
                this._tempFile = this._viewerType == 2 ? File.createTempFile("PubViewer", ".txt") : File.createTempFile("PubViewer", ".bin");
                this._tempFile.deleteOnExit();
                fos = new FileOutputStream(this._tempFile);
                byte[] bb = new byte[2048];
                while ((len = this._inputStream.read(bb)) != -1) {
                    fos.write(bb, 0, len);
                }
                fos.close();
                this._inputStream.close();
                this._inputStream = null;
            }
        }
        catch (IOException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.streamIOError.ex.txt"));
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
                fos = null;
            }
        }
    }

    protected void closeEntry() {
        if (this.isClosed()) {
            return;
        }
        if (this._tempFile != null) {
            boolean b = this._tempFile.delete();
            if (!b) {
                String tname = this._tempFile.getPath();
                System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"ViewerEntry.delErr.fmt.txt", (Object)tname, (Object)this._name));
            }
            this._tempFile = null;
        }
        this.setClosed(true);
    }

    protected void finalize() throws Throwable {
        if (this._inputStream != null) {
            try {
                this._inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._inputStream = null;
        }
        if (!this.isClosed()) {
            this.closeEntry();
        }
        super.finalize();
    }
}

