/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.io.ChainedIOException;
import com.sas.io.ReaderAdapter;
import com.sas.io.RemoteReader;
import com.sas.io.RemoteReaderInterface;
import com.sas.services.TransportException;
import com.sas.services.publish.AbstractEntry;
import com.sas.services.publish.RB;
import com.sas.services.publish.TextFileEntryInterface;
import com.sas.text.Message;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.ResourceBundle;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class TextFileEntry
extends AbstractEntry
implements TextFileEntryInterface {
    private static final int ARRAY_SIZE_2048 = 2048;
    private String _mimeType;
    private File _file;
    private String _encoding = null;
    private InputStream _inputStream = null;
    private String _name = null;
    private File _tempFile;
    private Reader _reader;
    private static final CharArrayReader DUMMY_READER = new CharArrayReader(new char[1]);

    public TextFileEntry() throws RemoteException {
        this(TextFileEntry.class);
    }

    protected TextFileEntry(Class theClass) throws RemoteException {
        super(theClass);
    }

    public TextFileEntry(File file) throws IllegalArgumentException, RemoteException {
        this(TextFileEntry.class);
        this._file = file;
        if (this._file == null) {
            throw new IllegalArgumentException(RB.getStringResource("PublishCommon.nullFile.ex.txt"));
        }
    }

    public TextFileEntry(InputStream inputStream, String name) throws IllegalArgumentException, RemoteException {
        this(TextFileEntry.class);
        this._inputStream = inputStream;
        this._name = name;
        if (this._inputStream == null) {
            throw new IllegalArgumentException(RB.getStringResource("PublishCommon.nullStream.ex.txt"));
        }
        if (this._inputStream == null) {
            throw new IllegalArgumentException(RB.getStringResource("PublishCommon.nullName.ex.txt"));
        }
    }

    public TextFileEntry(Reader reader, String name) throws IllegalArgumentException, RemoteException {
        this(TextFileEntry.class);
        this._reader = reader;
        this._name = name;
        if (this._reader == null) {
            throw new IllegalArgumentException(RB.getStringResource("PublishCommon.nullReader.ex.txt"));
        }
        if (this._name == null) {
            throw new IllegalArgumentException(RB.getStringResource("PublishCommon.nullName.ex.txt"));
        }
    }

    @Override
    public String getMIMEType() throws RemoteException, TransportException, IllegalStateException {
        this.throwExceptionIfClosed();
        return this._mimeType;
    }

    @Override
    public void setMIMEType(String mimeType) throws IllegalStateException, RemoteException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("PublishCommon.entryReadOnly.ex.txt"));
        }
        this._mimeType = mimeType;
    }

    @Override
    public String getName() throws RemoteException, TransportException, IllegalStateException {
        this.throwExceptionIfClosed();
        return this._file != null ? this._file.getName() : this._name;
    }

    @Override
    public Reader getReader() throws IOException, RemoteException, IllegalStateException {
        InputStreamReader reader = null;
        FileInputStream stream = null;
        this.throwExceptionIfClosed();
        if (this._reader != null) {
            reader = this.consumeReader();
        } else {
            if (this._file == null) {
                this.consumeStream();
                stream = new FileInputStream(this._tempFile);
            } else {
                try {
                    stream = new FileInputStream(this._file);
                }
                catch (FileNotFoundException e) {
                    throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.readerIOError.ex.txt"));
                }
            }
            if (this._encoding == null) {
                reader = new InputStreamReader(stream);
            } else {
                try {
                    reader = new InputStreamReader((InputStream)stream, this._encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.readerIOError.ex.txt"));
                }
            }
        }
        return new ReaderAdapter((Reader)reader);
    }

    @Override
    public Reader getReader(Object readerID) throws IOException, RemoteException, UnmarshalException, IllegalStateException {
        FileInputStream stream = null;
        InputStreamReader reader = null;
        this.throwExceptionIfClosed();
        if (this._reader != null) {
            reader = this.consumeReader();
        } else {
            if (this._file == null) {
                this.consumeStream();
                stream = new FileInputStream(this._tempFile);
            } else {
                try {
                    stream = new FileInputStream(this._file);
                }
                catch (FileNotFoundException e) {
                    throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.readerIOError.ex.txt"));
                }
            }
            if (this._encoding == null) {
                reader = new InputStreamReader(stream);
            } else {
                try {
                    reader = new InputStreamReader((InputStream)stream, this._encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.readerIOError.ex.txt"));
                }
            }
        }
        return reader;
    }

    @Override
    public RemoteReaderInterface getRemoteReader(Object readerID) throws ChainedIOException, RemoteException, IllegalStateException {
        FileInputStream stream = null;
        InputStreamReader reader = null;
        this.throwExceptionIfClosed();
        if (this._reader != null) {
            reader = this.consumeReader();
        } else {
            if (this._file == null) {
                try {
                    this.consumeStream();
                    stream = new FileInputStream(this._tempFile);
                }
                catch (IOException e) {
                    throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.readerIOError.ex.txt"));
                }
            }
            try {
                stream = new FileInputStream(this._file);
            }
            catch (FileNotFoundException e) {
                throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.remoteReaderIOError.ex.txt"));
            }
            if (this._encoding == null) {
                reader = new InputStreamReader(stream);
            } else {
                try {
                    reader = new InputStreamReader((InputStream)stream, this._encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.remoteReaderIOError.ex.txt"));
                }
            }
        }
        return new RemoteReader((Reader)reader);
    }

    @Override
    public void setEncoding(String encoding) throws RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        this._encoding = encoding;
    }

    @Override
    public Object hasReader() throws UnmarshalException, RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        return DUMMY_READER;
    }

    public void consumeStream() throws IOException, RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this._file != null) {
            return;
        }
        FileOutputStream fos = null;
        try {
            if (this._tempFile == null) {
                int len;
                this._tempFile = File.createTempFile("PubText", ".txt");
                this._tempFile.deleteOnExit();
                fos = new FileOutputStream(this._tempFile);
                byte[] bb = new byte[2048];
                while ((len = this._inputStream.read(bb)) != -1) {
                    fos.write(bb, 0, len);
                }
                fos.close();
                this._inputStream.close();
                this._inputStream = null;
            }
        }
        catch (IOException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.streamIOError.ex.txt"));
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
                fos = null;
            }
        }
    }

    private InputStreamReader consumeReader() throws ChainedIOException {
        FileOutputStream fos = null;
        OutputStreamWriter fosw = null;
        BufferedReader buffered = null;
        BufferedWriter bufferedOut = null;
        if (this._tempFile == null) {
            try {
                this._tempFile = File.createTempFile("PubText", ".txt");
                this._tempFile.deleteOnExit();
                fos = new FileOutputStream(this._tempFile);
                fosw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                buffered = new BufferedReader(this._reader);
                bufferedOut = new BufferedWriter(fosw);
                String s = null;
                while ((s = buffered.readLine()) != null) {
                    bufferedOut.write(s, 0, s.length());
                    bufferedOut.newLine();
                }
                fosw.flush();
                bufferedOut.flush();
                this._reader.close();
            }
            catch (IOException e) {
                throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.readerIOError.ex.txt"));
            }
            finally {
                if (fosw != null) {
                    try {
                        fosw.close();
                    }
                    catch (IOException iOException) {}
                    fosw = null;
                }
                if (buffered != null) {
                    try {
                        buffered.close();
                    }
                    catch (IOException iOException) {}
                    buffered = null;
                }
                if (bufferedOut != null) {
                    try {
                        bufferedOut.close();
                    }
                    catch (IOException iOException) {}
                    bufferedOut = null;
                }
            }
        }
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(this._tempFile), "UTF-8");
        }
        catch (IOException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.readerIOError.ex.txt"));
        }
        return reader;
    }

    protected void closeEntry() {
        if (this.isClosed()) {
            return;
        }
        if (this._tempFile != null) {
            String tname = this._tempFile.getPath();
            boolean b = this._tempFile.delete();
            if (!b) {
                System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"TextFileEntry.delErr.fmt.txt", (Object)tname, (Object)this._name));
            }
            this._tempFile = null;
        }
        this.setClosed(true);
    }

    @Override
    public Reader getReader(int maxLineLength) throws IOException, RemoteException, IllegalStateException {
        return this.getReader();
    }

    protected void finalize() throws Throwable {
        if (this._inputStream != null) {
            try {
                this._inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._inputStream = null;
        }
        if (!this.isClosed()) {
            this.closeEntry();
        }
        super.finalize();
    }
}

