/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish;

import com.sas.codepolicy.SASScope;
import com.sas.services.publish.Column;
import com.sas.services.publish.DatasetEntryCallbackInterface;
import com.sas.services.publish.DateTimeObsValue;
import com.sas.services.publish.NumericObsValue;
import com.sas.services.publish.ObsValue;
import com.sas.services.publish.RB;
import com.sas.services.publish.ServiceResultSetMetaData;
import com.sas.text.Message;
import com.sas.text.SASDateTimeFormat;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;

@SASScope
public class ServiceResultSet
implements ResultSet {
    private static final int MAX_VARIABLE_VALUE_LENGTH = Short.MAX_VALUE;
    private ObsValue[] _currentRow;
    protected DatasetEntryCallbackInterface _retriever;
    private Vector _obsVector;
    private Enumeration _obsEnum;
    private int _numColumns;
    protected Column[] _columns;
    private boolean _maxReached;
    private boolean _wasNull;
    private int _numberOfRows;

    public ServiceResultSet(DatasetEntryCallbackInterface retriever) {
        this._retriever = retriever;
    }

    public ServiceResultSet(DatasetEntryCallbackInterface retriever, int numRows) {
        this(retriever);
        this._numberOfRows = numRows;
    }

    public void setColumns(Column[] columns) {
        int len = columns.length;
        this._columns = new Column[len];
        this._numColumns = len;
        System.arraycopy(columns, 0, this._columns, 0, len);
    }

    @Override
    public synchronized boolean next() throws SQLException {
        boolean more = true;
        try {
            if (this._maxReached) {
                more = false;
            } else {
                this._currentRow = this.fetch();
                if (this._currentRow == null) {
                    this._maxReached = true;
                    this.close();
                    more = false;
                }
            }
        }
        catch (Exception ex) {
            this.close();
            this._maxReached = true;
            more = false;
        }
        return more;
    }

    @Override
    public synchronized void close() throws SQLException {
        this._maxReached = true;
        this._retriever.close();
    }

    @Override
    public synchronized String getString(int column) throws SQLException {
        String tempString = null;
        if (this._currentRow == null) {
            throw new SQLException(RB.getStringResource("ServiceResultSet.invalidRowSQLException.ex.txt"));
        }
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSet.invalidColumnValueSQLException.ex.txt"));
        }
        if (this._currentRow[column - 1].isMissing()) {
            this._wasNull = true;
            tempString = null;
        } else {
            this._wasNull = false;
            tempString = this._currentRow[column - 1].toString(Short.MAX_VALUE);
        }
        return tempString;
    }

    @Override
    public synchronized int getInt(int column) throws SQLException {
        if (this._currentRow == null) {
            throw new SQLException(RB.getStringResource("ServiceResultSet.invalidRowSQLException.ex.txt"));
        }
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSet.invalidColumnSQLException.ex.txt"));
        }
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized double getDouble(int column) throws SQLException {
        double d = 0.0;
        if (this._currentRow == null) {
            throw new SQLException(RB.getStringResource("ServiceResultSet.invalidRowSQLException.ex.txt"));
        }
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSet.invalidColumnSQLException.ex.txt"));
        }
        if (this._currentRow == null) {
            throw new SQLException(RB.getStringResource("ServiceResultSet.invalidRowSQLException.ex.txt"));
        }
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSet.invalidColumnValueSQLException.ex.txt"));
        }
        int type = this._columns[column - 1].getSQLType();
        if (this._currentRow[column - 1].isMissing()) {
            this._wasNull = true;
            d = 0.0;
        } else if (type == 12) {
            this._wasNull = false;
            String temp = this.getString(column);
            try {
                d = Double.valueOf(temp.trim());
            }
            catch (NumberFormatException e) {
                throw new SQLException(RB.getStringResource("ServiceResultSet.numberFormatSQLException.ex.txt"));
            }
        } else {
            this._wasNull = false;
            d = ((NumericObsValue)this._currentRow[column - 1]).getValue();
        }
        return d;
    }

    @Override
    public synchronized Date getDate(int column) throws SQLException {
        Date newdate = null;
        if (this._currentRow == null) {
            throw new SQLException(RB.getStringResource("ServiceResultSet.invalidRowSQLException.ex.txt"));
        }
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSet.invalidColumnValueSQLException.ex.txt"));
        }
        int type = this._columns[column - 1].getSQLType();
        if (type != 91 && type != 93 && type != 12) {
            throw new SQLException(RB.getStringResource("ServiceResultSet.typeToDateSQLException.ex.txt"));
        }
        if (this._currentRow[column - 1].isMissing()) {
            this._wasNull = true;
            newdate = null;
        } else if (type == 12) {
            this._wasNull = false;
            try {
                newdate = Date.valueOf(this._currentRow[column - 1].toString());
            }
            catch (IllegalArgumentException iae) {
                throw new SQLException(RB.getStringResource("ServiceResultSet.invalidDateSQLException.ex.txt"));
            }
        } else {
            long l = SASDateTimeFormat.SASDateToJavaDate((double)((DateTimeObsValue)this._currentRow[column - 1]).getValue());
            newdate = new Date(l);
        }
        return newdate;
    }

    @Override
    public synchronized Time getTime(int column) throws SQLException {
        Time time = null;
        if (this._currentRow == null) {
            throw new SQLException(RB.getStringResource("ServiceResultSet.invalidRowSQLException.ex.txt"));
        }
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSet.invalidColumnValueSQLException.ex.txt"));
        }
        int type = this._columns[column - 1].getSQLType();
        if (type != 92 && type != 93 && type != 12) {
            throw new SQLException(RB.getStringResource("ServiceResultSet.cannotConvertSQLException.ex.txt"));
        }
        if (this._currentRow[column - 1].isMissing()) {
            this._wasNull = true;
            time = null;
        } else if (type == 12) {
            this._wasNull = false;
            try {
                time = Time.valueOf(this._currentRow[column - 1].toString());
            }
            catch (IllegalArgumentException iae) {
                throw new SQLException(RB.getStringResource("ServiceResultSet.notValidValueSQLException.ex.txt"));
            }
        } else {
            this._wasNull = false;
            long l = SASDateTimeFormat.SASTimeToJavaDate((double)((DateTimeObsValue)this._currentRow[column - 1]).getValue());
            time = new Time(l);
        }
        return time;
    }

    @Override
    public synchronized Timestamp getTimestamp(int column) throws SQLException {
        Timestamp timestamp = null;
        if (this._currentRow == null) {
            throw new SQLException(RB.getStringResource("ServiceResultSet.invalidRowSQLException.ex.txt"));
        }
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSet.invalidColumnValueSQLException.ex.txt"));
        }
        int type = this._columns[column - 1].getSQLType();
        if (type != 91 && type != 93 && type != 12) {
            throw new SQLException(RB.getStringResource("ServiceResultSet.cannotConvertSQLException.ex.txt"));
        }
        if (this._currentRow[column - 1].isMissing()) {
            this._wasNull = true;
            timestamp = null;
        } else if (type == 12) {
            this._wasNull = false;
            try {
                timestamp = Timestamp.valueOf(this._currentRow[column - 1].toString());
            }
            catch (IllegalArgumentException iae) {
                throw new SQLException(RB.getStringResource("ServiceResultSet.notValidValueSQLException.ex.txt"));
            }
        } else {
            this._wasNull = false;
            long l = SASDateTimeFormat.SASDateTimeToJavaDate((double)((DateTimeObsValue)this._currentRow[column - 1]).getValue());
            timestamp = new Timestamp(l);
        }
        return timestamp;
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        ServiceResultSetMetaData rsmetadata = null;
        rsmetadata = new ServiceResultSetMetaData(this._columns, this._numColumns, this._numberOfRows);
        return rsmetadata;
    }

    @Override
    public synchronized Object getObject(int column) throws SQLException {
        if (this._currentRow == null) {
            throw new SQLException(RB.getStringResource("ServiceResultSet.invalidRowSQLException.ex.txt"));
        }
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSet.invalidColumnValueSQLException.ex.txt"));
        }
        this._wasNull = this._currentRow[column - 1].isMissing();
        return this._currentRow[column - 1].toSQLType();
    }

    @Override
    public synchronized Object getObject(String columnName) throws SQLException {
        int column = this.findColumn(columnName);
        return this.getObject(column);
    }

    protected synchronized ObsValue[] fetch() throws Exception {
        ObsValue[] obs = null;
        if (this._obsVector == null || !this._obsEnum.hasMoreElements()) {
            this._obsVector = this._retriever.getObservations();
            if (this._obsVector != null) {
                this._obsEnum = this._obsVector.elements();
            }
        }
        obs = this._obsVector == null ? null : (!this._obsEnum.hasMoreElements() ? null : (ObsValue[])this._obsEnum.nextElement());
        return obs;
    }

    @Override
    public synchronized boolean wasNull() throws SQLException {
        if (this._currentRow == null) {
            throw new SQLException(RB.getStringResource("ServiceResultSet.invalidColumnSQLException.ex.txt"));
        }
        return this._wasNull;
    }

    @Override
    public synchronized boolean getBoolean(int column) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized byte getByte(int column) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized short getShort(int column) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized long getLong(int column) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized float getFloat(int column) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int column) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int column, int scale) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized byte[] getBytes(int column) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized InputStream getAsciiStream(int column) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized InputStream getUnicodeStream(int column) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized InputStream getBinaryStream(int column) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized String getString(String columnName) throws SQLException {
        int column = this.findColumn(columnName);
        return this.getString(column);
    }

    @Override
    public synchronized boolean getBoolean(String columnName) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized byte getByte(String columnName) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized short getShort(String columnName) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized int getInt(String columnName) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized long getLong(String columnName) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized float getFloat(String columnName) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized double getDouble(String columnName) throws SQLException {
        int column = this.findColumn(columnName);
        return this.getDouble(column);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(String columnName) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized byte[] getBytes(String columnName) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized Date getDate(String columnName) throws SQLException {
        int column = this.findColumn(columnName);
        return this.getDate(column);
    }

    @Override
    public synchronized Time getTime(String columnName) throws SQLException {
        int column = this.findColumn(columnName);
        return this.getTime(column);
    }

    @Override
    public synchronized Timestamp getTimestamp(String columnName) throws SQLException {
        int column = this.findColumn(columnName);
        return this.getTimestamp(column);
    }

    @Override
    public synchronized InputStream getAsciiStream(String columnName) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized InputStream getUnicodeStream(String columnName) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized InputStream getBinaryStream(String columnName) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized String getCursorName() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized int findColumn(String columnName) throws SQLException {
        int foundIndex = -1;
        for (int i = 0; i < this._columns.length; ++i) {
            if (!this._columns[i].getName().equalsIgnoreCase(columnName)) continue;
            foundIndex = i;
        }
        if (foundIndex == -1) {
            throw new SQLException(RB.getStringResource("ServiceResultSet.invalidColumnSQLException.ex.txt"));
        }
        return foundIndex + 1;
    }

    public void setNumColumns(int i) {
        this._numColumns = i;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public synchronized boolean absolute(int rowsOffset) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized Reader getCharacterStream(String columnName) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized boolean isBeforeFirst() throws SQLException {
        boolean b = false;
        if (this._currentRow == null && !this._maxReached) {
            b = true;
        }
        return b;
    }

    @Override
    public synchronized boolean isAfterLast() throws SQLException {
        return this._maxReached;
    }

    @Override
    public synchronized boolean isFirst() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized boolean isLast() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void beforeFirst() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void afterLast() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized boolean first() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized boolean last() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized int getRow() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized boolean relative(int rowsOffset) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized boolean previous() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void setFetchDirection(int direction) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void setFetchSize(int rows) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized int getType() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized int getConcurrency() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized boolean rowUpdated() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized boolean rowInserted() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized boolean rowDeleted() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateNull(int columnIndex) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateNull(String columnName) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateByte(String columnName, byte x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateShort(String columnName, short x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateInt(String columnName, int x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateLong(String columnName, long x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateFloat(String columnName, float x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateDouble(String columnName, double x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateString(String columnName, String x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateDate(String columnName, Date x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateTime(String columnName, Time x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateObject(String columnName, Object x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void insertRow() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateRow() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void deleteRow() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void refreshRow() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void cancelRowUpdates() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void moveToCurrentRow() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized Blob getBlob(int i) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized Clob getClob(int i) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized Array getArray(int i) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized Ref getRef(int i) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized Ref getRef(String colName) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized Array getArray(String colName) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized Blob getBlob(String colName) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized Clob getClob(String colName) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized Date getDate(String columnName, Calendar cal) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized Time getTime(String columnName, Calendar cal) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized Statement getStatement() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized URL getURL(int columnIndex) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized URL getURL(String columnName) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateRef(String columnName, Ref x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateBlob(String columnName, Blob x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateClob(String columnName, Clob x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public synchronized void updateArray(String columnName, Array x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateNClob(int columnIndex, NClob clob) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateNClob(String columnLabel, NClob clob) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateNString(int columnIndex, String string) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateNString(String columnLabel, String string) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (null == iface) {
            throw new SQLException(RB.getStringResource("ServiceResultSet.ifaceNull.ex.txt"));
        }
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ServiceResultSet.ifaceInvalid.ex.fmt.txt", (Object)iface.toString());
        throw new SQLException(msg);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }
}

