/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish;

import com.sas.codepolicy.SASScope;
import com.sas.services.ParseException;
import com.sas.services.TransportException;
import com.sas.services.publish.BinaryFileEntryInterface;
import com.sas.services.publish.EntryInterface;
import com.sas.services.publish.EventData;
import com.sas.services.publish.EventDataInterface;
import com.sas.services.publish.HTMLEntryInterface;
import com.sas.services.publish.HTMLFileInterface;
import com.sas.services.publish.LibraryMemberEntryInterface;
import com.sas.services.publish.RB;
import com.sas.services.publish.ReferenceEntryInterface;
import com.sas.services.publish.ResultPackageInterface;
import com.sas.services.publish.TextFileEntryInterface;
import com.sas.services.publish.ViewerEntryInterface;
import com.sas.services.util.AttributeMap;
import com.sas.services.util.AttributeMapInterface;
import com.sas.services.util.XMLUtil;
import com.sas.services.webdav.TransformerFactoryFactory;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@SASScope
public class ResultPackageEventBuilder {
    private Element root;
    private Map _allNamespaces;
    int sasIndex;
    private static final String DESC_ATTR = "sas-publish:description";
    private static final String VERSION_ATTR = "sas-publish:version";
    private static final String TYPE_ATTR = "sas-publish:type";
    private static final String HTML_ELEMENT = "sas-publish:Html";
    private static final String FILE_ELEMENT = "sas-publish:File";
    private static final String VIEWER_ELEMENT = "sas-publish:Viewer";
    private static final String REFERENCE_ELEMENT = "sas-publish:Reference";
    private static final String PACKAGE_ELEMENT = "sas-publish:Package";
    private static final String SQLVIEW_ELEMENT = "sas-publish:Sqlview";
    private static final String DATASET_ELEMENT = "sas-publish:Dataset";
    private static final String CATALOG_ELEMENT = "sas-publish:Catalog";
    private static final String MDDB_ELEMENT = "sas-publish:Mddb";
    private static final String FDB_ELEMENT = "sas-publish:Fdb";
    private static final String MIMETYPE_ATTR = "sas-publish:mimeType";
    private static final String NAME_ATTR = "sas-publish:name";
    private static final String ABSTRACT_ATTR = "sas-publish:abstract";
    private static final String ENTRY_ELEMENT = "sas-publish:Entry";
    private static final String URL_ATTR = "sas-publish:url";
    private static final String COMPANION_ELEMENT = "sas-publish:Companion";
    private static final String TRANSPORT_ATTR = "sas-publish:transport";
    private static final String CHANNEL_ATTR = "sas-publish:channel";
    private static final String ENTRIES_ELEMENT = "sas-publish:Entries";
    private static final String PACKAGEURL_ATTR = "sas-publish:packageUrl";

    public EventDataInterface buildEvent(ResultPackageInterface rPkg, String persistedPackage, String channelName, String transportName, Map namespaces) throws TransportException {
        Document document = null;
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        this.sasIndex = 1;
        this._allNamespaces = namespaces != null ? new HashMap(namespaces) : new HashMap();
        try {
            factory = TransformerFactoryFactory.newDocumentBuilderFactory();
            factory.setValidating(false);
            builder = factory.newDocumentBuilder();
            document = builder.newDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new TransportException((Throwable)ex, RB.getStringResource("PublishCommon.error.ex.txt"));
        }
        catch (FactoryConfigurationError ex) {
            throw new TransportException((Throwable)ex, RB.getStringResource("PublishCommon.error.ex.txt"));
        }
        try {
            String abs;
            this.root = document.createElementNS("http://www.sas.com/xml/namespace/services.publish-1.1", PACKAGE_ELEMENT);
            document.appendChild(this.root);
            if (namespaces != null) {
                Iterator itor = namespaces.entrySet().iterator();
                Map.Entry mapEntry = null;
                while (itor.hasNext()) {
                    mapEntry = itor.next();
                    String prefix = (String)mapEntry.getKey();
                    String nss = (String)mapEntry.getValue();
                    this.root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, nss);
                }
            }
            this.root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:sas-publish", "http://www.sas.com/xml/namespace/services.publish-1.1");
            this.root.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", VERSION_ATTR, "1.0");
            String desc = rPkg.getDescription();
            if (desc != null) {
                this.root.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", DESC_ATTR, desc);
            }
            if ((abs = rPkg.getAbstract()) != null) {
                this.root.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", ABSTRACT_ATTR, abs);
            }
            if (persistedPackage != null) {
                this.root.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", PACKAGEURL_ATTR, persistedPackage);
            }
            if (channelName != null) {
                this.root.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", CHANNEL_ATTR, channelName);
            }
            if (transportName != null) {
                this.root.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", TRANSPORT_ATTR, transportName);
            }
            this.setNameValuePairs(rPkg, this.root);
            Element e = document.createElementNS("http://www.sas.com/xml/namespace/services.publish-1.1", ENTRIES_ELEMENT);
            this.root.appendChild(e);
            this.addEntries(rPkg, document, e);
        }
        catch (IOException ex) {
            throw new TransportException((Throwable)ex, RB.getStringResource("PublishCommon.error.ex.txt"));
        }
        boolean persisted = false;
        if (persistedPackage != null && !persistedPackage.equals("")) {
            persisted = true;
        }
        EventData eventData = new EventData(XMLUtil.convertNodeToString((Node)this.root), persisted);
        return eventData;
    }

    private void addEntries(ResultPackageInterface rPkg, Document document, Element element) throws TransportException, RemoteException {
        EntryInterface[] entries = rPkg.getEntries();
        for (int i = 0; i < entries.length; ++i) {
            String desc;
            Element e;
            EntryInterface entry = entries[i];
            if (entry instanceof ResultPackageInterface) {
                e = document.createElementNS("http://www.sas.com/xml/namespace/services.publish-1.1", ENTRY_ELEMENT);
                element.appendChild(e);
                e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", TYPE_ATTR, "nestedpackage");
                desc = entry.getDescription();
                if (desc != null) {
                    e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", DESC_ATTR, desc);
                }
                this.setNameValuePairs(entry, e);
                this.addNestedPackage((ResultPackageInterface)entry, document, e);
                continue;
            }
            if (entry instanceof BinaryFileEntryInterface || entry instanceof TextFileEntryInterface) {
                e = document.createElementNS("http://www.sas.com/xml/namespace/services.publish-1.1", ENTRY_ELEMENT);
                element.appendChild(e);
                e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", TYPE_ATTR, "file");
                desc = entry.getDescription();
                if (desc != null) {
                    e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", DESC_ATTR, desc);
                }
                this.setNameValuePairs(entry, e);
                this.addFile(entry, document, e);
                continue;
            }
            if (entry instanceof ReferenceEntryInterface) {
                e = document.createElementNS("http://www.sas.com/xml/namespace/services.publish-1.1", ENTRY_ELEMENT);
                element.appendChild(e);
                e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", TYPE_ATTR, "reference");
                desc = entry.getDescription();
                if (desc != null) {
                    e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", DESC_ATTR, desc);
                }
                this.setNameValuePairs(entry, e);
                this.addReference((ReferenceEntryInterface)entry, document, e);
                continue;
            }
            if (entry instanceof ViewerEntryInterface) {
                e = document.createElementNS("http://www.sas.com/xml/namespace/services.publish-1.1", ENTRY_ELEMENT);
                element.appendChild(e);
                e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", TYPE_ATTR, "viewer");
                desc = entry.getDescription();
                if (desc != null) {
                    e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", DESC_ATTR, desc);
                }
                this.setNameValuePairs(entry, e);
                this.addViewer((ViewerEntryInterface)entry, document, e);
                continue;
            }
            if (entry instanceof HTMLEntryInterface) {
                e = document.createElementNS("http://www.sas.com/xml/namespace/services.publish-1.1", ENTRY_ELEMENT);
                element.appendChild(e);
                e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", TYPE_ATTR, "html");
                desc = entry.getDescription();
                if (desc != null) {
                    e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", DESC_ATTR, desc);
                }
                this.setNameValuePairs(entry, e);
                this.addHTML((HTMLEntryInterface)entry, document, e);
                continue;
            }
            if (!(entry instanceof LibraryMemberEntryInterface)) continue;
            e = document.createElementNS("http://www.sas.com/xml/namespace/services.publish-1.1", ENTRY_ELEMENT);
            element.appendChild(e);
            this.addLibraryMember((LibraryMemberEntryInterface)entry, document, e);
            desc = entry.getDescription();
            if (desc != null) {
                e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", DESC_ATTR, desc);
            }
            this.setNameValuePairs(entry, e);
        }
    }

    private void addNestedPackage(ResultPackageInterface rPkg, Document document, Element element) throws TransportException, RemoteException {
        String abs;
        Element e = document.createElementNS("http://www.sas.com/xml/namespace/services.publish-1.1", PACKAGE_ELEMENT);
        element.appendChild(e);
        String desc = rPkg.getDescription();
        if (desc != null) {
            e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", DESC_ATTR, desc);
        }
        if ((abs = rPkg.getAbstract()) != null) {
            e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", ABSTRACT_ATTR, abs);
        }
        this.setNameValuePairs(rPkg, e);
        this.addEntries(rPkg, document, e);
    }

    private void addFile(EntryInterface entry, Document document, Element element) throws TransportException, RemoteException {
        String name = null;
        String mime = null;
        Element e = document.createElementNS("http://www.sas.com/xml/namespace/services.publish-1.1", FILE_ELEMENT);
        element.appendChild(e);
        if (entry instanceof BinaryFileEntryInterface) {
            e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", TYPE_ATTR, "binary");
            name = ((BinaryFileEntryInterface)entry).getName();
            mime = ((BinaryFileEntryInterface)entry).getMIMEType();
        } else {
            e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", TYPE_ATTR, "text");
            name = ((TextFileEntryInterface)entry).getName();
            mime = ((TextFileEntryInterface)entry).getMIMEType();
        }
        if (name != null) {
            e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", NAME_ATTR, name);
        }
        if (mime != null) {
            e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", MIMETYPE_ATTR, mime);
        }
    }

    private void addReference(ReferenceEntryInterface reference, Document document, Element element) throws TransportException, RemoteException {
        Element e = document.createElementNS("http://www.sas.com/xml/namespace/services.publish-1.1", REFERENCE_ELEMENT);
        element.appendChild(e);
        String ref = reference.getReference();
        if (ref != null) {
            e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", REFERENCE_ELEMENT, ref);
        }
    }

    private void addViewer(ViewerEntryInterface viewer, Document document, Element element) throws RemoteException, TransportException {
        String mime;
        Element e = document.createElementNS("http://www.sas.com/xml/namespace/services.publish-1.1", VIEWER_ELEMENT);
        element.appendChild(e);
        int viewerType = viewer.getViewerType();
        if (viewerType == 1) {
            e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", TYPE_ATTR, "html");
        } else {
            e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", TYPE_ATTR, "text");
        }
        String name = viewer.getName();
        if (name != null) {
            e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", NAME_ATTR, name);
        }
        if ((mime = viewer.getMIMEType()) != null) {
            e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", MIMETYPE_ATTR, mime);
        }
    }

    private void addHTML(HTMLEntryInterface htmlEntry, Document document, Element element) throws TransportException, RemoteException {
        HTMLFileInterface mainFile = htmlEntry.getFile();
        if (mainFile != null) {
            this.setHTMLAttributes(mainFile, document, element);
        }
        HTMLFileInterface[] companions = htmlEntry.getCompanionFiles();
        for (int i = 0; i < companions.length; ++i) {
            HTMLFileInterface file = companions[i];
            if (file == null) continue;
            this.setHTMLAttributes(file, document, element);
        }
    }

    private void setHTMLAttributes(HTMLFileInterface file, Document document, Element element) throws RemoteException, TransportException {
        String url;
        Element e;
        int fileType = file.getRole();
        if (fileType == 2 || fileType == 1) {
            e = document.createElementNS("http://www.sas.com/xml/namespace/services.publish-1.1", HTML_ELEMENT);
            element.appendChild(e);
            e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", TYPE_ATTR, "body");
        } else if (fileType == 3 || fileType == 7) {
            e = document.createElementNS("http://www.sas.com/xml/namespace/services.publish-1.1", HTML_ELEMENT);
            element.appendChild(e);
            e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", TYPE_ATTR, "frame");
        } else if (fileType == 5) {
            e = document.createElementNS("http://www.sas.com/xml/namespace/services.publish-1.1", HTML_ELEMENT);
            element.appendChild(e);
            e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", TYPE_ATTR, "page");
        } else if (fileType == 4) {
            e = document.createElementNS("http://www.sas.com/xml/namespace/services.publish-1.1", HTML_ELEMENT);
            element.appendChild(e);
            e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", TYPE_ATTR, "contents");
        } else {
            e = document.createElementNS("http://www.sas.com/xml/namespace/services.publish-1.1", COMPANION_ELEMENT);
            element.appendChild(e);
            String mime = file.getMIMEType();
            if (mime != null) {
                e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", MIMETYPE_ATTR, mime);
            }
        }
        String name = file.getName();
        if (name != null) {
            e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", NAME_ATTR, name);
        }
        if ((url = file.getName()) != null) {
            e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", URL_ATTR, url);
        }
    }

    private void addLibraryMember(LibraryMemberEntryInterface libEntry, Document document, Element e) throws RemoteException, TransportException {
        Element libElement;
        int type = libEntry.getLibraryMemberType();
        if (type == 2) {
            e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", TYPE_ATTR, "catalog");
            libElement = document.createElementNS("http://www.sas.com/xml/namespace/services.publish-1.1", CATALOG_ELEMENT);
            e.appendChild(libElement);
        } else if (type == 1) {
            e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", TYPE_ATTR, "dataset");
            libElement = document.createElementNS("http://www.sas.com/xml/namespace/services.publish-1.1", DATASET_ELEMENT);
            e.appendChild(libElement);
        } else if (type == 4) {
            e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", TYPE_ATTR, "fdb");
            libElement = document.createElementNS("http://www.sas.com/xml/namespace/services.publish-1.1", FDB_ELEMENT);
            e.appendChild(libElement);
        } else if (type == 3) {
            e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", TYPE_ATTR, "mddb");
            libElement = document.createElementNS("http://www.sas.com/xml/namespace/services.publish-1.1", MDDB_ELEMENT);
            e.appendChild(libElement);
        } else {
            e.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", TYPE_ATTR, "sqlview");
            libElement = document.createElementNS("http://www.sas.com/xml/namespace/services.publish-1.1", SQLVIEW_ELEMENT);
            e.appendChild(libElement);
        }
        String name = libEntry.getMemberName();
        if (name != null) {
            libElement.setAttributeNS("http://www.sas.com/xml/namespace/services.publish-1.1", NAME_ATTR, name);
        }
    }

    private void setNameValuePairs(EntryInterface entry, Element element) throws TransportException, RemoteException {
        AttributeMapInterface nameValues = entry.getNameValuePairs();
        if (nameValues == null) {
            return;
        }
        try {
            StringBuffer b = null;
            String n = null;
            String value = null;
            String prefix = null;
            String prefixWithoutColon2 = null;
            String[] names = nameValues.listAttributeNames();
            for (int i = 0; i < names.length; ++i) {
                int colonPos;
                n = names[i];
                String[] values = nameValues.getAttributes(n);
                value = AttributeMap.buildValue((String[])values);
                if (value == null) {
                    value = "";
                }
                if ((colonPos = n.indexOf(":")) < 0) {
                    element.setAttribute(n, value);
                    continue;
                }
                String namespaceToUse = null;
                for (String prefixWithoutColon2 : this._allNamespaces.keySet()) {
                    b = new StringBuffer();
                    b.append(prefixWithoutColon2);
                    b.append(":");
                    prefix = b.toString();
                    if (!n.startsWith(prefix)) continue;
                    namespaceToUse = (String)this._allNamespaces.get(prefixWithoutColon2);
                    break;
                }
                if (namespaceToUse != null) {
                    element.setAttributeNS(namespaceToUse, n, value);
                    continue;
                }
                prefixWithoutColon2 = n.substring(0, colonPos);
                b = new StringBuffer();
                b.append("xmlns:");
                b.append(prefixWithoutColon2);
                String reservedPrefix = b.toString();
                b = new StringBuffer();
                b.append("http://www.sas.com/xml/namespace/services.publish.reserved-1.1");
                b.append(this.sasIndex);
                ++this.sasIndex;
                namespaceToUse = b.toString();
                this.root.setAttributeNS("http://www.w3.org/2000/xmlns/", reservedPrefix, namespaceToUse);
                this._allNamespaces.put(prefixWithoutColon2, namespaceToUse);
                element.setAttributeNS(namespaceToUse, n, value);
            }
        }
        catch (ParseException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("PublishCommon.error.ex.txt"));
        }
    }
}

