/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.TransportException;
import com.sas.services.publish.AbstractEntry;
import com.sas.services.publish.HTMLEntryInterface;
import com.sas.services.publish.HTMLFile;
import com.sas.services.publish.HTMLFileInterface;
import com.sas.services.publish.RB;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class HTMLEntry
extends AbstractEntry
implements HTMLEntryInterface {
    private HTMLFileInterface _main = null;
    private ArrayList _companionFiles = new ArrayList();

    public HTMLEntry() throws RemoteException {
        super(HTMLEntry.class);
    }

    public HTMLEntry(HTMLFileInterface main, HTMLFileInterface[] companions) throws RemoteException {
        this();
        if (main != null) {
            int role = main.getRole();
            if (role != 1 && role != 7) {
                throw new IllegalArgumentException(RB.getStringResource("HTMLEntry.setFileIllegalArgumentException.ex.txt"));
            }
            this._main = main;
        }
        if (companions != null) {
            ArrayList<HTMLFileInterface> newList = new ArrayList<HTMLFileInterface>();
            for (int i = 0; i < companions.length; ++i) {
                HTMLFileInterface companion = companions[i];
                if (companion == null) continue;
                int role = companion.getRole();
                if (role == 1 || role == 7) {
                    throw new IllegalArgumentException(RB.getStringResource("HTMLEntry.addCompIllegalArgumentException.ex.txt"));
                }
                newList.add(companion);
            }
            this._companionFiles = newList;
        }
    }

    @Override
    public HTMLFileInterface getFile() throws RemoteException, TransportException, IllegalStateException {
        this.throwExceptionIfClosed();
        return this._main;
    }

    @Override
    public void setFile(HTMLFileInterface mainFile) throws IllegalArgumentException, IllegalStateException, RemoteException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("PublishCommon.entryReadOnly.ex.txt"));
        }
        int ftype = mainFile.getRole();
        if (ftype != 1 && ftype != 7) {
            throw new IllegalArgumentException(RB.getStringResource("HTMLEntry.setFileIllegalArgumentException.ex.txt"));
        }
        this._main = mainFile;
    }

    @Override
    public HTMLFileInterface getFile(String uniqueId) throws IllegalStateException, RemoteException, TransportException {
        HTMLFileInterface foundFile = null;
        this.throwExceptionIfClosed();
        if (this._main != null && uniqueId.equals(this._main.getEntityKey())) {
            foundFile = this._main;
        }
        if (foundFile == null) {
            for (HTMLFileInterface f : this._companionFiles) {
                if (!uniqueId.equals(f.getEntityKey())) continue;
                foundFile = f;
                break;
            }
        }
        return foundFile;
    }

    @Override
    public HTMLFileInterface[] getCompanionFiles() throws RemoteException, TransportException, IllegalStateException {
        this.throwExceptionIfClosed();
        HTMLFileInterface[] files = new HTMLFileInterface[this._companionFiles.size()];
        Iterator itor = this._companionFiles.iterator();
        int i = 0;
        while (itor.hasNext()) {
            files[i++] = (HTMLFileInterface)itor.next();
        }
        return files;
    }

    @Override
    public void addCompanionFile(HTMLFileInterface companion) throws IllegalArgumentException, IllegalStateException, RemoteException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("PublishCommon.entryReadOnly.ex.txt"));
        }
        int ftype = companion.getRole();
        if (ftype == 1 || ftype == 7) {
            throw new IllegalArgumentException(RB.getStringResource("HTMLEntry.addCompIllegalArgumentException.ex.txt"));
        }
        this._companionFiles.add(companion);
    }

    @Override
    public void setCompanionFiles(HTMLFileInterface[] companions) throws IllegalArgumentException, IllegalStateException, RemoteException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("PublishCommon.entryReadOnly.ex.txt"));
        }
        ArrayList<HTMLFileInterface> newList = new ArrayList<HTMLFileInterface>();
        for (int i = 0; i < companions.length; ++i) {
            HTMLFileInterface companion = companions[i];
            if (companion == null) continue;
            int ftype = companion.getRole();
            if (ftype == 1 || ftype == 7) {
                throw new IllegalArgumentException(RB.getStringResource("HTMLEntry.addCompIllegalArgumentException.ex.txt"));
            }
            newList.add(companion);
        }
        this._companionFiles.clear();
        this._companionFiles = newList;
    }

    protected void closeEntry() {
        if (this.isClosed()) {
            return;
        }
        try {
            HTMLFileInterface[] files = this.getCompanionFiles();
            for (int i = 0; i < files.length; ++i) {
                HTMLFileInterface file = files[i];
                if (!(file instanceof HTMLFile)) continue;
                ((HTMLFile)file).closeEntry();
            }
        }
        catch (Exception files) {
            // empty catch block
        }
        try {
            HTMLFileInterface file = this.getFile();
            if (file != null && file instanceof HTMLFile) {
                ((HTMLFile)file).closeEntry();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setClosed(true);
    }
}

