/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish;

import com.sas.codepolicy.SASScope;
import com.sas.services.publish.Column;
import com.sas.services.publish.NumericObsValue;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

@SASScope
public class DateTimeObsValue
extends NumericObsValue {
    private boolean _date;
    private boolean _time;

    public DateTimeObsValue(Column v) {
        super(v);
        this._date = true;
        this._time = false;
    }

    public DateTimeObsValue(Column v, boolean setdate, boolean settime) {
        super(v);
        this._date = setdate;
        this._time = settime;
    }

    public boolean isDate() {
        return this._date;
    }

    public boolean isTime() {
        return this._time;
    }

    public boolean isDateTime() {
        return this._date && this._time;
    }

    @Override
    public String toString(int len) {
        if (this.isMissing()) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        SASFormat sasFormat = this.getColumn().getSASFormat();
        String tempString = "";
        if (this._time) {
            if (this._date) {
                long l = SASDateTimeFormat.SASDateTimeToJavaDate((double)this.getValue());
                if (sasFormat == null) {
                    DateFormat df = DateFormat.getDateTimeInstance();
                    df.setCalendar(calendar);
                    tempString = df.format(new Timestamp(l));
                } else {
                    tempString = sasFormat.format((Object)this.getValue());
                }
            } else {
                long l = SASDateTimeFormat.SASTimeToJavaDate((double)this.getValue());
                if (sasFormat == null) {
                    DateFormat df = DateFormat.getTimeInstance();
                    df.setCalendar(calendar);
                    tempString = df.format(new Time(l));
                } else {
                    tempString = sasFormat.format((Object)this.getValue());
                }
            }
        } else if (sasFormat == null) {
            long l = SASDateTimeFormat.SASDateToJavaDate((double)this.getValue());
            DateFormat df = DateFormat.getDateInstance();
            df.setCalendar(calendar);
            tempString = df.format(new Date(l));
        } else {
            tempString = sasFormat.format((Object)this.getValue());
        }
        if (tempString.length() > len) {
            tempString = tempString.substring(0, len);
        }
        return tempString;
    }

    @Override
    public Object toSQLType() {
        if (this.isMissing()) {
            return null;
        }
        if (this._time) {
            if (this._date) {
                long l = SASDateTimeFormat.SASDateTimeToJavaDate((double)this.getValue());
                Timestamp datetime = new Timestamp(l);
                return datetime;
            }
            long l = SASDateTimeFormat.SASTimeToJavaDate((double)this.getValue());
            Time time = new Time(l);
            return time;
        }
        long l = SASDateTimeFormat.SASDateToJavaDate((double)this.getValue());
        java.sql.Date tdate = new java.sql.Date(l);
        return tdate;
    }
}

