/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish;

import com.sas.codepolicy.SASScope;
import com.sas.services.publish.RB;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.ResourceFactory;
import com.sas.services.webdav.ResourceInterface;
import com.sas.text.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ResourceBundle;
import javax.activation.DataSource;

@SASScope
public class DAVMailDataSource
implements DataSource {
    private String _contentType;
    private String _name;
    private File _tempFile = null;
    private String _url;
    private String _user;
    private String _password;

    public DAVMailDataSource(String url, String user, String password, String contentType, String name) {
        this._contentType = contentType;
        this._name = name;
        this._user = user;
        this._password = password;
        this._url = url;
    }

    public InputStream getInputStream() throws IOException {
        FileOutputStream fos = null;
        InputStream is = null;
        FileInputStream stream = null;
        ResourceInterface ri = null;
        try {
            ri = this._user != null && this._password != null && this._user.length() > 0 && this._password.length() > 0 ? ResourceFactory.bindResource((String)this._url, (String)this._user, (String)this._password) : ResourceFactory.bindResource((String)this._url);
            if (ri != null) {
                is = ri.getContents();
                if (this._tempFile == null) {
                    int len;
                    this._tempFile = File.createTempFile("PubAlert", ".bin");
                    this._tempFile.deleteOnExit();
                    fos = new FileOutputStream(this._tempFile);
                    byte[] bb = new byte[2048];
                    while ((len = is.read(bb)) != -1) {
                        fos.write(bb, 0, len);
                    }
                    fos.close();
                    fos = null;
                    is.close();
                    is = null;
                }
                stream = new FileInputStream(this._tempFile);
            }
        }
        catch (IOException e) {
            throw new IOException(Message.format((ResourceBundle)RB.getResources(), (String)"DAVMailDataSource.ioErr.ex.fmt.txt", (Object)e.getMessage()));
        }
        catch (DAVException e) {
            throw new IOException(Message.format((ResourceBundle)RB.getResources(), (String)"DAVMailDataSource.ioErr.ex.fmt.txt", (Object)e.getMessage()));
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
                is = null;
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
                fos = null;
            }
            if (ri != null) {
                try {
                    ri.close();
                }
                catch (Exception exception) {}
                ri = null;
            }
        }
        return stream;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    public String getContentType() {
        if (this._contentType == null) {
            return "application/octet-stream";
        }
        return this._contentType;
    }

    public String getName() {
        return this._name;
    }

    protected void finalize() throws Throwable {
        if (this._tempFile != null) {
            String tname = this._tempFile.getPath();
            boolean b = this._tempFile.delete();
            if (!b) {
                System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"DAVMailDataSource.delErr.fmt.txt", (Object)tname, (Object)this._name));
            }
            this._tempFile = null;
        }
        super.finalize();
    }
}

