/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish;

import com.sas.codepolicy.SASScope;
import com.sas.text.SASCharacterFormat;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import com.sas.text.SASNumericFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

@SASScope
public class ColumnFormat {
    private static String[] prefixes = new String[13];
    private static Hashtable suffixes;

    public Map findFormat(String inname, int width, int decimals) {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        short wid = (short)width;
        short ndec = (short)decimals;
        String tstring = inname.trim();
        if (tstring.length() == 0) {
            int subtype = ndec == 0 && wid != 0 ? 6 : 0;
            m.put("COLUMNTYPE", subtype);
            m.put("SASFORMAT", null);
            return m;
        }
        int subtype = 0;
        SASFormat f = null;
        if (width != 0 && decimals != 0) {
            f = SASFormat.getInstance((String)inname, (int)width, (int)decimals);
        } else if (width != 0) {
            f = SASFormat.getInstance((String)inname, (int)width);
        } else {
            SASFormat sASFormat = f = decimals != 0 ? SASFormat.getInstance((String)inname, (int)width, (int)decimals) : SASFormat.getInstance((String)inname);
        }
        if (f != null) {
            if (f.isCharacterFormat()) {
                subtype = 2;
            } else if (f.isDateTimeFormat()) {
                subtype = 5;
            } else if (f.isDateFormat()) {
                subtype = 3;
            } else if (f.isTimeFormat()) {
                subtype = 4;
            } else if (f.isNumericFormat()) {
                subtype = 1;
            } else if (f instanceof SASNumericFormat) {
                subtype = 1;
            } else if (f instanceof SASCharacterFormat) {
                subtype = 2;
            } else if (f instanceof SASDateTimeFormat) {
                subtype = inname.equalsIgnoreCase("DATETIME") || inname.equalsIgnoreCase("MMYY") ? 5 : (inname.equalsIgnoreCase("TIME") || inname.equalsIgnoreCase("MMSS") || inname.equalsIgnoreCase("HHMM") || inname.equalsIgnoreCase("HOUR") ? 4 : 3);
            }
        }
        m.put("SASFORMAT", (Integer)f);
        if (subtype != 0) {
            m.put("COLUMNTYPE", subtype);
            return m;
        }
        m.put("COLUMNTYPE", this.getIntl(inname));
        return m;
    }

    public int getIntl(String format) {
        if (format.length() < 8) {
            return 0;
        }
        String temp = format.substring(0, 3);
        for (int i = 0; i < 13; ++i) {
            if (!prefixes[i].equals(temp)) continue;
            String suffix = format.substring(3, 5);
            Integer subtype = (Integer)suffixes.get(suffix);
            return subtype != null ? subtype : 0;
        }
        return 0;
    }

    static {
        ColumnFormat.prefixes[0] = "DAN";
        ColumnFormat.prefixes[1] = "DES";
        ColumnFormat.prefixes[2] = "DEU";
        ColumnFormat.prefixes[3] = "ESP";
        ColumnFormat.prefixes[4] = "EUR";
        ColumnFormat.prefixes[5] = "FIN";
        ColumnFormat.prefixes[6] = "FRA";
        ColumnFormat.prefixes[7] = "FRS";
        ColumnFormat.prefixes[8] = "ITA";
        ColumnFormat.prefixes[9] = "NLD";
        ColumnFormat.prefixes[10] = "NOR";
        ColumnFormat.prefixes[11] = "PTG";
        ColumnFormat.prefixes[12] = "SVE";
        suffixes = new Hashtable();
        suffixes.put("DFDD", 3);
        suffixes.put("DFDE", 3);
        suffixes.put("DFDN", 3);
        suffixes.put("DFDT", 5);
        suffixes.put("DFDWN", 3);
        suffixes.put("DFMN", 3);
        suffixes.put("DFMY", 3);
        suffixes.put("DFWDX", 3);
        suffixes.put("DFWKX", 3);
    }
}

