/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish;

import com.sas.services.TransportException;
import com.sas.services.publish.DatasetEntryCallbackInterface;
import com.sas.services.publish.ExtendedAttributeData;
import com.sas.services.publish.RB;
import com.sas.services.publish.ServiceResultSet;
import com.sas.sql.AnnotatedResultSet;
import com.sas.text.Message;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class AnnotatedServiceResultSet
extends ServiceResultSet
implements AnnotatedResultSet {
    private boolean _wasNull = false;
    private List<String> _missingValues = new ArrayList<String>();

    public AnnotatedServiceResultSet(DatasetEntryCallbackInterface retriever) {
        super(retriever);
    }

    public AnnotatedServiceResultSet(DatasetEntryCallbackInterface retriever, int nobs) {
        super(retriever, nobs);
    }

    public void clearColumnAnnotations(int arg0) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    public void clearColumnAnnotations(String arg0) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    public void clearColumnAnnotation(String arg0, String arg1) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    public void clearColumnAnnotation(int arg0, String arg1) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    public void clearResultSetAnnotation(String annotationName) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    public void clearResultSetAnnotations() throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    public Character getMissingValueResultSetAnnotation(String annotationName) throws SQLException {
        try {
            ExtendedAttributeData extendedData = this._retriever.getExtendedAttributes();
            Map<String, Character> missingAttrs = extendedData.getDataSetMissingValueAttributes();
            this._wasNull = false;
            if (missingAttrs.containsKey(annotationName)) {
                this._wasNull = true;
                return missingAttrs.get(annotationName);
            }
            return null;
        }
        catch (TransportException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public Character getMissingValueColumnAnnotation(int columnIndex, String annotationName) throws SQLException {
        Map<String, Character> missingAttrs = this._columns[columnIndex - 1].getMissingValueAttributes();
        if (missingAttrs.containsKey(annotationName)) {
            this._wasNull = true;
            return missingAttrs.get(annotationName);
        }
        this._wasNull = false;
        return null;
    }

    public Character getMissingValueColumnAnnotation(String columnName, String annotationName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getMissingValueColumnAnnotation(columnIndex, annotationName);
    }

    public int getColumnAnnotationType(int columnIndex, String annotationName) throws SQLException {
        if (columnIndex < 1 || columnIndex > this._columns.length) {
            throw new SQLException(RB.getStringResource("AnnotatedServiceResultSet.invalidColumnIndexSQLException.ex.txt"));
        }
        if (this._columns[columnIndex - 1].getCharacterAttributes().containsKey(annotationName)) {
            return 12;
        }
        if (this._columns[columnIndex - 1].getNumericAttributes().containsKey(annotationName) || this._columns[columnIndex - 1].getMissingValueAttributes().containsKey(annotationName)) {
            return 2;
        }
        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"AnnotatedServiceResultSet.invalidAnnotationName.ex.fmt.txt", (Object)annotationName);
        throw new SQLException(msg);
    }

    public int getColumnAnnotationType(String columnName, String annotationName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getColumnAnnotationType(columnIndex, annotationName);
    }

    public Map<String, Object> getColumnAnnotations(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this._columns.length) {
            throw new SQLException(RB.getStringResource("AnnotatedServiceResultSet.invalidColumnIndexSQLException.ex.txt"));
        }
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.putAll(this._columns[columnIndex - 1].getCharacterAttributes());
        attrs.putAll(this._columns[columnIndex - 1].getNumericAttributes());
        attrs.putAll(this._columns[columnIndex - 1].getMissingValueAttributes());
        this._missingValues.clear();
        if (!this._columns[columnIndex - 1].getMissingValueAttributes().isEmpty()) {
            this._missingValues.addAll(this._columns[columnIndex - 1].getMissingValueAttributes().keySet());
        }
        return attrs;
    }

    public Map<String, Object> getColumnAnnotations(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getColumnAnnotations(columnIndex);
    }

    public double getDoubleColumnAnnotation(int columnIndex, String annotationName) throws SQLException {
        if (columnIndex < 1 || columnIndex > this._columns.length) {
            throw new SQLException(RB.getStringResource("AnnotatedServiceResultSet.invalidColumnIndexSQLException.ex.txt"));
        }
        this._wasNull = false;
        Map<String, Double> numAttrs = this._columns[columnIndex - 1].getNumericAttributes();
        Map<String, Character> missingAttrs = this._columns[columnIndex - 1].getMissingValueAttributes();
        if (missingAttrs.containsKey(annotationName)) {
            this._wasNull = true;
            return 0.0;
        }
        if (numAttrs.containsKey(annotationName)) {
            return numAttrs.get(annotationName);
        }
        return 0.0;
    }

    public double getDoubleColumnAnnotation(String columnName, String annotationName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getDoubleColumnAnnotation(columnIndex, annotationName);
    }

    public double getDoubleResultSetAnnotation(String annotationName) throws SQLException {
        try {
            ExtendedAttributeData extendedData = this._retriever.getExtendedAttributes();
            Map<String, Double> numAttrs = extendedData.getDataSetNumericAttributes();
            Map<String, Character> missingAttrs = extendedData.getDataSetMissingValueAttributes();
            this._wasNull = false;
            if (missingAttrs.containsKey(annotationName)) {
                this._wasNull = true;
                return 0.0;
            }
            if (numAttrs.containsKey(annotationName)) {
                return numAttrs.get(annotationName);
            }
            return 0.0;
        }
        catch (TransportException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public int getResultSetAnnotationType(String annotationName) throws SQLException {
        try {
            ExtendedAttributeData attrData = this._retriever.getExtendedAttributes();
            if (attrData.getDataSetCharacterAttributes().containsKey(annotationName)) {
                return 12;
            }
            if (attrData.getDataSetMissingValueAttributes().containsKey(annotationName)) {
                return 2;
            }
            if (attrData.getDataSetNumericAttributes().containsKey(annotationName)) {
                return 2;
            }
        }
        catch (TransportException e) {
            throw new SQLException(e.getMessage());
        }
        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"AnnotatedServiceResultSet.invalidAnnotationName.ex.fmt.txt", (Object)annotationName);
        throw new SQLException(msg);
    }

    public Map<String, Object> getResultSetAnnotations() throws SQLException {
        HashMap<String, Object> annotations = new HashMap<String, Object>();
        try {
            ExtendedAttributeData attrData = this._retriever.getExtendedAttributes();
            Map<String, Character> missingAttrs = attrData.getDataSetMissingValueAttributes();
            annotations.putAll(attrData.getDataSetCharacterAttributes());
            annotations.putAll(attrData.getDataSetNumericAttributes());
            annotations.putAll(missingAttrs);
            this._missingValues.clear();
            if (!missingAttrs.isEmpty()) {
                this._missingValues.addAll(missingAttrs.keySet());
            }
        }
        catch (TransportException e) {
            throw new SQLException(e.getMessage());
        }
        return annotations;
    }

    public String getStringColumnAnnotation(int columnIndex, String annotationName) throws SQLException {
        if (columnIndex < 1 || columnIndex > this._columns.length) {
            throw new SQLException(RB.getStringResource("AnnotatedServiceResultSet.invalidColumnIndexSQLException.ex.txt"));
        }
        Map<String, String> stringAttrs = this._columns[columnIndex - 1].getCharacterAttributes();
        Map<String, Double> numAttrs = this._columns[columnIndex - 1].getNumericAttributes();
        Map<String, Character> missingAttrs = this._columns[columnIndex - 1].getMissingValueAttributes();
        this._wasNull = false;
        if (stringAttrs.containsKey(annotationName)) {
            return stringAttrs.get(annotationName);
        }
        if (missingAttrs.containsKey(annotationName)) {
            this._wasNull = true;
            return null;
        }
        if (numAttrs.containsKey(annotationName)) {
            return Double.toString(numAttrs.get(annotationName));
        }
        return "";
    }

    public String getStringColumnAnnotation(String columnName, String annotationName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getStringColumnAnnotation(columnIndex, annotationName);
    }

    public Map<String, Object> getStringColumnAnnotations(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getColumnAnnotations(columnIndex);
    }

    public String getStringResultSetAnnotation(String annotationName) throws SQLException {
        try {
            this._wasNull = false;
            ExtendedAttributeData attrData = this._retriever.getExtendedAttributes();
            Map<String, String> charAttrs = attrData.getDataSetCharacterAttributes();
            Map<String, Double> numAttrs = attrData.getDataSetNumericAttributes();
            Map<String, Character> missingAttrs = attrData.getDataSetMissingValueAttributes();
            if (charAttrs.containsKey(annotationName)) {
                return charAttrs.get(annotationName);
            }
            if (missingAttrs.containsKey(annotationName)) {
                this._wasNull = true;
                return null;
            }
            if (numAttrs.containsKey(annotationName)) {
                return Double.toString(numAttrs.get(annotationName));
            }
            return "";
        }
        catch (TransportException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public boolean hasColumnAnnotation(int columnIndex, String annotationName) throws SQLException {
        if (columnIndex < 1 || columnIndex > this._columns.length) {
            throw new SQLException(RB.getStringResource("AnnotatedServiceResultSet.invalidColumnIndexSQLException.ex.txt"));
        }
        if (this._columns[columnIndex - 1].getCharacterAttributes().containsKey(annotationName)) {
            return true;
        }
        if (this._columns[columnIndex - 1].getNumericAttributes().containsKey(annotationName)) {
            return true;
        }
        return this._columns[columnIndex - 1].getMissingValueAttributes().containsKey(annotationName);
    }

    public boolean hasColumnAnnotation(String columnName, String annotationName) throws SQLException {
        if (null == columnName) {
            throw new SQLException(RB.getStringResource("AnnotatedServiceResultSet.invalidColumnNameSQLException.ex.txt"));
        }
        int columnIndex = this.findColumn(columnName);
        return this.hasColumnAnnotation(columnIndex, annotationName);
    }

    public boolean hasColumnAnnotations(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this._columns.length) {
            throw new SQLException(RB.getStringResource("AnnotatedServiceResultSet.invalidColumnIndexSQLException.ex.txt"));
        }
        return !this._columns[columnIndex - 1].getCharacterAttributes().isEmpty() || !this._columns[columnIndex - 1].getNumericAttributes().isEmpty() || !this._columns[columnIndex - 1].getMissingValueAttributes().isEmpty();
    }

    public boolean hasColumnAnnotations(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.hasColumnAnnotations(columnIndex);
    }

    public boolean hasResultSetAnnotation(String annotationName) throws SQLException {
        try {
            ExtendedAttributeData attrData = this._retriever.getExtendedAttributes();
            if (attrData.getDataSetCharacterAttributes().containsKey(annotationName)) {
                return true;
            }
            if (attrData.getDataSetNumericAttributes().containsKey(annotationName)) {
                return true;
            }
            if (attrData.getDataSetMissingValueAttributes().containsKey(annotationName)) {
                return true;
            }
        }
        catch (TransportException e) {
            throw new SQLException(e.getMessage());
        }
        return false;
    }

    public boolean hasResultSetAnnotations() throws SQLException {
        try {
            ExtendedAttributeData attrData = this._retriever.getExtendedAttributes();
            return !attrData.getDataSetCharacterAttributes().isEmpty() || !attrData.getDataSetNumericAttributes().isEmpty() || !attrData.getDataSetMissingValueAttributes().isEmpty();
        }
        catch (TransportException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public void setColumnAnnotations(int arg0, Map<String, Object> arg1) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    public void setColumnAnnotations(String arg0, Map<String, Object> arg1) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    public void setDoubleColumnAnnotation(int arg0, String arg1, Double arg2) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    public void setDoubleColumnAnnotation(String arg0, String arg1, Double arg2) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    public void setDoubleResultSetAnnotation(String arg0, Double arg1) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    public void setNullColumnAnnotation(int arg0, int arg1, String arg2) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    public void setNullColumnAnnotation(int arg0, int arg1, String arg2, String arg3) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    public void setNullResultSetAnnotation(int arg0, String arg1) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    public void setNullResultSetAnnotation(int arg0, String arg1, String arg2) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    public void setResultSetAnnotations(Map<String, Object> arg0) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    public void setStringColumnAnnotation(int arg0, String arg1, String arg2) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    public void setStringColumnAnnotation(String arg0, String arg1, String arg2) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    public void setStringResultSetAnnotation(String arg0, String arg1) throws SQLException {
        throw new SQLException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    public boolean wasAnnotationNull() throws SQLException {
        return this._wasNull;
    }

    public String[] wasAnnotationsNull() throws SQLException {
        String[] list = new String[]{};
        return this._missingValues.toArray(list);
    }
}

