/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui.model;

import com.platform.LSFJobFlow.api.JFTemplateParameter;
import com.platform.LSFJobFlow.api.JFTemplateParameterDef;
import com.platform.LSFJobFlow.api.JFTemplateParameterDefList;
import com.platform.LSFJobFlow.api.JFTemplateParameterList;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import com.platform.LSFJobFlow.ui.model.JFParamLine;
import com.platform.LSFJobFlow.ui.model.JFRepeatElemLine;
import com.platform.LSFJobFlow.ui.model.JFRepeatParamLine;
import com.platform.LSFJobFlow.ui.model.JFUnRepeatParamLine;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class JFTemplateTableModel
extends AbstractTableModel {
    private final String[] m_columnHeaders;
    private JFTemplateParameterList m_paramList;
    private JFTemplateParameterDefList m_paramDefList;
    private Vector m_hiddenParams;
    private Vector m_parameterLines;
    private boolean m_editable;

    public JFTemplateTableModel(JFTemplateParameterList paramList, JFTemplateParameterDefList paramDefList) {
        block9: {
            String caption;
            String[] input;
            String paramName;
            JFTemplateParameter[] datalist;
            JFParamLine paramLine;
            block8: {
                this.m_columnHeaders = new String[]{"   ", JFResourceBundle.getString("Parameter_Name"), JFResourceBundle.getString("Parameter_Value")};
                this.m_paramList = paramList;
                this.m_paramDefList = paramDefList;
                this.m_editable = this.m_paramDefList != null;
                this.m_parameterLines = new Vector();
                paramLine = null;
                JFTemplateParameterDef[] deflist = null;
                datalist = null;
                if (this.m_paramDefList != null) {
                    deflist = this.m_paramDefList.getParameters();
                }
                if (this.m_paramList != null) {
                    datalist = this.m_paramList.getParameters();
                }
                paramName = null;
                input = null;
                this.m_hiddenParams = null;
                caption = null;
                if (deflist == null) break block8;
                int len = deflist.length;
                for (int i = 0; i < len; ++i) {
                    paramName = deflist[i].getName();
                    if (paramName == null) continue;
                    input = null;
                    int idx = 0;
                    if (datalist != null) {
                        int len2 = datalist.length;
                        for (int j = 0; j < len2; ++j) {
                            if (datalist[j] == null || !paramName.equals(datalist[j].getName())) continue;
                            input = datalist[j].getUserInput();
                            idx = j;
                            break;
                        }
                    }
                    if (deflist[i].isHidden()) {
                        if (this.m_hiddenParams == null) {
                            this.m_hiddenParams = new Vector();
                        }
                        this.m_hiddenParams.add(datalist[idx]);
                        continue;
                    }
                    caption = JFUtility.getTemplateCaption(deflist[i].getCaption());
                    paramLine = deflist[i].isRepeatable() ? new JFRepeatParamLine(paramName, caption, input) : (input != null && input.length > 0 ? new JFUnRepeatParamLine(paramName, caption, input[0]) : new JFUnRepeatParamLine(paramName, caption, null));
                    ((JFParamLine)paramLine).setParameterDefinition(deflist[i]);
                    this.m_parameterLines.add(paramLine);
                }
                break block9;
            }
            if (datalist == null) break block9;
            int len = datalist.length;
            for (int i = 0; i < len; ++i) {
                if (datalist[i] == null) continue;
                paramName = datalist[i].getName();
                input = datalist[i].getUserInput();
                if (paramName == null) continue;
                caption = JFUtility.getTemplateCaption(datalist[i].getCaption());
                if (input == null || input.length <= 0) continue;
                paramLine = input.length == 1 ? new JFUnRepeatParamLine(paramName, caption, input[0]) : new JFRepeatParamLine(paramName, caption, input);
                this.m_parameterLines.add(paramLine);
            }
        }
    }

    public String[] getInputMissingParamList() {
        if (!this.m_editable || this.m_parameterLines == null) {
            return null;
        }
        Iterator it = this.m_parameterLines.iterator();
        JFParamLine item = null;
        JFTemplateParameterDef itemDef = null;
        ArrayList<String> ret = new ArrayList<String>();
        while (it != null && it.hasNext()) {
            item = (JFParamLine)it.next();
            itemDef = item.getParameterDefinition();
            if (!item.isEmpty() || itemDef == null || !itemDef.isRequired()) continue;
            String caption = itemDef.getCaption();
            if (caption == null || caption.length() <= 0) {
                caption = item.getParameterName();
            }
            ret.add(caption);
        }
        if (!ret.isEmpty()) {
            return ret.toArray(new String[0]);
        }
        return null;
    }

    public JFTemplateParameterList getUpdatedParameterList() {
        if (!this.m_editable || this.m_parameterLines == null) {
            return null;
        }
        Iterator it = this.m_parameterLines.iterator();
        JFParamLine item = null;
        JFTemplateParameterList ret = new JFTemplateParameterList();
        JFTemplateParameter param = null;
        while (it != null && it.hasNext()) {
            item = (JFParamLine)it.next();
            if (item.isEmpty() && item.isRepeatEmpty()) continue;
            if (item instanceof JFUnRepeatParamLine) {
                if (item.getUserInput() == null || item.getUserInput().trim().isEmpty()) continue;
                String[] inputs = new String[]{item.getUserInput().trim()};
                param = new JFTemplateParameter(item.getParameterName(), ((JFUnRepeatParamLine)item).getCaption(), inputs);
            } else if (item instanceof JFRepeatParamLine) {
                if (((JFRepeatParamLine)item).getInputs() == null || ((JFRepeatParamLine)item).getInputs().length == 0) continue;
                ArrayList<String> inputList = new ArrayList<String>();
                for (String strInput : ((JFRepeatParamLine)item).getInputs()) {
                    if (strInput == null || strInput.trim().isEmpty()) continue;
                    inputList.add(strInput.trim());
                }
                if (inputList.size() == 0) continue;
                param = new JFTemplateParameter(item.getParameterName(), ((JFRepeatParamLine)item).getCaption(), inputList.toArray(new String[0]));
            } else {
                param = null;
            }
            if (param == null) continue;
            ret.addParameter(param);
        }
        if (this.m_hiddenParams != null) {
            int size = this.m_hiddenParams.size();
            for (int i = 0; i < size; ++i) {
                ret.addParameter((JFTemplateParameter)this.m_hiddenParams.elementAt(i));
            }
        }
        return ret;
    }

    public void reverseExpansionOnRepeatParam(int row) {
        JFParamLine paramLine = this.getParameterLine(row);
        if (paramLine instanceof JFRepeatParamLine) {
            JFRepeatParamLine repeatParam;
            repeatParam.setShowElements(!(repeatParam = (JFRepeatParamLine)paramLine).isShowElements());
            if (!repeatParam.isReadOnly() && repeatParam.getElementsNum() == 0) {
                repeatParam.addNewElement();
            }
            this.fireTableDataChanged();
        }
    }

    public void appendNewRepeatElement(JFRepeatElemLine repeatElem) {
        JFRepeatParamLine repeatParam;
        if (repeatElem == null) {
            return;
        }
        JFParamLine param = this.getParameterLine(repeatElem.getParameterName());
        if (param instanceof JFRepeatParamLine && (repeatParam = (JFRepeatParamLine)param).isLastElement(repeatElem)) {
            repeatParam.addNewElement();
            this.fireTableDataChanged();
        }
    }

    public JFTemplateParameterDef getParameterDefinition(int row) {
        JFParamLine paramLine = this.getParameterLine(row);
        if (paramLine == null) {
            return null;
        }
        return paramLine.getParameterDefinition();
    }

    public JFParamLine getParameterLine(int row) {
        if (this.m_parameterLines == null) {
            return null;
        }
        Iterator it = this.m_parameterLines.iterator();
        JFParamLine item = null;
        JFParamLine foundItem = null;
        int count = 0;
        while (it != null && it.hasNext()) {
            item = (JFParamLine)it.next();
            if (row + 1 == ++count) {
                foundItem = item;
                break;
            }
            if (!(item instanceof JFRepeatParamLine) || !((JFRepeatParamLine)item).isShowElements()) continue;
            int elemNum = ((JFRepeatParamLine)item).getElementsNum();
            if (row + 1 <= count + elemNum) {
                foundItem = ((JFRepeatParamLine)item).getElementAt(row - count);
                break;
            }
            count += elemNum;
        }
        return foundItem;
    }

    public void removeEmptyRepeatElementLine(String paramName) {
        if (this.m_parameterLines == null || paramName == null || paramName.equals("")) {
            return;
        }
        JFParamLine param = this.getParameterLine(paramName);
        if (param instanceof JFRepeatParamLine && ((JFRepeatParamLine)param).removeEmptyElementLines()) {
            this.fireTableDataChanged();
        }
    }

    public void setEditable(boolean isEditable) {
        this.m_editable = isEditable;
    }

    @Override
    public String getColumnName(int col) {
        return this.m_columnHeaders[col];
    }

    @Override
    public int getRowCount() {
        if (this.m_parameterLines == null) {
            return 0;
        }
        Iterator it = this.m_parameterLines.iterator();
        JFParamLine item = null;
        int count = 0;
        while (it != null && it.hasNext()) {
            item = (JFParamLine)it.next();
            ++count;
            if (!(item instanceof JFRepeatParamLine) || !((JFRepeatParamLine)item).isShowElements()) continue;
            count += ((JFRepeatParamLine)item).getElementsNum();
        }
        return count;
    }

    @Override
    public int getColumnCount() {
        return this.m_columnHeaders.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        JFParamLine paramLine = this.getParameterLine(row);
        if (paramLine == null) {
            return null;
        }
        return paramLine.getTabColumnObject(col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (!this.m_editable) {
            return false;
        }
        if (col != 2) {
            return false;
        }
        JFParamLine paramLine = this.getParameterLine(row);
        if (paramLine == null || paramLine instanceof JFRepeatParamLine) {
            return false;
        }
        return !paramLine.isReadOnly();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col != 2 && !(value instanceof String)) {
            return;
        }
        JFParamLine paramLine = this.getParameterLine(row);
        if (paramLine != null) {
            paramLine.updateUserInput(((String)value).trim());
        }
    }

    public Class getColumnClass(int c) {
        if (c > 2) {
            return null;
        }
        return this.getValueAt(0, c).getClass();
    }

    private JFParamLine getParameterLine(String paramName) {
        if (paramName == null || this.m_parameterLines == null) {
            return null;
        }
        JFParamLine element = null;
        int j = this.m_parameterLines.size();
        for (int i = 0; i < j; ++i) {
            element = (JFParamLine)this.m_parameterLines.get(i);
            if (!paramName.equals(element.getParameterName())) continue;
            return element;
        }
        return null;
    }
}

