/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFTemplateParameterDef;
import com.platform.LSFJobFlow.ui.JFCellEditorComponent;
import com.platform.LSFJobFlow.ui.JFComboBoxCell;
import com.platform.LSFJobFlow.ui.JFPasswordFieldCell;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFTextFieldCell;
import com.platform.LSFJobFlow.ui.model.JFParamLine;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class JFTabCellEditor
extends DefaultCellEditor {
    private JFCellEditorComponent m_cellComponent;
    private JFTemplateParameterDef m_paramDef;

    public JFTabCellEditor(JFParamLine jFParamLine) {
        super(new JTextField());
        if (jFParamLine == null) {
            throw new NullPointerException(JFResourceBundle.getString("parameter_paramLine_is_null!"));
        }
        this.m_paramDef = jFParamLine.getParameterDefinition();
        if (this.m_paramDef != null) {
            this.m_cellComponent = this.m_paramDef.getType() == 6 ? new JFPasswordFieldCell() : (this.m_paramDef.getChoices() != null ? new JFComboBoxCell(this.m_paramDef.getChoices(), !this.m_paramDef.isLookup()) : new JFTextFieldCell(this.m_paramDef.getType()));
        }
        if (this.m_cellComponent != null) {
            this.editorComponent = this.m_cellComponent.getJComponent();
        }
        this.setClickCountToStart(1);
    }

    public void resetToInitialValue() {
        this.m_cellComponent.resetToInitialValue();
    }

    @Override
    public Object getCellEditorValue() {
        return this.m_cellComponent.getInput();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        final JTable jTable2 = jTable;
        this.m_cellComponent.setInput((String)object);
        this.m_cellComponent.setFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (SwingUtilities.findFocusOwner(jTable2) == null && jTable2.isEditing()) {
                    jTable2.getCellEditor().stopCellEditing();
                }
            }
        });
        return this.m_cellComponent.getJComponent();
    }
}

