/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFAdminManager;
import com.platform.LSFJobFlow.api.JFCommon;
import com.platform.LSFJobFlow.api.JFDynamicFlow;
import com.platform.LSFJobFlow.api.JFDynamicFlowArray;
import com.platform.LSFJobFlow.api.JFFilter;
import com.platform.LSFJobFlow.api.JFFlow;
import com.platform.LSFJobFlow.api.JFFlowDefinitionManager;
import com.platform.LSFJobFlow.api.JFLoginManager;
import com.platform.LSFJobFlow.api.JFPseudoFlow;
import com.platform.LSFJobFlow.api.JFUser;
import com.platform.LSFJobFlow.api.JFUserGroup;
import com.platform.LSFJobFlow.ui.Debug;
import com.platform.LSFJobFlow.ui.JFEnvVarsDialog;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFStandardOutputBean;
import com.platform.LSFJobFlow.ui.JFUtility;
import com.platform.LSFJobFlow.ui.TextAreaDialog;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class JFSubflowChooser
extends JDialog {
    public static final String PRODUCT_TITLE = JFResourceBundle.getString("DynamicFlowDefinitionDialog$TITLE1");
    public static final String PRODUCT_TITLE_ARRAY = JFResourceBundle.getString("DynamicFlowDefinitionDialog$TITLE2");
    public static final int TARGET_FLOW_NOT_FOUND = -1;
    public static final int TARGET_FLOW_NOT_PUBLISHED = -2;
    boolean m_editable = true;
    boolean m_userCancel = true;
    boolean m_isArray = false;
    String m_mainFlowName = null;
    JFDynamicFlow m_dynamicFlowDef = null;
    JFDynamicFlowArray m_dynamicFlowArrayDef = null;
    JFFlowDefinitionManager m_flowDefMgr = null;
    JFPseudoFlow[] m_pseudoFlows = null;
    Properties m_varProperties = new Properties();
    private boolean m_isJFAdmin = false;
    private boolean m_isGroupAdmin = false;
    private boolean m_isEnableGroupAdmin = false;
    private boolean m_isLimitGroupFlowOwner = false;
    private List<JFUserGroup> m_lsfUserGroups = null;
    private JFStandardOutputBean jFStandardOutputBean1;
    private JPanel jPanel1;
    private JButton m_CancelButton;
    private JButton m_DetailButton;
    private JButton m_ModifyButton;
    private JButton m_OKButton;
    private JRadioButton m_autoType;
    private JRadioButton m_defaultType;
    private JComboBox m_dynamicSubflowList;
    private JLabel m_dynamicSubflowNameLabel;
    private ButtonGroup m_exclutionGroup;
    private JLabel m_exclutionLabel;
    private JPanel m_exclutionPanel;
    private JPanel m_flowArrayIndexPanel;
    private JRadioButton m_inParallel;
    private JRadioButton m_inSequential;
    private JTextField m_indexHigh;
    private JLabel m_indexHighLabel;
    private JTextField m_indexLow;
    private JLabel m_indexLowLabel;
    private JTextField m_inputVariable;
    private JLabel m_inputVariableLabel;
    private JRadioButton m_manualType;
    private JTextField m_subflowName;
    private JLabel m_subflowNameLabel;
    private JPanel m_subflowNamePanel;
    private ButtonGroup m_subflowRefTypeGroup;
    private JLabel m_subflowRefTypeLabel;
    private JPanel m_subflowType;

    public JFSubflowChooser(Frame frame, boolean bl, boolean bl2) {
        super(frame, bl);
        String string;
        JFFilter jFFilter;
        String string2;
        this.initComponents();
        this.m_isArray = bl2;
        if (!this.m_isArray) {
            this.hideFlowArrayIndexPanel();
        }
        if (this.m_isArray) {
            this.m_subflowName.setToolTipText(JFResourceBundle.getString("DynamicFlowArray$TIP_name"));
            this.m_dynamicSubflowList.setToolTipText(JFResourceBundle.getString("DynamicFlowArray$TIP_refList"));
            this.m_inputVariable.setToolTipText(JFResourceBundle.getString("DynamicFlow$TIP_inputVar"));
        } else {
            this.m_subflowName.setToolTipText(JFResourceBundle.getString("DynamicSubFlow$TIP_name"));
            this.m_dynamicSubflowList.setToolTipText(JFResourceBundle.getString("DynamicSubFlow$TIP_refList"));
            this.m_inputVariable.setToolTipText(JFResourceBundle.getString("DynamicFlow$TIP_inputVar"));
        }
        this.jFStandardOutputBean1.showFieldsForDynamicFlow();
        this.pack();
        boolean bl3 = false;
        try {
            this.m_flowDefMgr = new JFFlowDefinitionManager();
            this.m_pseudoFlows = this.m_flowDefMgr.getPseudoFlows(new JFFilter());
        }
        catch (Exception exception) {
            if (exception.getMessage().indexOf(JFResourceBundle.getString("ERRORMSG_PERMISSIONDENIED")) >= 0) {
                bl3 = true;
            }
            string2 = JFResourceBundle.getString("JFSubflowChooser$ERR_targetFlowListInvalid");
            string2 = string2 + exception.getMessage();
            JFUtility.showAppErrorMsg(this, string2);
        }
        if (bl3) {
            try {
                jFFilter = new JFFilter();
                jFFilter.setUser(new JFUser(JFLoginManager.getUserName()).toJSUserName());
                this.m_pseudoFlows = this.m_flowDefMgr.getPseudoFlows(jFFilter);
            }
            catch (Exception exception) {
                string2 = JFResourceBundle.getString("JFSubflowChooser$ERR_targetFlowListInvalid");
                string2 = string2 + exception.getMessage();
                JFUtility.showAppErrorMsg(this, string2);
            }
        }
        jFFilter = null;
        try {
            jFFilter = new JFAdminManager();
            this.m_isJFAdmin = jFFilter.isRootAdminCached();
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.m_isJFAdmin = true;
            jFFilter = null;
        }
        if (this.m_pseudoFlows.length > 0 && jFFilter != null) {
            try {
                this.m_isEnableGroupAdmin = jFFilter.isEnableGroupAdminCached();
                if (this.m_isEnableGroupAdmin) {
                    this.m_isLimitGroupFlowOwner = jFFilter.isLimitGroupFlowOwnerCached();
                    this.m_lsfUserGroups = jFFilter.getUserGroupsCached();
                    this.m_isGroupAdmin = jFFilter.isGroupAdmin();
                }
            }
            catch (Exception exception) {
                string = JFResourceBundle.getString("JFSubflowChooser$ERR_targetFlowListInvalid");
                string = string + exception.getMessage();
                JFUtility.showAppErrorMsg(this, string);
            }
        }
        for (int i = 0; i < this.m_pseudoFlows.length; ++i) {
            if (this.m_pseudoFlows[i].getPublished() != 1) continue;
            if (!this.m_isJFAdmin && this.m_isGroupAdmin && this.m_isLimitGroupFlowOwner) {
                string = this.m_pseudoFlows[i].getFlowName();
                int n = string.indexOf(":");
                if (n <= 0) continue;
                String string3 = string.substring(0, n);
                try {
                    if (!jFFilter.isGroupAdminFor(string3)) continue;
                    this.m_dynamicSubflowList.addItem(this.m_pseudoFlows[i].getFlowName());
                }
                catch (Exception exception) {
                    Debug.printStackTrace(exception);
                }
                continue;
            }
            this.m_dynamicSubflowList.addItem(this.m_pseudoFlows[i].getFlowName());
        }
        this.setEditable(this.m_editable);
        this.getRootPane().setDefaultButton(this.m_OKButton);
    }

    public void hideFlowArrayIndexPanel() {
        this.m_flowArrayIndexPanel.setVisible(false);
        this.m_exclutionPanel.setVisible(false);
        this.pack();
    }

    private void initComponents() {
        this.m_subflowRefTypeGroup = new ButtonGroup();
        this.m_exclutionGroup = new ButtonGroup();
        this.m_subflowNamePanel = new JPanel();
        this.m_subflowNameLabel = new JLabel();
        this.m_subflowName = new JTextField();
        this.m_flowArrayIndexPanel = new JPanel();
        this.m_indexLowLabel = new JLabel();
        this.m_indexHighLabel = new JLabel();
        this.m_indexLow = new JTextField();
        this.m_indexHigh = new JTextField();
        this.m_exclutionPanel = new JPanel();
        this.m_exclutionLabel = new JLabel();
        this.m_inParallel = new JRadioButton();
        this.m_inSequential = new JRadioButton();
        this.m_subflowType = new JPanel();
        this.m_dynamicSubflowNameLabel = new JLabel();
        this.m_dynamicSubflowList = new JComboBox();
        this.m_subflowRefTypeLabel = new JLabel();
        this.m_DetailButton = new JButton();
        this.m_defaultType = new JRadioButton();
        this.m_autoType = new JRadioButton();
        this.m_manualType = new JRadioButton();
        this.m_inputVariableLabel = new JLabel();
        this.m_inputVariable = new JTextField();
        this.m_ModifyButton = new JButton();
        this.jFStandardOutputBean1 = new JFStandardOutputBean();
        this.jPanel1 = new JPanel();
        this.m_OKButton = new JButton();
        this.m_CancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(JFResourceBundle.getString("Insert_Subflow_Reference"));
        this.setMinimumSize(new Dimension(870, 97));
        this.setResizable(false);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.m_subflowNamePanel.setAlignmentX(0.0f);
        this.m_subflowNamePanel.setMaximumSize(new Dimension(430, Short.MAX_VALUE));
        this.m_subflowNameLabel.setText(JFResourceBundle.getString("Name_"));
        this.m_subflowNameLabel.setAlignmentX(0.5f);
        GroupLayout groupLayout = new GroupLayout(this.m_subflowNamePanel);
        this.m_subflowNamePanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.m_subflowNameLabel).addGap(35, 35, 35).addComponent(this.m_subflowName, -2, 235, -2).addContainerGap(111, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_subflowNameLabel).addComponent(this.m_subflowName, -2, -1, -2)).addContainerGap()));
        this.getContentPane().add(this.m_subflowNamePanel);
        this.m_flowArrayIndexPanel.setBorder(BorderFactory.createTitledBorder(JFResourceBundle.getString("Array_Definition")));
        this.m_flowArrayIndexPanel.setAlignmentX(0.0f);
        this.m_flowArrayIndexPanel.setMaximumSize(new Dimension(430, Short.MAX_VALUE));
        this.m_flowArrayIndexPanel.setPreferredSize(new Dimension(430, 140));
        this.m_indexLowLabel.setText(JFResourceBundle.getString("First_Element_"));
        this.m_indexHighLabel.setText(JFResourceBundle.getString("Last_Element_"));
        this.m_indexLow.setText("1");
        this.m_exclutionPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.m_exclutionPanel.setPreferredSize(new Dimension(287, 49));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("guiSharedResource");
        this.m_exclutionLabel.setText(resourceBundle.getString("Exclution_Order"));
        this.m_exclutionGroup.add(this.m_inParallel);
        this.m_inParallel.setSelected(true);
        this.m_inParallel.setText(resourceBundle.getString("Exclution_Order_Parallel"));
        this.m_inParallel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_inParallel.setMargin(new Insets(0, 0, 0, 0));
        this.m_exclutionGroup.add(this.m_inSequential);
        this.m_inSequential.setText(resourceBundle.getString("Exclution_Order_Sequential"));
        this.m_inSequential.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_inSequential.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout2 = new GroupLayout(this.m_exclutionPanel);
        this.m_exclutionPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.m_exclutionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.m_inSequential).addComponent(this.m_inParallel)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_exclutionLabel).addComponent(this.m_inParallel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_inSequential).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout3 = new GroupLayout(this.m_flowArrayIndexPanel);
        this.m_flowArrayIndexPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.m_exclutionPanel, -2, 287, -2).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout3.createSequentialGroup().addComponent(this.m_indexLowLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_indexLow, -2, 231, -2)).addGroup(groupLayout3.createSequentialGroup().addComponent(this.m_indexHighLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_indexHigh)))).addContainerGap(107, Short.MAX_VALUE)));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_indexLowLabel).addComponent(this.m_indexLow, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_indexHighLabel).addComponent(this.m_indexHigh, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.m_exclutionPanel, -2, -1, -2).addGap(44, 44, 44)));
        this.getContentPane().add(this.m_flowArrayIndexPanel);
        this.m_subflowType.setAlignmentX(0.0f);
        this.m_subflowType.setMaximumSize(new Dimension(430, Short.MAX_VALUE));
        this.m_subflowType.setPreferredSize(new Dimension(430, 197));
        this.m_dynamicSubflowNameLabel.setText(JFResourceBundle.getString("Choose_a_flow_to_insert_"));
        this.m_dynamicSubflowList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFSubflowChooser.this.m_dynamicSubflowListActionPerformed(actionEvent);
            }
        });
        this.m_subflowRefTypeLabel.setText(JFResourceBundle.getString("Select_update_type_"));
        this.m_DetailButton.setText(JFResourceBundle.getString("Detail"));
        this.m_DetailButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFSubflowChooser.this.m_DetailButtonActionPerformed(actionEvent);
            }
        });
        this.m_subflowRefTypeGroup.add(this.m_defaultType);
        this.m_defaultType.setSelected(true);
        this.m_defaultType.setText(JFResourceBundle.getString("Use_default_settings"));
        this.m_defaultType.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_subflowRefTypeGroup.add(this.m_autoType);
        this.m_autoType.setText(JFResourceBundle.getString("Automatic_update"));
        this.m_autoType.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_subflowRefTypeGroup.add(this.m_manualType);
        this.m_manualType.setText(JFResourceBundle.getString("Manual_update"));
        this.m_manualType.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_inputVariableLabel.setText(JFResourceBundle.getString("Specify_input_variable_"));
        this.m_inputVariable.setEditable(false);
        this.m_ModifyButton.setText(JFResourceBundle.getString("Modify..."));
        this.m_ModifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFSubflowChooser.this.m_ModifyButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout4 = new GroupLayout(this.m_subflowType);
        this.m_subflowType.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.m_subflowRefTypeLabel).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addComponent(this.m_defaultType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 86, -2)).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addComponent(this.m_autoType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 90, -2)).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addComponent(this.m_manualType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 112, -2)).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addComponent(this.m_dynamicSubflowNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 200, -2)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.m_dynamicSubflowList, 0, 219, Short.MAX_VALUE).addComponent(this.m_inputVariable, GroupLayout.Alignment.LEADING, -1, 219, Short.MAX_VALUE).addComponent(this.m_inputVariableLabel, GroupLayout.Alignment.LEADING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.m_ModifyButton, -1, -1, Short.MAX_VALUE).addComponent(this.m_DetailButton, -2, 90, -2)))))))).addGap(652, 652, 652)));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addComponent(this.m_dynamicSubflowNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_DetailButton).addComponent(this.m_dynamicSubflowList, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_inputVariableLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_inputVariable, -2, -1, -2).addComponent(this.m_ModifyButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.m_subflowRefTypeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_defaultType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_autoType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_manualType).addContainerGap()));
        this.getContentPane().add(this.m_subflowType);
        this.jFStandardOutputBean1.setAlignmentX(0.0f);
        this.jFStandardOutputBean1.setMaximumSize(new Dimension(860, Integer.MAX_VALUE));
        this.getContentPane().add(this.jFStandardOutputBean1);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setAlignmentX(0.0f);
        this.m_OKButton.setText(JFResourceBundle.getString("OK"));
        this.m_OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFSubflowChooser.this.m_OKButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.m_OKButton);
        this.m_CancelButton.setText(JFResourceBundle.getString("Cancel"));
        this.m_CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFSubflowChooser.this.m_CancelButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.m_CancelButton);
        this.getContentPane().add(this.jPanel1);
        this.pack();
    }

    JFrame getMainFrame() {
        JFrame jFrame = null;
        if (jFrame == null) {
            for (Container container = this.getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof JFrame)) continue;
                jFrame = (JFrame)container;
                break;
            }
        }
        return jFrame;
    }

    private void m_ModifyButtonActionPerformed(ActionEvent actionEvent) {
        JFEnvVarsDialog jFEnvVarsDialog = new JFEnvVarsDialog(this.getMainFrame(), true);
        jFEnvVarsDialog.setVarList(JFCommon.toVarList_withequal((Properties)this.m_varProperties));
        jFEnvVarsDialog.setLocationRelativeTo(this.getMainFrame());
        jFEnvVarsDialog.setEnableDefaultValue(true);
        jFEnvVarsDialog.setTitle(JFResourceBundle.getString("TITLE_INPUT_VARIABLES"));
        jFEnvVarsDialog.setVisible(true);
        String string = jFEnvVarsDialog.getVarList();
        if (string != null) {
            this.m_varProperties = JFCommon.fromVarList_withequal((String)string);
            this.m_inputVariable.setText(string);
        }
    }

    private void m_dynamicSubflowListActionPerformed(ActionEvent actionEvent) {
    }

    private String getFlowDetailStr(JFFlow jFFlow) {
        String string = "";
        string = string + "[" + JFResourceBundle.getString("Flow_name") + "] : " + jFFlow.getName();
        string = string + "\n[" + JFResourceBundle.getString("Flow_version") + "] : " + jFFlow.getFlowVersion().getVersion();
        string = string + "\n[" + JFResourceBundle.getString("Flow_submission_time") + "] : " + jFFlow.getFlowVersion().getSubmissionTime().getTimeString();
        string = string + "\n[" + JFResourceBundle.getString("Flow_comments") + "] : " + jFFlow.getFlowVersion().getComments();
        return string;
    }

    private void m_DetailButtonActionPerformed(ActionEvent actionEvent) {
        try {
            if (this.m_dynamicSubflowList.getSelectedItem() == null) {
                return;
            }
            String string = this.m_dynamicSubflowList.getSelectedItem().toString();
            JFFlow jFFlow = null;
            if (string.length() > 0) {
                jFFlow = this.m_flowDefMgr.getFlow(string);
            }
            if (jFFlow == null) {
                throw new Exception(JFResourceBundle.getString("JFSubflowChooser$ERR_targetFlowNotFound"));
            }
            Frame frame = JFUtility.getMainFrame(this);
            TextAreaDialog textAreaDialog = new TextAreaDialog(frame, true);
            String string2 = JFResourceBundle.getString("FlowDiagramBean$TITLE_viewFlowDetail_");
            string2 = string2 + " ";
            string2 = string2 + string;
            textAreaDialog.setTitle(string2);
            String string3 = this.getFlowDetailStr(jFFlow);
            textAreaDialog.setText(string3);
            textAreaDialog.setLocationRelativeTo(frame);
            textAreaDialog.setVisible(true);
        }
        catch (Exception exception) {
            JFUtility.showAppException(this, exception);
        }
    }

    private void m_CancelButtonActionPerformed(ActionEvent actionEvent) {
        this.m_userCancel = true;
        this.setVisible(false);
        this.dispose();
    }

    private void m_OKButtonActionPerformed(ActionEvent actionEvent) {
        this.m_userCancel = false;
        try {
            int n;
            String string;
            Object object;
            String string2;
            block16: {
                string2 = this.m_subflowName.getText();
                if (!JFUtility.isValidJobFlowIdentity(string2)) {
                    throw new Exception(JFResourceBundle.getString("JFSubflowChooser$ERR_flowNameInvalid"));
                }
                object = this.m_dynamicSubflowList.getSelectedItem();
                if (object == null || object.toString().length() == 0) {
                    throw new Exception(JFResourceBundle.getString("JFSubflowChooser$ERR_targetFlowNameInvalid"));
                }
                if (this.m_isArray) {
                    int n2;
                    block15: {
                        String string3 = this.m_indexLow.getText().trim();
                        string = this.m_indexHigh.getText().trim();
                        if (string3.equals("") || string.equals("")) {
                            JFUtility.showAppErrorMsg(this, JFResourceBundle.getString("FlowAttrDialog$ERR_ArrayValuesInvalid"));
                            return;
                        }
                        n2 = 0;
                        try {
                            n2 = Integer.parseInt(string3);
                            if (n2 < 1) {
                                JFUtility.showAppErrorMsg(this, JFResourceBundle.getString("FlowAttrDialog$ERR_ArrayFirstValueInvalid"));
                                return;
                            }
                        }
                        catch (Exception exception) {
                            if (string3.startsWith("#{") && string3.endsWith("}")) break block15;
                            JFUtility.showAppErrorMsg(this, JFResourceBundle.getString("FlowAttrDialog$ERR_ArrayValuesInvalid"));
                            return;
                        }
                    }
                    try {
                        int n3 = Integer.parseInt(string);
                        if (n2 > n3) {
                            JFUtility.showAppErrorMsg(this, JFResourceBundle.getString("FlowAttrDialog$ERR_ArraySecondValueInvalid"));
                            return;
                        }
                    }
                    catch (Exception exception) {
                        if (string.startsWith("#{") && string.endsWith("}")) break block16;
                        JFUtility.showAppErrorMsg(this, JFResourceBundle.getString("FlowAttrDialog$ERR_ArrayValuesInvalid"));
                        return;
                    }
                }
            }
            if ((n = this.isTargetFlowMatched(object.toString())) < 0) {
                string = JFResourceBundle.getString("JFSubflowChooser$WARNING_targetFlowNotFound");
                if (n == -2) {
                    string = JFResourceBundle.getString("JFSubflowChooser$WARNING_targetFlowNotPublished");
                }
                Object[] objectArray = new Object[]{object.toString(), string2};
                MessageFormat messageFormat = new MessageFormat(string);
                JFUtility.showAppWarningMsg(this, messageFormat.format(objectArray));
            }
            if (!this.jFStandardOutputBean1.hasValidFields(true)) {
                return;
            }
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            JFUtility.showAppException(this, exception);
        }
    }

    public boolean isCancelSet() {
        return this.m_userCancel;
    }

    public String getFirstElement() {
        return this.m_indexLow.getText().toString();
    }

    public String getLastElement() {
        return this.m_indexHigh.getText().toString();
    }

    public String getTargetFlowName() {
        Object object = this.m_dynamicSubflowList.getSelectedItem();
        if (object == null || object.toString().length() == 0) {
            return null;
        }
        return object.toString();
    }

    public Properties getVarProps() {
        return this.m_varProperties;
    }

    public JFDynamicFlowArray createDynamicFlowArray(JFDynamicFlowArray jFDynamicFlowArray) {
        if (jFDynamicFlowArray == null) {
            this.m_dynamicFlowDef = this.createDynamicFlow(null);
            this.m_dynamicFlowArrayDef = new JFDynamicFlowArray(this.m_dynamicFlowDef, this.getFirstElement(), this.getLastElement());
        } else {
            this.m_dynamicFlowArrayDef = jFDynamicFlowArray;
            this.m_dynamicFlowDef = this.createDynamicFlow(this.m_dynamicFlowArrayDef.getFlowDefinition());
            this.m_dynamicFlowArrayDef.setFlowDefinition(this.m_dynamicFlowDef);
            this.m_dynamicFlowArrayDef.setName(this.m_dynamicFlowDef.getName());
            this.m_dynamicFlowArrayDef.setElementIndex(this.getFirstElement(), this.getLastElement());
        }
        return this.m_dynamicFlowArrayDef;
    }

    public JFDynamicFlow createDynamicFlow(JFDynamicFlow jFDynamicFlow) {
        String string = this.m_subflowName.getText();
        if (jFDynamicFlow == null) {
            this.m_dynamicFlowDef = new JFDynamicFlow(string);
        } else {
            this.m_dynamicFlowDef = jFDynamicFlow;
            this.m_dynamicFlowDef.setName(string);
        }
        this.m_dynamicFlowDef.setAttribute("TargetFlowDefName", this.m_dynamicSubflowList.getSelectedItem().toString());
        if (this.m_autoType.isSelected()) {
            this.m_dynamicFlowDef.setAttribute("UpdateType", "Automatic");
        } else if (this.m_manualType.isSelected()) {
            this.m_dynamicFlowDef.setAttribute("UpdateType", "Manual");
        } else {
            this.m_dynamicFlowDef.setAttribute("UpdateType", "Default");
        }
        if (this.m_inSequential.isSelected()) {
            this.m_dynamicFlowDef.setAttribute("Exclusive", "Yes");
        } else {
            this.m_dynamicFlowDef.setAttribute("Exclusive", "No");
        }
        this.m_dynamicFlowDef.setVarProps(this.m_varProperties);
        if (this.jFStandardOutputBean1.getStdoutCreate()) {
            this.m_dynamicFlowDef.setAttribute("FlowCreateStdout", "Yes");
            this.m_dynamicFlowDef.setAttribute("FlowStdout", this.jFStandardOutputBean1.getStdoutFile());
        } else {
            this.m_dynamicFlowDef.setAttribute("FlowCreateStdout", "No");
            this.m_dynamicFlowDef.setAttribute("FlowStdout", "");
        }
        this.m_dynamicFlowDef.setAttribute("FlowStdoutDir", this.jFStandardOutputBean1.getStdoutDir());
        if (this.jFStandardOutputBean1.getStdoutAutoJobIndexCheckbox()) {
            this.m_dynamicFlowDef.setAttribute("FlowStdoutAutoIndex", "Yes");
        } else {
            this.m_dynamicFlowDef.setAttribute("FlowStdoutAutoIndex", "No");
        }
        if (this.jFStandardOutputBean1.getStderrCreate()) {
            this.m_dynamicFlowDef.setAttribute("FlowCreateStderr", "Yes");
            this.m_dynamicFlowDef.setAttribute("FlowStderr", this.jFStandardOutputBean1.getStderrFile());
        } else {
            this.m_dynamicFlowDef.setAttribute("FlowCreateStderr", "No");
            this.m_dynamicFlowDef.setAttribute("FlowStderr", "");
        }
        this.m_dynamicFlowDef.setAttribute("FlowStderrDir", this.jFStandardOutputBean1.getStderrDir());
        if (this.jFStandardOutputBean1.getStderrAutoJobIndexCheckbox()) {
            this.m_dynamicFlowDef.setAttribute("FlowStderrAutoIndex", "Yes");
        } else {
            this.m_dynamicFlowDef.setAttribute("FlowStderrAutoIndex", "No");
        }
        this.m_dynamicFlowDef.setAttribute("FlowUseStdoutFrom", this.jFStandardOutputBean1.getStdoutDynamicFileCreation());
        this.m_dynamicFlowDef.setAttribute("FlowUseStderrFrom", this.jFStandardOutputBean1.getStderrDynamicFileCreation());
        return this.m_dynamicFlowDef;
    }

    private void setDynamicFlowDef(JFDynamicFlow jFDynamicFlow) {
        this.m_subflowName.setText(jFDynamicFlow.getName());
        String string = jFDynamicFlow.getAttribute("TargetFlowDefName");
        if (string != null && !"".equals(string) && !this.selectAndSetTargetFlow(string)) {
            this.m_dynamicSubflowList.insertItemAt(string, 0);
            this.m_dynamicSubflowList.setSelectedIndex(0);
        }
        if ("Automatic".equals(jFDynamicFlow.getAttribute("UpdateType"))) {
            this.m_autoType.setSelected(true);
        } else if ("Manual".equals(jFDynamicFlow.getAttribute("UpdateType"))) {
            this.m_manualType.setSelected(true);
        } else {
            this.m_defaultType.setSelected(true);
        }
        this.m_varProperties = jFDynamicFlow.getVarProps();
        this.m_inputVariable.setText(JFCommon.toVarList((Properties)this.m_varProperties));
        this.jFStandardOutputBean1.populateFieldsForDynamicFlow(jFDynamicFlow);
    }

    private void setDynamicFlowArrayDef(JFDynamicFlowArray jFDynamicFlowArray) {
        this.setDynamicFlowDef(jFDynamicFlowArray.getFlowDefinition());
        this.m_indexLow.setText(jFDynamicFlowArray.getFirstElement());
        this.m_indexHigh.setText(jFDynamicFlowArray.getLastElement());
    }

    public boolean openDynamicFlow(JFDynamicFlow jFDynamicFlow, boolean bl) {
        if (jFDynamicFlow == null) {
            return false;
        }
        JFDynamicFlow jFDynamicFlow2 = (JFDynamicFlow)jFDynamicFlow.clone();
        this.m_editable = bl;
        if (bl) {
            this.setTitle(PRODUCT_TITLE + " - " + JFResourceBundle.getString("Edit_dynamic_subflow"));
        } else {
            this.setTitle(PRODUCT_TITLE + " - " + JFResourceBundle.getString("View_dynamic_subflow"));
        }
        this.setDynamicFlowDef(jFDynamicFlow);
        this.setEditable(bl);
        if (!JFUtility.isLinux()) {
            this.pack();
        }
        this.show();
        if (bl && !this.m_userCancel) {
            JFDynamicFlow jFDynamicFlow3 = this.createDynamicFlow(jFDynamicFlow);
            return !jFDynamicFlow3.equals(jFDynamicFlow2);
        }
        return false;
    }

    public boolean openDynamicFlowArray(JFDynamicFlowArray jFDynamicFlowArray, boolean bl) {
        if (jFDynamicFlowArray == null) {
            return false;
        }
        JFDynamicFlowArray jFDynamicFlowArray2 = (JFDynamicFlowArray)jFDynamicFlowArray.clone();
        this.m_editable = bl;
        if (bl) {
            this.setTitle(PRODUCT_TITLE_ARRAY + " - " + JFResourceBundle.getString("Edit_dynamic_flowarray"));
        } else {
            this.setTitle(PRODUCT_TITLE_ARRAY + " - " + JFResourceBundle.getString("View_dynamic_flowarray"));
        }
        this.setDynamicFlowArrayDef(jFDynamicFlowArray);
        this.setEditable(bl);
        String string = jFDynamicFlowArray.getFlowDefinition().getAttribute("Exclusive");
        if (string != null && string.equals("Yes")) {
            this.m_inSequential.setSelected(true);
            this.m_inParallel.setSelected(false);
        } else {
            this.m_inSequential.setSelected(false);
            this.m_inParallel.setSelected(true);
        }
        if (!JFUtility.isLinux()) {
            this.pack();
        }
        this.show();
        if (bl && !this.m_userCancel) {
            JFDynamicFlowArray jFDynamicFlowArray3 = this.createDynamicFlowArray(jFDynamicFlowArray);
            return !jFDynamicFlowArray3.equals(jFDynamicFlowArray2);
        }
        return false;
    }

    private boolean selectAndSetTargetFlow(String string) {
        int n = this.isTargetFlowMatched(string);
        if (n >= 0) {
            this.m_dynamicSubflowList.setSelectedItem(string);
            return true;
        }
        return false;
    }

    private int isTargetFlowMatched(String string) {
        if (string == null) {
            return -1;
        }
        if (this.m_pseudoFlows == null) {
            return -1;
        }
        for (int i = 0; i < this.m_pseudoFlows.length; ++i) {
            if (this.m_pseudoFlows[i].getPublished() == 1 && string.equals(this.m_pseudoFlows[i].getFlowName())) {
                return i;
            }
            if (this.m_pseudoFlows[i].getPublished() == 1 || !string.equals(this.m_pseudoFlows[i].getFlowName())) continue;
            return -2;
        }
        return -1;
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JFSubflowChooser((Frame)new JFrame(), true, false).setVisible(true);
            }
        });
    }

    private void setEditable(boolean bl) {
        if (bl) {
            this.m_indexHigh.setEnabled(true);
            this.m_indexLow.setEnabled(true);
            this.m_inputVariable.setEditable(false);
            this.m_dynamicSubflowList.setEditable(false);
            this.m_subflowName.setEditable(true);
            this.m_autoType.setEnabled(true);
            this.m_manualType.setEnabled(true);
            this.m_defaultType.setEnabled(true);
            this.m_CancelButton.setVisible(true);
            this.m_DetailButton.setVisible(true);
            this.m_ModifyButton.setVisible(true);
            this.m_OKButton.setVisible(true);
            this.getRootPane().setDefaultButton(this.m_OKButton);
        } else {
            this.m_indexHigh.setEnabled(false);
            this.m_indexLow.setEnabled(false);
            this.m_inputVariable.setEditable(false);
            this.m_dynamicSubflowNameLabel.setText(JFResourceBundle.getString("Flow_to_insert_"));
            this.m_dynamicSubflowList.setEditable(false);
            this.m_dynamicSubflowList.setEnabled(false);
            this.m_subflowName.setEditable(false);
            this.m_inputVariableLabel.setText(JFResourceBundle.getString("Input_variable_"));
            this.m_autoType.setEnabled(false);
            this.m_manualType.setEnabled(false);
            this.m_defaultType.setEnabled(false);
            this.m_DetailButton.setVisible(false);
            this.m_ModifyButton.setVisible(false);
            this.m_OKButton.setVisible(false);
            this.m_CancelButton.setText(JFResourceBundle.getString("Close"));
            this.m_CancelButton.setVisible(true);
        }
        this.m_inParallel.setEnabled(bl);
        this.m_inParallel.setOpaque(bl);
        this.m_inSequential.setEnabled(bl);
        this.m_inSequential.setOpaque(bl);
        this.jFStandardOutputBean1.setEditable(bl);
    }
}

