/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFTime;
import com.platform.LSFJobFlow.api.JFTimeEvent;
import com.platform.LSFJobFlow.api.JFVersion;
import com.platform.LSFJobFlow.ui.JFCalendarDetailsDialog;
import com.platform.LSFJobFlow.ui.JFDescriptionPane;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFTimeZoneSelectionBean;
import com.platform.LSFJobFlow.ui.JFUtility;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class JFSASTimeEventBean
extends JPanel {
    private static final String ERROR_MSG = JFResourceBundle.getString("All_field_should_be_correctly_filled_in");
    private static final int MAXIMUM_ROW = 5;
    private static final String INVALID = JFResourceBundle.getString("Invalid_input");
    private static final String OUTOFRANGE = JFResourceBundle.getString("The_input_is_out_of_range");
    private static final String ERROR = JFResourceBundle.getString("Error");
    private ActionListener m_listener;
    private Vector m_listOfCal;
    private DefaultComboBoxModel m_model;
    private boolean m_editable;
    private boolean m_daemonExist;
    private String m_calName;
    private String m_calExpr;
    private String m_calDesc;
    private String m_calCreationTime;
    private boolean m_isOldServer;
    private boolean m_enableOccurrence;
    private JLabel m_TimeZoneLabel;
    private JComboBox m_calBox;
    private JLabel m_calLabel;
    private JLabel m_descriptionLabel;
    private JFDescriptionPane m_descriptionPane;
    private JScrollPane m_descriptionScroll;
    private JButton m_detailButton;
    private JLabel m_durationExample;
    private JTextField m_durationField;
    private JLabel m_durationLabel;
    private JCheckBox m_endAfterCheckBox;
    private JTextField m_endAfterField;
    private JLabel m_headerLabel;
    private JLabel m_hourExample;
    private JTextField m_hourField;
    private JLabel m_hourLabel;
    private JLabel m_lastEventTimeLabel;
    private JTextField m_minuteField;
    private JLabel m_minuteLabel;
    private JLabel m_minutesExample;
    private JLabel m_nextEventTimeLabel;
    private JLabel m_occurLabel;
    private JButton m_refreshButton;
    private JFTimeZoneSelectionBean m_timeZoneSelectionBean;

    public JFSASTimeEventBean() {
        this.init(new Vector());
    }

    public JFSASTimeEventBean(Vector vector) {
        this.init(vector);
    }

    private void init(Vector vector) {
        this.m_listOfCal = vector;
        this.m_enableOccurrence = true;
        this.m_editable = true;
        this.initComponents();
        this.resetTimeLabels(null);
        this.setAccessibleInfo();
        this.m_model = new DefaultComboBoxModel(this.m_listOfCal);
        this.m_calBox.setModel(this.m_model);
    }

    private void resetTimeLabels(String string) {
        if (!this.m_editable) {
            if (string == null) {
                this.m_headerLabel.setText("");
            } else {
                if (string == null) {
                    string = "";
                }
                Object[] objectArray = new Object[]{string};
                String string2 = JFResourceBundle.getString("JFSASTimeEventBean$timezone_is");
                MessageFormat messageFormat = new MessageFormat(string2);
                this.m_headerLabel.setText(messageFormat.format(objectArray));
            }
        } else {
            this.m_headerLabel.setText(JFResourceBundle.getString("JFSASTimeEventBean$TITLE"));
        }
    }

    private void setAccessibleInfo() {
        this.m_calLabel.setLabelFor(this.m_calBox);
        this.m_calBox.getAccessibleContext().setAccessibleName(this.m_calLabel.getText());
        this.m_calBox.getAccessibleContext().setAccessibleDescription(this.m_calBox.getToolTipText());
        this.m_hourLabel.setLabelFor(this.m_hourField);
        this.m_hourField.getAccessibleContext().setAccessibleName(this.m_hourLabel.getText());
        this.m_hourField.getAccessibleContext().setAccessibleDescription(this.m_hourField.getToolTipText());
        this.m_minuteLabel.setLabelFor(this.m_minuteField);
        this.m_minuteField.getAccessibleContext().setAccessibleName(this.m_minuteLabel.getText());
        this.m_minuteField.getAccessibleContext().setAccessibleDescription(this.m_minuteField.getToolTipText());
        this.m_durationLabel.setLabelFor(this.m_durationField);
        this.m_durationField.getAccessibleContext().setAccessibleName(this.m_durationLabel.getText());
        this.m_durationField.getAccessibleContext().setAccessibleDescription(this.m_durationField.getToolTipText());
        this.m_descriptionLabel.setLabelFor(this.m_descriptionPane);
        this.m_descriptionPane.getAccessibleContext().setAccessibleName(this.m_descriptionLabel.getText());
        this.m_descriptionPane.getAccessibleContext().setAccessibleDescription(this.m_descriptionPane.getToolTipText());
        this.m_occurLabel.setLabelFor(this.m_endAfterField);
        this.m_endAfterField.getAccessibleContext().setAccessibleName(this.m_occurLabel.getText());
        this.m_endAfterField.getAccessibleContext().setAccessibleDescription(this.m_endAfterField.getToolTipText());
    }

    private void initComponents() {
        this.m_headerLabel = new JLabel();
        this.m_calLabel = new JLabel();
        this.m_hourLabel = new JLabel();
        this.m_minuteLabel = new JLabel();
        this.m_durationLabel = new JLabel();
        this.m_endAfterCheckBox = new JCheckBox();
        this.m_descriptionLabel = new JLabel();
        this.m_calBox = new JComboBox();
        this.m_hourField = new JTextField();
        this.m_minuteField = new JTextField();
        this.m_durationField = new JTextField();
        this.m_endAfterField = new JTextField();
        this.m_descriptionScroll = new JScrollPane();
        this.m_descriptionPane = new JFDescriptionPane();
        this.m_detailButton = new JButton();
        this.m_hourExample = new JLabel();
        this.m_minutesExample = new JLabel();
        this.m_durationExample = new JLabel();
        this.m_occurLabel = new JLabel();
        this.m_refreshButton = new JButton();
        this.m_TimeZoneLabel = new JLabel();
        this.m_timeZoneSelectionBean = new JFTimeZoneSelectionBean();
        this.m_lastEventTimeLabel = new JLabel();
        this.m_nextEventTimeLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.m_headerLabel.setText("Specify the date by selecting a calendar, then specify the time(at the client), in hours and minutes.");
        this.m_headerLabel.setMaximumSize(new Dimension(551, 16));
        this.m_headerLabel.setMinimumSize(new Dimension(551, 16));
        this.m_headerLabel.setPreferredSize(new Dimension(551, 16));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 15, 5, 15);
        this.add((Component)this.m_headerLabel, gridBagConstraints);
        this.m_calLabel.setHorizontalAlignment(2);
        this.m_calLabel.setText(JFResourceBundle.getString("Calendar_Name_"));
        this.m_calLabel.setMaximumSize(new Dimension(92, 16));
        this.m_calLabel.setMinimumSize(new Dimension(92, 16));
        this.m_calLabel.setPreferredSize(new Dimension(92, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 15, 1, 5);
        this.add((Component)this.m_calLabel, gridBagConstraints);
        this.m_hourLabel.setHorizontalAlignment(2);
        this.m_hourLabel.setText(JFResourceBundle.getString("Hours:__"));
        this.m_hourLabel.setMaximumSize(new Dimension(43, 16));
        this.m_hourLabel.setMinimumSize(new Dimension(43, 16));
        this.m_hourLabel.setPreferredSize(new Dimension(43, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 15, 1, 5);
        this.add((Component)this.m_hourLabel, gridBagConstraints);
        this.m_minuteLabel.setHorizontalAlignment(2);
        this.m_minuteLabel.setText(JFResourceBundle.getString("Minutes:__"));
        this.m_minuteLabel.setMaximumSize(new Dimension(54, 16));
        this.m_minuteLabel.setMinimumSize(new Dimension(54, 16));
        this.m_minuteLabel.setPreferredSize(new Dimension(54, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 15, 1, 5);
        this.add((Component)this.m_minuteLabel, gridBagConstraints);
        this.m_durationLabel.setHorizontalAlignment(2);
        this.m_durationLabel.setText(JFResourceBundle.getString("Duration_of_event:__"));
        this.m_durationLabel.setMaximumSize(new Dimension(123, 16));
        this.m_durationLabel.setMinimumSize(new Dimension(103, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 15, 1, 5);
        this.add((Component)this.m_durationLabel, gridBagConstraints);
        this.m_endAfterCheckBox.setText(JFResourceBundle.getString("End_after__"));
        this.m_endAfterCheckBox.setActionCommand("m_endAfterLabel");
        this.m_endAfterCheckBox.setMaximumSize(new Dimension(85, 24));
        this.m_endAfterCheckBox.setMinimumSize(new Dimension(85, 24));
        this.m_endAfterCheckBox.setPreferredSize(new Dimension(85, 24));
        this.m_endAfterCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JFSASTimeEventBean.this.m_endAfterCheckBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 15, 1, 5);
        this.add((Component)this.m_endAfterCheckBox, gridBagConstraints);
        this.m_descriptionLabel.setHorizontalAlignment(2);
        this.m_descriptionLabel.setText(JFResourceBundle.getString("Description:__"));
        this.m_descriptionLabel.setMaximumSize(new Dimension(74, 16));
        this.m_descriptionLabel.setMinimumSize(new Dimension(74, 16));
        this.m_descriptionLabel.setPreferredSize(new Dimension(74, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 15, 1, 5);
        this.add((Component)this.m_descriptionLabel, gridBagConstraints);
        this.m_calBox.setEditable(true);
        this.m_calBox.setMaximumRowCount(5);
        this.m_calBox.setToolTipText(JFResourceBundle.getString("JFSASTimeEventBean$TIP_calBox"));
        this.m_calBox.setMinimumSize(new Dimension(129, 23));
        this.m_calBox.setPreferredSize(new Dimension(300, 23));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 5, 1, 10);
        this.add((Component)this.m_calBox, gridBagConstraints);
        this.m_hourField.setColumns(20);
        this.m_hourField.setToolTipText(JFResourceBundle.getString("JFSASTimeEventBean$TIP_hourField"));
        this.m_hourField.setPreferredSize(new Dimension(166, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 5, 1, 10);
        this.add((Component)this.m_hourField, gridBagConstraints);
        this.m_minuteField.setColumns(20);
        this.m_minuteField.setToolTipText(JFResourceBundle.getString("JFSASTimeEventBean$TIP_minuteField"));
        this.m_minuteField.setPreferredSize(new Dimension(166, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 5, 1, 10);
        this.add((Component)this.m_minuteField, gridBagConstraints);
        this.m_durationField.setColumns(6);
        this.m_durationField.setText("1");
        this.m_durationField.setToolTipText(JFResourceBundle.getString("JFSASTimeEventBean$TIP_durationField"));
        this.m_durationField.setPreferredSize(new Dimension(54, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 5, 1, 10);
        this.add((Component)this.m_durationField, gridBagConstraints);
        this.m_endAfterField.setColumns(6);
        this.m_endAfterField.setEditable(false);
        this.m_endAfterField.setToolTipText(JFResourceBundle.getString("JFSASTimeEventBean$TIP_endAfter"));
        this.m_endAfterField.setEnabled(false);
        this.m_endAfterField.setOpaque(false);
        this.m_endAfterField.setPreferredSize(new Dimension(54, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 5, 1, 10);
        this.add((Component)this.m_endAfterField, gridBagConstraints);
        this.m_descriptionScroll.setPreferredSize(new Dimension(300, 100));
        this.m_descriptionPane.setToolTipText(JFResourceBundle.getString("JFSASTimeEventBean$TIP_descriptionField"));
        this.m_descriptionScroll.setViewportView(this.m_descriptionPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 5, 1, 15);
        this.add((Component)this.m_descriptionScroll, gridBagConstraints);
        this.m_detailButton.setText(JFResourceBundle.getString("Detail"));
        this.m_detailButton.setMaximumSize(new Dimension(116, 26));
        this.m_detailButton.setMinimumSize(new Dimension(76, 26));
        this.m_detailButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFSASTimeEventBean.this.m_detailButtonActionPerform(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.m_detailButton, gridBagConstraints);
        this.m_hourExample.setHorizontalAlignment(2);
        this.m_hourExample.setText(JFResourceBundle.getString("__(_e.g___*_or_1,6_or_1-7_)"));
        this.m_hourExample.setMaximumSize(new Dimension(159, 16));
        this.m_hourExample.setMinimumSize(new Dimension(129, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 5, 1, 15);
        this.add((Component)this.m_hourExample, gridBagConstraints);
        this.m_minutesExample.setHorizontalAlignment(2);
        this.m_minutesExample.setText(JFResourceBundle.getString("__(_e.g___*_or_10,40_or_20-30_)"));
        this.m_minutesExample.setMaximumSize(new Dimension(182, 16));
        this.m_minutesExample.setMinimumSize(new Dimension(172, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 5, 1, 15);
        this.add((Component)this.m_minutesExample, gridBagConstraints);
        this.m_durationExample.setHorizontalAlignment(2);
        this.m_durationExample.setText(JFResourceBundle.getString("__minutes"));
        this.m_durationExample.setMaximumSize(new Dimension(46, 16));
        this.m_durationExample.setMinimumSize(new Dimension(46, 16));
        this.m_durationExample.setPreferredSize(new Dimension(46, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 5, 1, 15);
        this.add((Component)this.m_durationExample, gridBagConstraints);
        this.m_occurLabel.setHorizontalAlignment(2);
        this.m_occurLabel.setText(JFResourceBundle.getString("Occurrences"));
        this.m_occurLabel.setMaximumSize(new Dimension(73, 16));
        this.m_occurLabel.setMinimumSize(new Dimension(73, 16));
        this.m_occurLabel.setPreferredSize(new Dimension(73, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 5, 1, 15);
        this.add((Component)this.m_occurLabel, gridBagConstraints);
        this.m_refreshButton.setText(JFResourceBundle.getString("Refresh"));
        this.m_refreshButton.setMaximumSize(new Dimension(134, 26));
        this.m_refreshButton.setMinimumSize(new Dimension(94, 26));
        this.m_refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFSASTimeEventBean.this.m_refreshButtongActionPerform(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 1, 1, 15);
        this.add((Component)this.m_refreshButton, gridBagConstraints);
        this.m_TimeZoneLabel.setText(JFResourceBundle.getString("TimeZone_"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.add((Component)this.m_TimeZoneLabel, gridBagConstraints);
        this.m_timeZoneSelectionBean.setBorder(BorderFactory.createTitledBorder(JFResourceBundle.getString("JFTimeZoneSelectionBean$BorderTitle")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 15);
        this.add((Component)this.m_timeZoneSelectionBean, gridBagConstraints);
        this.m_lastEventTimeLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 15, 1, 15);
        this.add((Component)this.m_lastEventTimeLabel, gridBagConstraints);
        this.m_nextEventTimeLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 15, 20, 15);
        this.add((Component)this.m_nextEventTimeLabel, gridBagConstraints);
    }

    private void m_refreshButtongActionPerform(ActionEvent actionEvent) {
        this.m_listener.actionPerformed(new ActionEvent(actionEvent, 0, "refresh"));
        this.resetTimeLabels(null);
    }

    private void m_detailButtonActionPerform(ActionEvent actionEvent) {
        JFCalendarDetailsDialog jFCalendarDetailsDialog = new JFCalendarDetailsDialog((Frame)this.getMainFrame(), true);
        jFCalendarDetailsDialog.setResizable(true);
        jFCalendarDetailsDialog.setLocationRelativeTo(this);
        jFCalendarDetailsDialog.setTitle(JFResourceBundle.getString("Calendar_Details"));
        jFCalendarDetailsDialog.setDetails(this.m_calName, this.m_calExpr, this.m_calDesc, this.m_calCreationTime);
        jFCalendarDetailsDialog.show();
    }

    private void m_endAfterCheckBoxItemStateChanged(ItemEvent itemEvent) {
        if (!this.m_editable) {
            return;
        }
        if (!this.m_enableOccurrence) {
            return;
        }
        boolean bl = this.m_endAfterCheckBox.isSelected();
        this.m_endAfterField.setEnabled(bl);
        this.m_endAfterField.setEditable(bl);
        this.m_endAfterField.setOpaque(bl);
    }

    public JFTimeEvent getEvent() throws Exception {
        String string = (String)this.m_calBox.getSelectedItem();
        String string2 = this.m_hourField.getText();
        String string3 = this.m_minuteField.getText();
        String string4 = this.m_durationField.getText();
        String string5 = this.m_timeZoneSelectionBean.getTimeZoneID();
        String string6 = null;
        if (this.m_endAfterCheckBox.isSelected()) {
            string6 = this.m_endAfterField.getText();
        }
        if (string == null || string.equals("")) {
            throw new Exception(JFResourceBundle.getString("Calendar_name_is_empty"));
        }
        if (!JFUtility.isValidExpression(string2, 0, 23)) {
            throw new Exception(JFResourceBundle.getString("Hours_field_is_invalid"));
        }
        try {
            if (Integer.parseInt(string4, 10) < 1) {
                throw new Exception(JFResourceBundle.getString("Duration_field_is_invalid"));
            }
        }
        catch (Exception exception) {
            throw new Exception(JFResourceBundle.getString("Duration_field_is_invalid"));
        }
        if (string6 != null) {
            try {
                if (Integer.parseInt(string6, 10) < 1) {
                    throw new Exception(JFResourceBundle.getString("Occurrences_field_is_invalid"));
                }
            }
            catch (Exception exception) {
                throw new Exception(JFResourceBundle.getString("Occurrences_field_is_invalid"));
            }
        }
        if (string3 == null || string3.equals("")) {
            string3 = "0";
        } else if (!JFUtility.isValidExpression(string3, 0, 59)) {
            throw new Exception(JFResourceBundle.getString("Minutes_field_is_invalid"));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "@");
        String string7 = null;
        String string8 = null;
        try {
            string7 = stringTokenizer.nextToken();
            string8 = stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            string7 = string;
            string8 = null;
        }
        JFTimeEvent jFTimeEvent = null;
        jFTimeEvent = this.m_isOldServer ? new JFTimeEvent(string7, string8, string2, string3, string4, string6, null) : new JFTimeEvent(string7, string8, string2, string3, string4, string6, string5);
        jFTimeEvent.setAttribute("Description", this.m_descriptionPane.getText());
        return jFTimeEvent;
    }

    void setEvent(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15) throws Exception {
        JFTime jFTime;
        if (!this.m_editable) {
            this.m_model.addElement(string + "@" + string2);
        }
        this.m_calBox.setSelectedItem(string + "@" + string2);
        this.m_hourField.setText(string3);
        this.m_minuteField.setText(string4);
        this.m_durationField.setText(string5);
        this.m_descriptionPane.setText(string7);
        this.m_calName = string + "@" + string2;
        this.m_calExpr = string9;
        this.m_calDesc = string10;
        this.m_calCreationTime = string11;
        if (this.m_calExpr == null || this.m_calExpr.equals("null") || this.m_calExpr.equals("")) {
            this.m_detailButton.setEnabled(false);
        } else {
            this.m_detailButton.setEnabled(true);
        }
        if (string12 != null) {
            if (string12.equals("null")) {
                this.m_lastEventTimeLabel.setText(JFResourceBundle.getString("Last_Time_Event") + "  " + JFResourceBundle.getString("None"));
            } else {
                jFTime = new JFTime(string12);
                this.m_lastEventTimeLabel.setText(JFResourceBundle.getString("Last_Time_Event") + "  " + jFTime.getTimeString());
            }
        } else {
            this.m_lastEventTimeLabel.setText(" ");
        }
        if (string13 != null) {
            if (string13.equals("null")) {
                this.m_nextEventTimeLabel.setText(JFResourceBundle.getString("Next_Time_Event") + "  " + JFResourceBundle.getString("None"));
            } else {
                jFTime = new JFTime(string13);
                this.m_nextEventTimeLabel.setText(JFResourceBundle.getString("Next_Time_Event") + "  " + jFTime.getTimeString());
            }
        } else {
            this.m_nextEventTimeLabel.setText(" ");
        }
        if (string14 == null) {
            this.resetTimeLabels(string8);
        } else {
            this.resetTimeLabels(null);
        }
        boolean bl = false;
        if (string6 != null && !string6.equals("")) {
            bl = true;
            this.m_endAfterField.setText(string6);
        } else {
            this.m_endAfterField.setText("");
        }
        this.m_endAfterCheckBox.setSelected(bl);
        boolean bl2 = bl && this.m_editable;
        this.m_endAfterField.setEnabled(bl2);
        this.m_endAfterField.setEditable(bl2);
        this.m_endAfterField.setOpaque(bl2);
        if (this.m_editable && !this.m_enableOccurrence) {
            this.m_endAfterField.setText("");
            this.m_endAfterCheckBox.setSelected(false);
            this.m_endAfterCheckBox.setEnabled(false);
            this.m_endAfterField.setEditable(false);
            this.m_endAfterField.setEnabled(false);
        }
        this.m_timeZoneSelectionBean.setTimeZone(string14, string15);
    }

    public JPanel getBeanPanel() {
        return this;
    }

    public void refreshData(Vector vector) {
        this.m_model.removeAllElements();
        for (int i = 0; i < vector.size(); ++i) {
            this.m_model.addElement(vector.elementAt(i));
        }
    }

    public void setInitEndAfterCheckBox(boolean bl) {
        this.m_endAfterCheckBox.setSelected(bl);
    }

    public void setEnableOccurrence(boolean bl) {
        this.m_enableOccurrence = bl;
        this.m_endAfterCheckBox.setSelected(bl);
    }

    public void setEditable(boolean bl) {
        this.m_editable = bl;
        this.m_calBox.setEnabled(bl);
        this.m_hourField.setEditable(bl);
        this.m_hourField.setEnabled(bl);
        this.m_hourField.setOpaque(bl);
        this.m_minuteField.setEditable(bl);
        this.m_minuteField.setEnabled(bl);
        this.m_minuteField.setOpaque(bl);
        this.m_durationField.setEditable(bl);
        this.m_durationField.setEnabled(bl);
        this.m_durationField.setOpaque(bl);
        this.m_endAfterCheckBox.setEnabled(bl);
        boolean bl2 = this.m_endAfterCheckBox.isSelected() && bl;
        this.m_endAfterField.setEditable(bl2);
        this.m_endAfterField.setEnabled(bl2);
        this.m_endAfterField.setOpaque(bl2);
        if (!this.m_enableOccurrence) {
            this.m_endAfterCheckBox.setEnabled(false);
            this.m_endAfterField.setEditable(false);
            this.m_endAfterField.setEnabled(false);
        }
        this.m_refreshButton.setEnabled(bl);
        if (bl) {
            this.m_detailButton.hide();
        } else {
            this.m_detailButton.setEnabled(!bl);
        }
        this.m_descriptionPane.setEditable(bl);
        this.m_descriptionPane.setOpaque(bl);
        boolean bl3 = this.m_isOldServer = !JFConfigManager.checkServerVersionCompatible((JFVersion)new JFVersion("7.1"));
        if (this.m_isOldServer) {
            this.m_timeZoneSelectionBean.setEditable(false);
            this.m_timeZoneSelectionBean.setEnabled(false);
        } else {
            this.m_timeZoneSelectionBean.setEditable(bl);
            this.m_timeZoneSelectionBean.setEnabled(bl);
        }
    }

    private String convertToString(int n) {
        if (n < 10) {
            return "0" + String.valueOf(n);
        }
        return String.valueOf(n);
    }

    void setActionListener(ActionListener actionListener) {
        this.m_listener = actionListener;
    }

    public void reset() {
        this.m_hourField.setText("");
        this.m_minuteField.setText("");
        this.m_durationField.setText("");
        this.m_durationField.setText("1");
        this.m_descriptionPane.setText("");
        this.m_endAfterField.setText("");
        this.resetTimeLabels(null);
        this.m_timeZoneSelectionBean.reset();
    }

    JFrame getMainFrame() {
        JFrame jFrame = null;
        if (jFrame == null) {
            for (Container container = this.getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof JFrame)) continue;
                jFrame = (JFrame)container;
                break;
            }
        }
        return jFrame;
    }

    public void setDaemonExist(boolean bl) {
        this.m_daemonExist = bl;
    }

    public void setCalendarEditable() {
        if (!this.m_editable) {
            return;
        }
        if (this.m_daemonExist) {
            this.m_calBox.setEditable(false);
        } else {
            this.m_calBox.setEditable(true);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        JFSASTimeEventBean jFSASTimeEventBean = new JFSASTimeEventBean();
        jFrame.getContentPane().add(jFSASTimeEventBean);
        jFrame.setSize(400, 250);
        jFrame.pack();
        jFrame.show();
    }
}

