/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFCommon;
import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFFlow;
import com.platform.LSFJobFlow.api.JFFlowArrayEvent;
import com.platform.LSFJobFlow.api.JFFlowEvent;
import com.platform.LSFJobFlow.api.JFFlowExceptionEvent;
import com.platform.LSFJobFlow.api.JFJobArrayEvent;
import com.platform.LSFJobFlow.api.JFJobEvent;
import com.platform.LSFJobFlow.api.JFLoginManager;
import com.platform.LSFJobFlow.api.JFUser;
import com.platform.LSFJobFlow.ui.JFDescriptionPane;
import com.platform.LSFJobFlow.ui.JFEventBeanINF;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;

public class JFProxyEventBean
extends JPanel
implements JFEventBeanINF {
    private static String[] s_op1 = new String[]{JFResourceBundle.getString("Greater_than"), JFResourceBundle.getString("Greater_than_or_equal_to"), JFResourceBundle.getString("Equal_to")};
    private static String[] s_op2 = new String[]{JFResourceBundle.getString("Greater_than"), JFResourceBundle.getString("Greater_than_or_equal_to"), JFResourceBundle.getString("Equal_to"), JFResourceBundle.getString("Less_than"), JFResourceBundle.getString("Less_than_or_equal_to"), JFResourceBundle.getString("Not_equal_to")};
    private static String[] s_op_trans = new String[]{">", ">=", "==", "<", "<=", "!="};
    private static String[] s_jobTypes = new String[]{JFResourceBundle.getString("Completes_successfully"), JFResourceBundle.getString("Fails"), JFResourceBundle.getString("Submitted"), JFResourceBundle.getString("Starts"), JFResourceBundle.getString("Ends_with_any_exit_code"), JFResourceBundle.getString("Ends_with_exit_code...")};
    private static String[] s_arrayTypes = new String[]{JFResourceBundle.getString("All_jobs_complete_successfully"), JFResourceBundle.getString("Any_job_fails"), JFResourceBundle.getString("All_jobs_end_with_any_exit_code"), JFResourceBundle.getString("The_sum_of_the_exit_codes_of_all_jobs_is"), JFResourceBundle.getString("Number_of_successful_jobs_is..."), JFResourceBundle.getString("Number_of_jobs_finished_with_any_exit_code_is..."), JFResourceBundle.getString("Number_of_unsuccessful_jobs_is..."), JFResourceBundle.getString("Number_of_jobs_started_is..."), JFResourceBundle.getString("Job_array_submitted")};
    private static String[] s_subFlowTypes = new String[]{JFResourceBundle.getString("The_flow_completes_successfully"), JFResourceBundle.getString("The_flow_fails"), JFResourceBundle.getString("The_flow_ends_with_any_exit_code"), JFResourceBundle.getString("The_flow_completes_successfully_with_exit_code..."), JFResourceBundle.getString("The_flow_fails_with_exit_code..."), JFResourceBundle.getString("The_flow_has_exit_code..."), JFResourceBundle.getString("Number_of_successful_jobs_is..."), JFResourceBundle.getString("Number_of_jobs_finished_with_any_exit_code_is..."), JFResourceBundle.getString("Number_of_unsuccessful_jobs_is"), JFResourceBundle.getString("Number_of_jobs_started_is...")};
    private static String[] s_flowTypes = new String[]{JFResourceBundle.getString("The_flow_completes_successfully"), JFResourceBundle.getString("The_flow_fails"), JFResourceBundle.getString("The_flow_ends_with_any_exit_code"), JFResourceBundle.getString("The_flow_completes_successfully_with_exit_code..."), JFResourceBundle.getString("The_flow_fails_with_exit_code..."), JFResourceBundle.getString("The_flow_has_exit_code..."), JFResourceBundle.getString("Number_of_successful_jobs_is..."), JFResourceBundle.getString("Number_of_jobs_finished_with_any_exit_code_is..."), JFResourceBundle.getString("Number_of_unsuccessful_jobs_is"), JFResourceBundle.getString("Number_of_jobs_started_is...")};
    private static String[] s_flowArrayTypes = new String[]{JFResourceBundle.getString("All_flows_complete_successfully"), JFResourceBundle.getString("All_flows_end_with_any_exit_code"), JFResourceBundle.getString("The_sum_of_the_exit_codes_of_all_flows_is..."), JFResourceBundle.getString("Number_of_successful_flows_is..."), JFResourceBundle.getString("Number_of_flows_finished_with_any_exit_code_is..."), JFResourceBundle.getString("Number_of_unsuccessful_flows_is..."), JFResourceBundle.getString("Number_of_flows_started_is...")};
    private boolean m_editable = true;
    private boolean m_submission = false;
    private String m_currentUserName;
    private JLabel m_durationLabel;
    private JLabel m_durationMinutesText;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane m_descScrollPane;
    private JRadioButton m_arrayRbutton;
    private JFDescriptionPane m_descrFLD;
    private JLabel m_descrLabel;
    private JTextField m_durationFLD;
    private JLabel m_eventTypeLabel;
    private JComboBox m_eventTypeSelector;
    private JRadioButton m_flowArrayRbutton;
    private JRadioButton m_flowRbutton;
    private JRadioButton m_jobRbutton;
    private JTextField m_minuteFLD;
    private JLabel m_minutesText;
    private JTextField m_nameFLD;
    private JLabel m_nameLabel;
    private JComboBox m_opSelector;
    private JTextField m_ownerFLD;
    private JLabel m_ownerLabel;
    private ButtonGroup m_radioButtonGrp;
    private JRadioButton m_subFlowRbutton;
    private JTextField m_valueFLD;

    public JFProxyEventBean() {
        this.initComponents();
        this.m_flowArrayRbutton.setVisible(false);
        this.setInputAccessibleInfo();
        this.m_editable = true;
        this.m_submission = false;
        this.m_currentUserName = new JFUser(JFLoginManager.getUserName()).toJSUserName();
    }

    public void setSubmission(boolean bl) {
        this.m_submission = bl;
    }

    @Override
    public JFEvent getEvent() throws Exception {
        if (!this.m_editable) {
            return null;
        }
        JFJobEvent jFJobEvent = null;
        String string = this.m_nameFLD.getText();
        if (string == null || string.length() == 0) {
            throw new Exception(JFResourceBundle.getString("ProxyEventBean$ERR_invalidName"));
        }
        if (!JFEvent.isValidProxyName((String)string)) {
            throw new Exception(JFResourceBundle.getString("ProxyEventBean$ERR_invalidFormatName"));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (this.m_flowRbutton.isSelected() && stringTokenizer.countTokens() > 1) {
            throw new Exception(JFResourceBundle.getString("ProxyEventBean$ERR_notMainFlow"));
        }
        if (this.m_subFlowRbutton.isSelected() && stringTokenizer.countTokens() < 2) {
            throw new Exception(JFResourceBundle.getString("ProxyEventBean$ERR_notSubFlow"));
        }
        if (this.m_jobRbutton.isSelected() && stringTokenizer.countTokens() < 2) {
            throw new Exception(JFResourceBundle.getString("ProxyEventBean$ERR_notJob"));
        }
        if (this.m_arrayRbutton.isSelected() && stringTokenizer.countTokens() < 2) {
            throw new Exception(JFResourceBundle.getString("ProxyEventBean$ERR_notJobArray"));
        }
        String string2 = new JFUser(this.m_ownerFLD.getText()).toJSUserName();
        if (string2 == null || string2.length() == 0) {
            throw new Exception(JFResourceBundle.getString("ProxyEventBean$ERR_invalidOwner"));
        }
        String string3 = string2 + ":" + string;
        int n = this.m_eventTypeSelector.getSelectedIndex();
        String string4 = null;
        if (this.m_opSelector.isVisible()) {
            string4 = s_op_trans[this.m_opSelector.getSelectedIndex()];
        }
        int n2 = 0;
        int[] nArray = null;
        if (this.m_valueFLD.isVisible()) {
            try {
                if (this.m_jobRbutton.isSelected() && n == 5) {
                    nArray = JFCommon.stringToIntegerArray((String)this.m_valueFLD.getText());
                } else {
                    n2 = Integer.parseInt(this.m_valueFLD.getText(), 10);
                }
            }
            catch (Exception exception) {
                throw new Exception(JFResourceBundle.getString("ProxyEventBean$ERR_invalidValue"));
            }
        }
        int n3 = 0;
        if (this.m_minuteFLD.isVisible()) {
            try {
                n3 = Integer.parseInt(this.m_minuteFLD.getText(), 10);
            }
            catch (Exception exception) {
                throw new Exception(JFResourceBundle.getString("ProxyEventBean$ERR_invalidMinute"));
            }
        }
        int n4 = 0;
        if (this.m_durationFLD.isVisible()) {
            try {
                n4 = Integer.parseInt(this.m_durationFLD.getText(), 10);
            }
            catch (Exception exception) {
                throw new Exception(JFResourceBundle.getString("ProxyEventBean$ERR_invalidDuration"));
            }
        }
        if (n4 < 0) {
            throw new Exception(JFResourceBundle.getString("ProxyEventBean$ERR_invalidDuration"));
        }
        if (this.m_jobRbutton.isSelected()) {
            switch (n) {
                case 0: {
                    jFJobEvent = new JFJobEvent(string3, 0);
                    break;
                }
                case 1: {
                    jFJobEvent = new JFJobEvent(string3, 5);
                    break;
                }
                case 2: {
                    jFJobEvent = new JFJobEvent(string3, 4);
                    break;
                }
                case 3: {
                    jFJobEvent = new JFJobEvent(string3, 2);
                    break;
                }
                case 4: {
                    jFJobEvent = new JFJobEvent(string3, 1);
                    break;
                }
                case 5: {
                    jFJobEvent = new JFJobEvent(string3, string4, nArray);
                    break;
                }
            }
        } else if (this.m_arrayRbutton.isSelected()) {
            switch (n) {
                case 0: {
                    jFJobEvent = new JFJobArrayEvent(string3, 0);
                    break;
                }
                case 1: {
                    jFJobEvent = new JFJobArrayEvent(string3, 4);
                    break;
                }
                case 2: {
                    jFJobEvent = new JFJobArrayEvent(string3, 1);
                    break;
                }
                case 3: {
                    jFJobEvent = new JFJobArrayEvent(string3, 2, string4, n2);
                    break;
                }
                case 4: {
                    jFJobEvent = new JFJobArrayEvent(string3, 10, string4, n2);
                    break;
                }
                case 5: {
                    jFJobEvent = new JFJobArrayEvent(string3, 12, string4, n2);
                    break;
                }
                case 6: {
                    jFJobEvent = new JFJobArrayEvent(string3, 11, string4, n2);
                    break;
                }
                case 7: {
                    jFJobEvent = new JFJobArrayEvent(string3, 13, string4, n2);
                    break;
                }
                case 8: {
                    jFJobEvent = new JFJobArrayEvent(string3, 3);
                    break;
                }
            }
        } else if (this.m_flowArrayRbutton.isSelected()) {
            switch (n) {
                case 0: {
                    jFJobEvent = new JFFlowArrayEvent(string3, 0);
                    break;
                }
                case 1: {
                    jFJobEvent = new JFFlowArrayEvent(string3, 3);
                    break;
                }
                case 2: {
                    jFJobEvent = new JFFlowArrayEvent(string3, 1);
                    break;
                }
                case 3: {
                    jFJobEvent = new JFFlowArrayEvent(string3, 2, string4, n2);
                    break;
                }
                case 4: {
                    jFJobEvent = new JFFlowArrayEvent(string3, 10, string4, n2);
                    break;
                }
                case 5: {
                    jFJobEvent = new JFFlowArrayEvent(string3, 12, string4, n2);
                    break;
                }
                case 6: {
                    jFJobEvent = new JFFlowArrayEvent(string3, 11, string4, n2);
                    break;
                }
                case 7: {
                    jFJobEvent = new JFFlowArrayEvent(string3, 13, string4, n2);
                    break;
                }
            }
        } else {
            switch (n) {
                case 0: {
                    jFJobEvent = new JFFlowEvent(string3, 0);
                    break;
                }
                case 1: {
                    jFJobEvent = new JFFlowEvent(string3, 3);
                    break;
                }
                case 2: {
                    jFJobEvent = new JFFlowEvent(string3, 1);
                    break;
                }
                case 3: {
                    jFJobEvent = new JFFlowEvent(string3, 0, string4, n2);
                    break;
                }
                case 4: {
                    jFJobEvent = new JFFlowEvent(string3, 3, string4, n2);
                    break;
                }
                case 5: {
                    jFJobEvent = new JFFlowEvent(string3, 2, string4, n2);
                    break;
                }
                case 6: {
                    jFJobEvent = new JFFlowEvent(string3, 10, string4, n2);
                    break;
                }
                case 7: {
                    jFJobEvent = new JFFlowEvent(string3, 12, string4, n2);
                    break;
                }
                case 8: {
                    jFJobEvent = new JFFlowEvent(string3, 11, string4, n2);
                    break;
                }
                case 9: {
                    jFJobEvent = new JFFlowEvent(string3, 13, string4, n2);
                    break;
                }
                case 10: {
                    if (!this.m_flowRbutton.isSelected() || !this.m_submission) {
                        throw new Exception(JFResourceBundle.getString("ProxyEventBean$ERR_FlowExceptionEvent"));
                    }
                    if (n3 < 1) {
                        throw new Exception(JFResourceBundle.getString("ProxyEventBean$ERR_MinuteLessThanOne"));
                    }
                    jFJobEvent = new JFFlowExceptionEvent(new JFFlow(string3), 3, n3);
                    break;
                }
                case 11: {
                    if (!this.m_flowRbutton.isSelected() || !this.m_submission) {
                        throw new Exception(JFResourceBundle.getString("ProxyEventBean$ERR_FlowExceptionEvent"));
                    }
                    if (n3 < 1) {
                        throw new Exception(JFResourceBundle.getString("ProxyEventBean$ERR_MinuteLessThanOne"));
                    }
                    jFJobEvent = new JFFlowExceptionEvent(new JFFlow(string3), 4, n3);
                    break;
                }
                case 12: {
                    if (!this.m_flowRbutton.isSelected() || !this.m_submission) {
                        throw new Exception(JFResourceBundle.getString("ProxyEventBean$ERR_FlowExceptionEvent"));
                    }
                    jFJobEvent = new JFFlowExceptionEvent(new JFFlow(string3), 0);
                    break;
                }
            }
        }
        if (jFJobEvent != null && this.m_descrFLD.getText() != null) {
            jFJobEvent.setAttribute("PositionX", "1");
            jFJobEvent.setAttribute("PositionY", "1");
            jFJobEvent.setAttribute("Description", this.m_descrFLD.getText());
        }
        if (jFJobEvent != null && this.m_durationFLD.getText() != null) {
            jFJobEvent.setAttribute("TimeDuration", this.m_durationFLD.getText());
        }
        return jFJobEvent;
    }

    @Override
    public void reset() {
        this.m_nameFLD.setText("");
        this.m_ownerFLD.setText(this.m_currentUserName);
        this.m_descrFLD.setText("");
        this.m_valueFLD.setText("");
        this.m_minuteFLD.setText("");
        this.m_durationFLD.setText("");
        String string = JFConfigManager.getConfig((String)"JS_PROXY_DURATION", (String)"");
        try {
            int n = Integer.parseInt(string);
            if (n > 0) {
                this.m_durationFLD.setText(string);
            } else {
                this.m_durationFLD.setText("0");
            }
        }
        catch (RuntimeException runtimeException) {
            this.m_durationFLD.setText("0");
        }
        this.m_jobRbutton.setEnabled(true);
        this.m_jobRbutton.doClick();
        this.m_jobRbutton.setEnabled(this.m_editable);
    }

    @Override
    public void setEditable(boolean bl) {
        this.m_editable = bl;
        this.m_jobRbutton.setEnabled(bl);
        this.m_arrayRbutton.setEnabled(bl);
        this.m_flowArrayRbutton.setEnabled(bl);
        this.m_flowRbutton.setEnabled(bl);
        this.m_subFlowRbutton.setEnabled(bl);
        this.m_nameFLD.setEditable(bl);
        this.m_nameFLD.setOpaque(bl);
        this.m_nameFLD.setEnabled(bl);
        this.m_ownerFLD.setEditable(bl);
        this.m_ownerFLD.setOpaque(bl);
        this.m_ownerFLD.setEnabled(bl);
        this.m_eventTypeSelector.setEnabled(bl);
        this.m_descrFLD.setEditable(bl);
        this.m_descrFLD.setOpaque(bl);
        this.m_descrFLD.setEnabled(bl);
        this.m_durationFLD.setEditable(bl);
        this.m_durationFLD.setOpaque(bl);
        this.m_durationFLD.setEnabled(bl);
        this.m_opSelector.setEnabled(bl);
        this.m_valueFLD.setEditable(bl);
        this.m_valueFLD.setOpaque(bl);
        this.m_valueFLD.setEnabled(bl);
        this.m_minuteFLD.setEditable(bl);
        this.m_minuteFLD.setOpaque(bl);
        this.m_minuteFLD.setEnabled(bl);
    }

    @Override
    public void showAllComponents() {
        this.m_arrayRbutton.setEnabled(true);
        this.m_arrayRbutton.doClick();
        this.m_arrayRbutton.setEnabled(this.m_editable);
        this.m_opSelector.setVisible(true);
        this.m_valueFLD.setVisible(true);
    }

    @Override
    public JPanel getBeanPanel() {
        return this;
    }

    @Override
    public void setEvent(JFEvent jFEvent) throws Exception {
        JFJobEvent jFJobEvent;
        this.reset();
        if (jFEvent == null) {
            return;
        }
        int n = 0;
        int n2 = -1;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (jFEvent instanceof JFJobEvent) {
            jFJobEvent = (JFJobEvent)jFEvent;
            if (!jFJobEvent.isProxy()) {
                throw new IllegalArgumentException(JFResourceBundle.getString("JobEventBean$ERR_parameterErr"));
            }
            this.m_jobRbutton.setEnabled(true);
            this.m_jobRbutton.doClick();
            this.m_jobRbutton.setEnabled(this.m_editable);
            string3 = jFJobEvent.getJobName();
            int n3 = jFJobEvent.getEventType();
            switch (n3) {
                case 0: {
                    n = 0;
                    break;
                }
                case 5: {
                    n = 1;
                    break;
                }
                case 4: {
                    n = 2;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                case 1: {
                    n = 4;
                    break;
                }
                case 3: {
                    n = 5;
                    n2 = JFUtility.getIndex(s_op_trans, jFJobEvent.getComparisonOp());
                    string = JFCommon.integerArrayToString((int[])jFJobEvent.getComparisonValues());
                    break;
                }
            }
        } else if (jFEvent instanceof JFJobArrayEvent) {
            jFJobEvent = (JFJobArrayEvent)jFEvent;
            if (!jFJobEvent.isProxy()) {
                throw new IllegalArgumentException(JFResourceBundle.getString("JobEventBean$ERR_parameterErr"));
            }
            this.m_arrayRbutton.setEnabled(true);
            this.m_arrayRbutton.doClick();
            this.m_arrayRbutton.setEnabled(this.m_editable);
            string3 = jFJobEvent.getJobArrayName();
            int n4 = jFJobEvent.getEventType();
            switch (n4) {
                case 0: {
                    n = 0;
                    break;
                }
                case 4: {
                    n = 1;
                    break;
                }
                case 1: {
                    n = 2;
                    break;
                }
                case 2: {
                    n = 3;
                    n2 = JFUtility.getIndex(s_op_trans, jFJobEvent.getComparisonOp());
                    string = String.valueOf(jFJobEvent.getComparisonValue());
                    break;
                }
                case 10: {
                    n = 4;
                    n2 = JFUtility.getIndex(s_op_trans, jFJobEvent.getComparisonOp());
                    string = String.valueOf(jFJobEvent.getComparisonValue());
                    break;
                }
                case 12: {
                    n = 5;
                    n2 = JFUtility.getIndex(s_op_trans, jFJobEvent.getComparisonOp());
                    string = String.valueOf(jFJobEvent.getComparisonValue());
                    break;
                }
                case 11: {
                    n = 6;
                    n2 = JFUtility.getIndex(s_op_trans, jFJobEvent.getComparisonOp());
                    string = String.valueOf(jFJobEvent.getComparisonValue());
                    break;
                }
                case 13: {
                    n = 7;
                    n2 = JFUtility.getIndex(s_op_trans, jFJobEvent.getComparisonOp());
                    string = String.valueOf(jFJobEvent.getComparisonValue());
                    break;
                }
                case 3: {
                    n = 8;
                    break;
                }
            }
        } else if (jFEvent instanceof JFFlowArrayEvent) {
            jFJobEvent = (JFFlowArrayEvent)jFEvent;
            if (!jFJobEvent.isProxy()) {
                throw new IllegalArgumentException(JFResourceBundle.getString("JobEventBean$ERR_parameterErr"));
            }
            this.m_flowArrayRbutton.setEnabled(true);
            this.m_flowArrayRbutton.doClick();
            this.m_flowArrayRbutton.setEnabled(this.m_editable);
            string3 = jFJobEvent.getFlowArrayName();
            int n5 = jFJobEvent.getEventType();
            switch (n5) {
                case 0: {
                    n = 0;
                    break;
                }
                case 3: {
                    n = 1;
                    break;
                }
                case 1: {
                    n = 2;
                    break;
                }
                case 2: {
                    n = 3;
                    n2 = JFUtility.getIndex(s_op_trans, jFJobEvent.getComparisonOp());
                    string = String.valueOf(jFJobEvent.getComparisonValue());
                    break;
                }
                case 10: {
                    n = 4;
                    n2 = JFUtility.getIndex(s_op_trans, jFJobEvent.getComparisonOp());
                    string = String.valueOf(jFJobEvent.getComparisonValue());
                    break;
                }
                case 12: {
                    n = 5;
                    n2 = JFUtility.getIndex(s_op_trans, jFJobEvent.getComparisonOp());
                    string = String.valueOf(jFJobEvent.getComparisonValue());
                    break;
                }
                case 11: {
                    n = 6;
                    n2 = JFUtility.getIndex(s_op_trans, jFJobEvent.getComparisonOp());
                    string = String.valueOf(jFJobEvent.getComparisonValue());
                    break;
                }
                case 13: {
                    n = 7;
                    n2 = JFUtility.getIndex(s_op_trans, jFJobEvent.getComparisonOp());
                    string = String.valueOf(jFJobEvent.getComparisonValue());
                    break;
                }
            }
        } else if (jFEvent instanceof JFFlowEvent) {
            jFJobEvent = (JFFlowEvent)jFEvent;
            if (!jFJobEvent.isProxy()) {
                throw new Exception(JFResourceBundle.getString("JobEventBean$ERR_parameterErr"));
            }
            string3 = jFJobEvent.getFlowName();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ":");
            if (stringTokenizer.countTokens() < 3) {
                this.m_flowRbutton.setEnabled(true);
                this.m_flowRbutton.doClick();
                this.m_flowRbutton.setEnabled(this.m_editable);
            } else {
                this.m_subFlowRbutton.setEnabled(true);
                this.m_subFlowRbutton.doClick();
                this.m_subFlowRbutton.setEnabled(this.m_editable);
            }
            int n6 = jFJobEvent.getEventType();
            switch (n6) {
                case 0: {
                    if (jFJobEvent.getComparisonOp() != null) {
                        n = 3;
                        n2 = JFUtility.getIndex(s_op_trans, jFJobEvent.getComparisonOp());
                        string = String.valueOf(jFJobEvent.getComparisonValue());
                        break;
                    }
                    n = 0;
                    break;
                }
                case 3: {
                    if (jFJobEvent.getComparisonOp() != null) {
                        n = 4;
                        n2 = JFUtility.getIndex(s_op_trans, jFJobEvent.getComparisonOp());
                        string = String.valueOf(jFJobEvent.getComparisonValue());
                        break;
                    }
                    n = 1;
                    break;
                }
                case 1: {
                    n = 2;
                    break;
                }
                case 2: {
                    n = 5;
                    n2 = JFUtility.getIndex(s_op_trans, jFJobEvent.getComparisonOp());
                    string = String.valueOf(jFJobEvent.getComparisonValue());
                    break;
                }
                case 10: {
                    n = 6;
                    n2 = JFUtility.getIndex(s_op_trans, jFJobEvent.getComparisonOp());
                    string = String.valueOf(jFJobEvent.getComparisonValue());
                    break;
                }
                case 12: {
                    n = 7;
                    n2 = JFUtility.getIndex(s_op_trans, jFJobEvent.getComparisonOp());
                    string = String.valueOf(jFJobEvent.getComparisonValue());
                    break;
                }
                case 11: {
                    n = 8;
                    n2 = JFUtility.getIndex(s_op_trans, jFJobEvent.getComparisonOp());
                    string = String.valueOf(jFJobEvent.getComparisonValue());
                    break;
                }
                case 13: {
                    n = 9;
                    n2 = JFUtility.getIndex(s_op_trans, jFJobEvent.getComparisonOp());
                    string = String.valueOf(jFJobEvent.getComparisonValue());
                    break;
                }
            }
        } else if (jFEvent instanceof JFFlowExceptionEvent) {
            if (!this.m_submission) {
                throw new Exception(JFResourceBundle.getString("ProxyEventBean$ERR_FlowExceptionEventNotSubmission"));
            }
            jFJobEvent = (JFFlowExceptionEvent)jFEvent;
            JFFlow jFFlow = jFJobEvent.getEventFlow();
            if (jFFlow == null) {
                throw new Exception(JFResourceBundle.getString("ProxyEventBean$ERR_NullExceptionFlow"));
            }
            string3 = jFFlow.getName();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ":");
            if (stringTokenizer.countTokens() >= 3) {
                throw new Exception(JFResourceBundle.getString("ProxyEventBean$ERR_SubFlowExceptionEvent"));
            }
            this.m_flowRbutton.setEnabled(true);
            this.m_flowRbutton.doClick();
            this.m_flowRbutton.setEnabled(this.m_editable);
            int n7 = jFJobEvent.getEventType();
            switch (n7) {
                case 3: {
                    n = 10;
                    string2 = String.valueOf(jFJobEvent.getValue());
                    break;
                }
                case 4: {
                    n = 11;
                    string2 = String.valueOf(jFJobEvent.getValue());
                    break;
                }
                case 0: {
                    n = 12;
                    break;
                }
            }
        } else {
            throw new IllegalArgumentException(JFResourceBundle.getString("JobEventBean$ERR_parameterErr"));
        }
        this.m_eventTypeSelector.setEnabled(true);
        this.m_eventTypeSelector.setSelectedIndex(n);
        this.m_eventTypeSelector.setEnabled(this.m_editable);
        if (n2 != -1) {
            this.m_opSelector.setSelectedIndex(n2);
        }
        if (string != null) {
            this.m_valueFLD.setText(string);
        }
        if (string2 != null) {
            this.m_minuteFLD.setText(string2);
        }
        if (string3 != null) {
            int n8 = string3.indexOf(58);
            if (n8 != -1) {
                this.m_ownerFLD.setText(string3.substring(0, n8));
                this.m_nameFLD.setText(string3.substring(n8 + 1));
            } else {
                this.m_nameFLD.setText(string3);
            }
        }
        this.m_descrFLD.setText(jFEvent.getAttribute("Description"));
        if (jFEvent.getAttribute("TimeDuration") != null && jFEvent.getAttribute("TimeDuration") != "null") {
            this.m_durationFLD.setText(jFEvent.getAttribute("TimeDuration"));
        }
    }

    @Override
    public String getSupportedEventTypeName() {
        return JFResourceBundle.getString("Proxy_Event");
    }

    private void setInputAccessibleInfo() {
        this.m_nameLabel.setLabelFor(this.m_nameFLD);
        this.m_nameFLD.getAccessibleContext().setAccessibleName(this.m_nameLabel.getText());
        this.m_nameFLD.getAccessibleContext().setAccessibleDescription(this.m_nameFLD.getToolTipText());
        this.m_ownerLabel.setLabelFor(this.m_ownerFLD);
        this.m_ownerFLD.getAccessibleContext().setAccessibleName(this.m_ownerLabel.getText());
        this.m_ownerFLD.getAccessibleContext().setAccessibleDescription(this.m_ownerFLD.getToolTipText());
        this.m_durationLabel.setLabelFor(this.m_durationFLD);
        this.m_durationFLD.getAccessibleContext().setAccessibleName(this.m_durationLabel.getText());
        this.m_durationFLD.getAccessibleContext().setAccessibleDescription(this.m_durationFLD.getToolTipText());
        this.m_eventTypeLabel.setLabelFor(this.m_eventTypeSelector);
        this.m_eventTypeSelector.getAccessibleContext().setAccessibleName(this.m_eventTypeLabel.getText());
        this.m_eventTypeSelector.getAccessibleContext().setAccessibleDescription(this.m_eventTypeSelector.getToolTipText());
        this.m_descrLabel.setLabelFor(this.m_descrFLD);
        this.m_descrFLD.getAccessibleContext().setAccessibleName(this.m_descrLabel.getText());
        this.m_descrFLD.getAccessibleContext().setAccessibleDescription(this.m_descrFLD.getToolTipText());
        this.m_minutesText.setLabelFor(this.m_minuteFLD);
        this.m_minuteFLD.getAccessibleContext().setAccessibleName(this.m_minutesText.getText());
        this.m_minuteFLD.getAccessibleContext().setAccessibleDescription(this.m_minuteFLD.getToolTipText());
    }

    private void initComponents() {
        this.m_radioButtonGrp = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.m_jobRbutton = new JRadioButton();
        this.m_arrayRbutton = new JRadioButton();
        this.m_flowRbutton = new JRadioButton();
        this.m_subFlowRbutton = new JRadioButton();
        this.m_flowArrayRbutton = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new TitledBorder(JFResourceBundle.getString("Create_proxy_for...")));
        this.m_radioButtonGrp.add(this.m_jobRbutton);
        this.m_jobRbutton.setText(JFResourceBundle.getString("Job"));
        this.m_jobRbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFProxyEventBean.this.m_jobRbuttonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_jobRbutton, gridBagConstraints);
        this.m_radioButtonGrp.add(this.m_arrayRbutton);
        this.m_arrayRbutton.setText(JFResourceBundle.getString("Job_Array"));
        this.m_arrayRbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFProxyEventBean.this.m_arrayRbuttonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_arrayRbutton, gridBagConstraints);
        this.m_radioButtonGrp.add(this.m_flowRbutton);
        this.m_flowRbutton.setText(JFResourceBundle.getString("Flow"));
        this.m_flowRbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFProxyEventBean.this.m_flowRbuttonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.jPanel1.add((Component)this.m_flowRbutton, gridBagConstraints);
        this.m_radioButtonGrp.add(this.m_subFlowRbutton);
        this.m_subFlowRbutton.setText(JFResourceBundle.getString("Subflow"));
        this.m_subFlowRbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFProxyEventBean.this.m_subFlowRbuttonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_subFlowRbutton, gridBagConstraints);
        this.m_radioButtonGrp.add(this.m_flowArrayRbutton);
        this.m_flowArrayRbutton.setText(JFResourceBundle.getString("Flow_Array"));
        this.m_flowArrayRbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFProxyEventBean.this.m_flowArrayRbuttonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_flowArrayRbutton, gridBagConstraints);
        this.add((Component)this.jPanel1, "North");
        this.jPanel2.setBorder(new TitledBorder(JFResourceBundle.getString("Trigger_event_when...")));
        this.add((Component)this.jPanel2, "Center");
        this.m_eventTypeSelector = new JComboBox();
        this.m_eventTypeSelector.setToolTipText(JFResourceBundle.getString("ProxyEventBean$TIP_eventTypeFLD"));
        this.m_eventTypeSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFProxyEventBean.this.m_eventTypeSelectorActionPerformed(actionEvent);
            }
        });
        this.m_nameLabel = new JLabel();
        this.m_nameLabel.setText(JFResourceBundle.getString("Flow_Array_name_"));
        this.m_nameFLD = new JTextField();
        this.m_nameFLD.setColumns(20);
        this.m_nameFLD.setToolTipText(JFResourceBundle.getString("ProxyEventBean$TIP_nameFLD"));
        this.m_ownerLabel = new JLabel();
        this.m_ownerLabel.setText(JFResourceBundle.getString("Owner_"));
        this.m_ownerFLD = new JTextField();
        this.m_ownerFLD.setColumns(20);
        this.m_ownerFLD.setToolTipText(JFResourceBundle.getString("ProxyEventBean$TIP_ownerFLD"));
        this.m_ownerFLD.setMinimumSize(new Dimension(88, 21));
        this.m_durationLabel = new JLabel();
        this.m_durationLabel.setText(JFResourceBundle.getString("Duration_"));
        this.m_durationFLD = new JTextField();
        this.m_durationFLD.setColumns(20);
        this.m_durationFLD.setToolTipText(JFResourceBundle.getString("ProxyEventBean$TIP_durationFLD"));
        this.m_durationMinutesText = new JLabel();
        this.m_durationMinutesText.setText(JFResourceBundle.getString("minutes"));
        this.m_eventTypeLabel = new JLabel();
        this.m_eventTypeLabel.setText(JFResourceBundle.getString("Event_type_"));
        this.m_opSelector = new JComboBox();
        this.m_valueFLD = new JTextField();
        this.m_valueFLD.setColumns(8);
        this.m_minuteFLD = new JTextField();
        this.m_minuteFLD.setColumns(8);
        this.m_minuteFLD.setMinimumSize(new Dimension(88, 21));
        this.m_minutesText = new JLabel();
        this.m_minutesText.setText(JFResourceBundle.getString("minutes"));
        this.m_descrLabel = new JLabel();
        this.m_descrLabel.setText(JFResourceBundle.getString("Description_"));
        this.m_descScrollPane = new JScrollPane();
        this.m_descScrollPane.setPreferredSize(new Dimension(300, 100));
        GroupLayout groupLayout = new GroupLayout(this.jPanel2);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addContainerGap(46, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.m_nameLabel).addComponent(this.m_durationLabel).addComponent(this.m_eventTypeLabel).addComponent(this.m_descrLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.m_descScrollPane, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.m_minuteFLD, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_minutesText)).addGroup(groupLayout.createSequentialGroup().addComponent(this.m_opSelector, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_valueFLD, -2, 124, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.m_nameFLD, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_ownerLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_ownerFLD, -2, -1, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.m_durationFLD, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_durationMinutesText)).addComponent(this.m_eventTypeSelector, 0, -1, Short.MAX_VALUE)).addGap(45)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_nameLabel).addComponent(this.m_nameFLD, -2, -1, -2).addComponent(this.m_ownerLabel).addComponent(this.m_ownerFLD, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_durationLabel).addComponent(this.m_durationFLD, -2, -1, -2).addComponent(this.m_durationMinutesText)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.m_eventTypeLabel).addComponent(this.m_eventTypeSelector, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_valueFLD, -2, -1, -2).addComponent(this.m_opSelector, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_minutesText).addComponent(this.m_minuteFLD, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.m_descScrollPane, -2, -1, -2).addComponent(this.m_descrLabel)).addContainerGap(216, Short.MAX_VALUE)));
        this.m_descrFLD = new JFDescriptionPane();
        this.m_descScrollPane.setViewportView(this.m_descrFLD);
        this.m_descrFLD.setToolTipText(JFResourceBundle.getString("ProxyEventBean$TIP_descriptionFLD"));
        this.jPanel2.setLayout(groupLayout);
    }

    private void m_flowArrayRbuttonActionPerformed(ActionEvent actionEvent) {
        this.m_eventTypeSelector.setModel(new DefaultComboBoxModel<String>(s_flowArrayTypes));
        this.m_eventTypeSelector.setSelectedIndex(0);
        this.m_nameLabel.setText(JFResourceBundle.getString("Flow_Array_name_"));
        this.m_nameFLD.setToolTipText(JFResourceBundle.getString("ProxyEventBean$TIP_arrayNameFLD"));
        this.m_nameFLD.setText("");
        this.m_nameFLD.requestFocus();
        this.m_nameFLD.getAccessibleContext().setAccessibleName(this.m_nameLabel.getText());
        this.m_nameFLD.getAccessibleContext().setAccessibleDescription(this.m_nameFLD.getToolTipText());
    }

    private void m_flowRbuttonActionPerformed(ActionEvent actionEvent) {
        if (this.m_submission) {
            this.m_eventTypeSelector.setModel(new DefaultComboBoxModel<String>(s_flowTypes));
        } else {
            this.m_eventTypeSelector.setModel(new DefaultComboBoxModel<String>(s_subFlowTypes));
        }
        this.m_eventTypeSelector.setSelectedIndex(0);
        this.m_nameLabel.setText(JFResourceBundle.getString("Flow_name_"));
        this.m_nameFLD.setToolTipText(JFResourceBundle.getString("ProxyEventBean$TIP_flowNameFLD"));
        this.m_nameFLD.setText("");
        this.m_nameFLD.requestFocus();
    }

    private void m_eventTypeSelectorActionPerformed(ActionEvent actionEvent) {
        int n = this.m_eventTypeSelector.getSelectedIndex();
        if (this.m_flowRbutton.isSelected() && (n == 10 || n == 11)) {
            this.m_opSelector.setVisible(false);
            this.m_valueFLD.setVisible(false);
            this.m_minuteFLD.setVisible(true);
            this.m_minutesText.setVisible(true);
            return;
        }
        if (this.m_flowRbutton.isSelected() && n == 12) {
            this.m_opSelector.setVisible(false);
            this.m_valueFLD.setVisible(false);
            this.m_minuteFLD.setVisible(false);
            this.m_minutesText.setVisible(false);
            return;
        }
        this.m_minuteFLD.setVisible(false);
        this.m_minutesText.setVisible(false);
        if (this.m_jobRbutton.isSelected()) {
            if (n == 5) {
                this.m_opSelector.setModel(new DefaultComboBoxModel<String>(s_op2));
                this.m_opSelector.setVisible(true);
                this.m_valueFLD.setVisible(true);
            } else {
                this.m_opSelector.setVisible(false);
                this.m_valueFLD.setVisible(false);
            }
        } else if (this.m_flowRbutton.isSelected() || this.m_subFlowRbutton.isSelected()) {
            if (n < 3) {
                this.m_opSelector.setVisible(false);
                this.m_valueFLD.setVisible(false);
            } else {
                if (n >= 3 && n <= 5) {
                    this.m_opSelector.setModel(new DefaultComboBoxModel<String>(s_op2));
                } else {
                    this.m_opSelector.setModel(new DefaultComboBoxModel<String>(s_op1));
                }
                this.m_opSelector.setVisible(true);
                this.m_valueFLD.setVisible(true);
            }
        } else if (n < 3 || n == 8) {
            this.m_opSelector.setVisible(false);
            this.m_valueFLD.setVisible(false);
        } else {
            if (n == 3) {
                this.m_opSelector.setModel(new DefaultComboBoxModel<String>(s_op2));
            } else {
                this.m_opSelector.setModel(new DefaultComboBoxModel<String>(s_op1));
            }
            this.m_opSelector.setVisible(true);
            this.m_valueFLD.setVisible(true);
        }
    }

    private void m_arrayRbuttonActionPerformed(ActionEvent actionEvent) {
        this.m_eventTypeSelector.setModel(new DefaultComboBoxModel<String>(s_arrayTypes));
        this.m_eventTypeSelector.setSelectedIndex(0);
        this.m_nameLabel.setText(JFResourceBundle.getString("Job_array_name_"));
        this.m_nameFLD.setToolTipText(JFResourceBundle.getString("ProxyEventBean$TIP_arrayNameFLD"));
        this.m_nameFLD.setText("");
        this.m_nameFLD.requestFocus();
        this.m_nameFLD.getAccessibleContext().setAccessibleName(this.m_nameLabel.getText());
        this.m_nameFLD.getAccessibleContext().setAccessibleDescription(this.m_nameFLD.getToolTipText());
    }

    private void m_subFlowRbuttonActionPerformed(ActionEvent actionEvent) {
        this.m_eventTypeSelector.setModel(new DefaultComboBoxModel<String>(s_subFlowTypes));
        this.m_eventTypeSelector.setSelectedIndex(0);
        this.m_nameLabel.setText(JFResourceBundle.getString("Subflow_name") + ":");
        this.m_nameFLD.setToolTipText(JFResourceBundle.getString("ProxyEventBean$TIP_subflowNameFLD"));
        this.m_nameFLD.setText("");
        this.m_nameFLD.requestFocus();
        this.m_nameFLD.getAccessibleContext().setAccessibleName(this.m_nameLabel.getText());
        this.m_nameFLD.getAccessibleContext().setAccessibleDescription(this.m_nameFLD.getToolTipText());
    }

    private void m_jobRbuttonActionPerformed(ActionEvent actionEvent) {
        this.m_eventTypeSelector.setModel(new DefaultComboBoxModel<String>(s_jobTypes));
        this.m_eventTypeSelector.setSelectedIndex(0);
        this.m_nameLabel.setText(JFResourceBundle.getString("Job_name_"));
        this.m_nameFLD.setToolTipText(JFResourceBundle.getString("ProxyEventBean$TIP_nameFLD"));
        this.m_nameFLD.setText("");
        this.m_nameFLD.requestFocus();
        this.m_nameFLD.getAccessibleContext().setAccessibleName(this.m_nameLabel.getText());
        this.m_nameFLD.getAccessibleContext().setAccessibleDescription(this.m_nameFLD.getToolTipText());
    }

    public static void main(String[] stringArray) {
        JDialog jDialog = new JDialog();
        jDialog.getContentPane().setLayout(new BorderLayout());
        JFProxyEventBean jFProxyEventBean = new JFProxyEventBean();
        jDialog.getContentPane().add((Component)jFProxyEventBean, "Center");
        jDialog.pack();
        jDialog.show();
    }
}

