/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.ui.Debug;
import com.platform.LSFJobFlow.ui.JFDiagramPanel;
import com.platform.LSFJobFlow.ui.JFPrintOptionsManager;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.MatteBorder;

public class JFPrintPreviewDialog
extends JDialog {
    PreviewContainer m_previewContainer = new PreviewContainer();
    Printable m_target;
    private int m_wPage = 0;
    private int m_hPage = 0;
    private boolean m_isFixedLayout = false;
    private static final int DEFAULT_SCALE = 75;
    private JToolBar jToolBar1;
    private JButton m_printButton;
    private JComboBox m_scaleSelection;
    private JButton m_closeButton;
    private JScrollPane m_previewScollPane;

    public JFPrintPreviewDialog(Frame frame, Printable printable) {
        super(frame, true);
        this.initComponents();
        this.m_isFixedLayout = printable instanceof JFDiagramPanel;
        this.m_target = printable;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(dimension.width, dimension.height - 30);
        this.printPreview();
        this.getRootPane().setDefaultButton(this.m_closeButton);
    }

    private void printPreview() {
        PageFormat pageFormat = JFPrintOptionsManager.getInstance().getPageFormat();
        if (pageFormat.getHeight() == 0.0 || pageFormat.getWidth() == 0.0) {
            JFUtility.showAppErrorMsg(this, "Unable to determine default page size");
            return;
        }
        this.m_wPage = (int)pageFormat.getWidth();
        this.m_hPage = (int)pageFormat.getHeight();
        int n = 75;
        int n2 = this.m_wPage * n / 100;
        int n3 = this.m_hPage * n / 100;
        int n4 = 0;
        try {
            while (true) {
                BufferedImage bufferedImage = new BufferedImage(this.m_wPage, this.m_hPage, 13);
                Graphics graphics = bufferedImage.getGraphics();
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, this.m_wPage, this.m_hPage);
                if (this.m_target.print(graphics, pageFormat, n4) == 0) {
                    PreviewPage previewPage = new PreviewPage(n2, n3, bufferedImage);
                    this.m_previewContainer.add(previewPage);
                    ++n4;
                    continue;
                }
                break;
            }
        }
        catch (PrinterException printerException) {
            Debug.printStackTrace(printerException);
            JFUtility.showAppErrorMsg(this, "Printing error: " + printerException.toString());
        }
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.m_printButton = new JButton();
        this.m_scaleSelection = new JComboBox();
        this.m_closeButton = new JButton();
        this.m_previewScollPane = new JScrollPane(this.m_previewContainer);
        this.setTitle(JFResourceBundle.getString("Print_Preview"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JFPrintPreviewDialog.this.closeDialog(windowEvent);
            }
        });
        this.jToolBar1.setFloatable(false);
        this.m_printButton.setIcon(new ImageIcon(this.getClass().getResource("/com/platform/LSFJobFlow/ui/resources/print16.gif")));
        this.m_printButton.setToolTipText(JFResourceBundle.getString("Print"));
        this.m_printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFPrintPreviewDialog.this.m_printButtonActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.m_printButton);
        this.m_scaleSelection.setModel(new DefaultComboBoxModel<String>(new String[]{"10%", "25%", "50%", "75%", "100%"}));
        this.m_scaleSelection.setSelectedItem(Integer.toString(75) + "%");
        this.m_scaleSelection.setToolTipText(JFResourceBundle.getString("Zoom"));
        this.m_scaleSelection.setMaximumSize(new Dimension(65, 26));
        this.m_scaleSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFPrintPreviewDialog.this.m_scaleSelectionActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.m_scaleSelection);
        this.m_closeButton.setText(JFResourceBundle.getString("Close"));
        this.m_closeButton.setToolTipText(JFResourceBundle.getString("Close_Preview"));
        this.m_closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFPrintPreviewDialog.this.m_closeButtonActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.m_closeButton);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.getContentPane().add((Component)this.m_previewScollPane, "Center");
        this.pack();
    }

    private void m_scaleSelectionActionPerformed(ActionEvent actionEvent) {
        String string = this.m_scaleSelection.getSelectedItem().toString();
        if (string.endsWith("%")) {
            string = string.substring(0, string.length() - 1).trim();
        }
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        int n2 = this.m_wPage * n / 100;
        int n3 = this.m_hPage * n / 100;
        Component[] componentArray = this.m_previewContainer.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof PreviewPage)) continue;
            PreviewPage previewPage = (PreviewPage)componentArray[i];
            previewPage.setScaledSize(n2, n3);
        }
        this.m_previewContainer.doLayout();
        this.m_previewContainer.getParent().getParent().validate();
    }

    private void m_printButtonActionPerformed(ActionEvent actionEvent) {
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPrintable(this.m_target, JFPrintOptionsManager.getInstance().getPageFormat());
            printerJob.print();
        }
        catch (PrinterException printerException) {
            Debug.printStackTrace(printerException);
        }
        this.setCursor(cursor);
    }

    private void m_closeButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
    }

    class PreviewPage
    extends JPanel {
        protected int m_w;
        protected int m_h;
        protected Image m_source;
        protected Image m_img;

        public PreviewPage(int n, int n2, Image image) {
            this.m_w = n;
            this.m_h = n2;
            this.m_source = image;
            this.m_img = this.m_source.getScaledInstance(this.m_w, this.m_h, 4);
            this.m_img.flush();
            this.setBackground(Color.white);
            this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
        }

        public void setScaledSize(int n, int n2) {
            this.m_w = n;
            this.m_h = n2;
            this.m_img = this.m_source.getScaledInstance(this.m_w, this.m_h, 4);
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            return new Dimension(this.m_w + insets.left + insets.right, this.m_h + insets.top + insets.bottom);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.drawImage(this.m_img, 0, 0, this);
            this.paintBorder(graphics);
        }
    }

    class PreviewContainer
    extends JPanel {
        protected int H_GAP = 16;
        protected int V_GAP = 10;

        PreviewContainer() {
        }

        @Override
        public Dimension getPreferredSize() {
            int n = this.getComponentCount();
            if (n == 0) {
                return new Dimension(this.H_GAP, this.V_GAP);
            }
            Component component = this.getComponent(0);
            Dimension dimension = component.getPreferredSize();
            int n2 = dimension.width;
            int n3 = dimension.height;
            int n4 = 0;
            int n5 = 0;
            if (JFPrintPreviewDialog.this.m_isFixedLayout) {
                n4 = ((JFDiagramPanel)JFPrintPreviewDialog.this.m_target).getPrintColumns();
                n5 = ((JFDiagramPanel)JFPrintPreviewDialog.this.m_target).getPrintRows();
            } else {
                Dimension dimension2 = this.getParent().getSize();
                n4 = Math.max((dimension2.width - this.H_GAP) / (n2 + this.H_GAP), 1);
                n5 = n / n4;
                if (n5 * n4 < n) {
                    ++n5;
                }
            }
            int n6 = n4 * (n2 + this.H_GAP) + this.H_GAP;
            int n7 = n5 * (n3 + this.V_GAP) + this.V_GAP;
            Insets insets = this.getInsets();
            return new Dimension(n6 + insets.left + insets.right, n7 + insets.top + insets.bottom);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void doLayout() {
            Insets insets = this.getInsets();
            int n = insets.left + this.H_GAP;
            int n2 = insets.top + this.V_GAP;
            int n3 = this.getComponentCount();
            if (n3 == 0) {
                return;
            }
            int n4 = 0;
            int n5 = 0;
            Component component = this.getComponent(0);
            Dimension dimension = component.getPreferredSize();
            int n6 = dimension.width;
            int n7 = dimension.height;
            if (JFPrintPreviewDialog.this.m_isFixedLayout) {
                n4 = ((JFDiagramPanel)JFPrintPreviewDialog.this.m_target).getPrintColumns();
                n5 = ((JFDiagramPanel)JFPrintPreviewDialog.this.m_target).getPrintRows();
            } else {
                Dimension dimension2 = this.getParent().getSize();
                n4 = Math.max((dimension2.width - this.H_GAP) / (n6 + this.H_GAP), 1);
                n5 = n3 / n4;
                if (n5 * n4 < n3) {
                    ++n5;
                }
            }
            int n8 = 0;
            for (int i = 0; i < n5; ++i) {
                for (int j = 0; j < n4; ++j) {
                    if (n8 >= n3) {
                        return;
                    }
                    component = this.getComponent(n8++);
                    component.setBounds(n, n2, n6, n7);
                    n += n6 + this.H_GAP;
                }
                n2 += n7 + this.V_GAP;
                n = insets.left + this.H_GAP;
            }
        }
    }
}

