/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFCalendar;
import com.platform.LSFJobFlow.api.JFLoginManager;
import com.platform.LSFJobFlow.api.JFUser;
import com.platform.LSFJobFlow.ui.JFCalendarScreen;
import com.platform.LSFJobFlow.ui.JFDescriptionPane;
import com.platform.LSFJobFlow.ui.JFMessage;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JFMergeCalendar
extends JFCalendarScreen
implements ActionListener,
MouseListener,
CaretListener,
DocumentListener {
    private JList definitionList;
    private JList operatorsList;
    private JList ownerList;
    private JTextField combineField;
    private JFDescriptionPane descriptionField;
    private JButton viewButton;
    private Vector listOfCalendars;
    private Vector data;
    private Vector owner;
    private DefaultListModel ownerListModel;
    private DefaultListModel nameListModel;
    private ActionListener actionListener = null;
    private CaretListener caretListener = null;
    private JFCalendar cal;
    private boolean isNew = false;
    private String m_currentUserName;

    public JFMergeCalendar(JFCalendar jFCalendar, Vector vector, boolean bl) {
        super(bl);
        this.cal = jFCalendar == null ? new JFCalendar("", null, null, null) : jFCalendar;
        this.m_currentUserName = JFLoginManager.getUserName();
        this.listOfCalendars = vector;
        this.initGUI();
        if (!this.getAllowEdit()) {
            this.disableButton();
        }
        this.setDirtyBit(false);
        if (jFCalendar.getExpression() == null || jFCalendar.getExpression().equals("")) {
            this.setNewBit(true);
        }
        this.setOwnerField(jFCalendar.getOwner());
    }

    private void initGUI() {
        String[] stringArray;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JFResourceBundle.getString("Calendar_Description")));
        String string = null;
        if (this.cal.getDescription() != null) {
            string = this.cal.getDescription();
        }
        JLabel jLabel = new JLabel(JFMessage.LABEL_DESCRIPTION, 4);
        this.descriptionField = new JFDescriptionPane();
        this.descriptionField.setXMLdoc(false);
        this.descriptionField.setText(string);
        this.descriptionField.getDocument().addDocumentListener(this);
        this.descriptionField.setToolTipText(JFResourceBundle.getString("CalEditor$TIP_descriptionFLD"));
        JScrollPane jScrollPane = new JScrollPane(this.descriptionField);
        JLabel jLabel2 = new JLabel(JFMessage.LABEL_OWNER);
        this.ownerField = new JTextField(this.cal.getOwner());
        this.ownerField.setToolTipText(JFResourceBundle.getString("CalEditor$TIP_ownerFLD"));
        this.ownerField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                JFMergeCalendar.this.m_owner = JFMergeCalendar.this.ownerField.getText();
                JFMergeCalendar.this.cal.setOwner(JFMergeCalendar.this.m_owner);
            }
        });
        GroupLayout groupLayout = new GroupLayout(jPanel);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(20).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel).addComponent(jLabel2)).addGap(20).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ownerField, -1, 200, Short.MAX_VALUE).addComponent(jScrollPane, -1, 200, Short.MAX_VALUE)).addGap(30)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10).addComponent(jLabel)).addGroup(groupLayout.createSequentialGroup().addGap(10).addComponent(jScrollPane, -1, 60, Short.MAX_VALUE))).addGap(10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.ownerField)).addGap(10)));
        jPanel.setLayout(groupLayout);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)new JLabel(JFMessage.INSTRUCTION), "South");
        JLabel jLabel3 = new JLabel(JFMessage.LABEL_EXISTING);
        JLabel jLabel4 = new JLabel(JFMessage.LABEL_OWNER);
        JLabel jLabel5 = new JLabel(JFMessage.LABEL_OPERATORS);
        JSplitPane jSplitPane = new JSplitPane(1);
        JSplitPane jSplitPane2 = new JSplitPane(1);
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel(new GridLayout(1, 3));
        jPanel3.setLayout(new BorderLayout());
        jPanel4.setLayout(new BorderLayout());
        jPanel5.setLayout(new BorderLayout());
        jPanel3.setBorder(null);
        jPanel4.setBorder(null);
        jPanel5.setBorder(null);
        jPanel3.add((Component)jLabel3, "North");
        jPanel4.add((Component)jLabel4, "North");
        jPanel5.add((Component)jLabel5, "North");
        this.data = new Vector();
        this.owner = new Vector();
        this.ownerListModel = new DefaultListModel();
        this.nameListModel = new DefaultListModel();
        for (int i = 0; i < this.listOfCalendars.size(); ++i) {
            stringArray = (String[])this.listOfCalendars.elementAt(i);
            this.data.add(stringArray.getName());
            this.nameListModel.addElement(stringArray.getName());
            this.ownerListModel.addElement(stringArray.getOwner());
            this.owner.add(stringArray.getOwner());
        }
        this.definitionList = new JList(this.nameListModel);
        this.definitionList.setVisibleRowCount(5);
        this.definitionList.addMouseListener(this);
        jPanel3.add((Component)this.definitionList, "Center");
        this.ownerList = new JList(this.ownerListModel);
        this.ownerList.setVisibleRowCount(5);
        this.ownerList.addMouseListener(this);
        this.ownerList.setEnabled(false);
        jPanel4.add((Component)this.ownerList, "Center");
        jSplitPane2.setLeftComponent(jPanel3);
        jSplitPane2.setRightComponent(jPanel4);
        jSplitPane2.setDividerLocation(300);
        jSplitPane2.setDividerSize(0);
        jSplitPane2.setBorder(null);
        JScrollPane jScrollPane2 = new JScrollPane(jSplitPane2);
        jScrollPane2.getVerticalScrollBar();
        jScrollPane2.setBorder(null);
        stringArray = new String[]{" In common with ", " Plus ", " Not ", " ( ", " ) ", " Not in common with "};
        this.operatorsList = new JList<String>(stringArray);
        this.operatorsList.setVisibleRowCount(5);
        this.operatorsList.addMouseListener(this);
        JScrollPane jScrollPane3 = new JScrollPane(this.operatorsList);
        jScrollPane3.getVerticalScrollBar();
        jScrollPane3.setBorder(null);
        jPanel5.add((Component)jScrollPane3, "Center");
        jSplitPane.setLeftComponent(jScrollPane2);
        jSplitPane.setRightComponent(jPanel5);
        jSplitPane.setDividerLocation(600);
        jSplitPane.setDividerSize(10);
        JPanel jPanel8 = new JPanel(new GridLayout(2, 1));
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        JLabel jLabel6 = new JLabel(JFMessage.LABEL_COMBINE);
        if (this.cal.getExpression().length() < 2) {
            String string2 = this.convertToDisplay(this.cal.getExpression());
            this.combineField = new JTextField(string2, 60);
        } else {
            String string3 = this.convertToDisplay(this.cal.getExpression().substring(1, this.cal.getExpression().length() - 1));
            this.combineField = new JTextField(string3, 60);
        }
        this.combineField.addCaretListener(this);
        jLabel6.setLabelFor(this.combineField);
        this.combineField.getAccessibleContext().setAccessibleName(jLabel6.getText());
        jPanel10.add(this.combineField);
        jPanel10.setBorder(null);
        JScrollPane jScrollPane4 = new JScrollPane(jPanel10);
        jPanel8.add(jLabel6);
        jPanel8.add(jScrollPane4);
        this.add((Component)jPanel2, "North");
        this.add((Component)jSplitPane, "Center");
        this.add((Component)jPanel8, "South");
        jLabel.setLabelFor(this.descriptionField);
        this.descriptionField.getAccessibleContext().setAccessibleName(jLabel.getText());
        this.descriptionField.getAccessibleContext().setAccessibleDescription(this.descriptionField.getToolTipText());
        jLabel6.setLabelFor(this.combineField);
        this.combineField.getAccessibleContext().setAccessibleName(jLabel6.getText());
    }

    private void disableButton() {
        this.descriptionField.setEnabled(false);
        this.descriptionField.setOpaque(false);
        this.definitionList.setEnabled(false);
        this.definitionList.setOpaque(false);
        this.operatorsList.setEnabled(false);
        this.operatorsList.setOpaque(false);
        this.combineField.setEnabled(false);
        this.combineField.setOpaque(false);
    }

    private void enableButton() {
        this.descriptionField.setEnabled(true);
        this.descriptionField.setOpaque(true);
        this.definitionList.setEnabled(true);
        this.definitionList.setOpaque(true);
        this.operatorsList.setEnabled(true);
        this.operatorsList.setOpaque(true);
        this.combineField.setEnabled(true);
        this.combineField.setOpaque(true);
    }

    @Override
    public void deleteCalendarFromList(JFCalendar jFCalendar) {
        for (int i = 0; i < this.nameListModel.size(); ++i) {
            if (!jFCalendar.getName().equals((String)this.nameListModel.elementAt(i)) || !jFCalendar.getOwner().equals((String)this.ownerListModel.elementAt(i))) continue;
            this.nameListModel.removeElementAt(i);
            this.ownerListModel.removeElementAt(i);
        }
    }

    @Override
    public void addCalendarToList(JFCalendar jFCalendar) {
        StringTokenizer stringTokenizer = new StringTokenizer(jFCalendar.getName(), "@");
        String string = stringTokenizer.nextToken();
        this.nameListModel.addElement(string);
        this.ownerListModel.addElement(jFCalendar.getOwner());
    }

    @Override
    public void removeAllCalendar() {
        this.nameListModel.removeAllElements();
        this.ownerListModel.removeAllElements();
    }

    private String convertToExpression(String string) {
        String string2 = this.replaceString(string, " Not in common with ", " &&! ");
        string2 = this.replaceString(string2, " Plus ", " || ");
        string2 = this.replaceString(string2, "Not ", "! ");
        string2 = this.replaceString(string2, " In common with ", " && ");
        return string2;
    }

    private String convertToDisplay(String string) {
        String string2 = this.replaceString(string, "&&!", " Not in common with ");
        string2 = this.replaceString(string2, "&&", " In common with ");
        string2 = this.replaceString(string2, "!", " Not ");
        string2 = this.replaceString(string2, "||", " Plus ");
        return string2;
    }

    private String replaceString(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        if (string2 == null || string2.length() <= 0 || string3 == null) {
            return string;
        }
        int n = string2.length();
        int n2 = string3.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        for (String string4 = string; string4 != null; string4 = string4.substring(n3 + n)) {
            n3 = string4.indexOf(string2);
            if (n3 < 0) {
                stringBuffer.append(string4);
                break;
            }
            stringBuffer.append(string4.substring(0, n3));
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    public String outputExpression() {
        String string = this.convertToExpression(this.combineField.getText().trim());
        return string;
    }

    private boolean isSomethingSelected() {
        String string = this.combineField.getText().trim();
        return !string.equals("");
    }

    @Override
    public JFCalendar getCalendarDef() {
        String string = this.cal.getName();
        String string2 = this.descriptionField.getText().trim();
        String string3 = "";
        string3 = !this.isSomethingSelected() ? "" : "(" + this.outputExpression() + ")";
        String string4 = this.cal.getOwner();
        this.cal = new JFCalendar(string, string3, string4, string2);
        return this.cal;
    }

    @Override
    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public void setCaretListener(CaretListener caretListener) {
        this.caretListener = caretListener;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.getAllowEdit()) {
            return;
        }
        if (mouseEvent.getClickCount() == 2 && (mouseEvent.getModifiers() & 0x10) == 16) {
            if (mouseEvent.getSource() == this.definitionList) {
                this.setDirtyBit(true);
                if (this.actionListener != null) {
                    this.actionListener.actionPerformed(new ActionEvent(this, 0, "internalFrame"));
                }
                String string = new JFUser(this.m_currentUserName).toJSUserName();
                String string2 = (String)this.ownerListModel.elementAt(this.definitionList.getSelectedIndex());
                if (string2 != null) {
                    string2.trim();
                }
                if (string.equals(string2)) {
                    this.combineField.setText(this.combineField.getText() + (String)this.nameListModel.elementAt(this.definitionList.getSelectedIndex()) + " ");
                } else {
                    this.combineField.setText(this.combineField.getText() + (String)this.nameListModel.elementAt(this.definitionList.getSelectedIndex()) + "@" + string2 + " ");
                }
            } else if (mouseEvent.getSource() == this.operatorsList) {
                this.setDirtyBit(true);
                if (this.actionListener != null) {
                    this.actionListener.actionPerformed(new ActionEvent(this, 0, "internalFrame"));
                }
                this.combineField.setText(this.combineField.getText() + this.operatorsList.getSelectedValue() + " ");
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        if (this.getAllowEdit()) {
            if (!this.m_refreshMode) {
                this.setDirtyBit(true);
            }
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 0, "internalFrame"));
            }
        }
    }

    @Override
    public void refresh(JFCalendar jFCalendar) {
        if (this.getDirtyBit()) {
            return;
        }
        this.m_refreshMode = true;
        if (jFCalendar.getExpression().length() < 2) {
            this.combineField.setText(this.convertToDisplay(jFCalendar.getExpression()));
        } else {
            this.combineField.setText(this.convertToDisplay(jFCalendar.getExpression().substring(1, jFCalendar.getExpression().length() - 1)));
        }
        if (jFCalendar.getDescription() != null) {
            this.descriptionField.setText(jFCalendar.getDescription());
        } else {
            this.descriptionField.setText("");
        }
        this.m_refreshMode = false;
    }

    @Override
    public void setAllowEdit(boolean bl) {
        if (this.getAllowEdit() == bl) {
            return;
        }
        super.setAllowEdit(bl);
        if (bl) {
            this.enableButton();
        } else {
            this.disableButton();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (!this.m_refreshMode) {
            this.setDirtyBit(true);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this.m_refreshMode) {
            this.setDirtyBit(true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (!this.m_refreshMode) {
            this.setDirtyBit(true);
        }
    }
}

