/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.ui.JFResourceBundle;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class JFMRUManager {
    private static final int MAX_REC_NUM = 4;
    private static final int MAX_MRU_LEN = 40;
    private JMenu m_fileMenu = null;
    private int m_insertPos;
    private ActionListener m_menuListener = null;
    private String[] m_items = null;
    private int m_curTop = -1;
    private int m_curNum = 0;

    public JFMRUManager(JMenu jMenu, int n, ActionListener actionListener) {
        if (jMenu == null) {
            throw new NullPointerException(JFResourceBundle.getString("parameter_fileMenu_is_null!"));
        }
        this.m_fileMenu = jMenu;
        this.m_insertPos = n;
        this.m_menuListener = actionListener;
        this.m_items = new String[4];
        this.m_curTop = -1;
        this.m_curNum = 0;
    }

    public void addEntry(String string) {
        if (string == null || string.length() <= 0) {
            return;
        }
        int n = this.indexOf(string);
        if (n != -1) {
            JMenuItem jMenuItem;
            if (n == this.m_curTop) {
                return;
            }
            int n2 = n;
            while (true) {
                if (n2 == this.m_curTop) break;
                this.m_items[n2] = this.m_items[(n2 + 1) % 4];
                n2 = (n2 + 1) % 4;
            }
            this.m_items[n2] = string;
            int n3 = (this.m_curTop + 4 - n) % 4 + 1;
            for (int i = 0; i < n3 - 1; ++i) {
                jMenuItem = this.m_fileMenu.getItem(this.m_insertPos + i);
                if (jMenuItem == null || jMenuItem.getText() == null) continue;
                String string2 = jMenuItem.getText();
                String string3 = String.valueOf(i + 2);
                jMenuItem.setText(string3 + string2.substring(1));
                jMenuItem.setMnemonic(string3.charAt(0));
            }
            jMenuItem = this.m_fileMenu.getItem(this.m_insertPos + n3 - 1);
            if (jMenuItem != null) {
                jMenuItem.setText("1" + jMenuItem.getText().substring(1));
                jMenuItem.setMnemonic('1');
                this.m_fileMenu.remove(jMenuItem);
                this.m_fileMenu.insert(jMenuItem, this.m_insertPos);
            }
        } else {
            if (this.m_curNum < 4) {
                ++this.m_curNum;
            } else {
                this.m_fileMenu.remove(this.m_insertPos + 4 - 1);
            }
            ++this.m_curTop;
            this.m_curTop %= 4;
            this.m_items[this.m_curTop] = string;
            JMenuItem jMenuItem = new JMenuItem("1 " + this.createMRUname(string));
            jMenuItem.setActionCommand(string);
            jMenuItem.setMnemonic('1');
            jMenuItem.addActionListener(this.m_menuListener);
            this.m_fileMenu.add((Component)jMenuItem, this.m_insertPos);
            for (int i = 1; i < this.m_curNum; ++i) {
                jMenuItem = this.m_fileMenu.getItem(this.m_insertPos + i);
                if (jMenuItem == null || jMenuItem.getText() == null) continue;
                String string4 = jMenuItem.getText();
                String string5 = String.valueOf(i + 1);
                jMenuItem.setText(string5 + string4.substring(1));
                jMenuItem.setMnemonic(string5.charAt(0));
            }
        }
    }

    public void loadEntries(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.addEntry(stringTokenizer.nextToken());
        }
    }

    public String serializeEntries() {
        if (this.m_curTop == -1) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_curNum; ++i) {
            int n = this.m_curNum < 4 ? i : (this.m_curTop + i + 1) % 4;
            stringBuffer.append(this.m_items[n]);
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    private String createMRUname(String string) {
        if (string == null || string.length() <= 40) {
            return string;
        }
        int n = string.length() - 40;
        return string.substring(0, 10) + "..." + string.substring(10 + n);
    }

    private int indexOf(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < 4; ++i) {
            if (!string.equals(this.m_items[i])) continue;
            return i;
        }
        return -1;
    }
}

