/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFAdminManager;
import com.platform.LSFJobFlow.api.JFCommon;
import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFLoginManager;
import com.platform.LSFJobFlow.api.JFUser;
import com.platform.LSFJobFlow.api.JFUserGroup;
import com.platform.LSFJobFlow.ui.JFCommandModifyDialog;
import com.platform.LSFJobFlow.ui.JFDescriptionPane;
import com.platform.LSFJobFlow.ui.JFJobEnvVarsDialog;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFStandardOutputBean;
import com.platform.LSFJobFlow.ui.JFUtility;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class JFLocalJobDefinitionBean
extends JPanel {
    private static final int DESCFIELDWIDTH = 430;
    private static final int DESCFIELDHEIGHT = 200;
    private static final Dimension DESCDIMENSION = new Dimension(430, 200);
    private JFJobEnvVarsDialog envVarsDialog;
    private static JFCommandModifyDialog cmdModifyDialog = null;
    BeanInputVerifier beanInputVerifier = null;
    private String m_currentUserName;
    private boolean m_isJFAdmin = false;
    private boolean m_isGroupAdmin = false;
    private boolean m_isLimitGroupFlowOwner = false;
    private List<JFUserGroup> m_lsfUserGroups = null;
    private String jobOwner = null;
    private JTextField cmdLineFLD;
    private JLabel cmdLineLabel;
    private JButton cmdModifyButton;
    private JFDescriptionPane descriptionPane;
    private JCheckBox disableSuspendCheckBox;
    private JTextField envVarsFLD;
    private JLabel envVarsLabel;
    private JFStandardOutputBean jFStandardOutputBean;
    private JScrollPane jScrollPane1;
    private JTextField jobNameFLD;
    private JLabel jobNameLabel;
    private JPanel jobPanel;
    private JPanel m_descriptionPanel;
    private JButton m_envVarsModifyButton;
    private JPanel m_runAsPanel;
    private JTextField nonZeroCodesFLD;
    private JLabel nonZeroCodesLabel;
    private JTextField userNameFLD;
    private JLabel userNameLabel;
    private JTextField workingDirFLD;
    private JLabel workingDirLabel;

    public JFLocalJobDefinitionBean() {
        this.initComponents();
        this.beanInputVerifier = new BeanInputVerifier();
        this.nonZeroCodesFLD.setInputVerifier(this.beanInputVerifier);
        this.m_currentUserName = JFLoginManager.getUserName();
        try {
            JFAdminManager jFAdminManager = new JFAdminManager();
            HashMap hashMap = jFAdminManager.getServerInfo();
            if (((String)hashMap.get("SERVER_TYPE")).equals("WIN32")) {
                this.disableSuspendCheckBox.setVisible(false);
            } else {
                this.disableSuspendCheckBox.setVisible(true);
            }
        }
        catch (Exception exception) {
            this.disableSuspendCheckBox.setVisible(true);
        }
        this.jFStandardOutputBean.showFieldsForJob();
    }

    private static final Dimension getDESCDIMENSION() {
        return DESCDIMENSION;
    }

    private void initComponents() {
        this.jobPanel = new JPanel();
        this.jobNameLabel = new JLabel();
        this.cmdLineLabel = new JLabel();
        this.cmdLineFLD = new JTextField();
        this.cmdModifyButton = new JButton();
        this.jobNameFLD = new JTextField();
        this.workingDirLabel = new JLabel();
        this.workingDirFLD = new JTextField();
        this.envVarsLabel = new JLabel();
        this.envVarsFLD = new JTextField();
        this.m_envVarsModifyButton = new JButton();
        this.nonZeroCodesLabel = new JLabel();
        this.nonZeroCodesFLD = new JTextField();
        this.disableSuspendCheckBox = new JCheckBox();
        this.jFStandardOutputBean = new JFStandardOutputBean();
        this.m_runAsPanel = new JPanel();
        this.userNameLabel = new JLabel();
        this.userNameFLD = new JTextField();
        this.m_descriptionPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.descriptionPane = new JFDescriptionPane();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        this.jobPanel.setBorder(BorderFactory.createTitledBorder(JFResourceBundle.getString("Define_the_Job")));
        this.jobPanel.setMinimumSize(new Dimension(265, 199));
        this.jobPanel.setPreferredSize(new Dimension(864, 219));
        this.jobPanel.setRequestFocusEnabled(false);
        this.jobPanel.setLayout(new GridBagLayout());
        this.jobNameLabel.setText(JFResourceBundle.getString("Name_"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.jobNameLabel, gridBagConstraints);
        this.cmdLineLabel.setText(JFResourceBundle.getString("Command_to_run_"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.cmdLineLabel, gridBagConstraints);
        this.cmdLineFLD.setColumns(20);
        this.cmdLineFLD.setToolTipText(JFResourceBundle.getString("JobDefinitionBean$TIP_cmdLineFLD"));
        this.cmdLineFLD.setMinimumSize(new Dimension(430, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.cmdLineFLD, gridBagConstraints);
        this.cmdModifyButton.setText(JFResourceBundle.getString("Modify..."));
        this.cmdModifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFLocalJobDefinitionBean.this.cmdModifyButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.cmdModifyButton, gridBagConstraints);
        this.jobNameFLD.setColumns(20);
        this.jobNameFLD.setToolTipText(JFResourceBundle.getString("JobDefinitionBean$TIP_jobNameFLD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.jobNameFLD, gridBagConstraints);
        this.workingDirLabel.setText(JFResourceBundle.getString("Working_directory"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.workingDirLabel, gridBagConstraints);
        this.workingDirFLD.setColumns(20);
        this.workingDirFLD.setToolTipText(JFResourceBundle.getString("JobDefinitionBean$TIP_workingDirFLD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.workingDirFLD, gridBagConstraints);
        this.envVarsLabel.setText(JFResourceBundle.getString("Environment_Variables"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.envVarsLabel, gridBagConstraints);
        this.envVarsFLD.setEditable(false);
        this.envVarsFLD.setToolTipText(JFResourceBundle.getString("JobDefinitionBean$TIP_envVarsFLD"));
        this.envVarsFLD.setMinimumSize(new Dimension(430, 20));
        this.envVarsFLD.setPreferredSize(new Dimension(430, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.envVarsFLD, gridBagConstraints);
        this.m_envVarsModifyButton.setText(JFResourceBundle.getString("Modify..."));
        this.m_envVarsModifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFLocalJobDefinitionBean.this.m_envVarsModifyButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.m_envVarsModifyButton, gridBagConstraints);
        this.nonZeroCodesLabel.setText(JFResourceBundle.getString("Non_zero_exit_codes_"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.nonZeroCodesLabel, gridBagConstraints);
        this.nonZeroCodesFLD.setColumns(20);
        this.nonZeroCodesFLD.setToolTipText(JFResourceBundle.getString("JobDefinitionBean$TIP_nonZeroCodesFLD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.nonZeroCodesFLD, gridBagConstraints);
        this.disableSuspendCheckBox.setText(JFResourceBundle.getString("Local_job_disable_suspension_"));
        this.disableSuspendCheckBox.setToolTipText(JFResourceBundle.getString("JobDefinitionBean$TIP_disableSuspend"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.disableSuspendCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.jobPanel, gridBagConstraints);
        this.jFStandardOutputBean.setMinimumSize(new Dimension(810, 210));
        this.jFStandardOutputBean.setPreferredSize(new Dimension(810, 210));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.jFStandardOutputBean, gridBagConstraints);
        this.m_runAsPanel.setBorder(BorderFactory.createTitledBorder(JFResourceBundle.getString("Run_As")));
        this.userNameLabel.setText(JFResourceBundle.getString("User_name_"));
        this.m_runAsPanel.add(this.userNameLabel);
        this.userNameFLD.setToolTipText(JFResourceBundle.getString("JobDefinitionBean$TIP_usernameFLD"));
        this.userNameFLD.setPreferredSize(new Dimension(400, 21));
        this.m_runAsPanel.add(this.userNameFLD);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.m_runAsPanel, gridBagConstraints);
        this.m_descriptionPanel.setBorder(BorderFactory.createTitledBorder(JFResourceBundle.getString("Enter_Description_")));
        this.m_descriptionPanel.setLayout(new GridBagLayout());
        this.jScrollPane1.setPreferredSize(JFLocalJobDefinitionBean.getDESCDIMENSION());
        this.descriptionPane.setToolTipText(JFResourceBundle.getString("JobDefinitionBean$TIP_descriptionFLD"));
        this.descriptionPane.setPreferredSize(JFLocalJobDefinitionBean.getDESCDIMENSION());
        this.jScrollPane1.setViewportView(this.descriptionPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.m_descriptionPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.m_descriptionPanel, gridBagConstraints);
    }

    private void cmdModifyButtonActionPerformed(ActionEvent actionEvent) {
        cmdModifyDialog = new JFCommandModifyDialog((Frame)this.getMainFrame(), true);
        cmdModifyDialog.setCmdFieldText(this.cmdLineFLD.getText());
        cmdModifyDialog.setLocationRelativeTo(this);
        cmdModifyDialog.setTitle(JFResourceBundle.getString("CommandModifyDialog$TITLE"));
        cmdModifyDialog.setVisible(true);
        String string = cmdModifyDialog.getCmdFieldText();
        if (string != null) {
            string = string.replaceAll("\r", " ");
            string = string.replaceAll("\n", " ");
            this.cmdLineFLD.setText(string);
        }
    }

    private void m_envVarsModifyButtonActionPerformed(ActionEvent actionEvent) {
        this.envVarsDialog = new JFJobEnvVarsDialog(this.getMainFrame(), true);
        this.envVarsDialog.setVarList(this.envVarsFLD.getText());
        this.envVarsDialog.setLocationRelativeTo(this);
        this.envVarsDialog.setTitle(JFResourceBundle.getString("JobDefinitionBean$TITLE_envVarsDialog"));
        this.envVarsDialog.setVisible(true);
        String string = this.envVarsDialog.getVarList();
        if (string != null) {
            this.envVarsFLD.setText(string);
        }
    }

    JFrame getMainFrame() {
        JFrame jFrame = null;
        if (jFrame == null) {
            for (Container container = this.getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof JFrame)) continue;
                jFrame = (JFrame)container;
                break;
            }
        }
        return jFrame;
    }

    void setEditable(boolean bl) {
        this.cmdLineFLD.setEditable(bl);
        this.jobNameFLD.setEditable(bl);
        this.cmdModifyButton.setEnabled(bl);
        this.m_envVarsModifyButton.setEnabled(bl);
        this.userNameFLD.setEditable(bl);
        this.workingDirFLD.setEditable(bl);
        this.nonZeroCodesFLD.setEditable(bl);
        this.descriptionPane.setEditable(bl);
        this.disableSuspendCheckBox.setEnabled(bl);
        this.jFStandardOutputBean.setEditable(bl);
    }

    public void setJFAdmin(boolean bl) {
        this.m_isJFAdmin = bl;
    }

    public void setLSFUserGroups(List<JFUserGroup> list) {
        this.m_lsfUserGroups = list;
        this.m_isGroupAdmin = this.m_lsfUserGroups != null && this.m_lsfUserGroups.size() > 0;
        if (this.m_isGroupAdmin) {
            JFAdminManager jFAdminManager = null;
            try {
                jFAdminManager = new JFAdminManager();
                this.m_isLimitGroupFlowOwner = jFAdminManager.isLimitGroupFlowOwnerCached();
            }
            catch (Exception exception) {
                this.m_isLimitGroupFlowOwner = false;
            }
        }
    }

    void populateFieldsForJob(JFJob jFJob) {
        this.EmptyFields();
        this.jobNameFLD.setText(jFJob.getName());
        Properties properties = jFJob.getAttributes();
        if (properties == null || properties.size() <= 0) {
            return;
        }
        this.initBeanFields(properties);
        this.jFStandardOutputBean.populateFieldsForJob(jFJob, 1);
    }

    private void initBeanFields(Properties properties) {
        if (properties == null || properties.size() <= 0) {
            return;
        }
        this.cmdLineFLD.setText(properties.getProperty("JobCmdLine", ""));
        if (this.jobOwner != null) {
            this.userNameFLD.setText(this.jobOwner);
        } else {
            this.userNameFLD.setText(properties.getProperty("UserName", ""));
        }
        this.workingDirFLD.setText(properties.getProperty("WorkingDirectory", ""));
        this.nonZeroCodesFLD.setText(properties.getProperty("NonZeroSuccessExitCodes", ""));
        this.descriptionPane.setText(properties.getProperty("Description", ""));
        if (JFCommon.checkEnvVars((String)properties.getProperty("JobEnvVars", ""))) {
            this.envVarsFLD.setText(properties.getProperty("JobEnvVars", ""));
        } else {
            JFUtility.showAppErrorMsg(this, JFResourceBundle.getString("JFEnvVarsDialog$ERR_badVarLoad"));
        }
        if (properties.getProperty("DisableSuspend", "No").equals("Yes")) {
            this.disableSuspendCheckBox.setSelected(true);
        } else {
            this.disableSuspendCheckBox.setSelected(false);
        }
    }

    private void EmptyFields() {
        this.cmdLineFLD.setText("");
        this.envVarsFLD.setText("");
        this.jobNameFLD.setText("");
        this.descriptionPane.setText("");
        this.userNameFLD.setText("");
        this.workingDirFLD.setText("");
        this.nonZeroCodesFLD.setText("");
    }

    boolean fieldsMatchJob(JFJob jFJob) {
        boolean bl = this.jobNameFLD.getText().equals(jFJob.getName());
        Properties properties = jFJob.getAttributes();
        boolean bl2 = bl = bl && this.cmdLineFLD.getText().equals(properties.getProperty("JobCmdLine")) && this.userNameFLD.getText().equals(properties.getProperty("UserName")) && this.workingDirFLD.getText().equals(properties.getProperty("WorkingDirectory")) && this.nonZeroCodesFLD.getText().equals(properties.getProperty("NonZeroSuccessExitCodes")) && this.descriptionPane.getText().equals(properties.getProperty("Description")) && this.envVarsFLD.getText().equals(properties.getProperty("JobEnvVars"));
        if (jFJob.getExecutionType().equals("local")) {
            bl = bl && this.disableSuspendCheckBox.isSelected() == jFJob.getAttribute("DisableSuspend").equals("Yes");
        }
        bl = bl && this.jFStandardOutputBean.fieldsMatchJob(jFJob);
        return bl;
    }

    void updateJobFromFields(JFJob jFJob) throws Exception {
        if (this.fieldsMatchJob(jFJob)) {
            return;
        }
        if (this.jobNameFLD.getText() == null || this.jobNameFLD.getText().trim().length() <= 0) {
            throw new Exception(JFResourceBundle.getString("JobDefinitionBean$ERR_jobNameInvalid"));
        }
        if (!JFUtility.isValidJobFlowIdentity(this.jobNameFLD.getText(), true)) {
            throw new Exception(JFResourceBundle.getString("JobDefinitionBean$ERR_jobNameInvalid"));
        }
        if (this.cmdLineFLD.getText() == null || this.cmdLineFLD.getText().trim().length() <= 0) {
            throw new Exception(JFResourceBundle.getString("JobDefinitionBean$ERR_cmdLineInvalid"));
        }
        if (!this.m_isJFAdmin && this.m_isGroupAdmin) {
            Cloneable cloneable;
            Object[] objectArray;
            boolean bl = true;
            String string = this.userNameFLD.getText().trim();
            JFUser jFUser = new JFUser(string);
            JFUser jFUser2 = new JFUser("all");
            int n = string.indexOf("#{");
            if (n != -1) {
                bl = false;
            }
            if (bl && !this.m_isLimitGroupFlowOwner && jFUser.equals((JFUser)(objectArray = new JFUser(this.m_currentUserName)))) {
                bl = false;
            }
            if (bl) {
                for (Object object : this.m_lsfUserGroups) {
                    cloneable = object.getGroupMembers();
                    if (cloneable != null && ((HashSet)cloneable).contains(jFUser)) {
                        bl = false;
                        break;
                    }
                    if (cloneable == null || !((HashSet)cloneable).contains(jFUser2)) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                Object object;
                objectArray = new Object[]{string};
                object = JFResourceBundle.getString("JobDefinitionBean$ERR_NotAdminOrGroupAdmin");
                cloneable = new MessageFormat((String)object);
                throw new Exception(((Format)cloneable).format(objectArray));
            }
        }
        jFJob.setName(this.jobNameFLD.getText());
        jFJob.setAttribute("JobCmdLine", this.cmdLineFLD.getText());
        jFJob.setAttribute("WorkingDirectory", this.workingDirFLD.getText());
        jFJob.setAttribute("NonZeroSuccessExitCodes", this.nonZeroCodesFLD.getText());
        jFJob.setAttribute("UserName", this.userNameFLD.getText());
        jFJob.setAttribute("Description", this.descriptionPane.getText());
        jFJob.setAttribute("JobEnvVars", this.envVarsFLD.getText());
        if (jFJob.getExecutionType().equals("local")) {
            if (this.disableSuspendCheckBox.isSelected()) {
                jFJob.setAttribute("DisableSuspend", "Yes");
            } else {
                jFJob.setAttribute("DisableSuspend", "No");
            }
        }
        if (this.jFStandardOutputBean != null) {
            if (this.jFStandardOutputBean.getStdoutCreate()) {
                jFJob.setAttribute("CreateStdout", "Yes");
                jFJob.setAttribute("Stdout", this.jFStandardOutputBean.getStdoutFile());
            } else {
                jFJob.setAttribute("CreateStdout", "No");
                jFJob.setAttribute("Stdout", "");
            }
            if (this.jFStandardOutputBean.getStdoutOverrideCheckbox()) {
                jFJob.setAttribute("StdoutOverride", "Yes");
            } else {
                jFJob.setAttribute("StdoutOverride", "No");
            }
            if (this.jFStandardOutputBean.getStderrCreate()) {
                jFJob.setAttribute("CreateStderr", "Yes");
                jFJob.setAttribute("Stderr", this.jFStandardOutputBean.getStderrFile());
            } else {
                jFJob.setAttribute("CreateStderr", "No");
                jFJob.setAttribute("Stderr", "");
            }
            if (this.jFStandardOutputBean.getStderrOverrideCheckbox()) {
                jFJob.setAttribute("StderrOverride", "Yes");
            } else {
                jFJob.setAttribute("StderrOverride", "No");
            }
        }
        jFJob.validate();
        if (!this.jFStandardOutputBean.hasValidFields(false)) {
            throw new Exception(JFResourceBundle.getString("JobDefinitionBean$ERR_noJobDefErr"));
        }
    }

    public void setJobOwner(String string) {
        this.jobOwner = string;
    }

    class BeanInputVerifier
    extends InputVerifier {
        BeanInputVerifier() {
        }

        @Override
        public boolean verify(JComponent jComponent) {
            if (jComponent == JFLocalJobDefinitionBean.this.nonZeroCodesFLD) {
                return JFUtility.verifyNonZeroCodes((JTextField)jComponent);
            }
            return true;
        }
    }
}

