/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFFlowVersion;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class JFFlowVersionListDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Object[] columnNames = new Object[]{JFResourceBundle.getString("COLUM_TITLE_Version"), JFResourceBundle.getString("COLUM_TITLE_SubmissionUser"), JFResourceBundle.getString("COLUM_TITLE_SubmissionTime"), JFResourceBundle.getString("COLUM_TITLE_Comments")};
    private JTable flowVersionTable;
    private String defaultVersion = JFResourceBundle.getString("Unavailable");
    private String latestVersion = JFResourceBundle.getString("Unavailable");
    private Object[][] rowData;
    private int rowIndex = -1;
    private int selectedIndex = 0;

    public JFFlowVersionListDialog(Frame frame, List<JFFlowVersion> list, String string) {
        super(frame, true);
        this.defaultVersion = string;
        this.rowData = new Object[list.size()][4];
        this.latestVersion = "1.0";
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i).getVersion();
            if (string2.equals(string)) {
                this.selectedIndex = i;
            }
            if (i == 0) {
                this.latestVersion = string2;
            }
            this.rowData[i][0] = string2;
            this.rowData[i][1] = list.get(i).getSubmissionUser().toJSUserName();
            this.rowData[i][2] = list.get(i).getSubmissionTime().getTimeString();
            this.rowData[i][3] = list.get(i).getComments();
        }
        this.initComponents();
    }

    public int getSelectedRow() {
        return this.rowIndex;
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.rowIndex = this.flowVersionTable.getSelectedRow();
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void initComponents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 10, 0));
        jPanel.add((Component)new JLabel(JFResourceBundle.getString("Default_Version") + this.defaultVersion), "North");
        jPanel.add((Component)new JLabel(JFResourceBundle.getString("Latest_Version") + this.latestVersion), "South");
        this.flowVersionTable = new JTable(this.rowData, columnNames){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.flowVersionTable.setRowHeight(30);
        this.flowVersionTable.setRowMargin(5);
        this.flowVersionTable.setRowSelectionAllowed(true);
        this.flowVersionTable.setSelectionMode(0);
        this.flowVersionTable.setSelectionBackground(Color.LIGHT_GRAY);
        this.flowVersionTable.setGridColor(Color.black);
        this.flowVersionTable.setRowSelectionInterval(this.selectedIndex, this.selectedIndex);
        this.flowVersionTable.setShowHorizontalLines(true);
        this.flowVersionTable.setShowVerticalLines(true);
        this.flowVersionTable.doLayout();
        this.flowVersionTable.setBackground(Color.WHITE);
        JScrollPane jScrollPane = new JScrollPane(this.flowVersionTable);
        jScrollPane.setPreferredSize(new Dimension(600, 141));
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(JFResourceBundle.getString("Save"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFFlowVersionListDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        JButton jButton2 = new JButton(JFResourceBundle.getString("BUTTON_CANCEL"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFFlowVersionListDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder(2, 5, 5, 0));
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add(jScrollPane);
        jPanel3.add((Component)jPanel2, "South");
        this.add(jPanel3);
        this.setTitle(JFResourceBundle.getString("TITLE_selectAFlowVersion"));
        this.pack();
    }
}

