/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFCalendar;
import com.platform.LSFJobFlow.ui.JFCalendarScreen;
import com.platform.LSFJobFlow.ui.JFDescriptionPane;
import com.platform.LSFJobFlow.ui.JFMessage;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class JFDateCalendar
extends JFCalendarScreen
implements ActionListener,
CaretListener,
DocumentListener {
    private static final String[] monthStr = JFMessage.MONTH;
    private static final String[] weekdayStr = JFMessage.DAY_OF_WEEK;
    private static final String[] translateMonthToNumber = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"};
    private static final Color SELECTED_TEXT_COLOR = Color.white;
    private static final Color UNSELECTED_TEXT_COLOR = Color.black;
    private static final Color SELECTED_BACKGROUND_COLOR = Color.lightGray;
    private static final Color UNSELECTED_BACKGROUND_COLOR = Color.white;
    private JToggleButton[][] daysButton;
    private JPanel[] monthPanels;
    private JFDescriptionPane descriptionField;
    private JLabel ownerLabel;
    private JButton forward;
    private JButton backward;
    private Calendar showDate;
    private String m_name;
    private Vector m_selectedDates = new Vector();
    private ActionListener actionListener = null;
    private Calendar today = Calendar.getInstance();
    private JFCalendar m_cal;
    private boolean m_descrFldIgnoreChange;

    public JFDateCalendar(JFCalendar jFCalendar, boolean bl) {
        super(bl);
        this.m_cal = jFCalendar;
        this.init();
        this.showDate = Calendar.getInstance();
        if (!this.getAllowEdit()) {
            this.disableCalendar();
        }
        if (jFCalendar.getExpression() == null || jFCalendar.getExpression().equals("")) {
            this.setNewBit(true);
        }
        this.refresh(jFCalendar);
        this.setOwnerField(jFCalendar.getOwner());
    }

    private void init() {
        int n;
        int n2;
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JFResourceBundle.getString("Calendar_Description")));
        JLabel jLabel = new JLabel(JFMessage.LABEL_DESCRIPTION);
        this.descriptionField = new JFDescriptionPane();
        this.descriptionField.setXMLdoc(false);
        this.descriptionField.getDocument().addDocumentListener(this);
        this.descriptionField.setToolTipText(JFResourceBundle.getString("CalEditor$TIP_descriptionFLD"));
        JScrollPane jScrollPane = new JScrollPane(this.descriptionField);
        jLabel.setLabelFor(this.descriptionField);
        this.descriptionField.getAccessibleContext().setAccessibleName(jLabel.getText());
        this.descriptionField.getAccessibleContext().setAccessibleDescription(this.descriptionField.getToolTipText());
        this.ownerLabel = new JLabel(JFMessage.LABEL_OWNER);
        this.ownerField = new JTextField(this.m_cal.getOwner());
        this.ownerField.setToolTipText(JFResourceBundle.getString("CalEditor$TIP_ownerFLD"));
        this.ownerField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                JFDateCalendar.this.m_owner = JFDateCalendar.this.ownerField.getText();
                JFDateCalendar.this.m_cal.setOwner(JFDateCalendar.this.m_owner);
            }
        });
        GroupLayout groupLayout = new GroupLayout(jPanel);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(20).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel).addComponent(this.ownerLabel)).addGap(20).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ownerField, -1, 200, Short.MAX_VALUE).addComponent(jScrollPane, -1, 200, Short.MAX_VALUE)).addGap(30)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10).addComponent(jLabel)).addGroup(groupLayout.createSequentialGroup().addGap(10).addComponent(jScrollPane, -1, 60, Short.MAX_VALUE))).addGap(10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ownerLabel).addComponent(this.ownerField)).addGap(10)));
        jPanel.setLayout(groupLayout);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 3));
        this.monthPanels = new JPanel[6];
        for (n2 = 0; n2 < 6; ++n2) {
            this.monthPanels[n2] = new JPanel();
            this.monthPanels[n2].setLayout(new GridLayout(7, 7));
        }
        this.daysButton = new JToggleButton[6][42];
        for (n2 = 0; n2 < 6; ++n2) {
            for (n = 0; n < 7; ++n) {
                this.monthPanels[n2].add(new JLabel(weekdayStr[n]));
            }
            for (n = 0; n < 42; ++n) {
                this.daysButton[n2][n] = new JToggleButton();
                this.daysButton[n2][n].setForeground(UNSELECTED_TEXT_COLOR);
                this.daysButton[n2][n].setBackground(UNSELECTED_BACKGROUND_COLOR);
                this.daysButton[n2][n].setBorder(null);
                this.daysButton[n2][n].setVisible(true);
                this.daysButton[n2][n].setEnabled(false);
                this.daysButton[n2][n].setMargin(new Insets(0, 0, 0, 0));
                this.daysButton[n2][n].addActionListener(this);
                this.monthPanels[n2].add(this.daysButton[n2][n]);
            }
        }
        JScrollPane[] jScrollPaneArray = new JScrollPane[6];
        for (n = 0; n < 6; ++n) {
            jScrollPaneArray[n] = new JScrollPane(this.monthPanels[n]);
            jScrollPaneArray[n].setBorder(null);
            jPanel2.add(jScrollPaneArray[n]);
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        this.backward = new JButton(JFMessage.BACKWARD);
        this.forward = new JButton(JFMessage.FORWARD);
        this.forward.setMnemonic(70);
        this.forward.addActionListener(this);
        this.backward.setMnemonic(66);
        this.backward.addActionListener(this);
        jPanel3.add(this.backward);
        jPanel3.add(this.forward);
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel3, "South");
        this.add((Component)jPanel2, "Center");
    }

    private void initCalendar(Calendar calendar) {
        int n = calendar.get(2) / 6 * 6;
        int n2 = calendar.get(1);
        int n3 = calendar.get(7);
        for (int i = 0; i < 6; ++i) {
            this.monthPanels[i].setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), monthStr[n + i] + ", " + n2));
            calendar.set(5, 1);
            calendar.set(2, n + i);
            n3 = calendar.get(7) - 1;
            for (int j = 0; j < calendar.getActualMaximum(5); ++j) {
                calendar.set(5, j + 1);
                this.daysButton[i][n3 + j].setText(String.valueOf(j + 1));
                this.daysButton[i][n3 + j].setToolTipText(translateMonthToNumber[n + i] + "/" + String.valueOf(j + 1) + "/" + String.valueOf(n2));
                if (calendar.get(1) == this.today.get(1) && calendar.get(2) == this.today.get(2) && calendar.get(5) == this.today.get(5)) {
                    this.daysButton[i][n3 + j].setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.red));
                }
                if (this.compareCalendar(this.today, calendar)) {
                    if (!this.getAllowEdit()) continue;
                    this.daysButton[i][n3 + j].setEnabled(true);
                    continue;
                }
                this.daysButton[i][n3 + j].setEnabled(false);
            }
        }
    }

    private boolean compareCalendar(Calendar calendar, Calendar calendar2) {
        if (calendar.get(1) < calendar2.get(1)) {
            return true;
        }
        if (calendar.get(1) > calendar2.get(1)) {
            return false;
        }
        if (calendar.get(2) < calendar2.get(2)) {
            return true;
        }
        if (calendar.get(2) > calendar2.get(2)) {
            return false;
        }
        return calendar.get(5) <= calendar2.get(5);
    }

    public Calendar getShowDate() {
        return this.showDate;
    }

    protected void setSelectedDates(Vector vector) {
        this.m_selectedDates.clear();
        for (Object e : vector) {
            if (this.m_selectedDates.contains(e)) continue;
            this.m_selectedDates.add(e);
        }
    }

    protected abstract void setSelectedDates(String var1);

    protected Vector getSelectedDates() {
        return this.m_selectedDates;
    }

    protected abstract String getExpression();

    @Override
    public void refresh(JFCalendar jFCalendar) {
        if (this.getDirtyBit()) {
            return;
        }
        this.m_refreshMode = true;
        this.setSelectedDates(jFCalendar.getExpression());
        this.m_descrFldIgnoreChange = true;
        this.descriptionField.setText(jFCalendar.getDescription());
        this.m_descrFldIgnoreChange = false;
        this.m_name = jFCalendar.getName();
        this.refreshDisplay();
        this.m_refreshMode = false;
    }

    private void highlightButton(Calendar calendar, Vector vector) {
        Calendar calendar2 = Calendar.getInstance();
        Calendar calendar3 = Calendar.getInstance();
        for (int i = 0; i < vector.size(); ++i) {
            calendar2 = (Calendar)vector.get(i);
            if (!this.isShow(calendar, calendar2)) continue;
            calendar3 = (Calendar)calendar2.clone();
            int n = calendar2.get(5);
            int n2 = calendar2.get(2);
            calendar3.set(5, 1);
            int n3 = calendar3.get(7);
            int n4 = n3 + n - 2;
            int n5 = n2 % 6;
            this.daysButton[n2 % 6][n4].setSelected(true);
            this.daysButton[n2 % 6][n4].setForeground(SELECTED_TEXT_COLOR);
            this.daysButton[n2 % 6][n4].setBackground(SELECTED_BACKGROUND_COLOR);
        }
    }

    private boolean isShow(Calendar calendar, Calendar calendar2) {
        int n = calendar.get(2) / 6 * 6;
        int n2 = calendar.get(1);
        int n3 = calendar2.get(1);
        int n4 = calendar2.get(2) / 6 * 6;
        return n == n4 && n2 == n3;
    }

    private void hideButton() {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 42; ++j) {
                this.daysButton[i][j].setText("");
                this.daysButton[i][j].setEnabled(false);
            }
        }
    }

    private void disableCalendar() {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 42; ++j) {
                this.daysButton[i][j].setEnabled(false);
            }
        }
        this.descriptionField.setEnabled(false);
        this.descriptionField.setOpaque(false);
    }

    private void resetButton() {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 42; ++j) {
                this.daysButton[i][j].setSelected(false);
                this.daysButton[i][j].setBorder(null);
                this.daysButton[i][j].setForeground(UNSELECTED_TEXT_COLOR);
                this.daysButton[i][j].setBackground(UNSELECTED_BACKGROUND_COLOR);
            }
        }
    }

    private void add(String string, String string2, String string3) {
        int n = Integer.parseInt(string);
        int n2 = Integer.parseInt(string2) - 1;
        int n3 = Integer.parseInt(string3);
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, n);
        calendar.set(2, n2);
        calendar.set(5, n3);
        this.m_selectedDates.add(calendar);
    }

    private void remove(String string, String string2, String string3) {
        int n = Integer.parseInt(string);
        int n2 = Integer.parseInt(string2) - 1;
        int n3 = Integer.parseInt(string3);
        Calendar calendar = Calendar.getInstance();
        for (int i = 0; i < this.m_selectedDates.size(); ++i) {
            calendar = (Calendar)this.m_selectedDates.get(i);
            int n4 = calendar.get(1);
            int n5 = calendar.get(2);
            int n6 = calendar.get(5);
            if (n4 != n || n5 != n2 || n6 != n3) continue;
            this.m_selectedDates.remove(i);
            return;
        }
    }

    @Override
    public JFCalendar getCalendarDef() {
        this.m_name = this.m_cal.getName();
        String string = this.descriptionField.getText().trim();
        String string2 = this.getExpression();
        this.m_cal = new JFCalendar(this.m_name, string2, this.m_owner, string);
        return this.m_cal;
    }

    @Override
    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.forward) {
            Calendar calendar = (Calendar)this.showDate.clone();
            this.showDate.add(2, 6);
            this.dateChanged(calendar, this.showDate);
            this.refreshDisplay();
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(actionEvent, 0, "FORWARD"));
            }
        } else if (actionEvent.getSource() == this.backward) {
            Calendar calendar = (Calendar)this.showDate.clone();
            this.showDate.add(2, -6);
            this.dateChanged(calendar, this.showDate);
            this.refreshDisplay();
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(actionEvent, 0, "BACKWARD"));
            }
        } else {
            JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
            String string = jToggleButton.getToolTipText();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, Integer.parseInt(string4));
            calendar.set(2, Integer.parseInt(string2) - 1);
            calendar.set(5, Integer.parseInt(string3));
            if (!this.compareCalendar(this.today, calendar)) {
                JOptionPane.showConfirmDialog(this, JFMessage.ERRORMSG_EXPIRE, JFUtility.getErrMsgTitle(), -1, 2);
                jToggleButton.setSelected(false);
                jToggleButton.setForeground(UNSELECTED_TEXT_COLOR);
                jToggleButton.setBackground(UNSELECTED_BACKGROUND_COLOR);
            } else if (jToggleButton.isSelected()) {
                this.setDirtyBit(true);
                jToggleButton.setForeground(SELECTED_TEXT_COLOR);
                jToggleButton.setBackground(SELECTED_BACKGROUND_COLOR);
                if (this.actionListener != null) {
                    this.actionListener.actionPerformed(new ActionEvent(this, 0, "internalFrame"));
                }
                this.add(string4, string2, string3);
            } else {
                this.setDirtyBit(true);
                jToggleButton.setForeground(UNSELECTED_TEXT_COLOR);
                jToggleButton.setBackground(UNSELECTED_BACKGROUND_COLOR);
                if (this.actionListener != null) {
                    this.actionListener.actionPerformed(new ActionEvent(this, 0, "internalFrame"));
                }
                this.remove(string4, string2, string3);
            }
        }
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        if (this.getAllowEdit()) {
            if (!this.m_refreshMode) {
                this.setDirtyBit(true);
            }
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 0, "internalFrame"));
            }
        }
    }

    protected void refreshDisplay() {
        this.hideButton();
        this.resetButton();
        this.initCalendar(this.showDate);
        this.highlightButton(this.showDate, this.m_selectedDates);
    }

    protected void dateChanged(Calendar calendar, Calendar calendar2) {
    }

    @Override
    public void setAllowEdit(boolean bl) {
        if (this.getAllowEdit() == bl) {
            return;
        }
        super.setAllowEdit(bl);
        if (bl) {
            this.refreshDisplay();
        } else {
            this.disableCalendar();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (!this.m_descrFldIgnoreChange) {
            this.setDirtyBit(true);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this.m_descrFldIgnoreChange) {
            this.setDirtyBit(true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (!this.m_descrFldIgnoreChange) {
            this.setDirtyBit(true);
        }
    }
}

