/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.ntservice;

import com.sas.security.SecuritySupport;
import com.sas.util.ntservice.MiddleWareService;
import com.sas.util.ntservice.NTServiceInterface;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.RMISecurityManager;
import java.rmi.registry.Registry;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.misc.URLClassPath;
import sun.rmi.registry.RegistryImpl;
import sun.rmi.server.LoaderHandler;

public class RMIRegistry
implements NTServiceInterface,
Runnable {
    private transient boolean stopFlag;
    private transient Registry registry;
    private String[] args;
    private ResourceBundle resources = null;

    private String time() {
        Date d = new Date(System.currentTimeMillis());
        return d.toString();
    }

    public void serviceContinue() {
        System.out.println("RMIRegistry Service Continued " + this.time());
    }

    public void servicePause() {
        System.out.println("RMIRegistry Service Paused " + this.time());
    }

    public void serviceShutdown() {
        System.out.println("RMIRegistry Service Shutdown " + this.time());
        this.stopFlag = true;
    }

    public void serviceStop() {
        System.out.println("RMIRegistry Service Stop" + this.time());
        this.stopFlag = true;
    }

    public void serviceStart(String[] a) {
        try {
            String logFile = "c:\\RMIRegsitry.txt";
            if (a != null && a.length > 0) {
                logFile = a[0];
            }
            PrintStream ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(new File(logFile))), true);
            System.setOut(ps);
            System.setErr(ps);
            System.out.println("Initializing RMIRegsitry Service Provider " + this.time());
        }
        catch (Exception logFile) {
            // empty catch block
        }
        this.args = a;
        this.stopFlag = false;
        Thread t = SecuritySupport.securitySupport.createThread((Runnable)this);
        t.start();
    }

    @Override
    public void run() {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            String envcp = System.getProperty("env.class.path");
            if (envcp == null) {
                envcp = ".";
            }
            URL[] urls = URLClassPath.pathToURLs((String)envcp);
            URLClassLoader cl = new URLClassLoader(urls);
            LoaderHandler.registerCodebaseLoader(cl);
            Thread.currentThread().setContextClassLoader(cl);
            int regPort = 1099;
            try {
                this.registry = new RegistryImpl(regPort);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.stopFlag = true;
            }
            System.out.println("RMIRegistry Initialized");
            while (!this.stopFlag) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (NumberFormatException e) {
            System.err.println(MessageFormat.format(this.getTextResource("rmiregistry.port.badnumber"), this.args[0]));
            System.err.println(MessageFormat.format(this.getTextResource("rmiregistry.usage"), "rmiregistry"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getTextResource(String key) {
        if (this.resources == null) {
            try {
                this.resources = ResourceBundle.getBundle("sun.rmi.registry.resources.rmiregistry");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (this.resources == null) {
                return "[missing resource file: " + key + "]";
            }
        }
        String val = null;
        try {
            val = this.resources.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (val == null) {
            return "[missing resource: " + key + "]";
        }
        return val;
    }

    public static void main(String[] args) {
        MiddleWareService r = new MiddleWareService();
        System.out.println("starting ");
        Enumeration<?> p = System.getProperties().propertyNames();
        while (p.hasMoreElements()) {
            String n = (String)p.nextElement();
            if (!n.startsWith("java")) continue;
            System.out.println(n + "=" + System.getProperty(n));
        }
        r.serviceStart(args);
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        r.serviceStop();
        System.out.println("done!");
    }
}

