/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.ClientNotifyInterface;
import com.sas.rmi.ClientWatcher;
import com.sas.rmi.Connection;
import com.sas.rmi.MWSClassLoader;
import com.sas.rmi.MWSHtmlGen;
import com.sas.rmi.NotifyTimerTask;
import com.sas.rmi.PrivilegedSocketFactory;
import com.sas.rmi.RB;
import com.sas.rmi.RMIUtil;
import com.sas.rmi.RocfORBCleanup;
import com.sas.rmi.RocfORBClient;
import com.sas.rmi.RocfORBInterface;
import com.sas.rmi.RocfORBListener;
import com.sas.rmi.RocfORBListenerList;
import com.sas.rmi.RocfORBMachine;
import com.sas.rmi.RocfORBPreloadConnection;
import com.sas.rmi.RocfORBPreloadThread;
import com.sas.rmi.RocfORBPrintStream;
import com.sas.rmi.RocfORBProfile2Interface;
import com.sas.rmi.RocfORBProperties;
import com.sas.rmi.RocfORBRefCnt;
import com.sas.rmi.RocfORBResPool;
import com.sas.rmi.RocfORBSession;
import com.sas.rmi.RocfORBSessionDescriptor;
import com.sas.rmi.RocfORBSource;
import com.sas.rmi.RocfORBTree;
import com.sas.rmi.ServerBusyTimeoutException;
import com.sas.rmi.SingleThreadedQueue;
import com.sas.security.BaseSecuritySupport;
import com.sas.util.ArrayAccess;
import com.sas.util.Comparator;
import com.sas.util.IndexedSetInterface;
import com.sas.util.Sort;
import com.sas.util.StringComparator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import sun.rmi.server.LoaderHandler;

public class RocfORB
extends RocfORBTree
implements RocfORBInterface,
RocfORBSource {
    public static final int NORMAL = 0;
    public static final int SHUTDOWN = 1;
    public static final int KILL = 2;
    public static final int RELOAD = 3;
    public static final int SLEEP = 4;
    public static final int STATUS = 5;
    public static final int RELOADCLASSES = 6;
    private transient RocfORBProperties m_props;
    private transient String[] m_args;
    private transient PrintStream m_outputFile;
    private transient PrintStream m_originalOut;
    private transient PrintStream m_originalErr;
    private transient boolean m_initialized = false;
    private transient String m_displayName;
    private transient RocfORBProfile2Interface m_profileProcessor = null;
    private transient RocfORBPreloadConnection[] m_preloads;
    private transient Vector m_threadPool;
    private transient long lastRefresh;
    private transient Properties m_funnelConfig;
    private transient long m_funnelConfigModTime;
    private transient int commandCode = 0;
    private transient boolean commandKill = false;
    private transient boolean commandShutdown = false;
    private transient boolean commandReload = false;
    private transient boolean commandSleep = false;
    private transient boolean commandReloadClasses = false;
    private transient boolean sleeping = false;
    private transient long sleepUntil;
    private transient RocfORBListenerList m_allRocfORBListeners;
    private transient Vector m_interestingClientID;
    private transient long pingint;
    private transient long lastping;
    private transient Hashtable ht_mfp;
    private transient Hashtable ht_sfm;
    private transient Hashtable ht_cfs;
    private transient RocfORBRefCnt refcnt;
    private transient ClassLoader SavedCL = null;
    private transient MWSClassLoader mcl = null;
    private transient boolean inRefresh = false;
    private transient Timer timer = new Timer(true);
    private transient SingleThreadedQueue stq = new SingleThreadedQueue("MWS-Queue");
    private transient MWSHtmlGen mwshtmlgen;
    private transient StatusPageGenerator spg;
    public static final int ROLLOVER_CLIENT_MAJOR = 0;
    public static final int ROLLOVER_SESSION_MAJOR = 1;
    public static final String PRELOAD_PROFILE_PREFIX = "preload";
    public static final String RB_KEY = "RocfORB.";
    private transient boolean defer;
    private transient Hashtable actionTable = new Hashtable();
    private transient Object actionSynchObject = new Object();

    public RocfORB() throws RemoteException {
        this.reset();
    }

    public static void main(String[] argv) {
        try {
            boolean inprocessRegistry = true;
            String inetString = null;
            int port = 1099;
            for (int i = 0; i < argv.length; ++i) {
                if (argv[i].startsWith("-x")) {
                    inprocessRegistry = false;
                    continue;
                }
                if (argv[i].startsWith("-i")) {
                    inetString = argv[i].substring(2);
                    continue;
                }
                if (!argv[i].startsWith("-p")) continue;
                port = Integer.parseInt(argv[i].substring(2));
            }
            if (inetString != null) {
                RMIUtil.setInetAddress(inetString);
            }
            PrivilegedSocketFactory psf = RMIUtil.trapSocket();
            if (inprocessRegistry) {
                boolean oldRegistryAlive = false;
                try {
                    Socket socket = new Socket(InetAddress.getLocalHost(), port);
                    oldRegistryAlive = true;
                    socket.close();
                }
                catch (IOException e) {
                    oldRegistryAlive = false;
                }
                if (oldRegistryAlive) {
                    String msg = "WARNING: Another RMI process already bound to this port\nPlease do not start RMIREGISTRY as an external process unless passing the '-x' option to RocfORB";
                    System.out.println(msg);
                } else {
                    LocateRegistry.createRegistry(port, (RMIClientSocketFactory)((Object)psf), (RMIServerSocketFactory)((Object)psf));
                }
            }
            new RocfORB().doit(argv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    RocfORBResPool getResPool(int index) {
        return (RocfORBResPool)this._Rocf_getKid(index);
    }

    protected int getResPoolCount() {
        return this._Rocf_numKids();
    }

    public void _Rocf_lastChildRemoved() throws RemoteException {
        super._Rocf_lastChildRemoved();
    }

    public void _RemoteObject_removeImpl() throws RemoteException {
        super._RemoteObject_removeImpl();
    }

    public Object _RemoteObject_getChildImpl(Object desc) throws RemoteException {
        RocfORBResPool _respool = null;
        Object clnt = null;
        RocfORBSessionDescriptor sdesc = (RocfORBSessionDescriptor)desc;
        Object clientCallback = sdesc.callback;
        Connection ctxt = sdesc.ctxt;
        ctxt.setFunnel(false);
        ctxt.setAppletCodebaseRelative(false);
        this.overrideConnectionProperties(ctxt);
        String host = RMIUtil.hostNormalize(ctxt.getHost());
        host = this.findDupKey(host);
        ctxt.setHost(host);
        RocfORB _orb = this;
        boolean needSetup = false;
        int nr = this.getResPoolCount();
        for (int ir = 0; _respool == null && ir < nr; ++ir) {
            Connection current = sdesc.ctxt;
            RocfORBResPool tres = this.getResPool(ir);
            Connection compare = tres.getConnection();
            boolean sameConnection = current.equals((Object)compare);
            if (!sameConnection) continue;
            _respool = tres;
        }
        if (_respool == null) {
            _respool = new RocfORBResPool();
            needSetup = true;
            this._Rocf_addChild((RocfORBTree)_respool);
        }
        _orb.getrefcnt().addref(clientCallback, (RocfORBTree)_respool);
        this.disconnectWatch(clientCallback);
        if (needSetup) {
            try {
                _respool.setup(sdesc);
            }
            catch (RemoteException rex) {
                rex.printStackTrace();
                _orb.getrefcnt().release(clientCallback);
                throw rex;
            }
        }
        return _respool;
    }

    RocfORBRefCnt getrefcnt() {
        return this.refcnt;
    }

    public void _Rocf_refresh() {
    }

    private void doit(String[] argv) throws RemoteException {
        this.reload(argv);
    }

    private void reset() {
        this.m_props = new RocfORBProperties();
        this.m_props.setDefaults(this);
        this.pingint = 0L;
        this.lastping = 0L;
        this.ht_mfp = new Hashtable();
        this.ht_sfm = new Hashtable();
        this.ht_cfs = new Hashtable();
        if (this.refcnt == null) {
            this.refcnt = new RocfORBRefCnt(this);
        }
        this.m_funnelConfigModTime = 0L;
        this._r_getSTQ().setQueueName("MWS-ORB");
    }

    private void reload(String[] argv) throws RemoteException {
        this.reset();
        this.trace(this.getDisplayName());
        this.m_args = argv;
        this.m_originalOut = System.out;
        this.m_originalErr = System.err;
        this.m_props.setPropertyFilename(this.m_props.getArg(argv, "-f", this.m_props.getPropertyFilename()));
        this.loadProperties(argv);
        this.m_props.processCommandLine(argv);
        this._r_setQueueWaitTimeout(this.m_props.getQueueWaitTimeout());
        this._Rocf_setDepthFirst(this.m_props.getRolloverType() == 0);
        this.rebind();
        this.setMWSClassLoader();
        this.loadProfiles();
        this.loadFunnelConfig(this.m_props.getRolloverDatabase());
        try {
            RocfORBCleanup hook = new RocfORBCleanup(this, this.m_props.getHtmlFile(), this.m_props.getHtmlServerRefresh());
            Runtime.getRuntime().addShutdownHook((Thread)hook);
        }
        catch (IOException e) {
            System.out.println("Failed to create shutdown thread");
        }
        if (this.spg == null) {
            this.spg = new StatusPageGenerator();
            this.mwshtmlgen = new MWSHtmlGen(this.m_props.getHtmlFile(), this.m_props.getHtmlFileRefresh(), this);
            this.getTimer().schedule((TimerTask)((Object)this.spg), 1000L, (long)this.m_props.getHtmlServerRefresh() * 1000L);
        }
        this.loadPreloads();
        this.m_initialized = true;
    }

    private void rebind() {
        try {
            String orbName = "//" + RMIUtil.getInetAddress().getHostAddress() + ":" + this.m_props.getPort() + "/RocfORB";
            this.traceRB("bindingTo.txt", orbName);
            Naming.rebind(orbName, (Remote)((Object)this));
            this.m_props.setOrbName(orbName);
        }
        catch (MalformedURLException ex) {
            System.out.println("Middleware aborting, cannot compose URL name");
            System.exit(0);
        }
        catch (RemoteException ex) {
            System.out.println("Middleware aborting, cannot contact RMIREGISTRY");
            System.exit(0);
        }
        catch (IOException ex) {
            System.out.println("Middleware aborting, cannot rebind");
            System.exit(0);
        }
    }

    private void loadProperties(String[] argv) {
        String outputFileName;
        this.m_props.readProperties(this.m_props.getPropertyFilename());
        if (!this.m_initialized) {
            int delaySeconds = this.m_props.getInitialDelay();
            delaySeconds = this.m_props.getIntArg(argv, "-d", delaySeconds);
            this.m_props.setInitialDelay(delaySeconds);
        }
        if ((outputFileName = this.m_props.getOutputFile()) != null) {
            try {
                FileOutputStream fos = new FileOutputStream(outputFileName, this.m_initialized);
                this.m_outputFile = RocfORBPrintStream.makePrintStream((FileOutputStream)fos);
                this.traceRB("loggingTo.txt", outputFileName);
                System.setOut(this.m_outputFile);
                System.setErr(this.m_outputFile);
            }
            catch (IOException ex) {
                System.out.println("Unable to set the output stream to " + outputFileName);
                this.m_outputFile = null;
            }
        }
        if (this.m_outputFile == null) {
            System.setOut(this.m_originalOut);
            System.setErr(this.m_originalErr);
        }
    }

    private void loadProfiles() {
        block9: {
            String pName;
            String profileProcessorName = this.m_props.getProfileProcessor();
            boolean reloadProcessor = false;
            if (this.m_profileProcessor != null && (pName = this.m_profileProcessor.getClass().getName()).equals(profileProcessorName)) {
                reloadProcessor = true;
            }
            if (profileProcessorName.trim().length() > 0) {
                if (reloadProcessor) {
                    this.m_profileProcessor.reload();
                } else {
                    this.traceRB("loadingProcessor.txt", profileProcessorName);
                    try {
                        Object o = ClassLoader.getSystemClassLoader().loadClass(profileProcessorName).newInstance();
                        if (o instanceof RocfORBProfile2Interface) {
                            this.m_profileProcessor = (RocfORBProfile2Interface)o;
                            Properties pp = this.m_props.getProperties("profileProcessor.");
                            boolean initialized = this.m_profileProcessor.initialize(pp);
                            if (!initialized) {
                                this.m_profileProcessor = null;
                            }
                            break block9;
                        }
                        this.traceRB("processorNotImplemented.txt");
                    }
                    catch (Exception ex) {
                        this.traceRB("processorNotFound.txt");
                    }
                }
            } else {
                this.m_profileProcessor = null;
            }
        }
    }

    private void loadPreloads() {
        this.killPreloadProfileConnections();
        this.m_preloads = null;
        Properties preloads = this.m_props.getProperties(PRELOAD_PROFILE_PREFIX);
        if (preloads == null || preloads.size() == 0) {
            this.traceRB("ready.txt");
            return;
        }
        String profileKey = ".profile";
        String asynchronousStartupKey = ".asynchronousStartup";
        String preloadedClientsKey = ".preloadedClients";
        String autoRestartKey = ".autoRestart";
        String retainKey = ".retain";
        Properties profiles = new Properties();
        Enumeration<Object> enumer = preloads.keys();
        while (enumer.hasMoreElements()) {
            String key = (String)enumer.nextElement();
            if (!key.endsWith(profileKey)) continue;
            profiles.put(key.substring(0, key.length() - profileKey.length()), preloads.getProperty(key));
        }
        Object[] tempa = new String[profiles.size()];
        enumer = profiles.keys();
        int i = 0;
        while (enumer.hasMoreElements()) {
            tempa[i++] = (String)enumer.nextElement();
        }
        ArrayAccess aa = new ArrayAccess(tempa);
        Sort sort = new Sort((IndexedSetInterface)aa, (Comparator)StringComparator.defaultInstance);
        sort.sort();
        Vector<RocfORBPreloadConnection> preloadV = new Vector<RocfORBPreloadConnection>();
        for (i = 0; i < tempa.length; ++i) {
            RocfORBPreloadConnection o = new RocfORBPreloadConnection();
            Object key = tempa[i];
            o.key = PRELOAD_PROFILE_PREFIX + (String)key;
            o.profile = this.m_props.getProperty(o.key + profileKey);
            String value = this.m_props.getProperty(o.key + asynchronousStartupKey);
            if (value != null) {
                o.asynchronousStartup = value.equalsIgnoreCase("true");
            }
            if ((value = this.m_props.getProperty(o.key + autoRestartKey)) != null) {
                o.autoRestart = value.equalsIgnoreCase("true");
            }
            if ((value = this.m_props.getProperty(o.key + retainKey)) != null) {
                o.retain = value.equalsIgnoreCase("true");
            }
            if ((value = this.m_props.getProperty(o.key + preloadedClientsKey)) != null) {
                String strTrimmed = value.trim();
                o.preloadedClients = Integer.parseInt(strTrimmed);
            }
            preloadV.addElement(o);
        }
        int size = preloadV.size();
        if (size > 0) {
            this.m_preloads = new RocfORBPreloadConnection[size];
            for (int j = 0; j < size; ++j) {
                this.m_preloads[j] = (RocfORBPreloadConnection)preloadV.elementAt(j);
            }
            this.preloadConnections();
        }
        if (size == 0) {
            this.traceRB("ready.txt");
        }
    }

    private void killPreloadProfileConnections() {
        boolean done = false;
        while (!done) {
            RocfORBClient _killClient = this.nextPreloadClient();
            if (_killClient != null) {
                this.traceRB("preloadStop.txt");
                _killClient.setAutoRestart(false);
                Object callback = _killClient.getCallback();
                this.getrefcnt().qrelease(callback);
                try {
                    _killClient._RemoteObject_remove();
                }
                catch (RemoteException e) {
                    System.out.println("Warning: exception thrown stopping client:");
                    e.printStackTrace();
                }
                catch (Exception bige) {
                    System.out.println("Error: serious exception in client termination:");
                    bige.printStackTrace();
                }
                continue;
            }
            done = true;
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void preloadConnections() {
        int i;
        if (this.m_preloads == null) {
            return;
        }
        if (this.m_profileProcessor == null) {
            this.traceRB("noProcessorForPreload.txt");
            return;
        }
        this.m_threadPool = new Vector();
        for (i = 0; i < this.m_preloads.length; ++i) {
            this.preloadConnection(i);
        }
        for (i = 0; i < this.m_threadPool.size(); ++i) {
            Thread t = (Thread)this.m_threadPool.elementAt(i);
            try {
                t.join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.m_threadPool = null;
        this.traceRB("ready.txt");
    }

    private void preloadConnection(int idx) {
        if (idx < 0 || idx >= this.m_preloads.length) {
            System.out.println("Invalid preload index: " + idx);
            return;
        }
        String profile = this.m_preloads[idx].profile;
        if (!this.m_profileProcessor.exists(profile)) {
            this.traceRB("preloadProfileNotFound.txt", profile);
            return;
        }
        Connection c = new Connection();
        c.setProfileName(profile);
        c.setUseProfile(true);
        try {
            this.m_profileProcessor.applyProfileProperties(profile, c);
        }
        catch (RemoteException rex) {
            System.out.println("Warning: problem applying profile: " + rex);
        }
        this.m_preloads[idx].runner = new RocfORBPreloadThread(this, c, this.m_preloads[idx]);
        if (this.m_preloads[idx].asynchronousStartup) {
            Thread t = BaseSecuritySupport.securitySupport.createThread((Runnable)this.m_preloads[idx].runner);
            this.m_threadPool.addElement(t);
            t.start();
        } else {
            this.m_preloads[idx].runner.run();
        }
    }

    private void _p(String s) {
        if (this.m_props.getVerbose()) {
            System.out.println(this.getDisplayName() + "::" + s);
        }
    }

    private void terminate(int errCode) {
        this.goToSleep();
        try {
            this._RemoteObject_remove();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        System.exit(errCode);
    }

    private void goToSleep() {
        try {
            this.killPreloadProfileConnections();
            Naming.unbind(this.m_props.getOrbName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sleeping = true;
    }

    void pinfo() {
        System.out.println(this.pinfoImpl());
    }

    private String pinfoImpl() {
        StringBuffer sb = new StringBuffer();
        RocfORB _orb = this;
        sb.append(_orb.getCurrentTimestamp() + "\n");
        int nr = _orb.getResPoolCount();
        for (int ir = 0; ir < nr; ++ir) {
            RocfORBResPool _respool = _orb.getResPool(ir);
            sb.append("" + _respool + "\n");
            int nm = _respool.getMachineCount();
            for (int im = 0; im < nm; ++im) {
                RocfORBMachine _machine = _respool.getMachine(im);
                sb.append(" " + _machine + "\n");
                int ns = _machine.getSessionCount();
                for (int is = 0; is < ns; ++is) {
                    RocfORBSession _session = _machine.getSession(is);
                    sb.append("  " + _session + "\n");
                    int nc = _session.getClientCount();
                    for (int ic = 0; ic < nc; ++ic) {
                        RocfORBClient _client = _session.getClient(ic);
                        sb.append("   " + _client + "\n");
                    }
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFunnelConfig(String name) {
        StringTokenizer s;
        String val;
        if (name == null) {
            this.m_funnelConfig = null;
            this.m_funnelConfigModTime = 0L;
            return;
        }
        File f = new File(name);
        if (!f.exists() || !f.isFile()) {
            this.traceRB("configFileNotFound.txt", name);
            return;
        }
        if (this.m_funnelConfigModTime == f.lastModified()) {
            this.traceRB("skipLoadingConfigFile.txt", name);
            return;
        }
        this.m_funnelConfigModTime = f.lastModified();
        if (this.m_funnelConfig == null) {
            this.m_funnelConfig = new Properties();
        }
        this.traceRB("loadingConfigFile.txt", name);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            Properties p = new Properties();
            p.load(fis);
            this.m_funnelConfig.clear();
            Enumeration<Object> enumer = p.keys();
            while (enumer.hasMoreElements()) {
                int maxClients;
                int maxSessions;
                String key = (String)enumer.nextElement();
                val = p.getProperty(key);
                key = RMIUtil.hostNormalize(key);
                s = new StringTokenizer(val, " \t,/");
                int sCount = s.countTokens();
                String[] sv = new String[sCount];
                for (int idx = 0; idx < sCount; ++idx) {
                    sv[idx] = s.nextToken();
                }
                if (sCount < 2) {
                    maxSessions = Integer.MAX_VALUE;
                    maxClients = this.myParseInt(sv[0], Integer.MAX_VALUE);
                } else {
                    maxSessions = this.myParseInt(sv[0], Integer.MAX_VALUE);
                    maxClients = this.myParseInt(sv[1], Integer.MAX_VALUE);
                }
                key = RMIUtil.hostNormalize(key);
                key = this.findDupKey(key);
                this.htputint(this.ht_sfm, key, maxSessions);
                this.htputint(this.ht_cfs, key, maxClients);
            }
            Enumeration keys = this.ht_sfm.keys();
            while (keys.hasMoreElements()) {
                String hhost = (String)keys.nextElement();
                String maxs = this.StarInt(this.htgetint(this.ht_sfm, hhost));
                String maxc = this.StarInt(this.htgetint(this.ht_cfs, hhost));
                this.traceRB("maximumClientsOnHost.txt", hhost + " = " + maxs + "/" + maxc);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {}
            }
        }
        if (this.m_profileProcessor != null) {
            String[] pname = this.m_profileProcessor.getProfileNames();
            for (int idx = 0; idx < pname.length; ++idx) {
                String profileName = pname[idx];
                val = this.m_profileProcessor.getProperty(profileName + ".serverRollover");
                if (val == null) continue;
                s = new StringTokenizer(val, " \t,");
                int sCount = s.countTokens();
                Vector<String> vtmp = new Vector<String>();
                for (int jdx = 0; jdx < sCount; ++jdx) {
                    String rhost = s.nextToken();
                    try {
                        rhost = RMIUtil.hostNormalize(rhost);
                        rhost = this.findDupKey(rhost);
                        vtmp.addElement(rhost);
                        continue;
                    }
                    catch (RemoteException rex) {
                        rex.printStackTrace();
                    }
                }
                String[] sv = new String[vtmp.size()];
                for (int i = 0; i < vtmp.size(); ++i) {
                    sv[i] = (String)vtmp.elementAt(i);
                }
                this.ht_mfp.put(profileName, sv);
            }
        }
    }

    private void printHT(Hashtable ht) {
        System.out.println("Hashtable");
        Enumeration keys = ht.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object val = ht.get(key);
            System.out.print(key + "=");
            if (val instanceof String[]) {
                String[] sv = (String[])val;
                for (int i = 0; i < sv.length; ++i) {
                    System.out.print(sv[i] + " ");
                }
            } else if (val instanceof Integer) {
                Integer iobj = (Integer)val;
                System.out.print(this.StarInt(iobj));
            } else {
                System.out.print(val + "");
            }
            System.out.println();
        }
    }

    String[] getMachinesForProfile(String profileName) {
        String[] sv = (String[])this.ht_mfp.get(profileName);
        return sv;
    }

    int getMaxSessionsForMachine(String machineName) {
        return this.htgetint(this.ht_sfm, machineName);
    }

    int getMaxClientsForSession(String machineName) {
        return this.htgetint(this.ht_cfs, machineName);
    }

    void htputint(Hashtable ht, String key, int i) {
        ht.put(key.toUpperCase(), new Integer(i));
    }

    int htgetint(Hashtable ht, String key) {
        Object o;
        block3: {
            block2: {
                o = null;
                if (key == null) break block2;
                Object v = ht.get(key.toUpperCase());
                o = v;
                if (v != null) break block3;
            }
            return Integer.MAX_VALUE;
        }
        return o;
    }

    String findDupKey(String key) throws RemoteException {
        Hashtable ht = this.ht_sfm;
        Enumeration keys = ht.keys();
        while (keys.hasMoreElements()) {
            String htkey = (String)keys.nextElement();
            if (!this.sameHost(htkey, key)) continue;
            return htkey;
        }
        key = RMIUtil.hostNormalize(key);
        this.htputint(this.ht_sfm, key, Integer.MAX_VALUE);
        this.htputint(this.ht_cfs, key, Integer.MAX_VALUE);
        return key;
    }

    private int myParseInt(String s, int defaultVal) {
        int ret = defaultVal;
        try {
            ret = Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ret;
    }

    private String getDisplayName() {
        if (this.m_displayName == null) {
            this.m_displayName = RB.getStringResource((String)RB_KEY, (String)"displayName.txt");
        }
        return this.m_displayName;
    }

    protected void trace(String s) {
        System.out.println(s + ":" + new Date());
    }

    protected void traceRB(String key) {
        this.trace(RB.getStringResource((String)RB_KEY, (String)key));
    }

    protected void traceRB(String key, String data) {
        this.trace(RB.getStringResource((String)RB_KEY, (String)key) + " " + data);
    }

    protected void overrideConnectionProperties(Connection c) throws RemoteException {
        c.setLoginDialogClassName(null);
        if (this.m_profileProcessor == null || c == null) {
            return;
        }
        if (!c.getUseProfile()) {
            return;
        }
        String key = c.getProfileName();
        if (key == null) {
            return;
        }
        if ((key = key.trim()).length() == 0) {
            return;
        }
        this.m_profileProcessor.applyProfileProperties(key, c);
    }

    public Object command(int id, Object userData) throws RemoteException {
        this.trace("*** " + this.getCurrentTimestamp() + " ***");
        switch (id) {
            case 2: {
                if (!this.isValidCommandHost((String)userData, "KILL")) break;
                this.commandKill = true;
                this.getTimer().schedule((TimerTask)((Object)new CommandPostProcessor()), 1000L);
                break;
            }
            case 1: {
                if (!this.isValidCommandHost((String)userData, "SHUTDOWN")) break;
                this.traceRB("waitingForNoClients.txt");
                this.commandShutdown = true;
                this.getTimer().schedule((TimerTask)((Object)new CommandPostProcessor()), 1000L);
                break;
            }
            case 3: {
                if (!this.isValidCommandHost((String)userData, "RELOAD")) break;
                this.traceRB("waitingForNoClients.txt");
                this.commandReload = true;
                this.getTimer().schedule((TimerTask)((Object)new CommandPostProcessor()), 1000L);
                break;
            }
            case 4: {
                String s = (String)userData;
                String dort = null;
                int idx = s.indexOf(" @");
                if (idx > 0) {
                    dort = s.substring(idx + 1);
                    s = s.substring(0, idx);
                }
                if (dort == null) break;
                this.sleepUntil = 0L;
                if (dort.startsWith("@D")) {
                    this.sleepUntil = this.msecs() + (long)(Integer.parseInt(dort.substring(2)) * 1000);
                } else if (dort.startsWith("@T")) {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss zzz");
                    Date d = null;
                    try {
                        formatter.setLenient(false);
                        ParsePosition pos = new ParsePosition(0);
                        d = formatter.parse(dort.substring(2), pos);
                    }
                    catch (Exception ex) {
                        d = null;
                    }
                    if (d != null) {
                        this.sleepUntil = d.getTime();
                    }
                }
                if (this.sleepUntil <= 0L || !this.isValidCommandHost(s, "SLEEP")) break;
                this.traceRB("waitingForNoClients.txt");
                this.commandSleep = true;
                break;
            }
            case 5: {
                if (!this.isValidCommandHost((String)userData, "STATUS")) break;
                return this.pinfoImpl();
            }
            case 6: {
                if (!this.isValidCommandHost((String)userData, "RELOADCLASSES")) break;
                this.commandReloadClasses = true;
                this.getTimer().schedule((TimerTask)((Object)new CommandPostProcessor()), 1000L);
                break;
            }
            default: {
                String e = RB.getStringResource((String)RB_KEY, (String)"commandUnknown.txt") + " " + id;
                this.trace(e);
                throw new RemoteException(e);
            }
        }
        return null;
    }

    private boolean isValidCommandHost(String host, String command) throws RemoteException {
        String commandHosts;
        boolean rc = false;
        if (host != null && (commandHosts = this.m_props.getAdminHosts()) != null) {
            if (commandHosts.equals("*")) {
                rc = true;
            } else {
                StringTokenizer stok = new StringTokenizer(commandHosts, " ,\t");
                while (stok.hasMoreTokens()) {
                    String vhost = stok.nextToken();
                    if (vhost.equals("*")) {
                        rc = true;
                        break;
                    }
                    if (!this.sameHost(vhost = RMIUtil.hostNormalize(vhost), host)) continue;
                    rc = true;
                    break;
                }
            }
        }
        if (!rc) {
            this.traceRB("receivedUnauthorizedCommand.txt", host + " (" + command + ")");
            String e = RB.getStringResource((String)RB_KEY, (String)"unauthorizedCommand.txt");
            throw new RemoteException(e);
        }
        this.traceRB("receivedCommand.txt", host + " (" + command + ")");
        return rc;
    }

    protected String getCurrentTimestamp() {
        return RMIUtil.currentTimeStamp();
    }

    private long msecs() {
        return System.currentTimeMillis();
    }

    boolean sameHost(String host1, String host2) throws RemoteException {
        boolean matches = false;
        try {
            InetAddress addr1 = InetAddress.getByName(host1);
            InetAddress addr2 = InetAddress.getByName(host2);
            matches = addr1.equals(addr2);
            if (matches && !host1.equals(host2)) {
                System.out.println("Note: " + host1 + " is network equivalent of " + host2);
            }
        }
        catch (UnknownHostException e) {
            throw new RemoteException("" + e);
        }
        return matches;
    }

    RocfORBClient nextPreloadClient() {
        return this.nextClient(this, true, false);
    }

    RocfORBClient nextActiveClient() {
        return this.nextClient(this, false, false);
    }

    RocfORBClient nextClient(RocfORBTree startTree, boolean available, boolean mustBeIdle) {
        RocfORBClient client = null;
        client = this.recursiveClient(startTree, available, mustBeIdle);
        return client;
    }

    private RocfORBClient recursiveClient(RocfORBTree startTree, boolean available, boolean mustBeIdle) {
        boolean dbg = false;
        RocfORBClient client = null;
        if (dbg) {
            System.out.println("Recursing on " + startTree);
        }
        if (startTree instanceof RocfORBClient) {
            boolean idleMatch;
            client = (RocfORBClient)startTree;
            boolean clientIdle = !client._Rocf_isBusy();
            boolean clientAvailable = client.isAvailable();
            boolean availableMatch = available == clientAvailable;
            boolean bl = idleMatch = !mustBeIdle || clientIdle;
            if (dbg) {
                System.out.print(" clientIdle=" + clientIdle);
                System.out.print(",clientAvailable=" + clientAvailable);
                System.out.print(",availableMatch=" + availableMatch);
                System.out.print(",idleMatch=" + idleMatch);
                System.out.println();
            }
            if (availableMatch && idleMatch) {
                return client;
            }
            return null;
        }
        int n = startTree._Rocf_numKids();
        for (int i = 0; i < n; ++i) {
            RocfORBTree subtree = (RocfORBTree)startTree._Rocf_getKid(i);
            client = this.recursiveClient(subtree, available, mustBeIdle);
            if (client == null) continue;
            return client;
        }
        return null;
    }

    int getCommandCode() {
        return this.commandCode;
    }

    void commandPostProcess() {
        if (this.m_props.getHtmlFile() != null) {
            if (this.commandKill) {
                this.commandCode = 2;
                this.getMWSHtmlGen().genPage();
            } else if (this.commandShutdown) {
                this.commandCode = 1;
                this.getMWSHtmlGen().genPage();
            } else if (this.commandReload) {
                this.commandCode = 3;
                this.getMWSHtmlGen().genPage();
            }
        }
        if (this.commandKill) {
            this.commandKill = false;
            System.exit(0);
        }
        if (this.commandShutdown) {
            if (this.nextActiveClient() == null) {
                this.killPreloadProfileConnections();
                this.commandKill = true;
                this.commandShutdown = false;
            } else {
                this.traceRB("shutdownPending.txt");
            }
            this.getTimer().schedule((TimerTask)((Object)new CommandPostProcessor()), 1000L);
        } else if (this.commandReload) {
            if (this.nextActiveClient() != null) {
                this.traceRB("reloadPending.txt");
                this.getTimer().schedule((TimerTask)((Object)new CommandPostProcessor()), 1000L);
            } else {
                this.commandReload = false;
                try {
                    this.reload(this.m_args);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        } else if (this.commandSleep) {
            this.commandSleep = false;
        } else if (this.commandReloadClasses) {
            this.traceRB("reloadClasses.txt");
            try {
                this.reload(this.m_args);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            this.commandReloadClasses = false;
        }
    }

    protected RocfORBProperties getProps() {
        return this.m_props;
    }

    public void addRocfORBListener(RocfORBListener listener) {
        if (null == this.m_allRocfORBListeners) {
            this.m_allRocfORBListeners = new RocfORBListenerList();
        }
        this.m_allRocfORBListeners.add(listener);
    }

    public void removeRocfORBListener(RocfORBListener listener) {
        if (null != this.m_allRocfORBListeners) {
            this.m_allRocfORBListeners.remove(listener);
        }
    }

    public void addClientTrackingID(Object GUID) {
        if (null == this.m_interestingClientID) {
            this.m_interestingClientID = new Vector();
        }
        this.m_interestingClientID.addElement(GUID);
    }

    public void removeClientTrackingID(Object GUID) {
        if (null != this.m_interestingClientID) {
            this.m_interestingClientID.removeElement(GUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectWatch(Object callback) {
        boolean log = this.m_props.getSynchLog();
        if (callback == null) {
            return;
        }
        if (!(callback instanceof ClientNotifyInterface)) {
            return;
        }
        ClientNotifyInterface client = (ClientNotifyInterface)callback;
        if (log) {
            System.out.println("RocfORB.disconnectWatch: creating new clientWatcher thread");
        }
        ClientWatcher clientWatcher = new ClientWatcher((Object)this, client, log);
        Thread thread = BaseSecuritySupport.securitySupport.createThread((Runnable)clientWatcher);
        thread.start();
        ClientWatcher clientWatcher2 = clientWatcher;
        synchronized (clientWatcher2) {
            try {
                clientWatcher.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void setDeferRestart(boolean defer) {
        this.defer = defer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueAction(Object callback, Object runner) {
        Object object = this.actionSynchObject;
        synchronized (object) {
            this.actionTable.put(callback, runner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _r_releaseUser(boolean preloadUser, Object callback) {
        super._r_releaseUser(preloadUser, callback);
        Object object = this.actionSynchObject;
        synchronized (object) {
            Object runner = this.actionTable.get(callback);
            if (runner != null) {
                this.actionTable.remove(callback);
                Object v = runner;
                synchronized (v) {
                    runner.notifyAll();
                }
            }
        }
    }

    private void setMWSClassLoader() {
        Field f;
        if (this.SavedCL == null) {
            this.SavedCL = ClassLoader.getSystemClassLoader();
        } else {
            try {
                f = ClassLoader.class.getDeclaredField("scl");
                f.setAccessible(true);
                f.set(null, this.SavedCL);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mcl = new MWSClassLoader(this.m_props.getSynchLog());
        try {
            f = ClassLoader.class.getDeclaredField("scl");
            f.setAccessible(true);
            f.set(null, this.mcl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.mcl != null) {
            LoaderHandler.registerCodebaseLoader(this.mcl);
            this.m_profileProcessor = null;
        }
    }

    public Object _RemoteObject_getChild(Object desc) throws RemoteException, ServerBusyTimeoutException {
        return super._RemoteObject_getChild(desc);
    }

    public void _RemoteObject_remove() throws RemoteException {
        super._RemoteObject_remove();
    }

    Timer getTimer() {
        return this.timer;
    }

    public SingleThreadedQueue _r_getSTQ() {
        return this.stq;
    }

    public MWSHtmlGen getMWSHtmlGen() {
        return this.mwshtmlgen;
    }

    class ActionItem {
        Object callback;
        boolean retain;
        RocfORBSessionDescriptor sdesc;

        ActionItem() {
        }
    }

    class CommandPostProcessor
    extends NotifyTimerTask {
        CommandPostProcessor() {
        }

        public void runImpl() {
            RocfORB.this.commandPostProcess();
        }
    }

    class StatusPageGenerator
    extends NotifyTimerTask {
        StatusPageGenerator() {
        }

        public void runImpl() {
            RocfORB.this.getMWSHtmlGen().genPage();
        }
    }
}

