/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.ibm.icu.util.TimeZone;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;

public class Timezone
extends TimeZone {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private TimeZone m_timezone;

    public Timezone() {
        this.m_timezone = TimeZone.getDefault();
    }

    public Timezone(String id) {
        this.m_timezone = TimeZone.getTimeZone((String)id);
    }

    public String getID() {
        return this.m_timezone.getID();
    }

    public static String getID(Calendar cal) {
        String javaID = cal.getTimeZone().getID();
        TimeZone zone = TimeZone.getTimeZone((String)javaID);
        if (zone != null) {
            return zone.getID();
        }
        return TimeZone.getDefault().getID();
    }

    public void setID(String ID) {
        this.m_timezone.setID(ID);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Timezone) {
            return this.m_timezone.getID().compareTo(((Timezone)((Object)obj)).getID()) == 0;
        }
        return this.m_timezone.equals(obj);
    }

    public String toString() {
        return this.m_timezone.getDisplayName();
    }

    public String toString(Locale locale) {
        return this.m_timezone.getDisplayName(locale);
    }

    public static String[] getAvailableIDSASList() {
        int MAXZONE = Integer.parseInt(m_bundle.getString("Timezone.Timezone.MAXZONE.lcl"));
        String[] list = new String[MAXZONE];
        for (int zone = 0; zone < MAXZONE; ++zone) {
            list[zone] = m_bundle.getString("Timezone.Timezone." + String.valueOf(zone) + ".lcl");
        }
        return list;
    }

    public int getOffset(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        return this.m_timezone.getOffset(arg0, arg1, arg2, arg3, arg4, arg5);
    }

    public int getRawOffset() {
        return this.m_timezone.getRawOffset();
    }

    public boolean inDaylightTime(Date arg0) {
        return this.m_timezone.inDaylightTime(arg0);
    }

    public void setRawOffset(int arg0) {
        this.m_timezone.setRawOffset(arg0);
    }

    public boolean useDaylightTime() {
        return this.m_timezone.useDaylightTime();
    }

    static {
        String strClassName = Timezone.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

