/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.model.DisplayInfo;
import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SASFolder", propOrder={"pathDataBinding"})
public class SASFolder
extends DisplayInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="Path", required=true)
    protected String pathDataBinding;
    private static final ResourceBundle m_bundle;
    public static final String IconName;

    public String getPathDataBinding() {
        return this.pathDataBinding;
    }

    public void setPathDataBinding(String value) {
        this.pathDataBinding = value;
    }

    public SASFolder() {
        super("", null, IconName);
    }

    public SASFolder(String location) {
        super("", null, IconName);
        this.setLocation(location);
    }

    public SASFolder(String name, String path) {
        super("", null, IconName);
        String n = this.normalizeName(name);
        this.setName(n);
        String p = this.normalizePath(path);
        this.setPath(p);
        super.setLocation(p + n);
    }

    @Override
    public boolean setLocation(String location) {
        String fqname = this.normalizeLocation(location);
        super.setLocation(fqname);
        int index = fqname.lastIndexOf("/");
        if (index < 0) {
            this.setPath("/");
            this.setName(fqname);
        } else if (index == 0) {
            this.setPath("/");
            this.setName(fqname.substring(1));
        } else {
            this.setPath(fqname.substring(0, index + 1));
            this.setName(fqname.substring(index + 1));
        }
        return true;
    }

    @Override
    public String getLocation() {
        String location = "";
        if (super.getLocation() != null) {
            location = this.normalizeLocation(super.getLocation());
        } else {
            if (this.pathDataBinding != null) {
                String p;
                location = p = this.normalizePath(this.pathDataBinding);
            }
            if (super.getName() != null) {
                String n = this.normalizeName(super.getName());
                location = location.concat(n);
            }
        }
        return location;
    }

    public void setPath(String path) {
        this.pathDataBinding = this.normalizePath(path);
    }

    public String getPath() {
        String path = "";
        if (this.pathDataBinding != null) {
            path = this.normalizePath(this.pathDataBinding);
        } else if (super.getLocation() != null) {
            String fqname = this.normalizeLocation(super.getLocation());
            int index = fqname.lastIndexOf("/");
            path = index > 0 ? fqname.substring(0, index + 1) : "/";
        }
        return path;
    }

    @Override
    public String getName() {
        String name = "";
        if (super.getName() != null) {
            name = this.normalizeName(super.getName());
        } else if (super.getLocation() != null) {
            String fqname = this.normalizeLocation(super.getLocation());
            int index = fqname.lastIndexOf("/");
            name = index < 0 ? fqname : (index == 0 ? fqname.substring(1) : fqname.substring(index + 1));
        }
        return name;
    }

    @Override
    public String toString() {
        return this.getLocation();
    }

    private String normalizePath(String path) {
        String p = path.trim();
        if (!p.startsWith("/")) {
            p = "/".concat(p);
        }
        if (!p.endsWith("/")) {
            p = p.concat("/");
        }
        return p;
    }

    private String normalizeName(String name) {
        String n = name.trim();
        if (n.startsWith("/")) {
            n = n.substring(1);
        }
        if (n.endsWith("/")) {
            n = n.substring(0, n.length() - 1);
        }
        return n;
    }

    private String normalizeLocation(String location) {
        String l = location.trim();
        if (!l.startsWith("/")) {
            l = "/".concat(l);
        }
        if (l.endsWith("/")) {
            l = l.substring(0, l.length() - 1);
        }
        return l;
    }

    static {
        String strClassName = DirectoryInfo.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
        IconName = m_bundle.getString("SASFolder.image");
    }
}

