/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.RecurrenceBaseClass;
import com.sas.scheduler.model.SchedulerServerInfo;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="OpaqueRecurrence", propOrder={"dataDataBinding", "expressionDataBinding", "schedulerDataBinding", "displayDataBinding"})
public class OpaqueRecurrence
extends RecurrenceBaseClass
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="Data", required=true)
    protected String dataDataBinding;
    @XmlElement(name="Expression", required=true)
    protected String expressionDataBinding;
    @XmlElement(name="Scheduler", required=true)
    protected String schedulerDataBinding;
    @XmlElement(name="Display", required=true)
    protected String displayDataBinding;
    static final String XML_Opaque_Tag = "opaque";
    static final String XML_Scheduler = "scheduler";
    static final String XML_Display = "display";
    static final String XML_Data = "data";
    static final String XML_Expression = "expression";

    public OpaqueRecurrence() {
        this.schedulerDataBinding = null;
        this.displayDataBinding = null;
        this.dataDataBinding = null;
        this.expressionDataBinding = null;
    }

    public OpaqueRecurrence(String scheduler, String display, String value) {
        SchedulerServerInfo info = new SchedulerServerInfo(null, scheduler);
        if (info.getType() == null) {
            throw new InvalidParameterException(scheduler);
        }
        this.schedulerDataBinding = scheduler;
        this.displayDataBinding = display;
        this.dataDataBinding = value;
        this.expressionDataBinding = null;
    }

    public OpaqueRecurrence(String scheduler, String display, String calname, String expression) {
        SchedulerServerInfo info = new SchedulerServerInfo(null, scheduler);
        if (info.getType() == null) {
            throw new InvalidParameterException(scheduler);
        }
        this.schedulerDataBinding = scheduler;
        this.displayDataBinding = display;
        this.dataDataBinding = calname;
        this.expressionDataBinding = expression;
    }

    public String getDataDataBinding() {
        return this.dataDataBinding;
    }

    public void setDataDataBinding(String value) {
        this.dataDataBinding = value;
    }

    public String getExpressionDataBinding() {
        return this.expressionDataBinding;
    }

    public void setExpressionDataBinding(String value) {
        this.expressionDataBinding = value;
    }

    public String getSchedulerDataBinding() {
        return this.schedulerDataBinding;
    }

    public void setSchedulerDataBinding(String value) {
        this.schedulerDataBinding = value;
    }

    public String getDisplayDataBinding() {
        return this.displayDataBinding;
    }

    public void setDisplayDataBinding(String value) {
        this.displayDataBinding = value;
    }

    public String getScheduler() {
        return this.schedulerDataBinding;
    }

    public String getData() {
        return this.dataDataBinding;
    }

    public String getExpression() {
        return this.expressionDataBinding;
    }

    @Override
    public List<Calendar> getNextDates(Calendar startDate, Calendar endQueryDate, int count) {
        return null;
    }

    @Override
    public boolean includesDate(Calendar date) {
        return false;
    }

    @Override
    public String toString(Locale locale) {
        return this.dataDataBinding;
    }

    public String toString(String hour, String minute, String duration) {
        return this.toString(Locale.getDefault(), hour, minute, duration);
    }

    public String toString(Locale locale, String hour, String minute, String duration) {
        Object[] args = new Object[]{hour, minute, duration};
        return MessageFormat.format(this.displayDataBinding, args);
    }

    @Override
    public IRecurrenceInfo copy() {
        OpaqueRecurrence recurrence = new OpaqueRecurrence();
        recurrence.copyFrom(this);
        return recurrence;
    }

    @Override
    protected void copyFrom(IRecurrenceInfo source) {
        if (source instanceof OpaqueRecurrence) {
            OpaqueRecurrence recurrence = (OpaqueRecurrence)source;
            this.dataDataBinding = recurrence.dataDataBinding;
            this.displayDataBinding = recurrence.displayDataBinding;
            this.expressionDataBinding = recurrence.expressionDataBinding;
            this.schedulerDataBinding = recurrence.schedulerDataBinding;
        }
    }

    @Override
    public void toXML(StringBuffer buffer) {
        buffer.append("<");
        buffer.append(XML_Opaque_Tag);
        buffer.append(" ");
        buffer.append(XML_Scheduler);
        buffer.append("=");
        buffer.append('\"');
        buffer.append(this.schedulerDataBinding);
        buffer.append('\"');
        buffer.append(" ");
        buffer.append(XML_Display);
        buffer.append("=");
        buffer.append('\"');
        buffer.append(this.displayDataBinding);
        buffer.append('\"');
        buffer.append(" ");
        buffer.append(XML_Data);
        buffer.append("=");
        buffer.append("'");
        buffer.append(this.dataDataBinding);
        buffer.append("'");
        buffer.append(" ");
        buffer.append(XML_Expression);
        buffer.append("=");
        buffer.append("'");
        buffer.append(this.expressionDataBinding);
        buffer.append("'");
        buffer.append("/>");
    }

    @Override
    public void injectXML(Document doc, Element parent) {
        Element tag = doc.createElement(XML_Opaque_Tag);
        parent.appendChild(tag);
        tag.setAttribute(XML_Scheduler, this.schedulerDataBinding);
        tag.setAttribute(XML_Display, this.displayDataBinding);
        tag.setAttribute(XML_Data, this.dataDataBinding);
        tag.setAttribute(XML_Expression, this.expressionDataBinding);
    }

    @Override
    public void toShortUniqueString(StringBuffer buffer) {
        int index = this.displayDataBinding.indexOf("@");
        buffer.append(this.displayDataBinding.substring(0, index));
    }
}

