/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.RunHistory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="JobRendererInfo", propOrder={"rendererNameDataBinding", "appIDsDataBinding", "lastHeartBeatDataBinding", "cumulativeJobCountDataBinding", "upTimeDataBinding", "activeJobCountDataBinding"})
public class JobRendererInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static char Separator = (char)124;
    private String rendererNameDataBinding;
    private List<String> appIDsDataBinding;
    private long lastHeartBeatDataBinding;
    private long cumulativeJobCountDataBinding;
    private long upTimeDataBinding;
    private int activeJobCountDataBinding;
    protected static final String Tag_Name = "Name=";
    protected static final String Tag_AppIDs = "AppIDs=";
    protected static final String Tag_LastHeartbeat = "LastHeartbeat=";
    protected static final String Tag_TotalJobCount = "TotalJobCount=";
    protected static final String Tag_ActiveJobCount = "ActiveJobCount=";
    protected static final String Tag_UpTime = "UpTime=";

    public JobRendererInfo() {
    }

    public JobRendererInfo(String rendererName, List<String> appIDs, long lastHeartBeat, int currentJobCount, long totalJobCount, long upTime) {
        this.rendererNameDataBinding = rendererName;
        this.appIDsDataBinding = appIDs;
        this.lastHeartBeatDataBinding = lastHeartBeat;
        this.cumulativeJobCountDataBinding = totalJobCount;
        this.activeJobCountDataBinding = currentJobCount;
        this.upTimeDataBinding = upTime;
    }

    public String getRendererNameDataBinding() {
        return this.rendererNameDataBinding;
    }

    public List<String> getApplicationIDsDataBinding() {
        return this.appIDsDataBinding;
    }

    public long getLastHeartBeatTimeDataBinding() {
        return this.lastHeartBeatDataBinding;
    }

    public long getCumulativeJobCountDataBinding() {
        return this.cumulativeJobCountDataBinding;
    }

    public long getUptimeDataBinding() {
        return this.upTimeDataBinding;
    }

    public int getActiveJobCountDataBinding() {
        return this.activeJobCountDataBinding;
    }

    public String serialize() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Tag_Name);
        buffer.append(this.rendererNameDataBinding);
        buffer.append(Separator);
        buffer.append(Tag_ActiveJobCount);
        buffer.append(Integer.toString(this.activeJobCountDataBinding));
        buffer.append(Separator);
        buffer.append(Tag_AppIDs);
        for (String id : this.appIDsDataBinding) {
            buffer.append(id);
            buffer.append(",");
        }
        buffer.append(Separator);
        buffer.append(Tag_LastHeartbeat);
        buffer.append(Long.toString(this.lastHeartBeatDataBinding));
        buffer.append(Separator);
        buffer.append(Tag_TotalJobCount);
        buffer.append(Long.toString(this.cumulativeJobCountDataBinding));
        buffer.append(Separator);
        buffer.append(Tag_UpTime);
        buffer.append(Long.toString(this.upTimeDataBinding));
        buffer.append(Separator);
        return buffer.toString();
    }

    public static JobRendererInfo createFromData(String data) {
        String name = RunHistory.GetParameterFromHistoryLine(data, Tag_Name);
        String idString = RunHistory.GetParameterFromHistoryLine(data, Tag_AppIDs);
        String[] ids = idString.split(",");
        ArrayList<String> appIDs = new ArrayList<String>();
        for (String id : ids) {
            if (id.length() <= 0) continue;
            appIDs.add(id);
        }
        long totalJobCount = JobRendererInfo.getLongValue(data, Tag_TotalJobCount);
        long upTime = JobRendererInfo.getLongValue(data, Tag_UpTime);
        long lastHeartbeat = JobRendererInfo.getLongValue(data, Tag_LastHeartbeat);
        long activeJobCount = JobRendererInfo.getLongValue(data, Tag_ActiveJobCount);
        return new JobRendererInfo(name, appIDs, lastHeartbeat, (int)activeJobCount, totalJobCount, upTime);
    }

    private static long getLongValue(String data, String tag) {
        String numString = RunHistory.GetParameterFromHistoryLine(data, tag);
        try {
            return Long.parseLong(numString);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }
}

