/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.AbstractEventInfo;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.FlowPFD;
import com.sas.scheduler.model.GroupingEventInfo;
import com.sas.scheduler.model.JobDependency;
import com.sas.scheduler.model.JobEventInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.model.TriggerEventInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="FlowInfo", propOrder={"schedulerDataBinding", "activeTriggerDataBinding", "availableTriggersDataBinding", "triggerTypeDataBinding", "responsiblePartyDataBinding", "jobsDataBinding", "jobDependenciesDataBinding", "submittedDataBinding", "flowDefinitionIdDataBinding", "scheduledUserIdDataBinding", "scheduleIdDataBinding", "triggerIdDataBinding", "emailNotificationDataBinding", "emailAddressDataBinding", "completionLevelDataBinding", "completionSelectedJobNamesDataBinding", "endBehaviorDataBinding", "exitcodeBehaviorDataBinding", "exclusiveDataBinding", "saveLayoutDataBinding", "schedulerQueueDataBinding", "jobDefaultEmailNotificationDataBinding", "jobDefaultEmailAddressDataBinding", "jobDefaultPriorityDataBinding", "jobDefaultEnvironmentVariablesDataBinding", "jobDefaultExceptionHandlersDataBinding"})
public class FlowInfo
extends DisplayInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="SchedulerServer", required=true)
    protected SchedulerServerInfo schedulerDataBinding;
    @XmlElement(name="ActiveTrigger", required=true)
    protected TriggerEventInfo activeTriggerDataBinding;
    @XmlElement(name="AvailableTriggers")
    protected List<TriggerEventInfo> availableTriggersDataBinding;
    @XmlElement(name="TriggerType", required=true)
    protected String triggerTypeDataBinding;
    @XmlElement(name="ResponsibleParty")
    protected String responsiblePartyDataBinding;
    @XmlElement(name="Job")
    protected List<DisplayInfo> jobsDataBinding;
    @XmlElement(name="JobDependency")
    protected List<JobDependency> jobDependenciesDataBinding;
    @XmlElement(name="Submitted")
    protected boolean submittedDataBinding;
    @XmlElement(name="FlowDefinitionId")
    protected String flowDefinitionIdDataBinding;
    @XmlElement(name="ScheduledUserId")
    protected String scheduledUserIdDataBinding;
    @XmlElement(name="ScheduleId")
    protected Long scheduleIdDataBinding;
    @XmlElement(name="TriggerId")
    protected String triggerIdDataBinding;
    @XmlElement(name="EmailNotification")
    protected Integer emailNotificationDataBinding;
    @XmlElement(name="EmailAddress")
    protected String emailAddressDataBinding;
    @XmlElement(name="CompletionLevel")
    protected Integer completionLevelDataBinding;
    @XmlElement(name="CompletionSelectedJobNames")
    protected List<String> completionSelectedJobNamesDataBinding;
    @XmlElement(name="EndBehavior")
    protected Integer endBehaviorDataBinding;
    @XmlElement(name="ExitcodeBehavior")
    protected Integer exitcodeBehaviorDataBinding;
    @XmlElement(name="Exclusive")
    protected boolean exclusiveDataBinding;
    @XmlElement(name="SavaLayout")
    protected boolean saveLayoutDataBinding;
    @XmlElement(name="SchedulerQueue")
    protected String schedulerQueueDataBinding;
    @XmlElement(name="JobDefaultEmailNotification")
    protected Integer jobDefaultEmailNotificationDataBinding;
    @XmlElement(name="JobDefaultEmailAddress")
    protected String jobDefaultEmailAddressDataBinding;
    @XmlElement(name="JobDefaultPriority")
    protected Integer jobDefaultPriorityDataBinding;
    @XmlElement(name="JobDefaultEnvironmentVariables")
    protected String jobDefaultEnvironmentVariablesDataBinding;
    @XmlElement(name="JobDefaultExceptionHandlers")
    protected String jobDefaultExceptionHandlersDataBinding;
    private static final ResourceBundle m_bundle;
    private static final int IdDigits = 8;
    @XmlTransient
    private boolean m_dirty = false;
    @XmlTransient
    private Vector m_data = null;
    @XmlTransient
    private int m_nextID = 1;
    @XmlTransient
    private NumberFormat m_nf;
    @XmlTransient
    private HashMap m_grouping = new HashMap();
    @XmlTransient
    private HashMap m_ids = new HashMap();
    @XmlTransient
    private FlowPFD m_pfd = null;
    public static final String IconName;
    public static final String IconError;
    public static final String IconNewName;
    public static final String IconScheduledName;
    public static final String IconScheduledError;
    public static final String StrGroupAnd = "AND";
    public static final int Group_AND = 31;
    public static final String StrGroupOr = "OR";
    public static final int Group_OR = 32;
    public static final String TableHeader_ID;
    public static final String TableHeader_Name;
    public static final String TableHeader_Type;
    public static final String TableHeader_Event;
    public static final String TableHeader_Description;
    public static final String TableHeader_Location;
    public static final String TableHeader_RunAs;
    public static final String TableHeader_Predecessors;
    public static final String PredecessorSeparator;
    public static final String Table_Name_FlowTrigger = "Flow Trigger";
    public static final String Table_Type_Flow = "TopFlow";
    public static final String Table_Type_Scheduler = "Scheduler";
    public static final String GateEventRole = "Gate";
    public static final String TriggerEventRole = "TriggerEvent";
    public static final String TimeEventRole = "TimeEvent";
    public static final String FileEventRole = "FileEvent";
    public static final String JobDependencyRole = "JobEvent";
    public static final String JobEventRole = "JOB";
    public static final String FlowEventRole = "FLOW";
    public static final String TRIGGERTYPE_RUNNOW = "RunNow";
    public static final String TRIGGERTYPE_MANUAL = "Manual";
    public static final String TRIGGERTYPE_EVENT = "Event";
    public static final int TIME_event = 40;
    public static final int FILE_event = 41;
    public static final int OP_MIN = 21;
    public static final int OP_MAX = 27;
    public static final String ArithmeticOperator_Equal_Text;
    public static final String ArithmeticOperator_Equal_Symbol;
    public static final int Compare_Equal = 21;
    public static final String ArithmeticOperator_NotEqual_Text;
    public static final String ArithmeticOperator_NotEqual_Symbol;
    public static final int Compare_NotEqual = 22;
    public static final String ArithmeticOperator_GreaterThan_Text;
    public static final String ArithmeticOperator_GreaterThan_Symbol;
    public static final int Compare_GreaterThan = 23;
    public static final String ArithmeticOperator_GreaterThanEqual_Text;
    public static final String ArithmeticOperator_GreaterThanEqual_Symbol;
    public static final int Compare_GreaterThanEqual = 24;
    public static final String ArithmeticOperator_LessThan_Text;
    public static final String ArithmeticOperator_LessThan_Symbol;
    public static final int Compare_LessThan = 25;
    public static final String ArithmeticOperator_LessThanEqual_Text;
    public static final String ArithmeticOperator_LessThanEqual_Symbol;
    public static final int Compare_LessThanEqual = 26;
    public static final String ArithmeticOperator_Negation_Symbol;
    public static final int Compare_Not = 27;
    public static final int FLOWBYGROUP_NAME = 0;
    public static final int FLOWBYGROUP_APPLICATION = 1;
    public static final int FLOWBYGROUP_SERVER = 2;
    public static final int FLOWBYGROUP_USER = 3;
    public static final int FLOWBYGROUP_JOBS = 4;
    public static final int FLOWBYGROUP_MAX = 5;
    public static final int EMAILNOTIFY_None = -1;
    public static final int EMAILNOTIFY_Start = 0;
    public static final int EMAILNOTIFY_StartEnd = 1;
    public static final int EMAILNOTIFY_StartExit = 2;
    public static final int EMAILNOTIFY_Exit = 3;
    public static final int EMAILNOTIFY_End = 4;
    public static final int FLOWCOMPLETION_None = 0;
    public static final int FLOWCOMPLETION_Default = 1;
    public static final int FLOWCOMPLETION_AllSelected = 2;
    public static final int FLOWCOMPLETION_AnySelected = 3;
    public static final int FLOWENDBEHAVIOR_None = 0;
    public static final int FLOWENDBEHAVIOR_Stop = 1;
    public static final int FLOWENDBEHAVIOR_Continue = 2;
    public static final int FLOWENDBEHAVIOR_Continue_Delay = 3;
    public static final int FLOWEXITCODE_None = 0;
    public static final int FLOWEXITCODE_last = 1;
    public static final int FLOWEXITCODE_sum = 2;
    public static final int JOBPRIORITY_None = -1;
    public static final int JOBPRIORITY_Top = 0;
    public static final int JOBPRIORITY_High = 1;
    public static final int JOBPRIORITY_Normal = 2;
    public static final int JOBPRIORITY_Medium = 3;
    public static final int JOBPRIORITY_Low = 4;

    public FlowInfo() {
        this.availableTriggersDataBinding = new ArrayList<TriggerEventInfo>();
        this.triggerTypeDataBinding = TRIGGERTYPE_RUNNOW;
        this.submittedDataBinding = false;
        this.scheduleIdDataBinding = 0L;
        this.jobsDataBinding = new ArrayList<DisplayInfo>();
        this.jobDependenciesDataBinding = new ArrayList<JobDependency>();
        this.emailNotificationDataBinding = -1;
        this.completionSelectedJobNamesDataBinding = new ArrayList<String>();
        this.completionLevelDataBinding = 1;
        this.endBehaviorDataBinding = 1;
        this.exitcodeBehaviorDataBinding = 2;
        this.exclusiveDataBinding = false;
        this.saveLayoutDataBinding = false;
        this.jobDefaultEmailNotificationDataBinding = -1;
        this.jobDefaultPriorityDataBinding = -1;
    }

    public FlowInfo(String name, TriggerEventInfo trigger, SchedulerServerInfo scheduler) {
        this(name, trigger, null, scheduler, trigger != null || scheduler != null);
    }

    public FlowInfo(String name, TriggerEventInfo trigger, List<DisplayInfo> jobs, SchedulerServerInfo scheduler) {
        this(name, trigger, jobs, scheduler, trigger != null || scheduler != null || jobs != null);
    }

    private FlowInfo(String name, TriggerEventInfo trigger, List<DisplayInfo> jobs, SchedulerServerInfo scheduler, boolean display_only) {
        super(name, null, IconName);
        this.setDisplayOnlyDataBinding(display_only);
        this.activeTriggerDataBinding = trigger;
        this.availableTriggersDataBinding = new ArrayList<TriggerEventInfo>();
        this.availableTriggersDataBinding.add(trigger);
        this.triggerTypeDataBinding = trigger != null ? trigger.getType() : TRIGGERTYPE_RUNNOW;
        this.jobsDataBinding = new ArrayList<DisplayInfo>();
        if (jobs != null) {
            this.jobsDataBinding.addAll(jobs);
        }
        this.schedulerDataBinding = scheduler;
        this.m_nf = NumberFormat.getInstance();
        this.m_nf.setMaximumIntegerDigits(8);
        this.m_nf.setMinimumIntegerDigits(1);
        this.m_nf.setGroupingUsed(false);
        this.jobDependenciesDataBinding = new ArrayList<JobDependency>();
        this.completionSelectedJobNamesDataBinding = new ArrayList<String>();
        this.submittedDataBinding = false;
        this.scheduleIdDataBinding = 0L;
        this.emailNotificationDataBinding = -1;
        this.completionLevelDataBinding = 1;
        this.endBehaviorDataBinding = 1;
        this.exitcodeBehaviorDataBinding = 2;
        this.exclusiveDataBinding = false;
        this.saveLayoutDataBinding = false;
        this.jobDefaultEmailNotificationDataBinding = -1;
        this.jobDefaultPriorityDataBinding = -1;
    }

    public void resetDirty(String id) {
        if (this.getId().compareTo(id) == 0) {
            this.m_dirty = false;
        }
    }

    public boolean isDirty() {
        return this.m_dirty;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    public static String getIconName(boolean scheduled, boolean errors) {
        if (scheduled) {
            if (errors) {
                return IconScheduledError;
            }
            return IconScheduledName;
        }
        if (errors) {
            return IconError;
        }
        return IconName;
    }

    public static Vector getColumns(boolean localized) {
        if (localized) {
            return FlowInfo.getColumns();
        }
        String strClassName = FlowInfo.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        ResourceBundle bundle = ResourceBundle.getBundle(strBundlePath, Locale.US);
        Vector<String> columnHeaders = new Vector<String>();
        columnHeaders.add(bundle.getString("FlowInfo.TableHeader.Predecessors.txt"));
        columnHeaders.add(bundle.getString("FlowInfo.TableHeader.ID.txt"));
        columnHeaders.add(bundle.getString("FlowInfo.TableHeader.Name.txt"));
        columnHeaders.add(bundle.getString("FlowInfo.TableHeader.Type.txt"));
        columnHeaders.add(bundle.getString("FlowInfo.TableHeader.Event.txt"));
        columnHeaders.add(bundle.getString("FlowInfo.TableHeader.Location.txt"));
        columnHeaders.add(bundle.getString("FlowInfo.TableHeader.RunAs.txt"));
        columnHeaders.add(bundle.getString("FlowInfo.TableHeader.Description.txt"));
        return columnHeaders;
    }

    public static Vector<String> getColumns() {
        Vector<String> columnHeaders = new Vector<String>();
        columnHeaders.add(TableHeader_Predecessors);
        columnHeaders.add(TableHeader_ID);
        columnHeaders.add(TableHeader_Name);
        columnHeaders.add(TableHeader_Type);
        columnHeaders.add(TableHeader_Event);
        columnHeaders.add(TableHeader_Location);
        columnHeaders.add(TableHeader_RunAs);
        columnHeaders.add(TableHeader_Description);
        return columnHeaders;
    }

    public Vector getData() {
        return this.getData(false);
    }

    public Vector<Vector> getData(boolean giveCondition) {
        if (this.m_data == null) {
            this.m_data = new Vector();
            if (this.activeTriggerDataBinding != null && this.triggerTypeDataBinding != null && this.triggerTypeDataBinding.compareTo(TRIGGERTYPE_RUNNOW) != 0 && this.triggerTypeDataBinding.compareTo(TRIGGERTYPE_MANUAL) != 0) {
                Vector<Object> row;
                AbstractEventInfo t = this.activeTriggerDataBinding.getEvent();
                if (t instanceof GroupingEventInfo) {
                    GroupingEventInfo gei = (GroupingEventInfo)t;
                    row = new Vector<Object>();
                    row.add(" ");
                    row.add(gei.getId());
                    row.add(Table_Name_FlowTrigger);
                    row.add(gei.getEventType());
                    if (giveCondition) {
                        row.add(this.fixIt(gei.toString()));
                    } else {
                        row.add(" ");
                    }
                    row.add(" ");
                    row.add(" ");
                    if (giveCondition) {
                        row.add(this.fixIt(gei.getDescription()));
                    } else {
                        row.add(" ");
                    }
                    this.m_data.add(0, row);
                    List<DisplayInfo> triggers = ((GroupingEventInfo)t).getDependencies();
                    int numTriggers = triggers.size();
                    for (int i = 0; i < numTriggers; ++i) {
                        DisplayInfo trigger = triggers.get(i);
                        String type = null;
                        if (trigger instanceof TimeEventInfo) {
                            type = TimeEventRole;
                        } else if (trigger instanceof FileEventInfo) {
                            type = FileEventRole;
                        }
                        if (trigger == null) continue;
                        trigger.setId(this.genId(trigger.toString()));
                        row = new Vector();
                        row.add(t.getId());
                        row.add(trigger.getId());
                        row.add(Table_Name_FlowTrigger);
                        row.add(type);
                        if (giveCondition) {
                            row.add(this.fixIt(trigger.toString()));
                        } else {
                            row.add(" ");
                        }
                        row.add(" ");
                        row.add(" ");
                        if (giveCondition) {
                            row.add(this.fixIt(trigger.getDescription()));
                        } else {
                            row.add(" ");
                        }
                        this.m_data.add(0, row);
                    }
                } else {
                    TriggerEventInfo trigger = this.activeTriggerDataBinding;
                    trigger.setId(this.genId(trigger.toString()));
                    row = new Vector();
                    row.add(" ");
                    row.add(trigger.getId());
                    row.add(Table_Name_FlowTrigger);
                    row.add(trigger.getType());
                    if (giveCondition) {
                        row.add(this.fixIt(trigger.toString()));
                    } else {
                        row.add(" ");
                    }
                    row.add(" ");
                    row.add(" ");
                    if (giveCondition && trigger.getEvent() != null) {
                        row.add(this.fixIt(trigger.getEvent().getDescription()));
                    } else {
                        row.add(" ");
                    }
                    this.m_data.add(0, row);
                }
            }
            int numTriggers = this.availableTriggersDataBinding != null ? this.availableTriggersDataBinding.size() : 0;
            for (int i = 0; i < numTriggers; ++i) {
                TriggerEventInfo tei = this.availableTriggersDataBinding.get(i);
                if (tei == null || tei.getType() == null || tei.getType().compareTo(TRIGGERTYPE_RUNNOW) == 0 || tei.getType().compareTo(TRIGGERTYPE_MANUAL) == 0 || tei.equals(this.activeTriggerDataBinding)) continue;
                tei.setId(this.genId(tei.toString()));
                Vector<String> row = new Vector<String>();
                row.add(" ");
                row.add(tei.getId());
                row.add(tei.getEvent().toString());
                row.add(tei.getType());
                if (giveCondition) {
                    row.add(this.fixIt(tei.toString()));
                } else {
                    row.add(" ");
                }
                row.add(" ");
                row.add(" ");
                if (giveCondition && tei.getEvent() != null) {
                    row.add(tei.getEvent().getDescription());
                } else {
                    row.add(" ");
                }
                this.m_data.add(row);
            }
            int numSteps = this.jobsDataBinding == null ? 0 : this.jobsDataBinding.size();
            for (int i = 0; i < numSteps; ++i) {
                DisplayInfo job = this.jobsDataBinding.get(i);
                this.m_data.addAll(this.processJob(job, giveCondition));
            }
        }
        return this.m_data;
    }

    public String getTriggerType() {
        return this.getTriggerTypeDataBinding();
    }

    public void setTriggerType(String triggerType) {
        this.triggerTypeDataBinding = triggerType;
    }

    public TriggerEventInfo getTriggerEvent() {
        return this.activeTriggerDataBinding;
    }

    public boolean setTriggerEvent(TriggerEventInfo event) {
        if (event == null) {
            this.activeTriggerDataBinding = null;
            this.triggerTypeDataBinding = TRIGGERTYPE_RUNNOW;
        } else {
            this.activeTriggerDataBinding = event;
            String string = this.triggerTypeDataBinding = event.getType() != null ? event.getType() : TRIGGERTYPE_RUNNOW;
            if (this.availableTriggersDataBinding == null) {
                AbstractEventInfo d = event.getEvent();
                if (d instanceof GroupingEventInfo) {
                    GroupingEventInfo gei = (GroupingEventInfo)d;
                    for (DisplayInfo di : gei.getDependencies()) {
                        TriggerEventInfo tei;
                        if (di instanceof TimeEventInfo) {
                            tei = new TriggerEventInfo((TimeEventInfo)di, event.getScheduler());
                            this.addTriggerEventList(tei);
                            continue;
                        }
                        if (!(di instanceof FileEventInfo)) continue;
                        tei = new TriggerEventInfo((FileEventInfo)di, event.getScheduler());
                        this.addTriggerEventList(tei);
                    }
                } else {
                    this.addTriggerEventList(event);
                }
            } else {
                AbstractEventInfo d = event.getEvent();
                if (d instanceof GroupingEventInfo) {
                    GroupingEventInfo gei = (GroupingEventInfo)d;
                    for (DisplayInfo di : gei.getDependencies()) {
                        TriggerEventInfo tei;
                        if (di instanceof TimeEventInfo) {
                            tei = new TriggerEventInfo((TimeEventInfo)di, event.getScheduler());
                            this.removeTriggerEventList(tei);
                            this.addTriggerEventList(tei);
                            continue;
                        }
                        if (!(di instanceof FileEventInfo)) continue;
                        tei = new TriggerEventInfo((FileEventInfo)di, event.getScheduler());
                        this.removeTriggerEventList(tei);
                        this.addTriggerEventList(tei);
                    }
                } else if (this.triggerTypeDataBinding.compareTo(TRIGGERTYPE_RUNNOW) != 0 && this.triggerTypeDataBinding.compareTo(TRIGGERTYPE_MANUAL) != 0) {
                    this.removeTriggerEventList(event);
                    this.addTriggerEventList(event);
                }
            }
        }
        this.m_dirty = true;
        return true;
    }

    public List<TriggerEventInfo> getFlowTriggerEvents() {
        ArrayList<TriggerEventInfo> list = new ArrayList<TriggerEventInfo>();
        if (this.availableTriggersDataBinding != null) {
            list.addAll(this.availableTriggersDataBinding);
        }
        return list;
    }

    public List<TriggerEventInfo> getFlowTriggerEvents(String type) {
        ArrayList<TriggerEventInfo> list = new ArrayList<TriggerEventInfo>();
        if (type.compareTo(TRIGGERTYPE_EVENT) == 0) {
            int numTriggers = this.availableTriggersDataBinding != null ? this.availableTriggersDataBinding.size() : 0;
            for (int i = 0; i < numTriggers; ++i) {
                TriggerEventInfo tei = this.availableTriggersDataBinding.get(i);
                if (tei == null || tei.getType() == null || tei.getType().compareTo(TRIGGERTYPE_RUNNOW) == 0 || tei.getType().compareTo(TRIGGERTYPE_MANUAL) == 0) continue;
                list.add(tei);
            }
        } else {
            int numTriggers = this.availableTriggersDataBinding != null ? this.availableTriggersDataBinding.size() : 0;
            for (int i = 0; i < numTriggers; ++i) {
                TriggerEventInfo tei = this.availableTriggersDataBinding.get(i);
                if (tei == null || tei.getType().compareTo(type) != 0) continue;
                list.add(tei);
            }
        }
        return list;
    }

    public boolean addTriggerEventList(TriggerEventInfo trigger) {
        if (trigger == null) {
            return false;
        }
        this.m_dirty = true;
        if (this.availableTriggersDataBinding == null) {
            this.availableTriggersDataBinding = new ArrayList<TriggerEventInfo>();
        }
        return this.availableTriggersDataBinding.add(trigger);
    }

    public boolean removeTriggerEventList(TriggerEventInfo trigger) {
        if (trigger == null) {
            return false;
        }
        String id = trigger.getId();
        if (id == null || this.availableTriggersDataBinding == null) {
            return false;
        }
        for (TriggerEventInfo t : this.availableTriggersDataBinding) {
            String tid = t.getId();
            if (tid == null || id.compareTo(tid) != 0) continue;
            this.m_dirty = true;
            return this.availableTriggersDataBinding.remove(t);
        }
        return false;
    }

    public boolean updateTriggerEventList(TriggerEventInfo trigger) {
        if (trigger == null) {
            return false;
        }
        String id = trigger.getId();
        if (id == null || this.availableTriggersDataBinding == null) {
            return false;
        }
        for (TriggerEventInfo t : this.availableTriggersDataBinding) {
            String tid = t.getId();
            if (tid == null || id.compareTo(tid) != 0) continue;
            this.m_dirty = true;
            this.availableTriggersDataBinding.remove(t);
            return this.availableTriggersDataBinding.add(trigger);
        }
        return false;
    }

    public boolean setTriggerEventList(List<TriggerEventInfo> events) {
        this.setDisplayOnlyDataBinding(false);
        this.m_dirty = true;
        if (this.availableTriggersDataBinding == null) {
            this.availableTriggersDataBinding = new ArrayList<TriggerEventInfo>();
        } else {
            this.availableTriggersDataBinding.clear();
        }
        return this.availableTriggersDataBinding.addAll(events);
    }

    public SchedulerServerInfo getScheduler() {
        return this.schedulerDataBinding;
    }

    public boolean setScheduler(SchedulerServerInfo server) {
        if (server == null) {
            if (this.schedulerDataBinding != null) {
                this.m_dirty = true;
            }
            this.schedulerDataBinding = server;
        } else if (this.schedulerDataBinding != null && !this.schedulerDataBinding.equals(server)) {
            this.schedulerDataBinding = server;
            this.m_dirty = true;
        } else if (this.schedulerDataBinding == null) {
            this.schedulerDataBinding = server;
            this.m_dirty = true;
        }
        this.setDisplayOnlyDataBinding(false);
        return true;
    }

    public GroupingEventInfo getLogicalGrouping(String id) {
        ArrayList groupings = new ArrayList(this.m_grouping.values());
        for (Object obj : groupings) {
            GroupingEventInfo ginfo = (GroupingEventInfo)obj;
            if (ginfo.getId().compareTo(id) != 0) continue;
            return ginfo;
        }
        return null;
    }

    public GroupingEventInfo getLogicalGrouping(JobInfo job) {
        return this.getLogicalGrouping((DisplayInfo)job);
    }

    public GroupingEventInfo getLogicalGrouping(FlowInfo subflow) {
        return this.getLogicalGrouping((DisplayInfo)subflow);
    }

    private GroupingEventInfo getLogicalGrouping(DisplayInfo job) {
        GroupingEventInfo grouping = (GroupingEventInfo)this.m_grouping.get(job);
        return grouping;
    }

    public boolean setLogicalGrouping(JobInfo job, GroupingEventInfo grouping) {
        return this.setLogicalGrouping((DisplayInfo)job, grouping);
    }

    public boolean setLogicalGrouping(FlowInfo subflow, GroupingEventInfo grouping) {
        return this.setLogicalGrouping((DisplayInfo)subflow, grouping);
    }

    private boolean setLogicalGrouping(DisplayInfo job, GroupingEventInfo grouping) {
        if (grouping.getEventType() == 0 || grouping.getEventType() == 1) {
            return this.m_grouping.put(job, grouping) != null;
        }
        return false;
    }

    public boolean isNotifyEmail() {
        return this.emailNotificationDataBinding != -1;
    }

    public int emailNotificationLevel() {
        return this.emailNotificationDataBinding;
    }

    public String emailAddress() {
        return this.emailAddressDataBinding;
    }

    public boolean setEmailNotification(boolean enabled, int value, String emailaddress) {
        if (enabled) {
            this.emailNotificationDataBinding = value;
            this.emailAddressDataBinding = emailaddress;
        } else {
            this.emailNotificationDataBinding = -1;
            this.emailAddressDataBinding = null;
        }
        this.m_dirty = true;
        return true;
    }

    public int completionLevel() {
        return this.completionLevelDataBinding;
    }

    public List<String> completionSelectedJobs() {
        return this.completionSelectedJobNamesDataBinding;
    }

    public boolean hasExclusive() {
        return this.exclusiveDataBinding;
    }

    public boolean setExclusive(boolean enabled) {
        if (this.exclusiveDataBinding != enabled) {
            this.m_dirty = true;
            this.exclusiveDataBinding = enabled;
        }
        return true;
    }

    public boolean saveLayout() {
        return this.saveLayoutDataBinding;
    }

    public boolean setSaveLayout(boolean enabled) {
        if (this.saveLayoutDataBinding != enabled) {
            this.m_dirty = true;
            this.saveLayoutDataBinding = enabled;
        }
        return true;
    }

    public boolean hasAdvanceCompletion() {
        switch (this.completionLevelDataBinding) {
            default: {
                return false;
            }
            case 2: 
            case 3: 
        }
        return true;
    }

    public boolean setCompletion(boolean enabled, int value, List<String> selectedJobNames) {
        if (enabled) {
            this.completionLevelDataBinding = value;
            this.completionSelectedJobNamesDataBinding = selectedJobNames;
        } else {
            this.completionLevelDataBinding = 1;
            this.completionSelectedJobNamesDataBinding = null;
        }
        this.m_dirty = true;
        return true;
    }

    public String getScheduleDefinitionId() {
        return this.flowDefinitionIdDataBinding;
    }

    public boolean setScheduleDefinitionId(String id) {
        this.flowDefinitionIdDataBinding = id;
        return true;
    }

    public long getScheduleID() {
        return this.scheduleIdDataBinding;
    }

    public boolean setScheduleID(long id) {
        this.scheduleIdDataBinding = id;
        return true;
    }

    public boolean isJobDefaultNotifyEmail() {
        return this.jobDefaultEmailNotificationDataBinding != -1;
    }

    public int jobDefaultEmailNotificationLevel() {
        return this.jobDefaultEmailNotificationDataBinding;
    }

    public String jobDefaultEmailAddress() {
        return this.jobDefaultEmailAddressDataBinding;
    }

    public boolean setJobDefaultEmailNotification(boolean enabled, int value, String emailaddress) {
        if (enabled) {
            this.jobDefaultEmailNotificationDataBinding = value;
            this.jobDefaultEmailAddressDataBinding = emailaddress;
        } else {
            this.jobDefaultEmailNotificationDataBinding = -1;
            this.jobDefaultEmailAddressDataBinding = null;
        }
        this.m_dirty = true;
        return true;
    }

    public String getJobDefaultEnvironmentVariables() {
        return this.jobDefaultEnvironmentVariablesDataBinding;
    }

    public boolean setJobDefaultEnvironmentVariables(String id) {
        this.jobDefaultEnvironmentVariablesDataBinding = id;
        return true;
    }

    public String getJobDefaultExceptionHandlers() {
        return this.jobDefaultExceptionHandlersDataBinding;
    }

    public boolean setJobDefaultExceptionHandlers(String value) {
        this.jobDefaultExceptionHandlersDataBinding = value;
        return true;
    }

    public int getJobDefaultPriority() {
        return this.jobDefaultPriorityDataBinding;
    }

    public boolean setJobDefaultPriority(int id) {
        this.jobDefaultPriorityDataBinding = id;
        return true;
    }

    public boolean hasErrors() {
        if (this.schedulerDataBinding == null) {
            return true;
        }
        if (this.jobsDataBinding != null) {
            for (DisplayInfo info : this.jobsDataBinding) {
                JobInfo jinfo;
                FlowInfo finfo;
                if (!(info instanceof FlowInfo ? (finfo = (FlowInfo)info).hasErrors() : info instanceof JobInfo && (jinfo = (JobInfo)info).hasErrors())) continue;
                return true;
            }
        }
        return false;
    }

    public void clearErrors() {
        if (this.jobsDataBinding != null) {
            for (DisplayInfo info : this.jobsDataBinding) {
                if (info instanceof FlowInfo) {
                    FlowInfo finfo = (FlowInfo)info;
                    finfo.clearErrors();
                    continue;
                }
                if (!(info instanceof JobInfo)) continue;
                JobInfo jinfo = (JobInfo)info;
                jinfo.clearError();
            }
        }
    }

    public List<DisplayInfo> getJobs() {
        return this.jobsDataBinding;
    }

    public JobInfo getJob(String id) {
        if (this.jobsDataBinding == null) {
            return null;
        }
        for (DisplayInfo obj : this.jobsDataBinding) {
            JobInfo job;
            if (!(obj instanceof JobInfo) || (job = (JobInfo)obj).getId().compareTo(id) != 0) continue;
            return job;
        }
        return null;
    }

    public DisplayInfo getItem(String id) {
        if (this.jobsDataBinding == null) {
            return null;
        }
        for (DisplayInfo obj : this.jobsDataBinding) {
            if (obj.getId().compareTo(id) != 0) continue;
            return obj;
        }
        return null;
    }

    public boolean removeJob(DisplayInfo job) {
        if (job == null) {
            return true;
        }
        boolean rc = false;
        int numSteps = this.jobsDataBinding == null ? 0 : this.jobsDataBinding.size();
        for (int i = 0; i < numSteps; ++i) {
            DisplayInfo info = this.jobsDataBinding.get(i);
            if (info.getId().compareTo(job.getId()) != 0) continue;
            this.jobsDataBinding.remove(i);
            this.removeJobDependency(info.getId());
            rc = true;
            break;
        }
        this.m_dirty = true;
        return rc;
    }

    public boolean convertJobInfoToFlowInfo(JobInfo job, FlowInfo subflow) {
        if (job == null || subflow == null) {
            return false;
        }
        int numSteps = this.jobsDataBinding == null ? 0 : this.jobsDataBinding.size();
        for (int i = 0; i < numSteps; ++i) {
            DisplayInfo info = this.jobsDataBinding.get(i);
            if (info.getId().compareTo(job.getId()) != 0) continue;
            if (info instanceof FlowInfo) {
                return true;
            }
            this.jobsDataBinding.remove(i);
            this.jobsDataBinding.add(i, subflow);
            this.m_dirty = true;
            return true;
        }
        return false;
    }

    public boolean addJob(DisplayInfo job) {
        if (this.jobsDataBinding == null) {
            this.jobsDataBinding = new ArrayList<DisplayInfo>();
        }
        this.m_dirty = true;
        return this.jobsDataBinding.add(job);
    }

    public boolean resetEventId(String oldId, String newId) {
        if (this.jobDependenciesDataBinding == null) {
            return false;
        }
        for (JobDependency jobDependency : this.jobDependenciesDataBinding) {
            if (!oldId.equals(jobDependency.getNodeId())) continue;
            jobDependency.setNodeId(newId);
            this.m_dirty = true;
            return true;
        }
        return false;
    }

    public boolean setJobs(List<DisplayInfo> jobs) {
        this.jobsDataBinding = new ArrayList<DisplayInfo>();
        this.m_dirty = true;
        return this.jobsDataBinding.addAll(jobs);
    }

    public boolean addEvent(DisplayInfo node, AbstractEventInfo e) {
        if (e == null) {
            return false;
        }
        AbstractEventInfo event = null;
        JobDependency jobDependency = null;
        if (node instanceof JobInfo || node instanceof FlowInfo) {
            if (this.jobDependenciesDataBinding == null) {
                this.jobDependenciesDataBinding = new ArrayList<JobDependency>();
            }
            for (int x = 0; x < this.jobDependenciesDataBinding.size(); ++x) {
                JobDependency jdep = this.jobDependenciesDataBinding.get(x);
                if (!jdep.getNodeId().equals(node.getId())) continue;
                jobDependency = jdep;
                event = jobDependency.getEvent();
                break;
            }
            if (event == null) {
                if (jobDependency == null) {
                    jobDependency = new JobDependency();
                    jobDependency.setNodeId(node.getId());
                    jobDependency.setEvent(e);
                    this.jobDependenciesDataBinding.add(jobDependency);
                } else {
                    jobDependency.setEvent(e);
                }
            } else if (event instanceof GroupingEventInfo) {
                GroupingEventInfo gei = (GroupingEventInfo)event;
                if (!gei.equals(e)) {
                    gei.addDependency(e);
                }
            } else if (e instanceof GroupingEventInfo) {
                GroupingEventInfo gei = (GroupingEventInfo)e;
                if (!gei.equals(event)) {
                    this.setLogicalGrouping(node, gei);
                    gei.addDependency(event);
                    this.setEvent(node.getId(), gei);
                    for (int x = 0; x < this.jobDependenciesDataBinding.size(); ++x) {
                        JobDependency jdep = this.jobDependenciesDataBinding.get(x);
                        if (!jdep.getNodeId().equals(node.getId())) continue;
                        jobDependency = jdep;
                        jobDependency.setEvent(gei);
                        break;
                    }
                    if (jobDependency == null) {
                        jobDependency = new JobDependency();
                        jobDependency.setNodeId(node.getId());
                        jobDependency.setEvent(gei);
                        this.jobDependenciesDataBinding.add(jobDependency);
                    }
                }
            } else {
                GroupingEventInfo gei = this.getLogicalGrouping(node);
                if (gei == null) {
                    if (node instanceof JobInfo) {
                        gei = new GroupingEventInfo((JobInfo)node, 1);
                    } else {
                        gei = new GroupingEventInfo((FlowInfo)node);
                        gei.setEventType(1);
                    }
                }
                gei.addDependency(event);
                gei.addDependency(e);
                this.setEvent(node.getId(), gei);
                for (int x = 0; x < this.jobDependenciesDataBinding.size(); ++x) {
                    JobDependency jdep = this.jobDependenciesDataBinding.get(x);
                    if (!jdep.getNodeId().equals(node.getId())) continue;
                    jobDependency = jdep;
                    jobDependency.setEvent(gei);
                    break;
                }
                if (jobDependency == null) {
                    jobDependency = new JobDependency();
                    jobDependency.setNodeId(node.getId());
                    jobDependency.setEvent(gei);
                    this.jobDependenciesDataBinding.add(jobDependency);
                }
            }
        } else if (node instanceof GroupingEventInfo) {
            GroupingEventInfo gei = (GroupingEventInfo)node;
            gei.addDependency(e);
        }
        this.m_dirty = true;
        return true;
    }

    private void setEvent(String id, AbstractEventInfo event) {
        if (this.jobDependenciesDataBinding == null) {
            this.jobDependenciesDataBinding = new ArrayList<JobDependency>();
        }
        for (JobDependency jobDependency : this.jobDependenciesDataBinding) {
            if (!id.equals(jobDependency.getNodeId())) continue;
            jobDependency.setEvent(event);
            break;
        }
    }

    public List<DisplayInfo> getEvents(DisplayInfo node) {
        if (node == null) {
            return new ArrayList<DisplayInfo>();
        }
        ArrayList<DisplayInfo> list = null;
        AbstractEventInfo di = this.getEvent(node);
        if (di == null) {
            di = this.getEvent(node.getId());
        }
        if (di instanceof GroupingEventInfo) {
            GroupingEventInfo gi = (GroupingEventInfo)di;
            list = gi.getDependencies();
        } else {
            list = new ArrayList<AbstractEventInfo>();
            list.add(di);
        }
        return list;
    }

    public List<AbstractEventInfo> getEvents2(DisplayInfo node) {
        if (node == null) {
            return new ArrayList<AbstractEventInfo>();
        }
        ArrayList<AbstractEventInfo> list = null;
        AbstractEventInfo di = this.getEvent(node);
        if (di == null) {
            di = this.getEvent(node.getId());
        }
        if (di instanceof GroupingEventInfo) {
            GroupingEventInfo gi = (GroupingEventInfo)di;
            list = gi.getDependencies2();
        } else {
            list = new ArrayList<AbstractEventInfo>();
            list.add(di);
        }
        return list;
    }

    public List<DisplayInfo> getCompletesSuccessors(DisplayInfo node) {
        ArrayList<DisplayInfo> list = new ArrayList<DisplayInfo>();
        String id = node.getId();
        for (JobDependency jobDependency : this.jobDependenciesDataBinding) {
            AbstractEventInfo event = jobDependency.getEvent();
            if (event instanceof JobEventInfo) {
                JobEventInfo jei = (JobEventInfo)event;
                int type = jei.getEventType();
                if (type != 0 && type != 10 && type != 2 || !id.equals(jobDependency.getEvent().getId())) continue;
                String successorId = jobDependency.getNodeId();
                int numSteps = this.jobsDataBinding == null ? 0 : this.jobsDataBinding.size();
                for (int i = 0; i < numSteps; ++i) {
                    DisplayInfo job = this.jobsDataBinding.get(i);
                    if (successorId.compareTo(job.getId()) != 0 || list.contains(job)) continue;
                    list.add(job);
                }
                continue;
            }
            if (!(event instanceof GroupingEventInfo)) continue;
            GroupingEventInfo gei = (GroupingEventInfo)event;
            List<AbstractEventInfo> events = gei.getEvents();
            for (AbstractEventInfo e : events) {
                JobEventInfo jei;
                int type;
                if (!(e instanceof JobEventInfo) || (type = (jei = (JobEventInfo)e).getEventType()) != 0 && type != 10 && type != 2 || !id.equals(jei.getId())) continue;
                String successorId = jobDependency.getNodeId();
                int numSteps = this.jobsDataBinding == null ? 0 : this.jobsDataBinding.size();
                for (int i = 0; i < numSteps; ++i) {
                    DisplayInfo job = this.jobsDataBinding.get(i);
                    if (successorId.compareTo(job.getId()) != 0 || list.contains(job)) continue;
                    list.add(job);
                }
            }
        }
        return list;
    }

    public List<DisplayInfo> getFailedSuccessors(DisplayInfo node) {
        ArrayList<DisplayInfo> list = new ArrayList<DisplayInfo>();
        String id = node.getId();
        for (JobDependency jobDependency : this.jobDependenciesDataBinding) {
            AbstractEventInfo event = jobDependency.getEvent();
            if (event instanceof JobEventInfo) {
                JobEventInfo jei = (JobEventInfo)event;
                int type = jei.getEventType();
                if (type == 0 || type == 10 || type == 2 || !id.equals(jobDependency.getEvent().getId())) continue;
                String successorId = jobDependency.getNodeId();
                int numSteps = this.jobsDataBinding == null ? 0 : this.jobsDataBinding.size();
                for (int i = 0; i < numSteps; ++i) {
                    DisplayInfo job = this.jobsDataBinding.get(i);
                    if (successorId.compareTo(job.getId()) != 0) continue;
                    list.add(job);
                }
                continue;
            }
            if (!(event instanceof GroupingEventInfo)) continue;
            GroupingEventInfo gei = (GroupingEventInfo)event;
            List<AbstractEventInfo> events = gei.getEvents();
            for (AbstractEventInfo e : events) {
                JobEventInfo jei;
                int type;
                if (!(e instanceof JobEventInfo) || (type = (jei = (JobEventInfo)e).getEventType()) == 0 || type == 10 || type == 2 || !id.equals(jei.getId())) continue;
                String successorId = jobDependency.getNodeId();
                int numSteps = this.jobsDataBinding == null ? 0 : this.jobsDataBinding.size();
                for (int i = 0; i < numSteps; ++i) {
                    DisplayInfo job = this.jobsDataBinding.get(i);
                    if (successorId.compareTo(job.getId()) != 0) continue;
                    list.add(job);
                }
            }
        }
        return list;
    }

    public List<DisplayInfo> getFailures(DisplayInfo node) {
        ArrayList<DisplayInfo> list = new ArrayList<DisplayInfo>();
        String id = node.getId();
        for (JobDependency jobDependency : this.jobDependenciesDataBinding) {
            if (!id.equals(jobDependency.getEvent().getId())) continue;
            String successorId = jobDependency.getNodeId();
            int numSteps = this.jobsDataBinding == null ? 0 : this.jobsDataBinding.size();
            for (int i = 0; i < numSteps; ++i) {
                DisplayInfo job = this.jobsDataBinding.get(i);
                if (successorId != job.getId()) continue;
                list.add(job);
            }
        }
        return list;
    }

    public List<DisplayInfo> hasComplexDependencies() {
        ArrayList<DisplayInfo> list = new ArrayList<DisplayInfo>();
        int numSteps = this.jobsDataBinding == null ? 0 : this.jobsDataBinding.size();
        for (int i = 0; i < numSteps; ++i) {
            DisplayInfo job = this.jobsDataBinding.get(i);
            if (!this.hasComplexDependencies(job)) continue;
            list.add(job);
        }
        return list;
    }

    public boolean hasComplexDependencies(JobInfo job) {
        return this.hasComplexDependencies((DisplayInfo)job);
    }

    public boolean hasComplexDependencies(FlowInfo subflow) {
        return this.hasComplexDependencies((DisplayInfo)subflow);
    }

    private boolean hasComplexDependencies(DisplayInfo job) {
        AbstractEventInfo dep = this.getEvent(job);
        if (dep instanceof GroupingEventInfo) {
            GroupingEventInfo gei = (GroupingEventInfo)dep;
            for (AbstractEventInfo obj : gei.getDependencies2()) {
                if (!(obj instanceof GroupingEventInfo)) continue;
                return true;
            }
        }
        return false;
    }

    public DisplayInfo getEvent(JobInfo job) {
        return this.getEvent((DisplayInfo)job);
    }

    public DisplayInfo getEvent(FlowInfo subflow) {
        return this.getEvent((DisplayInfo)subflow);
    }

    private AbstractEventInfo getEvent(DisplayInfo job) {
        if (job == null) {
            return null;
        }
        return this.getEvent(job.getId());
    }

    public AbstractEventInfo getEvent(String id) {
        AbstractEventInfo event = null;
        if (this.jobDependenciesDataBinding == null) {
            this.jobDependenciesDataBinding = new ArrayList<JobDependency>();
        }
        for (JobDependency jobDependency : this.jobDependenciesDataBinding) {
            if (!jobDependency.getNodeId().equals(id)) continue;
            event = jobDependency.getEvent();
        }
        return event;
    }

    public boolean removeEvent(DisplayInfo node, AbstractEventInfo e) {
        if (node == null) {
            return false;
        }
        if (node instanceof JobInfo) {
            for (JobDependency jobDependency : this.jobDependenciesDataBinding) {
                if (!jobDependency.getNodeId().equals(node.getId())) continue;
                AbstractEventInfo event = jobDependency.getEvent();
                if (event == null) {
                    return true;
                }
                if (!event.equals(e)) continue;
                jobDependency.setEvent(null);
                this.m_dirty = true;
                return true;
            }
        } else if (node instanceof GroupingEventInfo) {
            GroupingEventInfo gei = (GroupingEventInfo)node;
            this.m_dirty = true;
            return gei.removeDependency(e);
        }
        return false;
    }

    private void removeJobDependency(String nodeId) {
        for (JobDependency jobDependency : this.jobDependenciesDataBinding) {
            if (!jobDependency.getNodeId().equals(nodeId)) continue;
            this.jobDependenciesDataBinding.remove(jobDependency);
            break;
        }
    }

    private String genId(String key) {
        String id = (String)this.m_ids.get(key);
        if (id == null) {
            id = this.m_nf.format(this.m_nextID++);
            this.m_ids.put(key, id);
        }
        return id;
    }

    public FlowPFD getPFD() {
        return this.m_pfd;
    }

    public boolean setPFD(FlowPFD pfd) {
        if (pfd == null) {
            if (this.m_pfd != null) {
                this.m_dirty = true;
            }
            this.m_pfd = pfd;
        } else if (this.m_pfd == null || !this.m_pfd.equals(pfd)) {
            this.m_pfd = pfd;
            this.m_dirty = true;
        }
        return true;
    }

    private Vector processJob(DisplayInfo job, boolean giveCondition) {
        Vector data = new Vector();
        String jobName = job.getName();
        String type = job instanceof JobInfo ? ((JobInfo)job).getType() : "";
        String description = job.getDescription();
        String location = job.getLocation();
        String runas = " ";
        String predecessors = " ";
        String commandline = " ";
        if (job instanceof FlowInfo || type.equalsIgnoreCase(FlowEventRole)) {
            type = FlowEventRole;
        } else {
            type = ((JobInfo)job).getType();
            runas = ((JobInfo)job).getUserId();
            commandline = ((JobInfo)job).getCommandLine();
        }
        DisplayInfo preds = this.getPredecessors(job);
        String jobId = null;
        jobId = giveCondition ? job.getId() : this.genId(job.getId());
        Vector predData = new Vector();
        predecessors = this.getJobPreds(predData, preds, giveCondition);
        Vector<String> row = new Vector<String>();
        row.add(predecessors);
        row.add(jobId);
        row.add(jobName);
        row.add(type);
        row.add(commandline);
        row.add(location);
        row.add(runas);
        row.add(description);
        data.add(0, row);
        data.addAll(predData);
        return data;
    }

    private String getJobPreds(Vector data, DisplayInfo dinfo, boolean giveCondition) {
        if (dinfo == null) {
            return null;
        }
        String predecessors = null;
        if (dinfo instanceof GroupingEventInfo) {
            GroupingEventInfo gei = (GroupingEventInfo)dinfo;
            List<DisplayInfo> preds = gei.getDependencies();
            int numPreds = preds.size();
            for (int x = 0; x < numPreds; ++x) {
                Object[] args;
                Vector<String> row;
                String eid;
                DisplayInfo ei = preds.get(x);
                if (ei instanceof GroupingEventInfo) {
                    String neopreds = this.getJobPreds(data, ei, giveCondition);
                    if (predecessors == null) {
                        predecessors = neopreds;
                        continue;
                    }
                    Object[] args2 = new Object[]{predecessors, neopreds};
                    predecessors = MessageFormat.format(m_bundle.getString("FlowInfo.Table.Predecessor.Concatenate.fmt"), args2);
                    continue;
                }
                if (ei instanceof JobEventInfo) {
                    JobEventInfo jei = (JobEventInfo)ei;
                    eid = this.genId(jei.toString());
                    row = new Vector<String>();
                    row.add(" ");
                    row.add(eid);
                    row.add(JobEventInfo.getEventTypeDescription(jei.getEventType()));
                    row.add(JobDependencyRole);
                    row.add(jei.toString());
                    row.add(" ");
                    row.add(" ");
                    row.add(jei.getDescription());
                    data.add(row);
                    if (predecessors == null) {
                        predecessors = eid;
                        continue;
                    }
                    args = new Object[]{predecessors, eid};
                    predecessors = MessageFormat.format(m_bundle.getString("FlowInfo.Table.Predecessor.Concatenate.fmt"), args);
                    continue;
                }
                if (ei instanceof TimeEventInfo) {
                    TimeEventInfo tei = (TimeEventInfo)ei;
                    eid = this.genId(tei.getId());
                    row = new Vector();
                    row.add(" ");
                    row.add(eid);
                    if (giveCondition) {
                        row.add(this.fixIt(tei.toString()));
                    } else {
                        row.add(tei.toString());
                    }
                    row.add(tei.getType());
                    if (giveCondition) {
                        row.add(this.fixIt(tei.toString()));
                    } else {
                        row.add(tei.toString());
                    }
                    row.add(" ");
                    row.add(" ");
                    if (giveCondition) {
                        row.add(this.fixIt(tei.getDescription()));
                    } else {
                        row.add(" ");
                    }
                    data.add(row);
                    if (predecessors == null) {
                        predecessors = eid;
                        continue;
                    }
                    args = new Object[]{predecessors, eid};
                    predecessors = MessageFormat.format(m_bundle.getString("FlowInfo.Table.Predecessor.Concatenate.fmt"), args);
                    continue;
                }
                if (!(ei instanceof FileEventInfo)) continue;
                FileEventInfo fei = (FileEventInfo)ei;
                eid = this.genId(fei.getId());
                row = new Vector();
                row.add(" ");
                row.add(eid);
                row.add(fei.toString());
                row.add(fei.getType());
                row.add(fei.toString());
                row.add(" ");
                row.add(" ");
                if (giveCondition) {
                    row.add(fei.getDescription());
                } else {
                    row.add(" ");
                }
                data.add(row);
                if (predecessors == null) {
                    predecessors = eid;
                    continue;
                }
                args = new Object[]{predecessors, eid};
                predecessors = MessageFormat.format(m_bundle.getString("FlowInfo.Table.Predecessor.Concatenate.fmt"), args);
            }
            String eid = this.genId(String.valueOf(gei.hashCode()));
            Vector<String> row = new Vector<String>();
            row.add(predecessors);
            row.add(eid);
            row.add(gei.toString());
            row.add(GateEventRole);
            row.add(gei.toString());
            row.add(" ");
            row.add(" ");
            row.add(gei.getDescription());
            data.add(row);
            predecessors = eid;
        } else if (dinfo instanceof JobEventInfo) {
            JobEventInfo jei = (JobEventInfo)dinfo;
            String eid = this.genId(jei.toString());
            Vector<String> row = new Vector<String>();
            row.add(" ");
            row.add(eid);
            row.add(JobEventInfo.getEventTypeDescription(jei.getEventType()));
            row.add(JobDependencyRole);
            row.add(jei.toString());
            row.add(" ");
            row.add(" ");
            row.add(jei.getDescription());
            data.add(row);
            predecessors = eid;
        } else if (dinfo instanceof TimeEventInfo) {
            TimeEventInfo tei = (TimeEventInfo)dinfo;
            String eid = this.genId(tei.getId());
            Vector<String> row = new Vector<String>();
            row.add(" ");
            row.add(eid);
            if (giveCondition) {
                row.add(this.fixIt(tei.toString()));
            } else {
                row.add(tei.toString());
            }
            row.add(tei.getType());
            if (giveCondition) {
                row.add(this.fixIt(tei.toString()));
            } else {
                row.add(tei.toString());
            }
            row.add(" ");
            row.add(" ");
            if (giveCondition) {
                row.add(this.fixIt(tei.getDescription()));
            } else {
                row.add(" ");
            }
            data.add(row);
            predecessors = eid;
        } else if (dinfo instanceof FileEventInfo) {
            FileEventInfo fei = (FileEventInfo)dinfo;
            String eid = this.genId(fei.getId());
            Vector<String> row = new Vector<String>();
            row.add(" ");
            row.add(eid);
            row.add(fei.toString());
            row.add(fei.getType());
            row.add(fei.toString());
            row.add(" ");
            row.add(" ");
            if (giveCondition) {
                row.add(fei.getDescription());
            } else {
                row.add(" ");
            }
            data.add(row);
            predecessors = eid;
        }
        return predecessors;
    }

    private String fixIt(String s) {
        String searchString = ",";
        String replaceString = ";";
        while (s.indexOf(searchString) != -1) {
            if (s.startsWith(searchString)) {
                s = replaceString + s.substring(s.indexOf(searchString) + searchString.length());
                continue;
            }
            s = s.substring(0, s.indexOf(searchString)) + replaceString + s.substring(s.indexOf(searchString) + searchString.length());
        }
        return s;
    }

    private DisplayInfo getPredecessors(DisplayInfo job) {
        if (this.jobDependenciesDataBinding.size() > 0) {
            AbstractEventInfo info = this.getEvent(job.getId());
            return info;
        }
        return null;
    }

    public boolean isFlowSubmitted() {
        return this.submittedDataBinding;
    }

    public boolean setFlowSubmitted(boolean value) {
        if (this.submittedDataBinding != value) {
            this.submittedDataBinding = value;
            this.m_dirty = true;
        }
        return true;
    }

    public boolean setFlowSubmitted(boolean value, String userid) {
        if (this.submittedDataBinding != value) {
            this.submittedDataBinding = value;
            this.m_dirty = true;
        }
        if (!this.submittedDataBinding) {
            if (this.scheduledUserIdDataBinding != null) {
                this.setScheduledUserIdDataBinding(null);
                this.m_dirty = true;
            }
        } else if (userid != null && (this.scheduledUserIdDataBinding == null || this.scheduledUserIdDataBinding.compareTo(userid) != 0)) {
            this.setScheduledUserIdDataBinding(userid);
            this.m_dirty = true;
        }
        return true;
    }

    public String getScheduledUser() {
        return this.scheduledUserIdDataBinding;
    }

    public String getSchedulerQueue() {
        return this.schedulerQueueDataBinding;
    }

    public boolean setSchedulerQueue(String queueName) {
        this.schedulerQueueDataBinding = queueName;
        return true;
    }

    public void checkCircularDependencies() throws InvalidParameterException {
        HashMap<DisplayInfo, List<DisplayInfo>> processedJobs = new HashMap<DisplayInfo, List<DisplayInfo>>();
        for (int i = 0; i < this.jobsDataBinding.size(); ++i) {
            DisplayInfo job = this.jobsDataBinding.get(i);
            List<DisplayInfo> successorJobs = this.processJob(job, new ArrayList<DisplayInfo>(), processedJobs);
            processedJobs.put(job, successorJobs);
        }
    }

    private List<DisplayInfo> processJob(DisplayInfo job, List<DisplayInfo> successorObjects, HashMap<DisplayInfo, List<DisplayInfo>> processedJobs) throws InvalidParameterException {
        if (processedJobs.containsKey(job)) {
            return processedJobs.get(job);
        }
        if (DisplayInfo.infoInList(successorObjects, job)) {
            StringBuffer buffer = new StringBuffer(job.getId());
            for (int j = successorObjects.size(); j > 0; --j) {
                buffer.append(":" + successorObjects.get(j - 1).getId());
            }
            InvalidParameterException ex = new InvalidParameterException(buffer.toString());
            throw ex;
        }
        List<AbstractEventInfo> jobdeps = null;
        int numDeps = 0;
        if (job instanceof GroupingEventInfo) {
            jobdeps = ((GroupingEventInfo)job).getDependencies2();
            numDeps = jobdeps.size();
        } else {
            jobdeps = this.getEvents2(job);
            numDeps = jobdeps.size();
        }
        for (int x = 0; x < jobdeps.size(); ++x) {
            DisplayInfo dep = jobdeps.get(x);
            JobInfo currentJob = null;
            ArrayList<DisplayInfo> successors = new ArrayList<DisplayInfo>(successorObjects);
            successors.add(job);
            if (dep instanceof JobEventInfo) {
                JobEventInfo jei = (JobEventInfo)dep;
                currentJob = ((JobEventInfo)dep).getJobInfo();
                List<DisplayInfo> list = this.processJob(currentJob, successors, processedJobs);
                continue;
            }
            if (!(dep instanceof GroupingEventInfo)) continue;
            GroupingEventInfo gei = (GroupingEventInfo)dep;
            this.processJob(gei, successors, processedJobs);
        }
        successorObjects.add(job);
        return successorObjects;
    }

    public static String createCircularDependencyMessage(String firstSentence, String successorObjects, FlowInfo flow) throws SchedulerException {
        StringBuffer buffer = null;
        String firstid = null;
        String firstname = null;
        for (String jobid : successorObjects.split(":")) {
            String jobname;
            JobInfo job = flow.getJob(jobid);
            String string = jobname = job != null ? job.getName() : jobid;
            if (buffer == null) {
                buffer = new StringBuffer(job.getName());
                firstid = jobid;
                firstname = jobname;
                continue;
            }
            Object[] args0 = new Object[]{jobname};
            buffer.append(MessageFormat.format(m_bundle.getString("FlowInfo.CircularDependencies.Traceback.fmt"), args0));
            if (jobid.compareTo(firstid) == 0) break;
        }
        if (firstSentence == null) {
            String flowName = flow.getName();
            Object[] args1 = new Object[]{firstname, flowName};
            firstSentence = MessageFormat.format(m_bundle.getString("FlowInfo.CircularDependencies.FirstSentence.fmt"), args1);
        }
        Object[] args2 = new Object[]{buffer != null ? buffer.toString() : ""};
        String secondSentence = MessageFormat.format(m_bundle.getString("FlowInfo.CircularDependencies.SecondSentence.fmt"), args2);
        Object[] args3 = new Object[]{firstSentence, secondSentence};
        return MessageFormat.format(m_bundle.getString("FlowInfo.CircularDependencies.Exception.fmt"), args3);
    }

    public void writeObject(OutputStream out) throws IOException {
        byte[] b = null;
        byte[] newline = "\n".getBytes();
        byte[] tab = "\t".getBytes();
        String s = null;
        b = this.getName().getBytes();
        out.write(b);
        out.write(newline);
        if (this.schedulerDataBinding != null) {
            out.write(tab);
            s = "Scheduler: " + this.schedulerDataBinding.toString();
            b = s.getBytes();
            out.write(b);
            out.write(newline);
        }
        if (this.activeTriggerDataBinding != null) {
            TriggerEventInfo trigger;
            if (this.activeTriggerDataBinding.getEvent() instanceof GroupingEventInfo) {
                trigger = this.activeTriggerDataBinding;
                out.write(tab);
                out.write(tab);
                s = "Trigger: " + trigger.toString();
                b = s.getBytes();
                out.write(b);
                out.write(newline);
                List<AbstractEventInfo> triggers = ((GroupingEventInfo)trigger.getEvent()).getDependencies2();
                for (int x = 0; x < triggers.size(); ++x) {
                    DisplayInfo t = triggers.get(x);
                    out.write(tab);
                    out.write(tab);
                    out.write(tab);
                    s = "Trigger Component: " + t.toString();
                    b = s.getBytes();
                    out.write(b);
                    out.write(newline);
                }
            } else {
                trigger = this.activeTriggerDataBinding;
                out.write(tab);
                out.write(tab);
                s = "Trigger: " + trigger.toString();
                b = s.getBytes();
                out.write(b);
                out.write(newline);
            }
        }
        out.write(tab);
        out.write(tab);
        s = "Submitted: ";
        s = s + (this.submittedDataBinding ? "true" : "false");
        b = s.getBytes();
        out.write(b);
        out.write(newline);
        int numSteps = this.jobsDataBinding == null ? 0 : this.jobsDataBinding.size();
        for (int i = 0; i < numSteps; ++i) {
            DisplayInfo job = this.jobsDataBinding.get(i);
            out.write(tab);
            s = "Job: " + job.getId() + ":" + job.getName();
            b = s.getBytes();
            out.write(b);
            out.write(newline);
        }
        if (this.jobDependenciesDataBinding != null) {
            for (JobDependency jobDependency : this.jobDependenciesDataBinding) {
                String nodeId = jobDependency.getNodeId();
                out.write(tab);
                AbstractEventInfo event = jobDependency.getEvent();
                s = "Event: " + nodeId + ":" + event.toString();
                b = s.getBytes();
                out.write(b);
                out.write(newline);
                if (!(event instanceof GroupingEventInfo)) continue;
                ((GroupingEventInfo)event).writeObject(out, "\t\t");
            }
        }
        out.flush();
    }

    public TriggerEventInfo getActiveTriggerDataBinding() {
        return this.activeTriggerDataBinding;
    }

    public void setActiveTriggerDataBinding(TriggerEventInfo value) {
        this.activeTriggerDataBinding = value;
    }

    public List<TriggerEventInfo> getAvailableTriggersDataBinding() {
        if (this.availableTriggersDataBinding == null) {
            this.availableTriggersDataBinding = new ArrayList<TriggerEventInfo>();
        }
        return this.availableTriggersDataBinding;
    }

    public String getTriggerTypeDataBinding() {
        return this.triggerTypeDataBinding;
    }

    public void setTriggerTypeDataBinding(String value) {
        this.triggerTypeDataBinding = value;
    }

    public SchedulerServerInfo getSchedulerDataBinding() {
        return this.schedulerDataBinding;
    }

    public void setSchedulerDataBinding(SchedulerServerInfo value) {
        this.schedulerDataBinding = value;
    }

    public boolean isSubmittedDataBinding() {
        return this.submittedDataBinding;
    }

    public void setSubmittedDataBinding(boolean value) {
        this.submittedDataBinding = value;
    }

    public String getFlowDefinitionIdDataBinding() {
        return this.flowDefinitionIdDataBinding;
    }

    public void setFlowDefinitionIdDataBinding(String value) {
        this.flowDefinitionIdDataBinding = value;
    }

    public String getScheduledUserIdDataBinding() {
        return this.scheduledUserIdDataBinding;
    }

    public void setScheduledUserIdDataBinding(String value) {
        this.scheduledUserIdDataBinding = value;
    }

    public Long getScheduleIdDataBinding() {
        return this.scheduleIdDataBinding;
    }

    public void setScheduleIdDataBinding(Long value) {
        this.scheduleIdDataBinding = value;
    }

    public String getTriggerId() {
        return this.triggerIdDataBinding;
    }

    public void setTriggerId(String value) {
        this.triggerIdDataBinding = value;
    }

    public String getResponsiblePartyDataBinding() {
        return this.responsiblePartyDataBinding;
    }

    public void setResponsiblePartyDataBinding(String value) {
        this.responsiblePartyDataBinding = value;
    }

    public List<DisplayInfo> getJobsDataBinding() {
        if (this.jobsDataBinding == null) {
            this.jobsDataBinding = new ArrayList<DisplayInfo>();
        }
        return this.jobsDataBinding;
    }

    public List<JobDependency> getJobDependenciesDataBinding() {
        if (this.jobDependenciesDataBinding == null) {
            this.jobDependenciesDataBinding = new ArrayList<JobDependency>();
        }
        return this.jobDependenciesDataBinding;
    }

    public Integer getEmailNotificationDataBinding() {
        return this.emailNotificationDataBinding;
    }

    public void setEmailNotificationDataBinding(Integer value) {
        this.emailNotificationDataBinding = value;
    }

    public String getEmailAddressDataBinding() {
        return this.emailAddressDataBinding;
    }

    public void setEmailAddressDataBinding(String value) {
        this.emailAddressDataBinding = value;
    }

    public Integer getCompletionLevelDataBinding() {
        return this.completionLevelDataBinding;
    }

    public void setCompletionLevelDataBinding(Integer value) {
        this.completionLevelDataBinding = value;
    }

    public List<String> getCompletionSelectedJobNamesDataBinding() {
        if (this.completionSelectedJobNamesDataBinding == null) {
            this.completionSelectedJobNamesDataBinding = new ArrayList<String>();
        }
        return this.completionSelectedJobNamesDataBinding;
    }

    public Integer getEndBehaviorDataBinding() {
        return this.endBehaviorDataBinding;
    }

    public void setEndBehaviorDataBinding(Integer value) {
        this.endBehaviorDataBinding = value;
    }

    public Integer getExitcodeBehaviorDataBinding() {
        return this.exitcodeBehaviorDataBinding;
    }

    public void setExitcodeBehaviorDataBinding(Integer value) {
        this.exitcodeBehaviorDataBinding = value;
    }

    public boolean isExclusiveDataBinding() {
        return this.exclusiveDataBinding;
    }

    public void setExclusiveDataBinding(boolean value) {
        this.exclusiveDataBinding = value;
    }

    public boolean isSaveLayoutDataBinding() {
        return this.saveLayoutDataBinding;
    }

    public void setSaveLayoutDataBinding(boolean value) {
        this.saveLayoutDataBinding = value;
    }

    public String getSchedulerQueueDataBinding() {
        return this.schedulerQueueDataBinding;
    }

    public void setSchedulerQueueDataBinding(String value) {
        this.schedulerQueueDataBinding = value;
    }

    public Integer getJobDefaultEmailNotificationDataBinding() {
        return this.jobDefaultEmailNotificationDataBinding;
    }

    public void setJobDefaultEmailNotificationDataBinding(Integer value) {
        this.jobDefaultEmailNotificationDataBinding = value;
    }

    public String getJobDefaultEmailAddressDataBinding() {
        return this.jobDefaultEmailAddressDataBinding;
    }

    public void setJobDefaultEmailAddressDataBinding(String value) {
        this.jobDefaultEmailAddressDataBinding = value;
    }

    public Integer getJobDefaultPriorityDataBinding() {
        return this.jobDefaultPriorityDataBinding;
    }

    public void setJobDefaultPriorityDataBinding(Integer value) {
        this.jobDefaultPriorityDataBinding = value;
    }

    public String getJobDefaultEnvironmentVariablesDataBinding() {
        return this.jobDefaultEnvironmentVariablesDataBinding;
    }

    public void setJobDefaultEnvironmentVariablesDataBinding(String value) {
        this.jobDefaultEnvironmentVariablesDataBinding = value;
    }

    public String getJobDefaultExceptionHandlersDataBinding() {
        return this.jobDefaultExceptionHandlersDataBinding;
    }

    public void setJobDefaultExceptionHandlersDataBinding(String value) {
        this.jobDefaultExceptionHandlersDataBinding = value;
    }

    public void setAvailableTriggersDataBinding(List<TriggerEventInfo> availableTriggersDataBinding) {
        this.availableTriggersDataBinding = availableTriggersDataBinding;
    }

    public void setJobsDataBinding(List<DisplayInfo> jobsDataBinding) {
        this.jobsDataBinding = jobsDataBinding;
    }

    public void setJobDependenciesDataBinding(List<JobDependency> jobDependenciesDataBinding) {
        this.jobDependenciesDataBinding = jobDependenciesDataBinding;
    }

    public void setCompletionSelectedJobNamesDataBinding(List<String> completionSelectedJobNamesDataBinding) {
        this.completionSelectedJobNamesDataBinding = completionSelectedJobNamesDataBinding;
    }

    static {
        String strClassName = FlowInfo.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
        IconName = m_bundle.getString("FlowNode.image");
        IconError = m_bundle.getString("FlowErrorsNode.image");
        IconNewName = m_bundle.getString("FlowNew.image");
        IconScheduledName = m_bundle.getString("FlowScheduledNode.image");
        IconScheduledError = m_bundle.getString("FlowScheduledErrorsNode.image");
        TableHeader_ID = m_bundle.getString("FlowInfo.TableHeader.ID.txt");
        TableHeader_Name = m_bundle.getString("FlowInfo.TableHeader.Name.txt");
        TableHeader_Type = m_bundle.getString("FlowInfo.TableHeader.Type.txt");
        TableHeader_Event = m_bundle.getString("FlowInfo.TableHeader.Event.txt");
        TableHeader_Description = m_bundle.getString("FlowInfo.TableHeader.Description.txt");
        TableHeader_Location = m_bundle.getString("FlowInfo.TableHeader.Location.txt");
        TableHeader_RunAs = m_bundle.getString("FlowInfo.TableHeader.RunAs.txt");
        TableHeader_Predecessors = m_bundle.getString("FlowInfo.TableHeader.Predecessors.txt");
        PredecessorSeparator = m_bundle.getString("FlowInfo.Table.Concatenate.txt");
        ArithmeticOperator_Equal_Text = m_bundle.getString("FlowInfo.ArithmeticOperator_Equal.txt");
        ArithmeticOperator_Equal_Symbol = m_bundle.getString("FlowInfo.ArithmeticOperator_Equal.lcl");
        ArithmeticOperator_NotEqual_Text = m_bundle.getString("FlowInfo.ArithmeticOperator_NotEqual.txt");
        ArithmeticOperator_NotEqual_Symbol = m_bundle.getString("FlowInfo.ArithmeticOperator_NotEqual.lcl");
        ArithmeticOperator_GreaterThan_Text = m_bundle.getString("FlowInfo.ArithmeticOperator_GreaterThan.txt");
        ArithmeticOperator_GreaterThan_Symbol = m_bundle.getString("FlowInfo.ArithmeticOperator_GreaterThan.lcl");
        ArithmeticOperator_GreaterThanEqual_Text = m_bundle.getString("FlowInfo.ArithmeticOperator_GreaterThanEqual.txt");
        ArithmeticOperator_GreaterThanEqual_Symbol = m_bundle.getString("FlowInfo.ArithmeticOperator_GreaterThanEqual.lcl");
        ArithmeticOperator_LessThan_Text = m_bundle.getString("FlowInfo.ArithmeticOperator_LessThan.txt");
        ArithmeticOperator_LessThan_Symbol = m_bundle.getString("FlowInfo.ArithmeticOperator_LessThan.lcl");
        ArithmeticOperator_LessThanEqual_Text = m_bundle.getString("FlowInfo.ArithmeticOperator_LessThanEqual.txt");
        ArithmeticOperator_LessThanEqual_Symbol = m_bundle.getString("FlowInfo.ArithmeticOperator_LessThanEqual.lcl");
        ArithmeticOperator_Negation_Symbol = m_bundle.getString("FlowInfo.ArithmeticOperator_Negation.lcl");
    }
}

