/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.AbstractRecurrence;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.InvalidRecurrenceException;
import com.sas.text.Message;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DailyRecurrence", propOrder={"onlyWeekDaysDataBinding", "hourlyDataBinding"})
public class DailyRecurrence
extends AbstractRecurrence
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String XML_Daily_Tag = "daily";
    static final String XML_Only_Weekdays = "onlyWeekDays";
    static final String XML_Hourly = "hourly";
    @XmlElement(name="WeekDaysOnly")
    protected boolean onlyWeekDaysDataBinding = false;
    @XmlElement(name="Hourly")
    protected String hourlyDataBinding = null;

    public boolean isOnlyWeekDaysDataBinding() {
        return this.onlyWeekDaysDataBinding;
    }

    public void setOnlyWeekDaysDataBinding(boolean value) {
        this.onlyWeekDaysDataBinding = value;
    }

    public void setWeekDays(boolean on) {
        this.onlyWeekDaysDataBinding = on;
        if (this.onlyWeekDaysDataBinding) {
            this.setSkipCount(1);
        }
    }

    @Override
    public boolean setSkipCount(int skipCount) {
        if (skipCount > 1) {
            this.onlyWeekDaysDataBinding = false;
        }
        return super.setSkipCount(skipCount);
    }

    public boolean isWeekDays() {
        return this.onlyWeekDaysDataBinding;
    }

    public boolean setHourly(int skipcount, int offset) {
        if (skipcount > 0 && skipcount - offset >= 0) {
            this.hourlyDataBinding = skipcount + ":" + offset;
            return true;
        }
        this.hourlyDataBinding = null;
        return false;
    }

    public String getHourly() {
        return this.hourlyDataBinding;
    }

    @Override
    public String toString(Locale locale) {
        String strClassName = DailyRecurrence.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        ResourceBundle bundle = ResourceBundle.getBundle(strBundlePath, locale);
        String expression = "";
        Calendar startTime = this.getStartDate();
        Calendar endTime = this.getEndDate();
        int skip = this.getSkipCount();
        if (this.onlyWeekDaysDataBinding) {
            if (startTime == null) {
                if (endTime == null) {
                    expression = bundle.getString("DailyRecurrence.toString.Weekday.txt");
                } else {
                    Object[] args = new Object[]{DailyRecurrence.dateToString(endTime, locale)};
                    expression = Message.format((ResourceBundle)bundle, (String)"DailyRecurrence.toString.Weekday.End.fmt.txt", (Object[])args);
                }
            } else if (endTime == null) {
                Object[] args = new Object[]{DailyRecurrence.dateToString(startTime, locale)};
                expression = Message.format((ResourceBundle)bundle, (String)"DailyRecurrence.toString.Weekday.Start.fmt.txt", (Object[])args);
            } else {
                Object[] args = new Object[]{DailyRecurrence.dateToString(startTime, locale), DailyRecurrence.dateToString(endTime, locale)};
                expression = Message.format((ResourceBundle)bundle, (String)"DailyRecurrence.toString.Weekday.StartEnd.fmt.txt", (Object[])args);
            }
        } else if (startTime == null) {
            if (endTime == null) {
                expression = bundle.getString("DailyRecurrence.toString.All.txt");
            } else {
                Object[] args = new Object[]{DailyRecurrence.dateToString(endTime, locale)};
                expression = Message.format((ResourceBundle)bundle, (String)"DailyRecurrence.toString.All.End.fmt.txt", (Object[])args);
            }
        } else if (endTime == null) {
            if (skip == 1) {
                Object[] args = new Object[]{DailyRecurrence.dateToString(startTime, locale)};
                expression = Message.format((ResourceBundle)bundle, (String)"DailyRecurrence.toString.All.Start.fmt.txt", (Object[])args);
            } else {
                Object[] args = new Object[]{String.valueOf(skip), DailyRecurrence.dateToString(startTime, locale)};
                expression = Message.format((ResourceBundle)bundle, (String)"DailyRecurrence.toString.All.SkipStart.fmt.txt", (Object[])args);
            }
        } else if (skip == 1) {
            Object[] args = new Object[]{DailyRecurrence.dateToString(startTime, locale), DailyRecurrence.dateToString(endTime, locale)};
            expression = Message.format((ResourceBundle)bundle, (String)"DailyRecurrence.toString.All.StartEnd.fmt.txt", (Object[])args);
        } else {
            Object[] args = new Object[]{String.valueOf(skip), DailyRecurrence.dateToString(startTime, locale), DailyRecurrence.dateToString(endTime, locale)};
            expression = Message.format((ResourceBundle)bundle, (String)"DailyRecurrence.toString.All.SkipStartEnd.fmt.txt", (Object[])args);
        }
        return expression;
    }

    @Override
    public IRecurrenceInfo copy() {
        DailyRecurrence recurrence = new DailyRecurrence();
        recurrence.copyFrom(this);
        return recurrence;
    }

    @Override
    public boolean includesDate(Calendar queryDate) throws InvalidRecurrenceException {
        int dayOfWeek;
        if (!this.isDateInRange(queryDate)) {
            return false;
        }
        if (this.isWeekDays() && ((dayOfWeek = queryDate.get(7)) == 1 || dayOfWeek == 7)) {
            return false;
        }
        if (this.getSkipCount() > 1) {
            return super.includesDate(queryDate);
        }
        if (this.isWeekDays()) {
            return true;
        }
        return true;
    }

    @Override
    public List<Calendar> getNextDates(Calendar queryDate, Calendar endQueryDate, int count) {
        ArrayList<Calendar> results = new ArrayList<Calendar>();
        if (endQueryDate == null || queryDate == null || count < 0) {
            return results;
        }
        Calendar calStart = this.getStartDate();
        Calendar currentDate = (Calendar)queryDate.clone();
        if (calStart != null) {
            if (AbstractRecurrence.isBeforeByDay(currentDate, calStart)) {
                currentDate = (Calendar)calStart.clone();
            } else if (this.getSkipCount() > 1) {
                currentDate = (Calendar)calStart.clone();
                this.moveCurrentDateJustBeforeQueryDate(currentDate, queryDate, this.getSkipCount(), 5);
            }
        }
        while (!AbstractRecurrence.isAfterByDay(currentDate, endQueryDate)) {
            int dayOfWeek;
            boolean useThisDay = true;
            if (this.isWeekDays() && ((dayOfWeek = currentDate.get(7)) == 1 || dayOfWeek == 7)) {
                useThisDay = false;
            }
            if (useThisDay && !AbstractRecurrence.isBeforeByDay(currentDate, queryDate) && this.isDateInRange(currentDate)) {
                results.add((Calendar)currentDate.clone());
                if (count > 0 && results.size() >= count) break;
            }
            currentDate.add(5, this.getSkipCount());
            if (!this.isDateAfterRange(currentDate)) continue;
            break;
        }
        return results;
    }

    @Override
    public void copyFrom(IRecurrenceInfo source) {
        if (source instanceof DailyRecurrence) {
            DailyRecurrence recurrence = (DailyRecurrence)source;
            super.copyFrom(recurrence);
            this.onlyWeekDaysDataBinding = recurrence.isOnlyWeekDaysDataBinding();
        }
    }

    @Override
    public void toXML(StringBuffer buffer) {
        buffer.append('<');
        buffer.append(XML_Daily_Tag);
        if (this.hourlyDataBinding != null) {
            buffer.append(" ");
            buffer.append(XML_Hourly);
            buffer.append("=");
            buffer.append('\"');
            buffer.append(this.hourlyDataBinding);
            buffer.append('\"');
        }
        if (this.onlyWeekDaysDataBinding) {
            buffer.append(" ");
            buffer.append(XML_Only_Weekdays);
            buffer.append("=");
            buffer.append('\"');
            buffer.append(this.onlyWeekDaysDataBinding);
            buffer.append('\"');
        }
        buffer.append(">");
        super.toXML(buffer);
        buffer.append("</");
        buffer.append(XML_Daily_Tag);
        buffer.append(">");
    }

    @Override
    public void injectXML(Document doc, Element parent) {
        Element tag = doc.createElement(XML_Daily_Tag);
        parent.appendChild(tag);
        if (this.onlyWeekDaysDataBinding) {
            tag.setAttribute(XML_Only_Weekdays, Boolean.toString(this.onlyWeekDaysDataBinding));
        }
        if (this.hourlyDataBinding != null) {
            tag.setAttribute(XML_Hourly, this.hourlyDataBinding);
        }
        super.injectXML(doc, tag);
    }

    @Override
    public void toShortUniqueString(StringBuffer buffer) {
        buffer.append("DA_");
        if (this.onlyWeekDaysDataBinding) {
            buffer.append("wd_");
        }
        super.toShortUniqueString(buffer);
    }
}

