/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.xml;

import MITI.util.XmlUtil;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SoapUtil {
    public static final XmlUtil.NsName NS_XMLNS_ENV = new XmlUtil.NsName("env", "http://schemas.xmlsoap.org/soap/envelope/");
    public static final XmlUtil.NsName NS_XMLNS_XSD = new XmlUtil.NsName("xsd", "http://www.w3.org/2001/XMLSchema");
    public static final XmlUtil.NsName NS_XMLNS_XSI = new XmlUtil.NsName("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    public static final XmlUtil.NsName NS_XMLNS_ENC = new XmlUtil.NsName("enc", "http://schemas.xmlsoap.org/soap/encoding/");
    public static final XmlUtil.NsName NS_COMMON = new XmlUtil.NsName("common", "http://metaintegration.com/integration/common/5");
    public static final XmlUtil.NsName NS_MIMB_EXE = new XmlUtil.NsName("mimb_exe", "http://metaintegration.com/MIMB/Integration/5");
    public static final XmlUtil.NsName NS_MIMBEX = new XmlUtil.NsName("mimbex", "http://metaintegration.com/MIMB/IntegrationEx/5");
    public static final XmlUtil.NsName NS_MIMB = new XmlUtil.NsName("mimb", "http://metaintegration.com/integration/mimb/5");
    public static final XmlUtil.NsName NS_LOG = new XmlUtil.NsName("log", "http://metaintegration.com/integration/log/5");
    public static final XmlUtil.NsName NS_CONFIG = new XmlUtil.NsName("config", "http://metaintegration.com/integration/config/5");
    public static final XmlUtil.NsName NS_FILEACCESS = new XmlUtil.NsName("fileaccess", "http://metaintegration.com/integration/fileaccess/5");
    public static final XmlUtil.NsName NS_FILEBROWSE = new XmlUtil.NsName("filebrowse", "http://metaintegration.com/integration/filebrowse/5");
    public static final XmlUtil.NsName NS_DATAQUALITY = new XmlUtil.NsName("dataquality", "http://metaintegration.com/integration/dataquality/5");
    public static final XmlUtil.NsName NS_UPGRADE = new XmlUtil.NsName("upgrade", "http://metaintegration.com/integration/upgrade/5");
    public static final XmlUtil.NsName NS_LICENSE = new XmlUtil.NsName("license", "http://metaintegration.com/integration/license/5");
    public static final XmlUtil.NsName NS_SETUP = new XmlUtil.NsName("setup", "http://metaintegration.com/MIMB/setup/5");
    public static final XmlUtil.NsName NS_PREFERENCES = new XmlUtil.NsName("usrp", "http://metaintegration.com/MIMB/userpreferences/5");
    public static final XmlUtil.NsName NS_XLINK = new XmlUtil.NsName("xlink", "http://www.w3.org/1999/XLink");
    public static final XmlUtil.NsName NS_XMI = new XmlUtil.NsName("xmi", "http://www.omg.org/XMI");
    public static final XmlUtil.NsName NS_MIR = new XmlUtil.NsName("mir", "http://www.metaintegration.com/MIR_XMI_61");
    public static final String SOAP_FAULT = "Fault";
    public static final String SOAP_FAULT_FAULTCODE = "faultcode";
    public static final String SOAP_FAULT_FAULTSTRING = "faultstring";
    public static final String SOAP_FAULT_DETAIL = "detail";
    public static final String OEM_PARTNER_TOKEN_HEADER_ELEMENT = "OEMLicenseToken";
    public static final String TEMPORARY_LICENSE_TOKEN_HEADER_ATTRIBUTE = "temporaryLicenseToken";
    public static final String OEM_PARTNER_TOKEN_HEADER_ATTRIBUTE = "oemPartnerToken";
    public static final String MIMB_AGENT_EXCEPTION = "MimbAgentException";
    public static final String ATTR_ERROR_MESSAGE = "errorMessage";
    public static final String ELM_STACK_TRACE = "StackTraceLines";
    public static final String ELM_STACK_TRACE_LINE = "StackTraceLine";
    public static final String ELM_CAUSE = "CauseException";

    public static void printXml(Element element, StringBuffer stringBuffer) {
        SoapUtil.printXml(element, stringBuffer, "", true);
    }

    public static void printXml(Element element, StringBuffer stringBuffer, String string, boolean bl) {
        String string2;
        String string3;
        int n;
        String string4 = null;
        if (bl) {
            string4 = element.getNodeName();
        } else {
            string4 = element.getLocalName();
            if (string4 == null) {
                string4 = element.getNodeName();
            }
        }
        String string5 = "\n";
        if (string == null) {
            string = "";
            string5 = "";
        }
        stringBuffer.append(string).append('<').append(string4);
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (n = 0; n < namedNodeMap.getLength(); ++n) {
            Node node = namedNodeMap.item(n);
            string3 = null;
            if (bl) {
                string3 = node.getNodeName();
            } else {
                string3 = node.getLocalName();
                if (string3 == null) {
                    string3 = node.getNodeName();
                }
            }
            if (!bl && string3.indexOf("xmlns:") >= 0) continue;
            String string6 = node.getNodeValue();
            string6 = XmlUtil.escapeXml(string6);
            stringBuffer.append(string5).append(string).append(' ').append(string3).append("=\"").append(string6).append('\"');
        }
        n = 1;
        boolean bl2 = false;
        string3 = null;
        boolean bl3 = false;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            if (!bl3) {
                bl3 = true;
                if (!bl2) {
                    stringBuffer.append(">").append(string5);
                    bl2 = true;
                } else {
                    stringBuffer.append(string5);
                }
                string3 = string + string;
                n = 1;
            }
            SoapUtil.printXml((Element)node, stringBuffer, string3, bl);
        }
        if (!bl3 && (string2 = XmlUtil.getElementValue(element)) != null && string2.length() > 0) {
            string2 = XmlUtil.escapeXml(string2);
            stringBuffer.append('>').append(string2);
            bl2 = true;
            n = 0;
        }
        if (bl2) {
            if (n != 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append("</").append(string4).append(">").append(string5);
        } else {
            stringBuffer.append("/>").append(string5);
        }
    }

    public static void setElementValue(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            node.setNodeValue(string);
            return;
        }
        Document document = element.getOwnerDocument();
        element.appendChild(document.createTextNode(string));
    }

    public static void addNamespaceAttribute(Element element, XmlUtil.NsName nsName) {
        String string = "xmlns:" + nsName.getPrefix();
        element.setAttribute(string, nsName.getUri());
    }

    private static Element appendNewElement(Element element, XmlUtil.NsName nsName, String string) {
        Element element2 = element.getOwnerDocument().createElementNS(nsName.getUri(), nsName.getPrefix() + ":" + string);
        element.appendChild(element2);
        return element2;
    }

    public static Element addChildElement(Element element, XmlUtil.NsName nsName, String string, String[] stringArray) {
        Element element2 = SoapUtil.appendNewElement(element, nsName, string);
        if (stringArray != null && stringArray.length > 0) {
            if (stringArray.length % 2 > 0) {
                throw new IllegalArgumentException("Odd number in attributes name-value array parameter.");
            }
            for (int i = 0; i < stringArray.length; i += 2) {
                String string2 = stringArray[i];
                String string3 = stringArray[i + 1];
                element2.setAttribute(string2, string3);
            }
        }
        return element2;
    }

    public static Document prepareFaultMessage(Throwable throwable, String string, String string2) {
        try {
            DocumentBuilder documentBuilder = XmlUtil.getDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = XmlUtil.appendNewElement(document, null, SOAP_FAULT);
            XmlUtil.addNamespaceAttribute(element, NS_COMMON);
            Element element2 = XmlUtil.appendNewElement(element, null, SOAP_FAULT_FAULTCODE);
            SoapUtil.setElementValue(element2, string);
            Element element3 = XmlUtil.appendNewElement(element, null, SOAP_FAULT_FAULTSTRING);
            String string3 = throwable.getMessage();
            if (string3 == null) {
                string3 = "";
            }
            SoapUtil.setElementValue(element3, string3);
            Element element4 = XmlUtil.appendNewElement(element, null, SOAP_FAULT_DETAIL);
            SoapUtil.appendThrowableDataToElement(throwable, element4, string2);
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException(parserConfigurationException.getMessage());
        }
    }

    private static void appendThrowableDataToElement(Throwable throwable, Element element, String string) {
        Element element2 = SoapUtil.appendNewElement(element, NS_COMMON, string);
        element2.setAttribute(ATTR_ERROR_MESSAGE, throwable.getMessage());
        Element element3 = SoapUtil.appendNewElement(element2, NS_COMMON, ELM_STACK_TRACE);
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            Element element4 = SoapUtil.appendNewElement(element3, NS_COMMON, ELM_STACK_TRACE_LINE);
            element3.appendChild(element4);
            SoapUtil.setElementValue(element4, stackTraceElement.toString());
        }
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null && throwable2 != throwable) {
            SoapUtil.appendThrowableDataToElement(throwable2, element2, ELM_CAUSE);
        }
    }

    public static void copyElementToElement(Element element, Element element2, XmlUtil.NsName nsName) {
        Node node;
        String string = null;
        boolean bl = false;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() == 2) {
                element2.setAttribute(node2.getNodeName(), node2.getNodeValue());
                continue;
            }
            if (node2.getNodeType() == 3) {
                string = node2.getNodeValue();
                continue;
            }
            if (node2.getNodeType() != 1) continue;
            bl = true;
            node = nsName != null ? SoapUtil.appendNewElement(element2, nsName, node2.getNodeName()) : SoapUtil.appendNewElement(element2, new XmlUtil.NsName(node2.getPrefix(), node2.getNamespaceURI()), node2.getLocalName());
            SoapUtil.copyElementToElement((Element)node2, (Element)node, nsName);
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            node = namedNodeMap.item(i);
            element2.setAttribute(node.getNodeName(), node.getNodeValue());
        }
        if (!bl && string != null) {
            SoapUtil.setElementValue(element2, string);
        }
    }

    public static int getInt(String string) {
        if (string != null && !string.isEmpty()) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static long getLong(String string) {
        if (string != null && !string.isEmpty()) {
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }
}

