/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.thread;

import MITI.server.services.common.SessionHandle;
import MITI.util.log.MIRLogger;
import MITI.util.thread.Sdk;
import MITI.util.thread.SimpleTask;
import MITI.util.thread.SimpleThreadFactory;
import MITI.util.thread.SimpleThreadLogger;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SimpleTimer
extends ScheduledThreadPoolExecutor {
    private MIRLogger mainLogger = MIRLogger.getLogger();
    private SessionHandle userSession;

    public SimpleTimer(String string) {
        super(1, new SimpleThreadFactory(string, false));
        this.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
    }

    public void scheduleOnce(SimpleTask simpleTask) {
        this.schedule(simpleTask, 0L, TimeUnit.SECONDS);
    }

    public void schedule(final SimpleTask simpleTask, int n) {
        this.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                simpleTask.call();
            }
        }, 0L, n, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        if (!this.isShutdown()) {
            this.shutdown();
        }
        if (!this.isTerminated()) {
            try {
                while (!this.awaitTermination(10L, TimeUnit.SECONDS)) {
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        MIRLogger.setLogger(new SimpleThreadLogger(this.mainLogger));
        SessionHandle.setUserSession(this.userSession);
        super.beforeExecute(thread, runnable);
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        Sdk.clear();
        MIRLogger.clear();
        SessionHandle.clear();
        super.afterExecute(runnable, throwable);
    }
}

