/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.text;

import MITI.util.config.MimbConfiguration;
import MITI.util.config.MitiLocale;
import MITI.util.file.FilesWatcher;
import MITI.util.file.YamlFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class TextLiteralCollection
implements Comparable<TextLiteralCollection> {
    private static final Pattern PARAMETER = Pattern.compile("\\$\\{([^\\}\\.]+)\\.([^\\}\\.]+)\\}");
    private static ConcurrentHashMap<String, TextLiteralCollection> textLiteralsCollections = new ConcurrentHashMap(8, 0.9f, 1);
    private String name;
    private Set<String> languages = new HashSet<String>();
    private Map<String, TextLiteral> literals = new HashMap<String, TextLiteral>();
    private static final String[] APPS = new String[]{"bridge", "message", "model", "profile", "ui"};
    private static FilesWatcher watcher;

    private String replaceMacros(String string, MitiLocale mitiLocale) {
        Matcher matcher = PARAMETER.matcher(string);
        if (matcher.find()) {
            StringBuffer stringBuffer = new StringBuffer();
            do {
                String string2;
                String string3;
                TextLiteral textLiteral;
                if ((textLiteral = TextLiteralCollection.getLiteral(string3 = matcher.group(1), string2 = matcher.group(2))) == null) {
                    try {
                        Class.forName("MITI.literals." + string3 + "Literals", true, this.getClass().getClassLoader());
                        textLiteral = TextLiteralCollection.getLiteral(string3, string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                matcher.appendReplacement(stringBuffer, "");
                stringBuffer.append(textLiteral != null ? textLiteral.getText(mitiLocale) : "${" + string3 + "." + string2 + "}");
            } while (matcher.find());
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        return string;
    }

    protected TextLiteralCollection(String string) {
        this.name = string;
        this.languages.add("");
        textLiteralsCollections.put(string, this);
    }

    @Override
    public int compareTo(TextLiteralCollection textLiteralCollection) {
        return this.name.compareTo(textLiteralCollection.name);
    }

    private boolean hasLanguage(String string) {
        return this.languages.contains(string);
    }

    private static File getLiteralsLocation() {
        File file = MimbConfiguration.getMimbHome();
        if (file != null) {
            return new File(file, "conf/literals");
        }
        return null;
    }

    public static Collection<String> getAvailableLanguages() {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = TextLiteralCollection.getLiteralsLocation();
        if (file != null) {
            for (File file2 : file.listFiles()) {
                if (!file2.isDirectory()) continue;
                arrayList.add(file2.getName());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLanguage(String string, boolean bl) {
        TextLiteralCollection textLiteralCollection = this;
        synchronized (textLiteralCollection) {
            if (!this.languages.contains(string) || bl) {
                File file = new File(TextLiteralCollection.getLiteralsLocation(), string);
                if (file.isDirectory()) {
                    for (String string2 : APPS) {
                        File file2 = new File(new File(file, string2), this.name + ".yaml");
                        if (!file2.isFile()) continue;
                        this.loadFile(file2);
                    }
                }
                this.languages.add(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile(File file) {
        TextLiteralCollection textLiteralCollection = this;
        synchronized (textLiteralCollection) {
            String string = file.getParentFile().getParentFile().getName();
            Map<String, String> map = YamlFile.load(file);
            if (map != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    TextLiteral textLiteral = this.literals.get(entry.getKey());
                    if (textLiteral == null) continue;
                    textLiteral.texts.put(string, entry.getValue());
                }
            }
        }
    }

    public static TextLiteral getLiteral(String string, String string2) {
        TextLiteralCollection textLiteralCollection = textLiteralsCollections.get(string);
        if (textLiteralCollection != null) {
            return textLiteralCollection.literals.get(string2);
        }
        return null;
    }

    public Collection<TextLiteral> getLiterals() {
        return this.literals.values();
    }

    public TextLiteral getLiteral(String string) {
        return this.literals.get(string);
    }

    public String getPrefix() {
        return this.name;
    }

    public static TextLiteralCollection getByPrefix(String string) {
        return textLiteralsCollections.get(string);
    }

    public static void start() {
        if (watcher == null) {
            watcher = new FilesWatcher(TextLiteralCollection.getLiteralsLocation(), true){

                @Override
                protected void updateFiles(Collection<File> collection) {
                    TreeMap<TextLiteralCollection, TreeSet<String>> treeMap = new TreeMap<TextLiteralCollection, TreeSet<String>>();
                    for (File file : collection) {
                        String string;
                        if (!file.getName().endsWith(".yaml")) continue;
                        String string2 = file.getName().replace(".yaml", "");
                        TextLiteralCollection textLiteralCollection = (TextLiteralCollection)textLiteralsCollections.get(string2);
                        if (textLiteralCollection == null || !textLiteralCollection.hasLanguage(string = file.getParentFile().getParentFile().getName())) continue;
                        TreeSet<String> treeSet = (TreeSet<String>)treeMap.get(textLiteralCollection);
                        if (treeSet == null) {
                            treeSet = new TreeSet<String>();
                            treeMap.put(textLiteralCollection, treeSet);
                        }
                        if (!treeSet.add(string)) continue;
                        textLiteralCollection.loadLanguage(string, true);
                    }
                }
            };
            watcher.start();
        }
    }

    public static void stop() {
        if (watcher != null) {
            watcher.stop();
            watcher = null;
        }
    }

    public class TextLiteral {
        private String id;
        private ConcurrentHashMap<String, String> texts = new ConcurrentHashMap(64, 0.9f, 1);

        public TextLiteral(String string, String string2) {
            this.id = string;
            this.texts.put("", string2);
            TextLiteralCollection.this.literals.put(this.id, this);
        }

        public String getId() {
            return this.id;
        }

        public String getText() {
            return this.getText(MitiLocale.getLocale());
        }

        public String getText(MitiLocale mitiLocale) {
            String string = this.getText(mitiLocale.getId());
            if (string == null) {
                if (!mitiLocale.getCountry().isEmpty()) {
                    string = this.getText(mitiLocale.getLanguage());
                }
                if (string == null && !"en".equals(mitiLocale.getLanguage())) {
                    string = this.getText(mitiLocale.getLanguage());
                }
                if (string == null) {
                    string = this.texts.getOrDefault("", this.id);
                }
            }
            return TextLiteralCollection.this.replaceMacros(string, mitiLocale);
        }

        private String getText(String string) {
            if (!string.isEmpty() && !TextLiteralCollection.this.hasLanguage(string)) {
                TextLiteralCollection.this.loadLanguage(string, false);
            }
            return this.texts.get(string);
        }
    }
}

