/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.string;

import java.math.BigInteger;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AlphaNumericComparator
implements Comparator<String> {
    public static final AlphaNumericComparator CASE_SENSITIVE = new AlphaNumericComparator(false);
    public static final AlphaNumericComparator CASE_INSENSITIVE = new AlphaNumericComparator(true);
    private static final Pattern NAME = Pattern.compile("([0-9]+)$");
    private boolean ignoreCase;

    private AlphaNumericComparator(boolean bl) {
        this.ignoreCase = bl;
    }

    @Override
    public int compare(String string, String string2) {
        if (string == null || string.isEmpty()) {
            return string2 == null || string2.isEmpty() ? 0 : -1;
        }
        if (string2 == null || string2.isEmpty()) {
            return 1;
        }
        int n = 0;
        if (Character.isDigit(string.charAt(string.length() - 1)) && Character.isDigit(string2.charAt(string2.length() - 1))) {
            Matcher matcher = NAME.matcher(string);
            Matcher matcher2 = NAME.matcher(string2);
            if (matcher.find() && matcher2.find() && matcher.start() == matcher2.start() && string.regionMatches(this.ignoreCase, 0, string2, 0, matcher.start())) {
                n = new BigInteger(matcher.group()).compareTo(new BigInteger(matcher2.group()));
                if (n == 0) {
                    n = this.ignoreCase ? matcher.group().compareToIgnoreCase(matcher2.group()) : matcher.group().compareTo(matcher2.group());
                }
            } else {
                n = this.ignoreCase ? string.compareToIgnoreCase(string2) : string.compareTo(string2);
            }
        } else {
            int n2 = n = this.ignoreCase ? string.compareToIgnoreCase(string2) : string.compareTo(string2);
        }
        if (this.ignoreCase && n == 0) {
            n = string.compareTo(string2);
        }
        return n;
    }
}

