/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.ssl;

import MITI.util.ssl.TrustAllManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLUtil {
    private static final char[] PASSWORD = "changeit".toCharArray();

    public static SSLContext getDefaultContext() throws GeneralSecurityException {
        return SSLContext.getDefault();
    }

    public static SSLContext getSslContext(URL uRL, boolean bl, boolean bl2) throws SSLHandshakeException, IOException, GeneralSecurityException {
        if ("https".equalsIgnoreCase(uRL.getProtocol())) {
            return SSLUtil.getTrustContext((URL)uRL, (boolean)bl, (boolean)bl2).ctx;
        }
        return null;
    }

    public static KeyStore getKeyStore(URL uRL, boolean bl, boolean bl2) throws SSLHandshakeException, IOException, GeneralSecurityException {
        return SSLUtil.getTrustContext((URL)uRL, (boolean)bl, (boolean)bl2).ks;
    }

    private static TrustContext getTrustContext(URL uRL, boolean bl, boolean bl2) throws SSLHandshakeException, IOException, GeneralSecurityException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        TrustContext trustContext = new TrustContext();
        trustContext.ctx = SSLContext.getInstance("TLS");
        trustContext.ks = KeyStore.getInstance(KeyStore.getDefaultType());
        if (bl) {
            object4 = new File(System.getProperty("java.home"), "lib/security");
            object3 = new File((File)object4, "jssecacerts");
            if (!((File)object3).exists() || !((File)object3).isFile()) {
                object3 = new File((File)object4, "cacerts");
            }
            try {
                object2 = new FileInputStream((File)object3);
                object = null;
                try {
                    trustContext.ks.load((InputStream)object2, PASSWORD);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (object2 != null) {
                        if (object != null) {
                            try {
                                ((FileInputStream)object2).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((FileInputStream)object2).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                if (bl2) {
                    throw iOException;
                }
                trustContext.ks.load(null);
            }
        } else {
            trustContext.ks.load(null);
        }
        object4 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        ((TrustManagerFactory)object4).init(trustContext.ks);
        object3 = (X509TrustManager)((TrustManagerFactory)object4).getTrustManagers()[0];
        object2 = new TrustAllManager((X509TrustManager)object3);
        boolean bl3 = ((TrustAllManager)object2).trustAll = !bl2;
        if ("localhost".equalsIgnoreCase(uRL.getHost())) {
            ((TrustAllManager)object2).trustAll = true;
        }
        trustContext.ctx.init(null, new TrustManager[]{object2}, null);
        object = trustContext.ctx.getSocketFactory();
        try {
            int n = uRL.getPort() == -1 ? 443 : uRL.getPort();
            SSLSocket sSLSocket = (SSLSocket)((SocketFactory)object).createSocket(uRL.getHost(), n);
            sSLSocket.setSoTimeout(10000);
            sSLSocket.startHandshake();
            sSLSocket.close();
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            if (bl2 || ((TrustAllManager)object2).getServerCert() == null) {
                throw sSLHandshakeException;
            }
            X509Certificate x509Certificate = ((TrustAllManager)object2).getServerCert();
            trustContext.ks.setCertificateEntry(x509Certificate.getSubjectDN().getName(), x509Certificate);
            ((TrustManagerFactory)object4).init(trustContext.ks);
            trustContext.ctx.init(null, ((TrustManagerFactory)object4).getTrustManagers(), null);
        }
        catch (IOException iOException) {
            if (bl || bl2) {
                throw iOException;
            }
            ((TrustAllManager)object2).trustAll = true;
        }
        return trustContext;
    }

    private static class TrustContext {
        SSLContext ctx;
        KeyStore ks;

        private TrustContext() {
        }
    }
}

