/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.log;

import MITI.server.services.common.LogEvent;
import MITI.util.DateUtil;
import MITI.util.XmlUtil;
import MITI.util.log.LogEventHandler;
import MITI.util.log.MimbLogOutputStream;
import MITI.util.text.MessageLiteral;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlLogEventHandler
extends LogEventHandler {
    private static Document eventDoc = null;
    private OutputStream output;

    public XmlLogEventHandler(OutputStream outputStream) {
        this.output = outputStream;
    }

    @Override
    public void log(LogEvent logEvent) {
        try {
            XmlLogEventHandler.writeLogEventXml(logEvent, this.output);
            this.output.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static final void writeLogEventXml(LogEvent logEvent, OutputStream outputStream) throws IOException {
        Element element = eventDoc.createElement("Message");
        if (logEvent.getThreadId() != null) {
            element.setAttribute("threadId", logEvent.getThreadId());
        }
        element.setAttribute("type", MessageLiteral.convertLevelToText(logEvent.getLevel()));
        element.setAttribute("code", logEvent.getCode());
        element.setAttribute("timestamp", DateUtil.formatUtcDate(logEvent.getTime()));
        if (logEvent.getStackTrace() != null) {
            element.setAttribute("stackTrace", logEvent.getStackTrace());
        }
        XmlUtil.setElementValue(element, logEvent.getText());
        StringBuffer stringBuffer = new StringBuffer();
        XmlUtil.printXml(element, stringBuffer, null, false);
        byte[] byArray = stringBuffer.toString().getBytes("UTF-8");
        outputStream.write(MimbLogOutputStream.MIR_LOG_EVENT_HEADER_START);
        String string = Integer.toString(byArray.length) + "        ";
        string = string.substring(0, 8);
        outputStream.write(string.getBytes("UTF-8"));
        outputStream.write(MimbLogOutputStream.MIR_LOG_EVENT_HEADER_END);
        outputStream.write(byArray);
    }

    static {
        try {
            DocumentBuilder documentBuilder = XmlUtil.getDocumentBuilder();
            eventDoc = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException(parserConfigurationException.getMessage(), parserConfigurationException);
        }
    }
}

