/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.log;

import MITI.server.services.common.LogEvent;
import MITI.util.DateUtil;
import MITI.util.XmlUtil;
import MITI.util.text.MessageLiteral;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class MimbLogOutputStream
extends OutputStream {
    private static final int PROCESSING_HEADER = 1;
    private static final int PROCESSING_TEXT = 2;
    private static final int PROCESSING_XML = 3;
    public static final byte[] MIR_LOG_EVENT_HEADER_START;
    public static final byte[] MIR_LOG_EVENT_HEADER_END;
    public static final int MIR_LOG_EVENT_HEADER_SIZE_LEN = 8;
    private static final int MIR_LOG_EVENT_HEADER_TOTAL_LEN;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream(102400);
    private int state = 1;
    private int bytesToProcess = 0;
    private DocumentBuilder documentBuilder;

    protected MimbLogOutputStream() {
        try {
            this.documentBuilder = XmlUtil.getDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException(parserConfigurationException);
        }
    }

    @Override
    public void close() throws IOException {
        while (this.buffer.size() > 0) {
            this.state = 2;
            this.append(new byte[]{10}, 0, 1);
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.append(byArray, n, n2);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray);
    }

    protected abstract void processEvent(LogEvent var1);

    private void append(byte[] byArray, int n, int n2) throws UnsupportedEncodingException {
        for (int i = 0; i < n2 && i + n < byArray.length; ++i) {
            byte by = byArray[i + n];
            if (this.state == 1) {
                if (this.buffer.size() < MIR_LOG_EVENT_HEADER_START.length && by != MIR_LOG_EVENT_HEADER_START[this.buffer.size()]) {
                    this.state = 2;
                } else {
                    this.buffer.write(by);
                    if (this.buffer.size() > MIR_LOG_EVENT_HEADER_START.length && this.buffer.size() < MIR_LOG_EVENT_HEADER_START.length + 8) {
                        int n3 = by - 48;
                        if (n3 < 0 || n3 > 9) continue;
                        this.bytesToProcess = this.bytesToProcess * 10 + n3;
                        continue;
                    }
                    if (this.buffer.size() != MIR_LOG_EVENT_HEADER_TOTAL_LEN) continue;
                    this.buffer.reset();
                    this.state = 3;
                    continue;
                }
            }
            if (this.state == 2) {
                if (by == 10) {
                    if (this.buffer.size() > 0) {
                        LogEvent logEvent = new LogEvent();
                        logEvent.setText(this.buffer.toString("UTF-8"));
                        this.processEvent(logEvent);
                    }
                    this.reset();
                    continue;
                }
                if (by == 13) continue;
                this.buffer.write(by);
                continue;
            }
            if (this.state != 3) continue;
            this.buffer.write(by);
            if (this.buffer.size() != this.bytesToProcess) continue;
            LogEvent logEvent = new LogEvent();
            if (!this.deserializeLogEvent(logEvent, this.buffer.toByteArray(), 0, this.buffer.size())) {
                logEvent.setText(this.buffer.toString("UTF-8"));
            }
            this.processEvent(logEvent);
            this.reset();
        }
    }

    private void reset() {
        this.state = 1;
        this.bytesToProcess = 0;
        this.buffer.reset();
    }

    private boolean deserializeLogEvent(LogEvent logEvent, byte[] byArray, int n, int n2) {
        try {
            String string;
            Document document = this.documentBuilder.parse(new ByteArrayInputStream(byArray, n, n2));
            Element element = document.getDocumentElement();
            if (element == null) {
                return false;
            }
            logEvent.setThreadId(element.getAttribute("threadId"));
            logEvent.setCode(element.getAttribute("code"));
            logEvent.setLevel(MessageLiteral.MessageLevel.getId(element.getAttribute("type")));
            if (element.hasAttribute("stackTrace")) {
                logEvent.setStackTrace(element.getAttribute("stackTrace"));
            }
            if ((string = element.getAttribute("timestamp")) != null && string.length() > 0) {
                logEvent.setTime(DateUtil.parseUtcDate(string).getTime());
            }
            logEvent.setText(XmlUtil.getElementValue(element));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static {
        try {
            MIR_LOG_EVENT_HEADER_START = "<!-- MIRLog size=".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
        try {
            MIR_LOG_EVENT_HEADER_END = " -->".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
        MIR_LOG_EVENT_HEADER_TOTAL_LEN = MIR_LOG_EVENT_HEADER_START.length + 8 + MIR_LOG_EVENT_HEADER_END.length;
    }
}

