/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.file;

import MITI.server.services.common.LogEvent;
import MITI.util.cmd.CommandLineOption;
import MITI.util.cmd.CommandLineParser;
import MITI.util.cmd.HelpOption;
import MITI.util.cmd.MandatoryOption;
import MITI.util.cmd.TypedOption;
import MITI.util.log.MIRLogger;
import MITI.util.log.XmlLogEventHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class Zip {
    private static final int BUFSIZE = 32768;
    private static HelpOption helpOption = new HelpOption();
    private static MandatoryOption runXmlOption = new MandatoryOption(new String[]{"-r", "--runXml"}, "", TypedOption.Type.FILE);
    private static CommandLineOption[] options = new CommandLineOption[]{helpOption, runXmlOption};

    private static String makeRelative(String string) {
        return string.replaceAll("^/*", "");
    }

    public static void unzip(ZipInputStream zipInputStream, OutputStream outputStream) throws IOException {
        int n = 0;
        byte[] byArray = new byte[32768];
        while (0 < (n = zipInputStream.read(byArray))) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static void unzip(File file, File file2) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));){
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                File file3;
                if (zipEntry.isDirectory()) {
                    file3 = new File(file2, Zip.makeRelative(zipEntry.getName()));
                    file3.mkdirs();
                } else {
                    file3 = new File(file2, Zip.makeRelative(zipEntry.getName()));
                    file3.getParentFile().mkdirs();
                    try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3));){
                        Zip.unzip(zipInputStream, bufferedOutputStream);
                    }
                }
                zipInputStream.closeEntry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zip(ZipOutputStream zipOutputStream, String string, File file) throws IOException {
        String string2 = Zip.makeRelative(string + "/" + file.getName());
        ZipEntry zipEntry = new ZipEntry(string2);
        zipEntry.setTime(file.lastModified());
        zipOutputStream.putNextEntry(zipEntry);
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            int n = 0;
            byte[] byArray = new byte[32768];
            do {
                if ((n = bufferedInputStream.read(byArray)) <= 0) continue;
                zipOutputStream.write(byArray, 0, n);
            } while (n > 0);
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            zipOutputStream.closeEntry();
        }
    }

    private static void zip(ZipOutputStream zipOutputStream, String string, File ... fileArray) throws IOException {
        for (File file : fileArray) {
            if (file.isDirectory()) {
                Zip.zip(zipOutputStream, string + "/" + file.getName(), file.listFiles());
                continue;
            }
            Zip.zip(zipOutputStream, string, file);
        }
    }

    public static void zip(ZipOutputStream zipOutputStream, File ... fileArray) throws IOException {
        Zip.zip(zipOutputStream, "", fileArray);
    }

    public static void zip(File file, File ... fileArray) throws IOException {
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));){
            Zip.zip(zipOutputStream, "", fileArray);
        }
    }

    public static void zip(File file, String string, File ... fileArray) throws IOException {
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));){
            Zip.zip(zipOutputStream, string, fileArray);
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        MIRLogger.init(new XmlLogEventHandler(System.err));
        try {
            CommandLineParser.process(stringArray, 0, options);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            System.exit(1);
        }
        String string = null;
        File file = null;
        File file2 = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            object = documentBuilderFactory.newDocumentBuilder();
            Document document = ((DocumentBuilder)object).parse(runXmlOption.getFileValue());
            Element element = document.getDocumentElement();
            string = element.getAttribute("action");
            file = new File(element.getAttribute("zip"));
            file2 = new File(element.getAttribute("dir"));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalArgumentException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new IllegalArgumentException(sAXException);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
        try {
            if (string.equals("zip")) {
                Zip.zip(file, file2);
            } else if (string.equals("unzip")) {
                Zip.unzip(file, file2);
            }
        }
        catch (IOException iOException) {
            object = new LogEvent("Fatal error", 1, "");
            ((LogEvent)object).setStackTrace(iOException);
            MIRLogger.getLogger().log((LogEvent)object);
            System.exit(1);
        }
        System.exit(0);
    }
}

