/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.file;

import MITI.server.services.common.DbInfo;
import MITI.server.services.common.HostInfo;
import MITI.server.services.common.LicenseException;
import MITI.server.services.common.SystemInfo;
import MITI.util.MacAddress;
import MITI.util.MachineInfo;
import MITI.util.VersionInfo;
import MITI.util.XmlUtil;
import MITI.util.cmd.CommandLineOption;
import MITI.util.cmd.CommandLineParser;
import MITI.util.cmd.FlagOption;
import MITI.util.cmd.HelpOption;
import MITI.util.cmd.Option;
import MITI.util.file.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HostFile {
    private HostInfo hostInfo;
    private String versionInfo;
    private SystemInfo systemInfo;
    private DbInfo dbInfo;
    private static final String EOL = "\r\n";
    private static final String HOST = "License";
    private static final String HOST_ID = "HostId";
    private static final String MAC_ADRESS = "MacAdress";
    private static final String VERSION_INFO = "Version";
    private static final String SYSTEM = "ApplicationServer";
    private static final String SYSTEM_HARDWARE = "SystemHardware";
    private static final String SYSTEM_SOFTWARE = "SystemSoftware";
    private static final String SYSTEM_ENCODING = "SystemEncoding";
    private static final String SYSTEM_JAVA = "SystemJava";
    private static final String DB = "DatabaseServer";
    private static final String DB_TYPE = "Type";
    private static final String DB_URL = "ConnectionString";
    private static final String DB_USER = "UserName";
    private static final String DB_MIR_VERSION = "MIRDatabaseVersion";
    private static final String DB_SIZE = "DatabaseInformation";
    private static final String DB_VERSION = "Version";
    private static final String DB_DRIVER = "JDBCDriver";
    private static final String DB_DRIVER_VERSION = "JDBCDriverVersion";
    private static final String DB_ISOLATION_LEVEL = "TransactionIsolationLevel";
    private static HelpOption helpOption = new HelpOption();
    private static Option fileOption = new Option(new String[]{"-f", "--file"}, "The output file that will contain the host information");
    private static Option interfaceOption = new Option(new String[]{"-i", "--interface"}, "Specify which interface to use");
    private static FlagOption hostIdOption = new FlagOption(new String[]{"-h", "--host"}, "Also include the hostId/diskId");
    private static CommandLineOption[] options = new CommandLineOption[]{helpOption, fileOption, interfaceOption, hostIdOption};

    public HostFile(HostInfo hostInfo, String string, SystemInfo systemInfo, DbInfo dbInfo) {
        this.hostInfo = hostInfo;
        this.versionInfo = string;
        this.systemInfo = systemInfo;
        this.dbInfo = dbInfo;
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version='1.0' encoding='UTF-8'?>").append(EOL);
        stringBuffer.append("<License>").append(EOL);
        if (this.hostInfo.getHostId() != null) {
            stringBuffer.append("    <HostId>" + XmlUtil.escapeXml(this.hostInfo.getHostId()) + "</" + HOST_ID + ">").append(EOL);
        }
        if (this.hostInfo.getMacAddress() != null) {
            stringBuffer.append("    <MacAdress>" + XmlUtil.escapeXml(this.hostInfo.getMacAddress()) + "</" + MAC_ADRESS + ">").append(EOL);
        }
        stringBuffer.append("    <Version>" + XmlUtil.escapeXml(this.versionInfo) + "</" + "Version" + ">").append(EOL);
        stringBuffer.append("    <ApplicationServer>").append(EOL);
        stringBuffer.append("        <SystemHardware>" + XmlUtil.escapeXml(this.systemInfo.getHardware()) + "</" + SYSTEM_HARDWARE + ">").append(EOL);
        stringBuffer.append("        <SystemSoftware>" + XmlUtil.escapeXml(this.systemInfo.getSoftware()) + "</" + SYSTEM_SOFTWARE + ">").append(EOL);
        stringBuffer.append("        <SystemEncoding>" + XmlUtil.escapeXml(this.systemInfo.getEncoding()) + "</" + SYSTEM_ENCODING + ">").append(EOL);
        stringBuffer.append("        <SystemJava>" + XmlUtil.escapeXml(this.systemInfo.getJava()) + "</" + SYSTEM_JAVA + ">").append(EOL);
        stringBuffer.append("    </ApplicationServer>").append(EOL);
        if (this.dbInfo != null) {
            stringBuffer.append("    <DatabaseServer>").append(EOL);
            stringBuffer.append("        <Type>" + XmlUtil.escapeXml(this.dbInfo.getDbType()) + "</" + DB_TYPE + ">").append(EOL);
            stringBuffer.append("        <ConnectionString>" + XmlUtil.escapeXml(this.dbInfo.getDbConnectString()) + "</" + DB_URL + ">").append(EOL);
            stringBuffer.append("        <UserName>" + XmlUtil.escapeXml(this.dbInfo.getDbUserName()) + "</" + DB_USER + ">").append(EOL);
            stringBuffer.append("        <MIRDatabaseVersion>" + XmlUtil.escapeXml(this.dbInfo.getMirDatabaseVersion()) + "</" + DB_MIR_VERSION + ">").append(EOL);
            stringBuffer.append("        <DatabaseInformation>" + XmlUtil.escapeXml(this.dbInfo.getDatabaseSizeInfo()) + "</" + DB_SIZE + ">").append(EOL);
            stringBuffer.append("        <Version>" + XmlUtil.escapeXml(this.dbInfo.getDbVersion()) + "</" + "Version" + ">").append(EOL);
            stringBuffer.append("        <JDBCDriver>" + XmlUtil.escapeXml(this.dbInfo.getJdbcDriver()) + "</" + DB_DRIVER + ">").append(EOL);
            stringBuffer.append("        <JDBCDriverVersion>" + XmlUtil.escapeXml(this.dbInfo.getJdbcDriverVersion()) + "</" + DB_DRIVER_VERSION + ">").append(EOL);
            stringBuffer.append("        <TransactionIsolationLevel>" + String.valueOf(this.dbInfo.getTransactionIsolationLevel()) + "</" + DB_ISOLATION_LEVEL + ">").append(EOL);
            stringBuffer.append("    </DatabaseServer>").append(EOL);
        }
        stringBuffer.append("</License>");
        return stringBuffer.toString();
    }

    public void write(File file) throws FileNotFoundException {
        FileUtil.writeContent(file, this.getText(), FileUtil.UTF8);
    }

    public void read(String string) throws LicenseException {
        Element element = XmlUtil.parseString(string);
        if (element == null) {
            throw new LicenseException("Invalid host file");
        }
        this.hostInfo = new HostInfo();
        this.hostInfo.setHostId(this.getNodeContent(element, HOST_ID));
        this.hostInfo.setMacAddress(this.getNodeContent(element, MAC_ADRESS));
        this.versionInfo = this.getNodeContent(element, "Version");
        this.systemInfo = new SystemInfo();
        Element element2 = this.getNodeByName(element, SYSTEM);
        if (element2 != null) {
            this.systemInfo.setHardware(this.getNodeContent(element2, SYSTEM_HARDWARE));
            this.systemInfo.setSoftware(this.getNodeContent(element2, SYSTEM_SOFTWARE));
            this.systemInfo.setEncoding(this.getNodeContent(element2, SYSTEM_ENCODING));
            this.systemInfo.setJava(this.getNodeContent(element2, SYSTEM_JAVA));
        }
        this.dbInfo = new DbInfo();
        Element element3 = this.getNodeByName(element, DB);
        if (element3 != null) {
            this.dbInfo.setDbType(this.getNodeContent(element3, DB_TYPE));
            this.dbInfo.setDbConnectString(this.getNodeContent(element3, DB_URL));
            this.dbInfo.setDbUserName(this.getNodeContent(element3, DB_USER));
            this.dbInfo.setMirDatabaseVersion(this.getNodeContent(element3, DB_MIR_VERSION));
            this.dbInfo.setDatabaseSizeInfo(this.getNodeContent(element3, DB_SIZE));
            this.dbInfo.setDbVersion(this.getNodeContent(element3, "Version"));
            this.dbInfo.setJdbcDriver(this.getNodeContent(element3, DB_DRIVER));
            this.dbInfo.setJdbcDriverVersion(this.getNodeContent(element3, DB_DRIVER_VERSION));
        }
    }

    private Element getNodeByName(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() == 1) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    private String getNodeContent(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() == 1) {
            Node node = nodeList.item(0);
            return node.getTextContent();
        }
        return null;
    }

    private static void printUsage() {
        System.out.println("HostInfo usage:");
        CommandLineParser.printUsage(options, System.out);
    }

    public static void main(String[] stringArray) {
        try {
            CommandLineParser.process(stringArray, 0, options);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            HostFile.printUsage();
            System.exit(1);
        }
        if (helpOption.isSet()) {
            HostFile.printUsage();
            System.exit(0);
        }
        File file = fileOption.isSet() ? fileOption.getFileValue() : new File("HostInfo.xml");
        HostInfo hostInfo = new HostInfo();
        hostInfo.setHostName(MachineInfo.getHostName());
        if (interfaceOption.isSet()) {
            hostInfo.setMacAddress(MacAddress.getMacAddress(interfaceOption.getStringValue()));
        } else {
            hostInfo.setMacAddress(MachineInfo.getMacAddress());
        }
        if (hostIdOption.isSet() || hostInfo.getMacAddress() == null) {
            hostInfo.setHostId(MachineInfo.getHostId());
        }
        VersionInfo versionInfo = VersionInfo.loadMitiJar(HostFile.class);
        SystemInfo systemInfo = new SystemInfo();
        systemInfo.setHardware(MachineInfo.getHardware());
        systemInfo.setSoftware(MachineInfo.getSoftware());
        systemInfo.setEncoding(MachineInfo.getEncoding());
        systemInfo.setJava(MachineInfo.getJavaInfo());
        HostFile hostFile = new HostFile(hostInfo, versionInfo.getVersionString(), systemInfo, null);
        try {
            hostFile.write(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }
}

