/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.csv;

import MITI.util.csv.SimpleCsv;
import MITI.util.csv.SimpleCsvOptions;
import MITI.util.file.FileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleCsvWriter
extends SimpleCsv {
    private BufferedWriter writer;
    private Pattern pattern;

    public SimpleCsvWriter(File file, SimpleCsvOptions simpleCsvOptions) throws IOException {
        this(file, simpleCsvOptions, false, FileUtil.UTF8);
    }

    public SimpleCsvWriter(File file, SimpleCsvOptions simpleCsvOptions, boolean bl) throws IOException {
        this(file, simpleCsvOptions, bl, FileUtil.UTF8);
    }

    public SimpleCsvWriter(File file, SimpleCsvOptions simpleCsvOptions, boolean bl, Charset charset) throws IOException {
        super(file, simpleCsvOptions, charset);
        boolean bl2 = charset == FileUtil.UTF8 && (!file.exists() || file.length() == 0L || !bl);
        this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, bl), charset));
        if (bl2) {
            this.writer.write(65279);
        }
        this.pattern = Pattern.compile(this.getSimpleRegexp(false));
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    public void printLine(String ... stringArray) throws IOException {
        this.printLine(Arrays.asList(stringArray));
    }

    public void printLine(Collection<String> collection) throws IOException {
        ++this.lineNumber;
        int n = 0;
        for (String string : collection) {
            if (n++ != 0) {
                this.writer.append(this.options.getSeparator());
            }
            if (string != null) {
                this.writer.append(this.escape(string));
            }
            if (n != this.columnCount) continue;
            break;
        }
        while (n++ < this.columnCount) {
            this.writer.append(this.options.getSeparator());
        }
        this.writer.newLine();
        this.writer.flush();
    }

    private String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        Matcher matcher = this.pattern.matcher(string);
        while (matcher.find()) {
            if (!bl) {
                bl = true;
                stringBuffer.append(this.options.getQuote());
            }
            if (matcher.group().indexOf(this.options.getEscape()) == -1 && matcher.group().indexOf(this.options.getQuote()) == -1) continue;
            matcher.appendReplacement(stringBuffer, String.valueOf(this.options.getEscape()) + matcher.group());
        }
        matcher.appendTail(stringBuffer);
        if (bl) {
            stringBuffer.append(this.options.getQuote());
        }
        return stringBuffer.toString();
    }
}

