/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.config;

import java.util.Locale;

public class MitiLocale {
    public static final String ENV_LANG = "MIR_I18N_LANG";
    public static final MitiLocale EN = new MitiLocale("en");
    private static ThreadLocal<MitiLocale> locale = new ThreadLocal<MitiLocale>(){

        @Override
        protected synchronized MitiLocale initialValue() {
            String string = System.getenv(MitiLocale.ENV_LANG);
            return string != null ? new MitiLocale(string) : EN;
        }
    };
    private String language;
    private String country;

    public static void clear() {
        locale.remove();
    }

    public static String getLang() {
        return locale.get().getLanguage();
    }

    public static MitiLocale getLocale() {
        return locale.get();
    }

    public static void setLocale(String string) {
        locale.set(new MitiLocale(string));
    }

    public MitiLocale(String string) {
        String[] stringArray = string.split("_");
        this.language = stringArray.length > 0 ? stringArray[0] : "";
        this.country = stringArray.length > 1 ? stringArray[1] : "";
    }

    public MitiLocale(Locale locale) {
        this.language = locale.getLanguage();
        this.country = locale.getCountry();
    }

    public String getId() {
        return this.country.isEmpty() ? this.language : this.language + "_" + this.country;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCountry() {
        return this.country;
    }
}

