/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.cmd;

import MITI.util.cmd.FlagOption;

public abstract class CommandLineOption {
    protected String[] keys;
    protected String description;

    public CommandLineOption(String[] stringArray, String string) {
        this.keys = stringArray;
        this.description = string;
    }

    protected int processOption(String string, String[] stringArray, int n) {
        String string2 = null;
        if (!(this instanceof FlagOption)) {
            if (stringArray.length <= n) {
                throw new IllegalArgumentException("Missing \"" + string + "\" parameter value");
            }
            string2 = stringArray[n];
        }
        try {
            this.setValue(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Invalid option [" + string + (string2 != null ? ": " + string2 : "") + "]: " + illegalArgumentException.getMessage());
        }
        return string2 != null ? 1 : 0;
    }

    protected abstract void setValue(String var1);

    public abstract boolean isSet();

    protected String[] getSupportedKeys() {
        return this.keys;
    }

    public String getDescription() {
        return this.description;
    }

    protected boolean canRepeat() {
        return false;
    }

    protected boolean isMandatory() {
        return false;
    }

    protected boolean isHelpOption() {
        return false;
    }

    protected boolean isHiddenOption() {
        return false;
    }

    protected boolean isSupportedKey(String string) {
        String[] stringArray = this.getSupportedKeys();
        for (int i = 0; i < this.getSupportedKeys().length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    String getDisplayKeys() {
        String string = "";
        if (!this.isMandatory()) {
            string = string + "[";
        }
        if (this.getSupportedKeys().length > 1) {
            string = string + "{";
        }
        for (int i = 0; i < this.getSupportedKeys().length; ++i) {
            if (i > 0) {
                string = string + "|";
            }
            string = string + " " + this.getSupportedKeys()[i] + " ";
        }
        if (this.getSupportedKeys().length > 1) {
            string = string + "}";
        }
        if (!this.isMandatory()) {
            string = string + "]";
        }
        if (this.canRepeat()) {
            string = string + "...";
        }
        return string;
    }
}

